/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;

public class PKIXCertPathBuilderResult
extends PKIXCertPathValidatorResult
implements CertPathBuilderResult {
    private CertPath certPath;

    public PKIXCertPathBuilderResult(CertPath certPath, TrustAnchor trustAnchor, PolicyNode policyTree, PublicKey subjectPublicKey) {
        super(trustAnchor, policyTree, subjectPublicKey);
        if (certPath == null) {
            throw new NullPointerException("certPath must not be null");
        }
        this.certPath = certPath;
    }

    @Override
    public CertPath getCertPath() {
        return this.certPath;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PKIXCertPathBuilderResult: [\n");
        sb.append("  Certification Path: " + this.certPath + "\n");
        sb.append("  Trust Anchor: " + this.getTrustAnchor().toString() + "\n");
        sb.append("  Policy Tree: " + String.valueOf(this.getPolicyTree()) + "\n");
        sb.append("  Subject Public Key: " + this.getPublicKey() + "\n");
        sb.append("]");
        return sb.toString();
    }
}

