/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;

public class CertPathValidatorException
extends GeneralSecurityException {
    static final long serialVersionUID = -2365020986539324560L;
    private int index = -1;
    private CertPath certPath;
    private Reason reason = BasicReason.UNSPECIFIED;
    private Throwable ie;

    public CertPathValidatorException() {
    }

    public CertPathValidatorException(String msg) {
        super(msg);
    }

    public CertPathValidatorException(Throwable cause) {
        super(cause);
    }

    public CertPathValidatorException(String msg, Throwable cause) {
        this(msg, cause, null, -1);
    }

    public CertPathValidatorException(String msg, Throwable cause, CertPath certPath, int index) {
        this(msg, cause, certPath, index, BasicReason.UNSPECIFIED);
    }

    public CertPathValidatorException(String msg, Throwable cause, CertPath certPath, int index, Reason reason) {
        super(msg, cause);
        if (certPath == null && index != -1) {
            throw new IllegalArgumentException();
        }
        if (index < -1 || certPath != null && index >= certPath.getCertificates().size()) {
            throw new IndexOutOfBoundsException();
        }
        if (reason == null) {
            throw new NullPointerException("reason can't be null");
        }
        this.certPath = certPath;
        this.index = index;
        this.reason = reason;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getIndex() {
        return this.index;
    }

    public Reason getReason() {
        return this.reason;
    }

    @Override
    public Throwable getCause() {
        return super.getCause();
    }

    @Override
    public String toString() {
        if (this.getCause() == null) {
            return super.toString();
        }
        return super.toString() + "; internal cause is: \n\t" + this.getCause().toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        if (this.reason == null) {
            this.reason = BasicReason.UNSPECIFIED;
        }
        if (this.certPath == null && this.index != -1) {
            throw new InvalidObjectException("certpath is null and index != -1");
        }
        if (this.index < -1 || this.certPath != null && this.index >= this.certPath.getCertificates().size()) {
            throw new InvalidObjectException("index out of range");
        }
    }

    public static enum BasicReason implements Reason
    {
        UNSPECIFIED,
        EXPIRED,
        NOT_YET_VALID,
        REVOKED,
        UNDETERMINED_REVOCATION_STATUS,
        INVALID_SIGNATURE,
        ALGORITHM_CONSTRAINED;

    }

    public static interface Reason
    extends Serializable {
    }
}

