/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class Jps {
    private static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final String SUN_JVM_ARGS = "sun.jvm.args";
    private static boolean printApplicationArguments;
    private static boolean printJvmArguments;
    private static boolean noPackageName;
    private static boolean vmidOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int rc = 0;
        Jps.parseArguments(args);
        List<AttachProvider> providers = AttachProvider.providers();
        AttachProvider theProvider = null;
        if (0 != providers.size()) {
            theProvider = providers.get(0);
        }
        if (null == theProvider) {
            System.err.println("no attach providers available");
            rc = 1;
        } else {
            List<VirtualMachineDescriptor> vmds = theProvider.listVirtualMachines();
            for (VirtualMachineDescriptor vmd : vmds) {
                StringBuilder outputBuffer = new StringBuilder(vmd.id());
                if (!vmidOnly) {
                    try {
                        VirtualMachine theVm = theProvider.attachVirtualMachine(vmd);
                        try {
                            String jvmArguments;
                            Properties vmProperties = theVm.getSystemProperties();
                            String theCommand = vmProperties.getProperty(SUN_JAVA_COMMAND, "");
                            String[] parts = theCommand.split("\\s+", 2);
                            if (noPackageName) {
                                String[] commandName = parts[0];
                                int finalDot = commandName.lastIndexOf(46);
                                parts[0] = commandName.substring(finalDot + 1);
                            }
                            if (printApplicationArguments) {
                                for (String p : parts) {
                                    outputBuffer.append(' ');
                                    outputBuffer.append(p);
                                }
                            } else if (parts.length > 0) {
                                outputBuffer.append(' ');
                                outputBuffer.append(parts[0]);
                            }
                            if (printJvmArguments && null != (jvmArguments = vmProperties.getProperty(SUN_JVM_ARGS)) && !jvmArguments.isEmpty()) {
                                outputBuffer.append(' ');
                                outputBuffer.append(jvmArguments);
                            }
                        }
                        finally {
                            theVm.detach();
                        }
                    }
                    catch (AttachNotSupportedException | IOException e) {
                        outputBuffer.append(' ');
                        outputBuffer.append("<no information available>");
                    }
                }
                System.out.println(outputBuffer.toString());
            }
        }
        System.exit(rc);
    }

    private static void parseArguments(String[] args) {
        printApplicationArguments = false;
        printJvmArguments = false;
        noPackageName = true;
        vmidOnly = false;
        String HELPTEXT = "jps: Print a list of Java processes and information about them%n    -J: supply arguments to the Java VM running jps%n    -l: print the application package name%n    -q: print only the virtual machine identifiers%n    -m: print the application arguments%n    -v: print the Java VM arguments, including those produced automatically%n";
        String[] stringArray = args;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String a;
            switch (a = stringArray[i]) {
                case "-l": {
                    noPackageName = false;
                    continue block12;
                }
                case "-m": {
                    printApplicationArguments = true;
                    continue block12;
                }
                case "-q": {
                    vmidOnly = true;
                    continue block12;
                }
                case "-v": {
                    printJvmArguments = true;
                    continue block12;
                }
                default: {
                    System.out.printf("jps: Print a list of Java processes and information about them%n    -J: supply arguments to the Java VM running jps%n    -l: print the application package name%n    -q: print only the virtual machine identifiers%n    -m: print the application arguments%n    -v: print the Java VM arguments, including those produced automatically%n", new Object[0]);
                    System.exit(1);
                }
            }
        }
    }
}

