/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import sun.reflect.CallerSensitive;

public final class AccessController {
    static final int OBJS_INDEX_ACC = 0;
    static final int OBJS_INDEX_PDS = 1;
    static final int OBJS_ARRAY_SIZE = 3;
    static final int OBJS_INDEX_PERMS_OR_CACHECHECKED = 2;
    private static final SecurityPermission createAccessControlContext;

    private static native void initializeInternal();

    private AccessController() {
    }

    private static native Object[] getAccSnapshot(int var0, boolean var1);

    private static native ProtectionDomain getCallerPD(int var0);

    private static void throwACE(boolean debug, Permission perm, ProtectionDomain pDomain, boolean createACCdenied) {
        if (debug) {
            DebugRecursionDetection.getTlDebug().set("");
            AccessControlContext.debugPrintAccess();
            if (createACCdenied) {
                System.err.println("access denied " + perm + " due to untrusted AccessControlContext since " + createAccessControlContext + " is denied.");
            } else {
                System.err.println("access denied " + perm);
            }
            DebugRecursionDetection.getTlDebug().remove();
        }
        if (debug && (AccessControlContext.debugSetting() & 8) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            new Exception("Stack trace").printStackTrace();
            if (createACCdenied) {
                System.err.println("domain that failed " + createAccessControlContext + " check " + pDomain);
            } else {
                System.err.println("domain that failed " + pDomain);
            }
            DebugRecursionDetection.getTlDebug().remove();
        }
        if (createACCdenied) {
            throw new AccessControlException(Msg.getString("K002d", perm, createAccessControlContext), perm);
        }
        throw new AccessControlException(Msg.getString("K002c", perm), perm);
    }

    private static boolean checkPermissionHelper(Permission perm, AccessControlContext acc, Object[] objects, int frame, AccessControlContext.AccessCache checked, Object[] objPDomains, int debug, int startPos) {
        ProtectionDomain callerPD;
        int length;
        boolean limitedPermImplied = false;
        boolean debugEnabled = (debug & 2) != 0;
        Object[] pDomains = AccessController.generatePDarray(acc, objPDomains, debugEnabled, startPos);
        if (debugEnabled && 0 != (AccessControlContext.debugSetting() & 4)) {
            DebugRecursionDetection.getTlDebug().set("");
            AccessControlContext.debugPrintAccess();
            if (null == pDomains || 0 == pDomains.length) {
                System.err.println("domain (context is null)");
            } else {
                for (int i = 0; i < pDomains.length; ++i) {
                    System.err.println("domain " + i + " " + pDomains[i]);
                }
            }
            DebugRecursionDetection.getTlDebug().remove();
        }
        int n = length = pDomains == null ? 0 : pDomains.length;
        if (null != acc && null != acc.context && 1 != acc.authorizeState && null != System.getSecurityManager() && null != (callerPD = (ProtectionDomain)objPDomains[startPos - 1]) && !callerPD.implies(createAccessControlContext)) {
            AccessController.throwACE((debug & 1) != 0, perm, callerPD, true);
        }
        if (2 == startPos) {
            if (null != acc && (null != acc.doPrivilegedAcc || null != acc.nextStackAcc || acc.isLimitedContext)) {
                checked = new AccessControlContext.AccessCache();
                return AccessControlContext.checkPermissionWithCache(perm, pDomains, debug, acc, false, null, null, checked);
            }
            if (pDomains != null) {
                for (int i = 0; i < length; ++i) {
                    if (pDomains[length - i - 1] == null || ((ProtectionDomain)pDomains[length - i - 1]).implies(perm)) continue;
                    AccessController.throwACE((debug & 1) != 0, perm, (ProtectionDomain)pDomains[length - i - 1], false);
                }
            }
        } else if (AccessControlContext.checkPermissionWithCache(perm, pDomains, debug, (AccessControlContext)objects[frame * 3], null != objects[frame * 3 + 2], (Permission[])objects[frame * 3 + 2], null, checked)) {
            limitedPermImplied = true;
        }
        return limitedPermImplied;
    }

    private static void debugPrintStack(boolean debug, Permission perm) {
        if (debug && (AccessControlContext.debugSetting() & 2) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            new Exception("Stack trace for " + perm).printStackTrace();
            DebugRecursionDetection.getTlDebug().remove();
        }
    }

    private static boolean debugHelperPreJEP140(Object[] objects, Permission perm) {
        boolean debug = true;
        if (AccessControlContext.debugCodeBaseArray != null) {
            debug = false;
            for (int i = 2; i < objects.length; ++i) {
                CodeSource cs;
                Object pd = objects[i];
                if (pd == null || (cs = ((ProtectionDomain)pd).getCodeSource()) == null || !AccessControlContext.debugCodeBase(cs.getLocation())) continue;
                debug = true;
                break;
            }
            AccessControlContext acc = (AccessControlContext)objects[0];
            if (!debug) {
                boolean bl = debug = acc != null && acc.hasDebugCodeBase();
            }
        }
        if (debug && !AccessControlContext.debugPermission(perm)) {
            debug = false;
        }
        AccessController.debugPrintStack(debug, perm);
        return debug;
    }

    private static boolean debugHelperJEP140(Object[] objects, Permission perm) {
        boolean debug = true;
        if (AccessControlContext.debugCodeBaseArray != null) {
            debug = false;
            block0: for (int j = 0; j < objects.length / 3; ++j) {
                AccessControlContext acc = (AccessControlContext)objects[j * 3];
                Object[] objPDomains = (Object[])objects[j * 3 + 1];
                for (int i = 1; i < objPDomains.length; ++i) {
                    CodeSource cs;
                    Object pd = objPDomains[i];
                    if (pd == null || (cs = ((ProtectionDomain)pd).getCodeSource()) == null || !AccessControlContext.debugCodeBase(cs.getLocation())) continue;
                    debug = true;
                    break block0;
                }
                if (acc == null || !acc.hasDebugCodeBase()) continue;
                debug = true;
                break;
            }
        }
        if (debug) {
            debug = AccessControlContext.debugPermission(perm);
        }
        AccessController.debugPrintStack(debug, perm);
        return debug;
    }

    public static void checkPermission(Permission perm) throws AccessControlException {
        Object[] objects;
        boolean isPreJEP140Format;
        if (perm == null) {
            throw new NullPointerException();
        }
        int debug = 0;
        if (AccessControlContext.debugSetting() != 0 && null == DebugRecursionDetection.getTlDebug().get()) {
            debug = 3;
        }
        boolean bl = isPreJEP140Format = 0 != (objects = AccessController.getAccSnapshot(1, false)).length % 3;
        if (isPreJEP140Format) {
            if (debug != 0 && !AccessController.debugHelperPreJEP140(objects, perm)) {
                debug = 1;
            }
            AccessController.checkPermissionHelper(perm, (AccessControlContext)objects[0], null, 0, null, objects, debug, 2);
        } else {
            Object[] objPDomains;
            AccessControlContext acc;
            int frameNbr = objects.length / 3;
            if (debug != 0 && !AccessController.debugHelperJEP140(objects, perm)) {
                debug = 1;
            }
            AccessControlContext.AccessCache checked = new AccessControlContext.AccessCache();
            for (int j = 0; j < frameNbr && !AccessController.checkPermissionHelper(perm, acc = (AccessControlContext)objects[j * 3], objects, j, checked, objPDomains = (Object[])objects[j * 3 + 1], debug, 1); ++j) {
            }
        }
        if ((debug & 2) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + perm);
            DebugRecursionDetection.getTlDebug().remove();
        }
    }

    private static void keepalive(AccessControlContext context) {
    }

    private static void keepalive(Permission ... perms) {
    }

    public static AccessControlContext getContext() {
        return AccessController.getContextHelper(false);
    }

    @CallerSensitive
    private static AccessControlContext getContextHelper(boolean forDoPrivilegedWithCombiner) {
        boolean isPreJEP140Format;
        Object[] domains = AccessController.getAccSnapshot(2, forDoPrivilegedWithCombiner);
        boolean bl = isPreJEP140Format = 0 != domains.length % 3;
        if (isPreJEP140Format) {
            AccessControlContext acc = (AccessControlContext)domains[0];
            ProtectionDomain[] pDomains = AccessController.generatePDarray(acc, domains, false, 2);
            int newAuthorizedState = AccessController.getNewAuthorizedState(acc, (ProtectionDomain)domains[1]);
            AccessControlContext accTmp = null != acc && (null != acc.doPrivilegedAcc || null != acc.nextStackAcc || acc.isLimitedContext) ? new AccessControlContext(acc, pDomains, newAuthorizedState) : new AccessControlContext(pDomains, newAuthorizedState);
            if (null != acc && null != acc.domainCombiner) {
                accTmp.domainCombiner = acc.domainCombiner;
            }
            return accTmp;
        }
        int frameNbr = domains.length / 3;
        AccessControlContext accContext = null;
        AccessControlContext accLower = null;
        DomainCombiner dc = null;
        for (int j = 0; j < frameNbr; ++j) {
            AccessControlContext acc = (AccessControlContext)domains[j * 3];
            ProtectionDomain[] pDomains = AccessController.generatePDarray(acc, (Object[])domains[j * 3 + 1], false, 1);
            int newAuthorizedState = AccessController.getNewAuthorizedState(acc, (ProtectionDomain)((Object[])domains[j * 3 + 1])[0]);
            AccessControlContext accTmp = null != acc && acc.isLimitedContext || 1 < frameNbr ? new AccessControlContext(acc, pDomains, newAuthorizedState) : new AccessControlContext(pDomains, newAuthorizedState);
            if (null != acc && null != acc.domainCombiner) {
                accTmp.domainCombiner = acc.domainCombiner;
                if (dc == null) {
                    dc = acc.domainCombiner;
                }
            }
            if (null != domains[j * 3 + 2]) {
                accTmp.isLimitedContext = true;
                accTmp.limitedPerms = (Permission[])domains[j * 3 + 2];
            }
            if (null == accLower) {
                accContext = accTmp;
            } else {
                accLower.nextStackAcc = accTmp;
            }
            accLower = accTmp;
        }
        if (accContext != null && accContext.domainCombiner == null && dc != null) {
            accContext.domainCombiner = dc;
        }
        return accContext;
    }

    private static ProtectionDomain[] generatePDarray(AccessControlContext acc, Object[] domains, boolean debug, int startPos) {
        ProtectionDomain[] pDomains = null;
        if (null != acc && null != acc.domainCombiner && (1 == acc.authorizeState || null == System.getSecurityManager())) {
            if (debug) {
                DebugRecursionDetection.getTlDebug().set("");
                AccessControlContext.debugPrintAccess();
                System.err.println("AccessController invoking the Combiner");
                DebugRecursionDetection.getTlDebug().remove();
            }
            pDomains = acc.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(domains, null, startPos), acc.context);
        } else {
            pDomains = AccessController.toArrayOfProtectionDomains(domains, acc, startPos);
        }
        if (null != pDomains && 0 == pDomains.length) {
            pDomains = null;
        }
        return pDomains;
    }

    private static int getNewAuthorizedState(AccessControlContext acc, ProtectionDomain callerPD) {
        int newAuthorizedState;
        if (null != acc && null != System.getSecurityManager()) {
            newAuthorizedState = acc.authorizeState;
            if (2 == newAuthorizedState) {
                newAuthorizedState = null == callerPD || callerPD.implies(createAccessControlContext) ? 1 : 0;
            }
        } else {
            newAuthorizedState = 1;
        }
        return newAuthorizedState;
    }

    static ProtectionDomain[] toArrayOfProtectionDomains(Object[] domains, AccessControlContext acc, int startPos) {
        ProtectionDomain[] accDomains = acc == null ? null : acc.context;
        ProtectionDomain[] answer = null;
        if (domains == null) {
            if (accDomains != null && accDomains.length != 0) {
                answer = accDomains;
            }
        } else if (accDomains == null) {
            int domainCount = domains.length - startPos;
            for (int i = 0; i < domainCount; ++i) {
                if (domains[startPos + i] != null) continue;
                domainCount = i;
                break;
            }
            if (domainCount > 0) {
                answer = new ProtectionDomain[domainCount];
                System.arraycopy((Object)domains, startPos, (Object)answer, 0, domainCount);
            }
        } else {
            Object domain;
            int domainCount = domains.length;
            int accDomainCount = accDomains.length;
            int newDomainCount = 0;
            answer = new ProtectionDomain[domainCount + accDomainCount];
            block1: for (int i = startPos; i < domainCount && (domain = domains[i]) != null; ++i) {
                int j = accDomainCount;
                do {
                    if (--j >= 0) continue;
                    answer[newDomainCount] = (ProtectionDomain)domain;
                    ++newDomainCount;
                    continue block1;
                } while (accDomains[j] != domain);
            }
            if (newDomainCount + accDomainCount == 0) {
                answer = null;
            } else if (newDomainCount == 0) {
                answer = accDomains;
            } else {
                if (newDomainCount < domainCount) {
                    ProtectionDomain[] copy = new ProtectionDomain[newDomainCount + accDomainCount];
                    System.arraycopy((Object)answer, 0, (Object)copy, 0, newDomainCount);
                    answer = copy;
                }
                System.arraycopy((Object)accDomains, 0, (Object)answer, newDomainCount, accDomainCount);
            }
        }
        return answer;
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        return action.run();
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) {
        T result = action.run();
        AccessController.keepalive(context);
        return result;
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        try {
            return action.run();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        try {
            T result = action.run();
            AccessController.keepalive(context);
            return result;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action, AccessController.getContextHelper(true));
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return AccessController.doPrivileged(action, AccessController.getContextHelper(true));
    }

    private static void checkPermsNPE(Permission ... perms) {
        for (int i = 0; i < perms.length; ++i) {
            if (null != perms[i]) continue;
            throw new NullPointerException();
        }
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context, Permission ... perms) {
        AccessController.checkPermsNPE(perms);
        T result = action.run();
        AccessController.keepalive(context);
        AccessController.keepalive(perms);
        return result;
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action, AccessControlContext context, Permission ... perms) {
        ProtectionDomain[] protectionDomainArray;
        AccessController.checkPermsNPE(perms);
        ProtectionDomain domain = AccessController.getCallerPD(1);
        if (domain == null) {
            protectionDomainArray = null;
        } else {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
            protectionDomainArray = protectionDomainArray2;
            protectionDomainArray2[0] = domain;
        }
        ProtectionDomain[] pdArray = protectionDomainArray;
        return AccessController.doPrivileged(action, new AccessControlContext(context, pdArray, AccessController.getNewAuthorizedState(context, domain)), perms);
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context, Permission ... perms) throws PrivilegedActionException {
        try {
            AccessController.checkPermsNPE(perms);
            T result = action.run();
            AccessController.keepalive(context);
            AccessController.keepalive(perms);
            return result;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
    }

    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action, AccessControlContext context, Permission ... perms) throws PrivilegedActionException {
        ProtectionDomain[] protectionDomainArray;
        AccessController.checkPermsNPE(perms);
        ProtectionDomain domain = AccessController.getCallerPD(1);
        if (domain == null) {
            protectionDomainArray = null;
        } else {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
            protectionDomainArray = protectionDomainArray2;
            protectionDomainArray2[0] = domain;
        }
        ProtectionDomain[] pdArray = protectionDomainArray;
        return AccessController.doPrivileged(action, new AccessControlContext(context, pdArray, AccessController.getNewAuthorizedState(context, domain)), perms);
    }

    static {
        AccessController.initializeInternal();
        createAccessControlContext = new SecurityPermission("createAccessControlContext");
    }

    static final class DebugRecursionDetection {
        private static ThreadLocal<String> tlDebug = new ThreadLocal();

        DebugRecursionDetection() {
        }

        static ThreadLocal<String> getTlDebug() {
            return tlDebug;
        }
    }
}

