/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.LockInfoUtil;
import com.ibm.java.lang.management.internal.ManagementAccessControl;
import com.ibm.java.lang.management.internal.MonitorInfoUtil;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import com.ibm.java.lang.management.internal.ThreadInfoUtil;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfoAccessImpl;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class ThreadInfo {
    private long threadId;
    private long nativeTId;
    private String threadName;
    private Thread.State threadState;
    private boolean suspended;
    private boolean inNative;
    private long blockedCount;
    private long blockedTime;
    private long waitedCount;
    private long waitedTime;
    private String lockName;
    private long lockOwnerId = -1L;
    private String lockOwnerName;
    private StackTraceElement[] stackTraces = new StackTraceElement[0];
    private LockInfo lockInfo;
    private LockInfo[] lockedSynchronizers = new LockInfo[0];
    private MonitorInfo[] lockedMonitors = new MonitorInfo[0];
    private String TOSTRING_VALUE;

    private ThreadInfo(long threadIdVal, String threadNameVal, Thread.State threadStateVal, boolean suspendedVal, boolean inNativeVal, long blockedCountVal, long blockedTimeVal, long waitedCountVal, long waitedTimeVal, String lockNameVal, long lockOwnerIdVal, String lockOwnerNameVal, StackTraceElement[] stackTraceVal, LockInfo lockInfo, MonitorInfo[] lockedMonitors, LockInfo[] lockedSynchronizers) {
        this.threadId = threadIdVal;
        this.threadName = threadNameVal;
        this.threadState = threadStateVal;
        this.suspended = suspendedVal;
        this.inNative = inNativeVal;
        this.blockedCount = blockedCountVal;
        this.blockedTime = blockedTimeVal;
        this.waitedCount = waitedCountVal;
        this.waitedTime = waitedTimeVal;
        this.lockName = lockNameVal;
        this.lockOwnerId = lockOwnerIdVal;
        this.lockOwnerName = lockOwnerNameVal;
        this.stackTraces = stackTraceVal;
        this.lockInfo = lockInfo;
        this.lockedMonitors = lockedMonitors;
        this.lockedSynchronizers = lockedSynchronizers;
    }

    private ThreadInfo(Thread thread, long nativeId, int state, boolean isSuspended, boolean isInNative, long blockedCount, long blockedTime, long waitedCount, long waitedTime, StackTraceElement[] stackTrace, Object blockingMonitor, Thread lockOwner) {
        this.threadId = thread.getId();
        this.nativeTId = nativeId;
        this.threadName = thread.getName();
        this.threadState = Thread.State.values()[state];
        this.suspended = isSuspended;
        this.inNative = isInNative;
        this.blockedCount = blockedCount;
        this.blockedTime = blockedTime;
        this.waitedCount = waitedCount;
        this.waitedTime = waitedTime;
        if (lockOwner != null) {
            this.lockOwnerId = lockOwner.getId();
            this.lockOwnerName = lockOwner.getName();
        }
        this.stackTraces = stackTrace;
        if (blockingMonitor != null) {
            this.lockName = blockingMonitor.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(blockingMonitor));
        }
    }

    private ThreadInfo(Thread thread, long nativeId, int state, boolean isSuspended, boolean isInNative, long blockedCount, long blockedTime, long waitedCount, long waitedTime, StackTraceElement[] stackTrace, Object blockingObject, Thread blockingObjectOwner, MonitorInfo[] lockedMonitors, LockInfo[] lockedSynchronizers) {
        this(thread, nativeId, state, isSuspended, isInNative, blockedCount, blockedTime, waitedCount, waitedTime, stackTrace, blockingObject, blockingObjectOwner);
        this.lockedMonitors = lockedMonitors;
        this.lockedSynchronizers = lockedSynchronizers;
        if (blockingObject != null) {
            this.lockInfo = new LockInfo(blockingObject.getClass().getName(), System.identityHashCode(blockingObject));
        }
        if (this.lockInfo != null) {
            this.lockName = this.lockInfo.toString();
        }
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public LockInfo getLockInfo() {
        return this.lockInfo;
    }

    long getNativeThreadId() {
        return this.nativeTId;
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.stackTraces.clone();
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public boolean isInNative() {
        return this.inNative;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public MonitorInfo[] getLockedMonitors() {
        return this.lockedMonitors;
    }

    public LockInfo[] getLockedSynchronizers() {
        return this.lockedSynchronizers;
    }

    public static ThreadInfo from(CompositeData cd) {
        ThreadInfo result = null;
        if (cd != null) {
            StackTraceElement[] stackTraceVals;
            String lockOwnerNameVal;
            long lockOwnerIdVal;
            String lockNameVal;
            long waitedTimeVal;
            long waitedCountVal;
            long blockedTimeVal;
            long blockedCountVal;
            boolean inNativeVal;
            boolean suspendedVal;
            Thread.State threadStateVal;
            String threadNameVal;
            long threadIdVal;
            if (!ThreadInfoUtil.getCompositeType().isValue(cd)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                threadIdVal = (Long)cd.get("threadId");
                threadNameVal = (String)cd.get("threadName");
                String threadStateStringVal = (String)cd.get("threadState");
                try {
                    threadStateVal = Thread.State.valueOf(threadStateStringVal);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(Msg.getString("K0612", e));
                }
                suspendedVal = (Boolean)cd.get("suspended");
                inNativeVal = (Boolean)cd.get("inNative");
                blockedCountVal = (Long)cd.get("blockedCount");
                blockedTimeVal = (Long)cd.get("blockedTime");
                waitedCountVal = (Long)cd.get("waitedCount");
                waitedTimeVal = (Long)cd.get("waitedTime");
                lockNameVal = (String)cd.get("lockName");
                lockOwnerIdVal = (Long)cd.get("lockOwnerId");
                lockOwnerNameVal = (String)cd.get("lockOwnerName");
                CompositeData[] stackTraceDataVal = (CompositeData[])cd.get("stackTrace");
                stackTraceVals = StackTraceElementUtil.fromArray(stackTraceDataVal);
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            LockInfo lockInfoVal = ThreadInfo.recoverLockInfoAttribute(cd, lockNameVal);
            MonitorInfo[] lockedMonitorVals = ThreadInfo.recoverLockedMonitors(cd);
            LockInfo[] lockedSynchronizerVals = ThreadInfo.recoverLockedSynchronizers(cd);
            result = new ThreadInfo(threadIdVal, threadNameVal, threadStateVal, suspendedVal, inNativeVal, blockedCountVal, blockedTimeVal, waitedCountVal, waitedTimeVal, lockNameVal, lockOwnerIdVal, lockOwnerNameVal, stackTraceVals, lockInfoVal, lockedMonitorVals, lockedSynchronizerVals);
        }
        return result;
    }

    private static LockInfo[] recoverLockedSynchronizers(CompositeData cd) {
        LockInfo[] result;
        try {
            CompositeData[] lockedSynchronizersDataVal = (CompositeData[])cd.get("lockedSynchronizers");
            result = LockInfoUtil.fromArray(lockedSynchronizersDataVal);
        }
        catch (InvalidKeyException e) {
            result = new LockInfo[]{};
        }
        return result;
    }

    private static MonitorInfo[] recoverLockedMonitors(CompositeData cd) {
        MonitorInfo[] result;
        try {
            CompositeData[] lockedMonitorsDataVal = (CompositeData[])cd.get("lockedMonitors");
            result = MonitorInfoUtil.fromArray(lockedMonitorsDataVal);
        }
        catch (InvalidKeyException e) {
            result = new MonitorInfo[]{};
        }
        return result;
    }

    private static LockInfo recoverLockInfoAttribute(CompositeData cd, String lockNameVal) {
        LockInfo result = null;
        try {
            CompositeData lockInfoCDVal;
            CompositeData compositeData = lockInfoCDVal = cd.get("lockInfo") != null ? (CompositeData)cd.get("lockInfo") : null;
            if (lockInfoCDVal != null) {
                if (!LockInfoUtil.getCompositeType().isValue(lockInfoCDVal)) {
                    throw new IllegalArgumentException(Msg.getString("K05E5"));
                }
                result = new LockInfo((String)lockInfoCDVal.get("className"), (Integer)lockInfoCDVal.get("identityHashCode"));
            }
        }
        catch (InvalidKeyException e) {
            result = ThreadInfo.createLockInfoFromLockName(lockNameVal);
        }
        return result;
    }

    public String toString() {
        String ls = System.lineSeparator();
        if (this.TOSTRING_VALUE == null) {
            StringBuilder result = new StringBuilder();
            result.append(String.format("\"%s\" Id=%d %s", new Object[]{this.threadName, this.threadId, this.threadState}));
            if (Thread.State.BLOCKED == this.threadState) {
                result.append(String.format(" on %s owned by \"%s\" Id=%d", this.lockName, this.lockOwnerName, this.lockOwnerId));
            }
            if (this.stackTraces != null && this.stackTraces.length > 0) {
                result.append(ls);
                MonitorInfo[] lockList = this.getLockedMonitors();
                MonitorInfo[] lockArray = new MonitorInfo[this.stackTraces.length];
                for (MonitorInfo mi : lockList) {
                    int lockDepth = mi.getLockedStackDepth();
                    lockArray[lockDepth] = mi;
                }
                int stackDepth = 0;
                for (StackTraceElement element : this.stackTraces) {
                    result.append("\tat ");
                    Util.printStackTraceElement(element, null, result, true);
                    result.append(ls);
                    if (null != lockArray[stackDepth]) {
                        MonitorInfo mi = lockArray[stackDepth];
                        result.append(String.format("\t- locked %s%n", mi.toString()));
                    }
                    ++stackDepth;
                }
            } else {
                result.append(" null");
                result.append(ls);
            }
            this.TOSTRING_VALUE = result.toString();
        }
        return this.TOSTRING_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ThreadInfo ti = (ThreadInfo)obj;
        if (ti.getBlockedCount() != this.getBlockedCount()) {
            return false;
        }
        if (ti.getBlockedTime() != this.getBlockedTime()) {
            return false;
        }
        if (ti.getLockName() != null && this.getLockName() != null ? !ti.getLockName().equals(this.getLockName()) : ti.getLockName() != this.getLockName()) {
            return false;
        }
        if (ti.getLockOwnerId() != this.getLockOwnerId()) {
            return false;
        }
        if (ti.getLockOwnerName() != null && this.getLockOwnerName() != null ? !ti.getLockOwnerName().equals(this.getLockOwnerName()) : ti.getLockOwnerName() != this.getLockOwnerName()) {
            return false;
        }
        if (ti.getLockInfo() != null && this.getLockInfo() != null ? !ti.getLockInfo().toString().equals(this.getLockInfo().toString()) : ti.getLockInfo() != this.getLockInfo()) {
            return false;
        }
        if (!Arrays.equals(ti.getStackTrace(), this.getStackTrace())) {
            return false;
        }
        if (ti.getThreadId() != this.getThreadId()) {
            return false;
        }
        if (!ti.getThreadName().equals(this.getThreadName())) {
            return false;
        }
        if (!ti.getThreadState().equals((Object)this.getThreadState())) {
            return false;
        }
        if (ti.getWaitedCount() != this.getWaitedCount()) {
            return false;
        }
        if (ti.getWaitedTime() != this.getWaitedTime()) {
            return false;
        }
        if (ti.isInNative() != this.isInNative()) {
            return false;
        }
        return ti.isSuspended() == this.isSuspended();
    }

    public int hashCode() {
        return (Long.toString(this.getBlockedCount()) + this.getBlockedTime() + this.getLockName() + this.getLockOwnerId() + this.getLockOwnerName() + this.getStackTrace().length + this.getThreadId() + this.getThreadName() + (Object)((Object)this.getThreadState()) + this.getWaitedCount() + this.getWaitedTime() + this.isInNative() + this.isSuspended()).hashCode();
    }

    private static LockInfo createLockInfoFromLockName(String lockString) {
        StringTokenizer strTok;
        LockInfo result = null;
        if (lockString != null && lockString.length() > 0 && (strTok = new StringTokenizer(lockString, "@")).countTokens() == 2) {
            try {
                result = new LockInfo(strTok.nextToken(), Integer.parseInt(strTok.nextToken(), 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    static {
        ManagementAccessControl.setThreadInfoAccess(new ThreadInfoAccessImpl());
    }
}

