/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import com.ibm.oti.util.Msg;
import java.lang.management.LockInfo;
import javax.management.openmbean.CompositeData;

public class MonitorInfo
extends LockInfo {
    private final int stackDepth;
    private final StackTraceElement stackFrame;

    public MonitorInfo(String className, int identityHashCode, int stackDepth, StackTraceElement stackFrame) {
        super(className, identityHashCode);
        if (stackFrame == null && stackDepth >= 0 || stackFrame != null && stackDepth < 0) {
            String arg = stackFrame == null ? Msg.getString("K0610") : Msg.getString("K0611");
            throw new IllegalArgumentException(Msg.getString("K060F", stackDepth, arg));
        }
        this.stackDepth = stackDepth;
        this.stackFrame = stackFrame;
    }

    private MonitorInfo(Object object, int stackDepth, StackTraceElement stackFrame) {
        super(object.getClass().getName(), System.identityHashCode(object));
        this.stackDepth = stackDepth;
        this.stackFrame = stackFrame;
    }

    public int getLockedStackDepth() {
        return this.stackDepth;
    }

    public StackTraceElement getLockedStackFrame() {
        return this.stackFrame;
    }

    public static MonitorInfo from(CompositeData cd) {
        MonitorInfo result = null;
        if (cd != null) {
            ManagementUtils.verifyFieldNumber(cd, 4);
            String[] attributeNames = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            ManagementUtils.verifyFieldNames(cd, attributeNames);
            String[] attributeTypes = new String[]{"java.lang.String", "java.lang.Integer", CompositeData.class.getName(), "java.lang.Integer"};
            ManagementUtils.verifyFieldTypes(cd, attributeNames, attributeTypes);
            Object[] attributeVals = cd.getAll(attributeNames);
            String classNameVal = (String)attributeVals[0];
            int idHashCodeVal = (Integer)attributeVals[1];
            CompositeData lockedStackFrameCDVal = (CompositeData)attributeVals[2];
            StackTraceElement lockedStackFrameVal = StackTraceElementUtil.from(lockedStackFrameCDVal);
            int lockedStackDepthVal = (Integer)attributeVals[3];
            result = new MonitorInfo(classNameVal, idHashCodeVal, lockedStackDepthVal, lockedStackFrameVal);
        }
        return result;
    }
}

