/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import java.lang.management.MemoryUsage;
import javax.management.openmbean.CompositeData;

public class MemoryNotificationInfo {
    public static final String MEMORY_THRESHOLD_EXCEEDED = "java.management.memory.threshold.exceeded";
    public static final String MEMORY_COLLECTION_THRESHOLD_EXCEEDED = "java.management.memory.collection.threshold.exceeded";
    private String poolName;
    private MemoryUsage usage;
    private long count;

    public MemoryNotificationInfo(String poolName, MemoryUsage usage, long count) {
        this.poolName = poolName;
        this.usage = usage;
        this.count = count;
    }

    public long getCount() {
        return this.count;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public MemoryUsage getUsage() {
        return this.usage;
    }

    public static MemoryNotificationInfo from(CompositeData cd) {
        MemoryNotificationInfo result = null;
        if (cd != null) {
            ManagementUtils.verifyFieldNumber(cd, 3);
            String[] attributeNames = new String[]{"poolName", "usage", "count"};
            ManagementUtils.verifyFieldNames(cd, attributeNames);
            String[] attributeTypes = new String[]{"java.lang.String", CompositeData.class.getName(), "java.lang.Long"};
            ManagementUtils.verifyFieldTypes(cd, attributeNames, attributeTypes);
            Object[] attributeVals = cd.getAll(attributeNames);
            String poolNameVal = (String)attributeVals[0];
            MemoryUsage usageVal = MemoryUsage.from((CompositeData)attributeVals[1]);
            long countVal = (Long)attributeVals[2];
            result = new MemoryNotificationInfo(poolNameVal, usageVal, countVal);
        }
        return result;
    }
}

