/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ClassLoadingMXBeanImpl;
import com.ibm.java.lang.management.internal.CompilationMXBeanImpl;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.lang.management.internal.ExtendedMemoryMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedOperatingSystemMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedRuntimeMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedThreadMXBeanImpl;
import com.ibm.lang.management.internal.OpenTypeMappingIHandler;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerPermission;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

public class ManagementFactory {
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ClassLoadingMXBeanImpl.getInstance();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return CompilationMXBeanImpl.getInstance();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ExtendedMemoryMXBeanImpl.getInstance().getGarbageCollectorMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ExtendedMemoryMXBeanImpl.getInstance().getMemoryManagerMXBeans(true);
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ExtendedMemoryMXBeanImpl.getInstance();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ExtendedMemoryMXBeanImpl.getInstance().getMemoryPoolMXBeans(true);
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ExtendedOperatingSystemMXBeanImpl.getInstance();
    }

    public static MBeanServer getPlatformMBeanServer() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new MBeanServerPermission("createMBeanServer"));
        }
        return ServerHolder.platformServer;
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ExtendedRuntimeMXBeanImpl.getInstance();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ExtendedThreadMXBeanImpl.getInstance();
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection connection, String mxbeanName, Class<T> mxbeanInterface) throws IOException {
        ObjectName mxbeanObjectName = ManagementUtils.checkNamedMXBean(mxbeanName, mxbeanInterface);
        Class[] interfaces = ManagementUtils.isANotificationEmitter(connection, mxbeanObjectName) ? new Class[]{mxbeanInterface, NotificationEmitter.class} : new Class[]{mxbeanInterface};
        OpenTypeMappingIHandler handler = new OpenTypeMappingIHandler(connection, mxbeanInterface, mxbeanObjectName);
        Object proxyInstance = Proxy.newProxyInstance(mxbeanInterface.getClassLoader(), interfaces, (InvocationHandler)handler);
        return mxbeanInterface.cast(proxyInstance);
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> mxbeanInterface) {
        return ManagementUtils.getPlatformMXBean(mxbeanInterface);
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> mxbeanInterface) throws IllegalArgumentException {
        return ManagementUtils.getPlatformMXBeans(mxbeanInterface);
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(MBeanServerConnection connection, Class<T> mxbeanInterface) throws IOException {
        ManagementUtils.checkSupportedSingleton(mxbeanInterface);
        String interfaceName = mxbeanInterface.getName();
        Set<ObjectName> beanNames = connection.queryNames(null, null);
        for (ObjectName objectName : beanNames) {
            block4: {
                try {
                    if (!connection.isInstanceOf(objectName, interfaceName)) {
                    }
                    break block4;
                }
                catch (InstanceNotFoundException e) {
                    if (!ManagementUtils.VERBOSE_MODE) continue;
                    e.printStackTrace(System.err);
                }
                continue;
            }
            return (T)((PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy(connection, objectName.toString(), mxbeanInterface));
        }
        return null;
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(MBeanServerConnection connection, Class<T> mxbeanInterface) throws IllegalArgumentException, IOException {
        ManagementUtils.checkSupported(mxbeanInterface);
        LinkedList<T> matchedBeans = new LinkedList<T>();
        Set<ObjectName> beanNames = connection.queryNames(null, null);
        for (ObjectName objectName : beanNames) {
            block4: {
                try {
                    if (!connection.isInstanceOf(objectName, mxbeanInterface.getName())) {
                    }
                    break block4;
                }
                catch (InstanceNotFoundException e) {
                    if (!ManagementUtils.VERBOSE_MODE) continue;
                    e.printStackTrace(System.err);
                }
                continue;
            }
            matchedBeans.add(ManagementFactory.newPlatformMXBeanProxy(connection, objectName.toString(), mxbeanInterface));
        }
        return matchedBeans;
    }

    public static Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        return ManagementUtils.getPlatformManagementInterfaces();
    }

    private static final class ServerHolder {
        static final MBeanServer platformServer = MBeanServerFactory.createMBeanServer();

        private ServerHolder() {
        }

        private static Void registerPlatformBeans() {
            for (PlatformManagedObject bean : ManagementUtils.getAllAvailableMXBeans()) {
                ObjectName objectName = bean.getObjectName();
                if (platformServer.isRegistered(objectName)) continue;
                try {
                    platformServer.registerMBean(bean, objectName);
                }
                catch (NullPointerException | InstanceAlreadyExistsException | MBeanRegistrationException e) {
                    if (!ManagementUtils.VERBOSE_MODE) continue;
                    e.printStackTrace(System.err);
                }
                catch (NotCompliantMBeanException e) {
                    e.printStackTrace();
                    if (!ManagementUtils.VERBOSE_MODE) continue;
                    e.printStackTrace(System.err);
                }
            }
            return null;
        }

        static {
            PrivilegedAction<Object> action = ServerHolder::registerPlatformBeans;
            AccessController.doPrivileged(action);
        }
    }
}

