/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;

public class LockInfo {
    private final String className;
    private final int identityHashCode;

    private LockInfo(Object object) {
        this(object.getClass().getName(), System.identityHashCode(object));
    }

    public LockInfo(String className, int identityHashCode) {
        if (className == null) {
            throw new NullPointerException(Msg.getString("K0600"));
        }
        this.className = className;
        this.identityHashCode = identityHashCode;
    }

    public String getClassName() {
        return this.className;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public static LockInfo from(CompositeData compositeData) {
        LockInfo element = null;
        if (compositeData != null) {
            ManagementUtils.verifyFieldNumber(compositeData, 2);
            String[] attributeNames = new String[]{"className", "identityHashCode"};
            ManagementUtils.verifyFieldNames(compositeData, attributeNames);
            String[] attributeTypes = new String[]{"java.lang.String", "java.lang.Integer"};
            ManagementUtils.verifyFieldTypes(compositeData, attributeNames, attributeTypes);
            Object[] attributeVals = compositeData.getAll(attributeNames);
            String className = (String)attributeVals[0];
            int idHashCode = (Integer)attributeVals[1];
            element = new LockInfo(className, idHashCode);
        }
        return element;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.className);
        sb.append('@');
        sb.append(Integer.toHexString(this.identityHashCode));
        return sb.toString();
    }
}

