/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.PermuteHandle;
import java.lang.invoke.PrimitiveHandle;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Modifier;

final class ReceiverBoundHandle
extends DirectHandle {
    final Object receiver;
    final MethodHandle combinableVersion;
    private static final ThunkTable _thunkTable = new ThunkTable();

    public ReceiverBoundHandle(PrimitiveHandle toBind, Object receiver, MethodHandle combinableVersion) {
        super(toBind, (byte)0);
        if (!(toBind instanceof DirectHandle)) {
            throw new IllegalArgumentException();
        }
        this.vmSlot = toBind.vmSlot;
        this.receiver = receiver;
        this.defc = toBind.defc;
        this.combinableVersion = combinableVersion;
    }

    private ReceiverBoundHandle(ReceiverBoundHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.receiver = originalHandle.receiver;
        this.combinableVersion = originalHandle.combinableVersion.cloneWithNewType(newType);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new ReceiverBoundHandle(this, newType);
    }

    static final MethodType receiverBoundMethodType(MethodType type) {
        return type.dropFirstParameterType();
    }

    @Override
    boolean canRevealDirect() {
        return false;
    }

    @Override
    MethodHandle permuteArguments(MethodType permuteType, int ... permute) throws NullPointerException, IllegalArgumentException {
        MethodHandle result = new PermuteHandle(permuteType, this, permute);
        result = this.combinableVersion.permuteArguments(permuteType, permute);
        return result;
    }

    @Override
    MethodHandle insertArguments(MethodHandle equivalent, MethodHandle unboxingHandle, int location, Object ... values) {
        MethodHandle result = equivalent;
        result = this.combinableVersion.insertArguments(equivalent, unboxingHandle, location, values);
        return result;
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    final void nullCheckReceiverIfNonStatic() {
        if (this.receiver == null && !Modifier.isStatic(this.final_modifiers)) {
            this.receiver.getClass();
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(int argPlaceholder) {
        this.nullCheckReceiverIfNonStatic();
        if (ILGenMacros.isCustomThunk()) {
            ReceiverBoundHandle.directCall_V(this.receiver, argPlaceholder);
        } else if (ReceiverBoundHandle.isAlreadyCompiled(this.vmSlot)) {
            ComputedCalls.dispatchDirect_V(ReceiverBoundHandle.compiledEntryPoint(this.vmSlot), this.receiver, argPlaceholder);
        } else {
            ComputedCalls.dispatchJ9Method_V(this.vmSlot, this.receiver, argPlaceholder);
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_I(int argPlaceholder) {
        this.nullCheckReceiverIfNonStatic();
        if (ILGenMacros.isCustomThunk()) {
            return ReceiverBoundHandle.directCall_I(this.receiver, argPlaceholder);
        }
        if (ReceiverBoundHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_I(ReceiverBoundHandle.compiledEntryPoint(this.vmSlot), this.receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_I(this.vmSlot, this.receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final long invokeExact_thunkArchetype_J(int argPlaceholder) {
        this.nullCheckReceiverIfNonStatic();
        if (ILGenMacros.isCustomThunk()) {
            return ReceiverBoundHandle.directCall_J(this.receiver, argPlaceholder);
        }
        if (ReceiverBoundHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_J(ReceiverBoundHandle.compiledEntryPoint(this.vmSlot), this.receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_J(this.vmSlot, this.receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final float invokeExact_thunkArchetype_F(int argPlaceholder) {
        this.nullCheckReceiverIfNonStatic();
        if (ILGenMacros.isCustomThunk()) {
            return ReceiverBoundHandle.directCall_F(this.receiver, argPlaceholder);
        }
        if (ReceiverBoundHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_F(ReceiverBoundHandle.compiledEntryPoint(this.vmSlot), this.receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_F(this.vmSlot, this.receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final double invokeExact_thunkArchetype_D(int argPlaceholder) {
        this.nullCheckReceiverIfNonStatic();
        if (ILGenMacros.isCustomThunk()) {
            return ReceiverBoundHandle.directCall_D(this.receiver, argPlaceholder);
        }
        if (ReceiverBoundHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_D(ReceiverBoundHandle.compiledEntryPoint(this.vmSlot), this.receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_D(this.vmSlot, this.receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final Object invokeExact_thunkArchetype_L(int argPlaceholder) {
        this.nullCheckReceiverIfNonStatic();
        if (ILGenMacros.isCustomThunk()) {
            return ReceiverBoundHandle.directCall_L(this.receiver, argPlaceholder);
        }
        if (ReceiverBoundHandle.isAlreadyCompiled(this.vmSlot)) {
            return ComputedCalls.dispatchDirect_L(ReceiverBoundHandle.compiledEntryPoint(this.vmSlot), this.receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchJ9Method_L(this.vmSlot, this.receiver, argPlaceholder);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof ReceiverBoundHandle) {
            ((ReceiverBoundHandle)right).compareWithReceiverBound(this, c);
        } else {
            c.fail();
        }
    }

    @Override
    void compareWithDirect(DirectHandle left, Comparator c) {
        c.fail();
    }

    final void compareWithReceiverBound(ReceiverBoundHandle left, Comparator c) {
        c.compareUserSuppliedParameter(left.receiver, this.receiver);
        super.compareWithDirect(left, c);
    }
}

