/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithIntArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;

final class PermuteHandle
extends MethodHandle {
    private final MethodHandle next;
    private final int[] permute;
    private static final ThunkTable _thunkTable = new ThunkTable();

    PermuteHandle(MethodType type, MethodHandle next, int[] permute) {
        super(type, (byte)21, permute);
        this.next = next;
        this.permute = permute;
    }

    PermuteHandle(PermuteHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.permute = originalHandle.permute;
    }

    @Override
    MethodHandle permuteArguments(MethodType permuteType, int ... permute2) {
        int[] combinedPermute = new int[this.permute.length];
        for (int i = 0; i < this.permute.length; ++i) {
            combinedPermute[i] = permute2[this.permute[i]];
        }
        return new PermuteHandle(permuteType, this.next, combinedPermute);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    protected final ThunkTuple computeThunks(Object permutationArg) {
        int[] permutation = (int[])permutationArg;
        return this.thunkTable().get(new ThunkKeyWithIntArray(ThunkKey.computeThunkableType(this.type()), permutation));
    }

    private static native int permuteArgs(int var0);

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int argPlaceholder) {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.next);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        return ILGenMacros.invokeExact_X(this.next, PermuteHandle.permuteArgs(argPlaceholder));
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new PermuteHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof PermuteHandle) {
            ((PermuteHandle)right).compareWithPermute(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithPermute(PermuteHandle left, Comparator c) {
        c.compareStructuralParameter(left.permute.length, this.permute.length);
        for (int i = 0; i < left.permute.length && i < this.permute.length; ++i) {
            c.compareStructuralParameter(left.permute[i], this.permute[i]);
        }
        c.compareChildHandle(left.next, this.next);
    }
}

