/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CallSite;
import java.lang.invoke.GlobalRefCleaner;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSiteDynamicInvokerHandle;
import java.lang.invoke.StructuralComparator;
import java.lang.invoke.WrongMethodTypeException;
import sun.misc.Cleaner;

public class MutableCallSite
extends CallSite {
    private MutableCallSiteDynamicInvokerHandle cachedDynamicInvoker;
    private final GlobalRefCleaner globalRefCleaner;
    private static final long targetFieldOffset;
    private volatile MethodHandle target;
    private volatile MethodHandle epoch;
    private static final Object bypassBase;
    private int equivalenceInterval = 0;
    private int equivalenceCounter = 0;
    private long invalidationCookie;

    private static native void registerNatives();

    private static long initializeTargetFieldOffset() {
        try {
            return MethodHandle.UNSAFE.objectFieldOffset(MutableCallSite.class.getDeclaredField("target"));
        }
        catch (Exception e) {
            InternalError ie = new InternalError();
            ie.initCause(e);
            throw ie;
        }
    }

    public MutableCallSite(MethodHandle mutableTarget) throws NullPointerException {
        super(mutableTarget.type());
        this.target = this.epoch = mutableTarget;
        this.freeze();
        this.globalRefCleaner = new GlobalRefCleaner();
        Cleaner.create((Object)this, (Runnable)this.globalRefCleaner);
    }

    public MutableCallSite(MethodType type) throws NullPointerException {
        super(type);
        this.target = CallSite.initialTarget(type);
        this.epoch = null;
        this.freeze();
        this.globalRefCleaner = new GlobalRefCleaner();
        Cleaner.create((Object)this, (Runnable)this.globalRefCleaner);
    }

    @Override
    public final MethodHandle dynamicInvoker() {
        if (null == this.cachedDynamicInvoker) {
            this.cachedDynamicInvoker = new MutableCallSiteDynamicInvokerHandle(this);
        }
        return this.cachedDynamicInvoker;
    }

    @Override
    public final MethodHandle getTarget() {
        return this.target;
    }

    private static Object initializeBypassBase() {
        try {
            return MethodHandle.UNSAFE.staticFieldBase(MutableCallSite.class.getDeclaredField("targetFieldOffset"));
        }
        catch (Exception e) {
            InternalError ie = new InternalError();
            ie.initCause(e);
            throw ie;
        }
    }

    @Override
    public void setTarget(MethodHandle newTarget) {
        if (this.type() != newTarget.type) {
            throw WrongMethodTypeException.newWrongMethodTypeException(this.type(), newTarget.type);
        }
        MethodHandle oldTarget = this.target;
        if (oldTarget != newTarget) {
            if (--this.equivalenceCounter <= 0) {
                if (StructuralComparator.get().handlesAreEquivalent(oldTarget, newTarget)) {
                    this.equivalenceInterval = 1;
                    MethodHandle.UNSAFE.compareAndSwapObject(this, targetFieldOffset, oldTarget, newTarget);
                } else {
                    this.thaw(oldTarget, newTarget);
                    this.equivalenceInterval = Math.min(1 + this.equivalenceInterval + (this.equivalenceInterval >> 2), 1000);
                }
                this.equivalenceCounter = this.equivalenceInterval;
            } else {
                this.thaw(oldTarget, newTarget);
            }
            if (this.globalRefCleaner.bypassOffset != 0L) {
                MethodHandle.UNSAFE.putObject(bypassBase, this.globalRefCleaner.bypassOffset, newTarget);
            }
        }
    }

    private synchronized void thaw(MethodHandle oldTarget, MethodHandle newTarget) {
        this.epoch = null;
        MutableCallSite.invalidate(new long[]{this.invalidationCookie});
        this.target = newTarget;
        this.epoch = newTarget;
    }

    private void freeze() {
    }

    private static native void invalidate(long[] var0);

    public static void syncAll(MutableCallSite[] sites) throws NullPointerException {
        for (int i = 0; i < sites.length; ++i) {
            sites[i].freeze();
        }
    }

    static native void freeGlobalRef(long var0);

    static {
        MutableCallSite.registerNatives();
        targetFieldOffset = MutableCallSite.initializeTargetFieldOffset();
        bypassBase = MutableCallSite.initializeBypassBase();
    }
}

