/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.InvokeExactHandle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class MethodType
implements Serializable {
    static final Class<?>[] EMTPY_PARAMS = new Class[0];
    static final Set<Class<?>> WRAPPER_SET;
    static final Class<?>[] primitivesArray;
    private static Map<MethodType, WeakReference<MethodType>> internTable;
    private static InternTableAddLock internTableAddLock;
    final Class<?> returnType;
    final Class<?>[] arguments;
    int argSlots;
    int[] stackDescriptionBits;
    private String methodDescriptor;
    private int hashcode = 0;
    private InvokeExactHandle invoker;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final long serialVersionUID = 292L;

    private MethodType(Class<?> rtype, Class<?>[] ptypes, boolean copyArguments) {
        this.returnType = rtype;
        if (copyArguments) {
            this.arguments = new Class[ptypes.length];
            System.arraycopy(ptypes, 0, this.arguments, 0, ptypes.length);
        } else {
            this.arguments = ptypes;
        }
    }

    private final int[] stackDescriptionBits(Class<?>[] args, int stackSlots) {
        int neededInts = (stackSlots + 1 + 31) / 32;
        int[] ints = new int[neededInts];
        int index = 0;
        int argBit = 1;
        int curr = 0;
        curr |= argBit;
        argBit <<= 1;
        for (Class<?> c : args) {
            if (c.isPrimitive()) {
                if ((c.equals(Double.TYPE) || c.equals(Long.TYPE)) && (argBit <<= 1) == 0) {
                    argBit = 1;
                    ints[index] = curr;
                    ++index;
                    curr = 0;
                }
            } else {
                curr |= argBit;
            }
            if ((argBit <<= 1) != 0) continue;
            argBit = 1;
            ints[index] = curr;
            ++index;
            curr = 0;
        }
        if (index < ints.length) {
            ints[index] = curr;
        }
        return ints;
    }

    public MethodType changeParameterType(int position, Class<?> type) {
        Class[] newParameters = (Class[])this.arguments.clone();
        newParameters[position] = type;
        return MethodType.methodType(this.returnType, newParameters, false);
    }

    public MethodType changeReturnType(Class<?> type) {
        return MethodType.methodType(type, this.arguments, false);
    }

    public MethodType dropParameterTypes(int startPosition, int endPosition) throws IndexOutOfBoundsException {
        if (startPosition >= 0 && endPosition >= 0 && startPosition <= endPosition && endPosition <= this.arguments.length) {
            int delta = endPosition - startPosition;
            Class[] newParameters = new Class[this.arguments.length - delta];
            System.arraycopy(this.arguments, 0, (Object)newParameters, 0, startPosition);
            System.arraycopy(this.arguments, endPosition, (Object)newParameters, startPosition, this.arguments.length - endPosition);
            return MethodType.methodType(this.returnType, newParameters, false);
        }
        throw new IndexOutOfBoundsException("'" + this + "' startPosition=" + startPosition + " endPosition=" + endPosition);
    }

    MethodType dropFirstParameterType() throws IndexOutOfBoundsException {
        if (this.arguments.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return MethodType.methodType(this.returnType, Arrays.copyOfRange(this.arguments, 1, this.arguments.length), false);
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (!(x instanceof MethodType)) {
            return false;
        }
        MethodType that = (MethodType)x;
        if (this.arguments.length != that.arguments.length || this.returnType != that.returnType) {
            return false;
        }
        return Arrays.equals(this.arguments, that.arguments);
    }

    public MethodType erase() {
        Class[] newParameters = (Class[])this.arguments.clone();
        for (int i = 0; i < newParameters.length; ++i) {
            if (newParameters[i].isPrimitive()) continue;
            newParameters[i] = Object.class;
        }
        return MethodType.methodType(this.returnType.isPrimitive() ? this.returnType : Object.class, newParameters, false);
    }

    public static MethodType fromMethodDescriptorString(String methodDescriptor, ClassLoader loader) {
        Map<String, MethodType> classLoaderMethodTypeCache;
        MethodType mt;
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        MethodType methodType = mt = (classLoaderMethodTypeCache = VM.getVMLangAccess().getMethodTypeCache(classLoader)) != null ? classLoaderMethodTypeCache.get(methodDescriptor) : null;
        if (null == mt) {
            if (methodDescriptor.indexOf(46) != -1) {
                throw new IllegalArgumentException(methodDescriptor);
            }
            ArrayList<Class<?>> classes = MethodType.parseIntoClasses(methodDescriptor, classLoader);
            if (classes.size() == 0) {
                throw new IllegalArgumentException(methodDescriptor);
            }
            Class<?> returnType = classes.remove(classes.size() - 1);
            mt = MethodType.methodType(returnType, classes);
            if (classLoaderMethodTypeCache != null) {
                classLoaderMethodTypeCache.put(mt.methodDescriptor, mt);
            }
        }
        return mt;
    }

    private static final MethodType fromMethodDescriptorStringAppendArg(String methodDescriptor, ClassLoader loader, Class<?> appendArgumentType) {
        ArrayList<Class<?>> types = MethodType.parseIntoClasses(methodDescriptor, loader);
        Class returnType = (Class)types.remove(types.size() - 1);
        types.add(appendArgumentType);
        return MethodType.methodType(returnType, types);
    }

    static final MethodType vmResolveFromMethodDescriptorString(String methodDescriptor, ClassLoader loader, Class<?> appendArgumentType) throws Throwable {
        try {
            if (null == appendArgumentType) {
                return MethodType.fromMethodDescriptorString(methodDescriptor, loader);
            }
            return MethodType.fromMethodDescriptorStringAppendArg(methodDescriptor, loader, appendArgumentType);
        }
        catch (TypeNotPresentException e) {
            throw MethodType.throwNoClassDefFoundError(e);
        }
    }

    private static final Throwable throwNoClassDefFoundError(TypeNotPresentException e) {
        Throwable cause = e.getCause();
        if (cause instanceof ClassNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(cause.getMessage());
            noClassDefFoundError.initCause(cause);
            throw noClassDefFoundError;
        }
        throw e;
    }

    private static final Class<?> nonPrimitiveClassFromString(String name, ClassLoader classLoader) {
        try {
            name = name.replace('/', '.');
            if (name.indexOf(76) == 0) {
                name = name.substring(1, name.length() - 1);
            }
            return Class.forName(name, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    static final int parseIntoClass(char[] signature, int index, ArrayList<Class<?>> args, ClassLoader classLoader, String descriptor) {
        Class<Object> c;
        char current = signature[index];
        if (current == 'L' || current == '[') {
            String name;
            int start = index;
            while (signature[index] == '[') {
                ++index;
            }
            if (signature[index] != 'L') {
                name = descriptor.substring(start, index + 1);
            } else {
                int end = descriptor.indexOf(59, index);
                if (end == -1) {
                    throw new IllegalArgumentException(Msg.getString("K05d6", descriptor));
                }
                name = descriptor.substring(start, end + 1);
                index = end;
            }
            c = MethodType.nonPrimitiveClassFromString(name, classLoader);
        } else {
            try {
                c = primitivesArray[current - 65];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                c = null;
            }
            if (c == null) {
                if (current == 'V') {
                    MethodType.primitivesArray[21] = Void.TYPE;
                    c = Void.TYPE;
                } else {
                    throw new IllegalArgumentException(Msg.getString("K05d7", current));
                }
            }
        }
        args.add(c);
        return index;
    }

    private static final ArrayList<Class<?>> parseIntoClasses(String methodDescriptor, ClassLoader classLoader) {
        int length = methodDescriptor.length();
        if (length == 0) {
            throw new IllegalArgumentException(Msg.getString("K05d3", methodDescriptor));
        }
        char[] signature = new char[length];
        methodDescriptor.getChars(0, length, signature, 0);
        int index = 0;
        boolean closeBracket = false;
        if (signature[index] != '(') {
            throw new IllegalArgumentException(Msg.getString("K05d4", methodDescriptor));
        }
        ++index;
        ArrayList args = new ArrayList();
        while (index < length) {
            if (signature[index] == ')') {
                if (closeBracket) {
                    throw new IllegalArgumentException(Msg.getString("K05d5", methodDescriptor));
                }
                closeBracket = true;
                ++index;
                continue;
            }
            index = MethodType.parseIntoClass(signature, index, args, classLoader, methodDescriptor);
            ++index;
        }
        return args;
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.arguments.length);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int hash = 31 + this.returnType.hashCode();
            for (Class<?> c : this.arguments) {
                hash = 31 * hash + c.hashCode();
            }
            this.hashcode = hash;
        }
        return this.hashcode;
    }

    public boolean hasPrimitives() {
        if (this.returnType.isPrimitive()) {
            return true;
        }
        for (Class<?> c : this.arguments) {
            if (!c.isPrimitive()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWrappers() {
        if (WRAPPER_SET.contains(this.returnType) || this.returnType == Void.class) {
            return true;
        }
        for (Class<?> c : this.arguments) {
            if (!WRAPPER_SET.contains(c)) continue;
            return true;
        }
        return false;
    }

    public MethodType insertParameterTypes(int position, Class<?> ... types) throws IndexOutOfBoundsException {
        if (position < 0 || position > this.arguments.length) {
            throw new IndexOutOfBoundsException();
        }
        int typesLength = types.length;
        if (typesLength == 0) {
            return this;
        }
        Class[] params = new Class[this.arguments.length + typesLength];
        System.arraycopy(this.arguments, 0, (Object)params, 0, position);
        System.arraycopy(types, 0, (Object)params, position, typesLength);
        System.arraycopy(this.arguments, position, (Object)params, position + typesLength, this.arguments.length - position);
        return MethodType.methodType(this.returnType, params, false);
    }

    public MethodType insertParameterTypes(int position, List<Class<?>> types) {
        return this.insertParameterTypes(position, types.toArray(new Class[types.size()]));
    }

    public static MethodType methodType(Class<?> type) {
        return MethodType.methodType(type, EMTPY_PARAMS, false);
    }

    public static MethodType methodType(Class<?> type, Class<?> parameter0) {
        return MethodType.methodType(type, new Class[]{parameter0}, false);
    }

    public static MethodType methodType(Class<?> returnType, Class<?>[] parameters) {
        return MethodType.methodType(returnType, parameters, true);
    }

    private static MethodType methodType(Class<?> returnType, Class<?>[] parameters, boolean copyArguments) {
        returnType.getClass();
        MethodType type = new MethodType(returnType, parameters, copyArguments);
        return type.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodType intern() {
        MethodType type = this.probeTable();
        if (type != null) {
            return type;
        }
        InternTableAddLock internTableAddLock = MethodType.internTableAddLock;
        synchronized (internTableAddLock) {
            type = this.probeTable();
            if (type != null) {
                return type;
            }
            int stackSlots = this.arguments.length;
            for (Class<?> c : this.arguments) {
                c.getClass();
                if (c == Double.TYPE || c == Long.TYPE) {
                    ++stackSlots;
                    continue;
                }
                if (c != Void.TYPE) continue;
                throw new IllegalArgumentException(Msg.getString("K05d9", Void.TYPE));
            }
            if (stackSlots > 255) {
                throw new IllegalArgumentException(Msg.getString("K05d8", stackSlots));
            }
            this.argSlots = stackSlots;
            this.stackDescriptionBits = this.stackDescriptionBits(this.arguments, this.argSlots);
            this.methodDescriptor = this.createMethodDescriptorString();
            MethodType tenured = MethodType.makeTenured(this);
            internTable.put(tenured, new WeakReference<MethodType>(tenured));
            return tenured;
        }
    }

    private MethodType probeTable() {
        Reference reference = internTable.get(this);
        if (reference != null) {
            return (MethodType)reference.get();
        }
        return null;
    }

    private static native MethodType makeTenured(MethodType var0);

    public static MethodType methodType(Class<?> type, Class<?> parameter0, Class<?> ... parameters) {
        Class[] params = new Class[parameters.length + 1];
        params[0] = parameter0;
        System.arraycopy(parameters, 0, (Object)params, 1, parameters.length);
        return MethodType.methodType(type, params, false);
    }

    public static MethodType methodType(Class<?> type, List<Class<?>> parameters) {
        return MethodType.methodType(type, parameters.toArray(new Class[parameters.size()]), false);
    }

    public static MethodType methodType(Class<?> returnType, MethodType methodType) {
        return MethodType.methodType(returnType, methodType.arguments, false);
    }

    public static MethodType genericMethodType(int numParameters) throws IllegalArgumentException {
        return MethodType.genericMethodType(numParameters, false);
    }

    public static MethodType genericMethodType(int numParameters, boolean isVarargs) throws IllegalArgumentException {
        if (numParameters < 0 || numParameters > (isVarargs ? 254 : 255)) {
            throw new IllegalArgumentException();
        }
        int count = numParameters;
        if (isVarargs) {
            ++count;
        }
        Object[] params = new Class[count];
        Arrays.fill(params, Object.class);
        if (isVarargs) {
            params[numParameters] = Object[].class;
        }
        return MethodType.methodType(Object.class, params, false);
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.arguments.clone();
    }

    public int parameterCount() {
        return this.arguments.length;
    }

    public List<Class<?>> parameterList() {
        List<Object> list = Arrays.asList((Object[])this.arguments.clone());
        return Collections.unmodifiableList(list);
    }

    public Class<?> parameterType(int position) throws IndexOutOfBoundsException {
        return this.arguments[position];
    }

    public Class<?> returnType() {
        return this.returnType;
    }

    Class<?> lastParameterType() {
        Class<Void> result = Void.TYPE;
        if (this.arguments.length > 0) {
            result = this.arguments[this.arguments.length - 1];
        }
        return result;
    }

    public String toMethodDescriptorString() {
        return this.methodDescriptor;
    }

    private String createMethodDescriptorString() {
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> c : this.arguments) {
            sb.append(MethodType.getBytecodeStringName(c));
        }
        sb.append(")");
        sb.append(MethodType.getBytecodeStringName(this.returnType));
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.arguments.length; ++i) {
            sb.append(this.arguments[i].getSimpleName());
            if (i >= this.arguments.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        sb.append(this.returnType.getSimpleName());
        return sb.toString();
    }

    public MethodType unwrap() {
        Class[] args = (Class[])this.arguments.clone();
        for (int i = 0; i < args.length; ++i) {
            args[i] = MethodType.unwrapPrimitive(args[i]);
        }
        Class<Object> unwrappedReturnType = MethodType.unwrapPrimitive(this.returnType);
        if (MethodType.unwrapPrimitive(this.returnType) == Void.class) {
            unwrappedReturnType = Void.TYPE;
        }
        return MethodType.methodType(unwrappedReturnType, args, false);
    }

    public MethodType wrap() {
        Class[] args = (Class[])this.arguments.clone();
        for (int i = 0; i < args.length; ++i) {
            args[i] = MethodType.wrapPrimitive(args[i]);
        }
        return MethodType.methodType(MethodType.wrapPrimitive(this.returnType), args, false);
    }

    public MethodType appendParameterTypes(Class<?> ... classes) throws IllegalArgumentException, NullPointerException {
        if (classes == null) {
            throw new NullPointerException();
        }
        return this.appendParameterTypes(Arrays.asList(classes));
    }

    public MethodType appendParameterTypes(List<Class<?>> classes) throws IllegalArgumentException, NullPointerException {
        if (classes == null) {
            throw new NullPointerException();
        }
        ArrayList combinedParameters = new ArrayList(Arrays.asList(this.arguments));
        combinedParameters.addAll(classes);
        return MethodType.methodType(this.returnType, combinedParameters);
    }

    static Class<?> wrapPrimitive(Class<?> primitveClass) {
        if (primitveClass.isPrimitive()) {
            if (Integer.TYPE == primitveClass) {
                return Integer.class;
            }
            if (Long.TYPE == primitveClass) {
                return Long.class;
            }
            if (Byte.TYPE == primitveClass) {
                return Byte.class;
            }
            if (Character.TYPE == primitveClass) {
                return Character.class;
            }
            if (Double.TYPE == primitveClass) {
                return Double.class;
            }
            if (Float.TYPE == primitveClass) {
                return Float.class;
            }
            if (Boolean.TYPE == primitveClass) {
                return Boolean.class;
            }
            if (Void.TYPE == primitveClass) {
                return Void.class;
            }
            if (Short.TYPE == primitveClass) {
                return Short.class;
            }
        }
        return primitveClass;
    }

    static Class<?> unwrapPrimitive(Class<?> wrapperClass) {
        if (Integer.class == wrapperClass) {
            return Integer.TYPE;
        }
        if (Long.class == wrapperClass) {
            return Long.TYPE;
        }
        if (Byte.class == wrapperClass) {
            return Byte.TYPE;
        }
        if (Character.class == wrapperClass) {
            return Character.TYPE;
        }
        if (Double.class == wrapperClass) {
            return Double.TYPE;
        }
        if (Float.class == wrapperClass) {
            return Float.TYPE;
        }
        if (Short.class == wrapperClass) {
            return Short.TYPE;
        }
        if (Boolean.class == wrapperClass) {
            return Boolean.TYPE;
        }
        return wrapperClass;
    }

    static String getBytecodeStringName(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Short.TYPE) {
                return "S";
            }
        }
        String name = c.getName().replace('.', '/');
        if (c.isArray()) {
            return name;
        }
        return "L" + name + ";";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.returnType());
        out.writeObject(this.parameterArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            final Field fReturnType = this.getClass().getDeclaredField("returnType");
            final Field fArguments = this.getClass().getDeclaredField("arguments");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    fReturnType.setAccessible(true);
                    fArguments.setAccessible(true);
                    return null;
                }
            });
            try {
                fReturnType.set(this, in.readObject());
                fArguments.set(this, in.readObject());
            }
            catch (Exception e) {
                fReturnType.set(this, Void.TYPE);
                fArguments.set(this, EMTPY_PARAMS);
                throw e;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return MethodType.methodType(this.returnType, this.arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InvokeExactHandle getInvokeExactHandle() {
        if (null == this.invoker) {
            MethodType methodType = this;
            synchronized (methodType) {
                if (null == this.invoker) {
                    this.invoker = new InvokeExactHandle(this);
                }
            }
        }
        return this.invoker;
    }

    static {
        Class[] wrappers = new Class[]{Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Boolean.class};
        WRAPPER_SET = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(wrappers)));
        primitivesArray = new Class[26];
        MethodType.primitivesArray[1] = Byte.TYPE;
        MethodType.primitivesArray[2] = Character.TYPE;
        MethodType.primitivesArray[3] = Double.TYPE;
        MethodType.primitivesArray[5] = Float.TYPE;
        MethodType.primitivesArray[8] = Integer.TYPE;
        MethodType.primitivesArray[9] = Long.TYPE;
        MethodType.primitivesArray[18] = Short.TYPE;
        MethodType.primitivesArray[25] = Boolean.TYPE;
        internTable = Collections.synchronizedMap(new WeakHashMap());
        internTableAddLock = new InternTableAddLock();
        serialPersistentFields = new ObjectStreamField[0];
    }

    static final class InternTableAddLock {
        InternTableAddLock() {
        }
    }
}

