/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import com.ibm.oti.vm.VMLangAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.AsTypeHandle;
import java.lang.invoke.BruteArgumentMoverHandle;
import java.lang.invoke.CacheKey;
import java.lang.invoke.CallSite;
import java.lang.invoke.CollectHandle;
import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.ConvertHandle;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.FilterReturnHandle;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.PermuteHandle;
import java.lang.invoke.PrimitiveHandle;
import java.lang.invoke.ReceiverBoundHandle;
import java.lang.invoke.SpreadHandle;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import sun.misc.Unsafe;
import sun.reflect.ConstantPool;

public abstract class MethodHandle {
    static final byte KIND_BOUND = 0;
    static final byte KIND_GETFIELD = 1;
    static final byte KIND_GETSTATICFIELD = 2;
    static final byte KIND_PUTFIELD = 3;
    static final byte KIND_PUTSTATICFIELD = 4;
    static final byte KIND_VIRTUAL = 5;
    static final byte KIND_STATIC = 6;
    static final byte KIND_SPECIAL = 7;
    static final byte KIND_CONSTRUCTOR = 8;
    static final byte KIND_INTERFACE = 9;
    static final byte KIND_COLLECT = 10;
    static final byte KIND_INVOKEEXACT = 11;
    static final byte KIND_INVOKEGENERIC = 12;
    static final byte KIND_ASTYPE = 13;
    static final byte KIND_DYNAMICINVOKER = 14;
    static final byte KIND_FILTERRETURN = 15;
    static final byte KIND_EXPLICITCAST = 16;
    static final byte KIND_VARARGSCOLLECT = 17;
    static final byte KIND_PASSTHROUGH = 18;
    static final byte KIND_SPREAD = 19;
    static final byte KIND_INSERT = 20;
    static final byte KIND_PERMUTE = 21;
    static final byte KIND_CONSTANTOBJECT = 22;
    static final byte KIND_CONSTANTINT = 23;
    static final byte KIND_CONSTANTFLOAT = 24;
    static final byte KIND_CONSTANTLONG = 25;
    static final byte KIND_CONSTANTDOUBLE = 26;
    static final byte KIND_FOLDHANDLE = 27;
    static final byte KIND_GUARDWITHTEST = 28;
    static final byte KIND_FILTERARGUMENTS = 29;
    static final byte KIND_VARHANDLEINVOKEEXACT = 30;
    static final byte KIND_VARHANDLEINVOKEGENERIC = 31;
    static final int PUBLIC_FINAL_NATIVE = 4369;
    static final Unsafe UNSAFE = Unsafe.getUnsafe();
    static final JITHelpers JITHELPERS = JITHelpers.getHelpers();
    private static final int CUSTOM_THUNK_INVOCATION_COUNT = 1000;
    private static final int DONT_CHECK_FOR_A_WHILE_COUNT = -1000000000;
    final MethodType type;
    final byte kind;
    int invocationCount;
    ThunkTuple thunks;
    static final int VTABLE_ENTRY_SIZE = VM.ADDRESS_SIZE;
    static final int VTABLE_ENTRY_SHIFT = 31 - Integer.numberOfLeadingZeros(VTABLE_ENTRY_SIZE);
    static final int J9CLASS_OFFSET = MethodHandle.vmRefFieldOffset(Class.class);
    static final long INTRP_VTABLE_OFFSET = VM.J9CLASS_SIZE;
    static final int HEADER_SIZE = VM.OBJECT_HEADER_SIZE;
    static final Class<?>[] EMPTY_CLASS_ARRAY;
    CacheKey cacheKey;
    private MethodHandle previousAsType;
    private static final int BSM_ARGUMENT_SIZE = 2;
    private static final int BSM_ARGUMENT_COUNT_OFFSET = 2;
    private static final int BSM_ARGUMENTS_OFFSET = 4;
    private static final int BSM_LOOKUP_ARGUMENT_INDEX = 0;
    private static final int BSM_NAME_ARGUMENT_INDEX = 1;
    private static final int BSM_TYPE_ARGUMENT_INDEX = 2;
    private static final int BSM_OPTIONAL_ARGUMENTS_START_INDEX = 3;

    final void doCustomizationLogic() {
        if (++this.invocationCount > 1000) {
            this.requestCustomThunk();
            this.invocationCount = -1000000000;
        }
    }

    final void undoCustomizationLogic(MethodHandle callee) {
        --callee.invocationCount;
    }

    final void undoCustomizationLogic(MethodHandle callee1, MethodHandle callee2) {
        --callee1.invocationCount;
        --callee2.invocationCount;
    }

    final void undoCustomizationLogic(MethodHandle callee1, MethodHandle callee2, MethodHandle callee3) {
        --callee1.invocationCount;
        --callee2.invocationCount;
        --callee3.invocationCount;
    }

    final void undoCustomizationLogic(MethodHandle ... callees) {
        for (MethodHandle callee : callees) {
            if (callee == null) continue;
            --callee.invocationCount;
        }
    }

    final void requestCustomThunk() {
        this.thunks = ThunkTuple.copyOf(this.thunks);
        this.requestCustomThunkFromJit(this.thunks);
    }

    private native void requestCustomThunkFromJit(ThunkTuple var1);

    ThunkTable thunkTable() {
        throw new UnsupportedOperationException("Subclass must implement this");
    }

    ThunkTuple computeThunks(Object arg) {
        return this.thunkTable().get(new ThunkKey(ThunkKey.computeThunkableType(this.type())));
    }

    final long invokeExactTargetAddress() {
        return this.thunks.invokeExactThunk;
    }

    static long getJ9ClassFromClass(Class<?> c) {
        if (JITHELPERS.is32Bit()) {
            return JITHELPERS.getJ9ClassFromClass32(c);
        }
        return JITHELPERS.getJ9ClassFromClass64(c);
    }

    MethodHandle cloneWithNewType(MethodType newType) {
        throw new UnsupportedOperationException("Subclass must implement this");
    }

    private static MethodHandle asType(MethodHandle mh, MethodType newType) {
        return mh.asType(newType);
    }

    MethodHandle(MethodType type, byte kind, Object thunkArg) {
        this.kind = kind;
        this.type = type;
        MethodHandle.enforceArityLimit(kind, this.type);
        this.thunks = this.computeThunks(thunkArg);
        long i = this.thunks.invokeExactThunk;
    }

    MethodHandle(MethodHandle original, MethodType newType) {
        this.kind = original.kind;
        this.type = newType;
        MethodHandle.enforceArityLimit(original.kind, newType);
        this.thunks = original.thunks;
        this.previousAsType = original.previousAsType;
    }

    Class<?> getDefc() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    Class<?> getReferenceClass() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    Class<?> getSpecialCaller() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    String getMethodName() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    int getModifiers() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable, WrongMethodTypeException;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable, WrongMethodTypeException, ClassCastException;

    public MethodType type() {
        return this.type;
    }

    public MethodHandle asSpreader(Class<?> arrayClass, int spreadCount) throws IllegalArgumentException, WrongMethodTypeException {
        return this.asSpreaderCommon(this.type.parameterCount() - spreadCount, arrayClass, spreadCount);
    }

    private final MethodHandle asSpreaderCommon(int spreadPosition, Class<?> arrayClass, int spreadCount) throws IllegalArgumentException, WrongMethodTypeException {
        MethodType collectType;
        int length = this.type.parameterCount();
        if (!arrayClass.isArray() || spreadPosition < 0 || spreadPosition > length) {
            throw new IllegalArgumentException();
        }
        if (spreadCount < 0 || spreadCount > length) {
            MethodHandle.throwIllegalArgumentExceptionForMHArgCount();
        }
        MethodHandle adapted = this;
        if (0 == spreadCount) {
            collectType = this.type.insertParameterTypes(spreadPosition, arrayClass);
        } else {
            Class<?> componentType = arrayClass.getComponentType();
            collectType = this.type.changeParameterType(spreadPosition, arrayClass);
            if (spreadCount > 1) {
                collectType = collectType.dropParameterTypes(spreadPosition + 1, spreadPosition + spreadCount);
            }
            Object[] parameters = (Class[])this.type.arguments.clone();
            Arrays.fill(parameters, spreadPosition, spreadPosition + spreadCount, componentType);
            adapted = this.asType(MethodType.methodType(this.type.returnType, parameters));
        }
        return new SpreadHandle(adapted, collectType, arrayClass, spreadCount, spreadPosition);
    }

    public MethodHandle asCollector(Class<?> arrayClass, int collectCount) throws IllegalArgumentException, WrongMethodTypeException, NullPointerException {
        return this.asCollectorCommon(this.type.parameterCount() - 1, arrayClass, collectCount);
    }

    private final MethodHandle asCollectorCommon(int collectPosition, Class<?> arrayClass, int collectCount) throws IllegalArgumentException, WrongMethodTypeException, NullPointerException {
        int parameterCount = this.type.parameterCount();
        if (0 == parameterCount || collectCount < 0 || collectCount > 255 || collectPosition < 0 || collectPosition >= parameterCount) {
            throw new IllegalArgumentException();
        }
        arrayClass.getClass();
        Class<?> positionClass = this.type.parameterType(collectPosition);
        if (!arrayClass.isArray() || !positionClass.isAssignableFrom(arrayClass)) {
            throw new IllegalArgumentException(Msg.getString("K05cc", (Object)arrayClass.toString(), this.type.toString()));
        }
        return new CollectHandle(this.asType(this.type.changeParameterType(collectPosition, arrayClass)), collectCount, collectPosition);
    }

    public MethodHandle asType(MethodType newType) throws ClassCastException {
        if (this.type.equals(newType)) {
            return this;
        }
        MethodHandle localPreviousAsType = this.previousAsType;
        if (localPreviousAsType != null && localPreviousAsType.type == newType) {
            return localPreviousAsType;
        }
        MethodHandle handle = this;
        Class<?> fromReturn = this.type.returnType;
        Class<?> toReturn = newType.returnType;
        if (fromReturn != toReturn) {
            if (toReturn.isAssignableFrom(fromReturn)) {
                handle = this.cloneWithNewType(MethodType.methodType(toReturn, this.type.arguments));
            } else {
                MethodHandle filter = ConvertHandle.FilterHelpers.getReturnFilter(fromReturn, toReturn, false);
                handle = new FilterReturnHandle(this, filter);
            }
        }
        if (handle.type != newType) {
            handle = new AsTypeHandle(handle, newType);
        }
        this.previousAsType = handle;
        return handle;
    }

    private static final native int vmRefFieldOffset(Class<?> var0);

    public Object invokeWithArguments(Object ... args) throws Throwable, WrongMethodTypeException, ClassCastException {
        int argsLength = 0;
        if (args != null) {
            argsLength = args.length;
        }
        if (argsLength != this.type.arguments.length) {
            throw MethodHandle.newWrongMethodTypeException(this.type, args, argsLength);
        }
        if (argsLength < 253) {
            return IWAContainer.getMH(this.type.arguments.length).invokeExact(this, args);
        }
        return this.asSpreader(Object[].class, argsLength).invoke(args);
    }

    private static WrongMethodTypeException newWrongMethodTypeException(MethodType type, Object[] args, int argsLength) {
        Class[] classes = new Class[argsLength];
        for (int i = 0; i < argsLength; ++i) {
            Class c = Void.class;
            Object o = args[i];
            if (o != null) {
                c = o.getClass();
            }
            classes[i] = c;
        }
        return WrongMethodTypeException.newWrongMethodTypeException(type, MethodType.methodType(type.returnType, classes));
    }

    private static native Object invokeWithArgumentsHelper(MethodHandle var0, Object[] var1);

    public Object invokeWithArguments(List<?> args) throws Throwable, WrongMethodTypeException, ClassCastException, NullPointerException {
        return this.invokeWithArguments(args.toArray());
    }

    public MethodHandle asVarargsCollector(Class<?> arrayParameter) throws IllegalArgumentException {
        if (!arrayParameter.isArray()) {
            throw new IllegalArgumentException();
        }
        Class<?> lastArgType = this.type().lastParameterType();
        if (!lastArgType.isAssignableFrom(arrayParameter)) {
            throw new IllegalArgumentException();
        }
        return new VarargsCollectorHandle(this, arrayParameter, false);
    }

    public boolean isVarargsCollector() {
        return this instanceof VarargsCollectorHandle;
    }

    boolean canRevealDirect() {
        return false;
    }

    boolean directHandleOriginatedInFindVirtual() {
        return false;
    }

    public MethodHandle asFixedArity() {
        return this;
    }

    public MethodHandle bindTo(Object value) throws IllegalArgumentException, ClassCastException {
        Class<?> firstParameterType = this.type().parameterType(0);
        if (firstParameterType.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        value = firstParameterType.cast(value);
        if (this.getClass() == DirectHandle.class) {
            return new ReceiverBoundHandle((PrimitiveHandle)this, value, MethodHandles.insertArguments(this, 0, value));
        }
        return MethodHandles.insertArguments(this, 0, value);
    }

    MethodHandle permuteArguments(MethodType permuteType, int ... permute) {
        MethodHandle result = new PermuteHandle(permuteType, this, permute);
        result = new BruteArgumentMoverHandle(permuteType, this, permute, EMPTY_CLASS_ARRAY, result);
        return result;
    }

    MethodHandle insertArguments(MethodHandle equivalent, MethodHandle unboxingHandle, int location, Object ... values) {
        MethodHandle result = equivalent;
        int numValues = values.length;
        MethodType mtype = equivalent.type();
        int[] permute = BruteArgumentMoverHandle.insertPermute(BruteArgumentMoverHandle.identityPermute(mtype), location, numValues, -1);
        result = new BruteArgumentMoverHandle(mtype, unboxingHandle, permute, values, result);
        return result;
    }

    private static final Class<?> fromFieldDescriptorString(String fieldDescriptor, ClassLoader classLoader) {
        ArrayList classList = new ArrayList();
        int length = fieldDescriptor.length();
        if (length == 0) {
            throw new IllegalArgumentException(Msg.getString("K05d3", fieldDescriptor));
        }
        char[] signature = new char[length];
        fieldDescriptor.getChars(0, length, signature, 0);
        MethodType.parseIntoClass(signature, 0, classList, classLoader, fieldDescriptor);
        return classList.get(0);
    }

    private static final native int getCPTypeAt(Object var0, int var1);

    private static final native MethodType getCPMethodTypeAt(Object var0, int var1);

    private static final native MethodHandle getCPMethodHandleAt(Object var0, int var1);

    private static final native String getCPClassNameAt(Class<?> var0, int var1);

    private static final MethodHandle resolveInvokeDynamic(long j9class, String name, String methodDescriptor, long bsmData) throws Throwable {
        MethodHandle result = null;
        MethodType type = null;
        try {
            VMLangAccess access = VM.getVMLangAccess();
            Object internalRamClass = access.createInternalRamClass(j9class);
            Class classObject = null;
            classObject = JITHELPERS.is32Bit() ? JITHELPERS.getClassFromJ9Class32((int)j9class) : JITHELPERS.getClassFromJ9Class64(j9class);
            Objects.requireNonNull(classObject);
            type = MethodType.vmResolveFromMethodDescriptorString(methodDescriptor, access.getClassloader(classObject), null);
            MethodHandles.Lookup lookup = new MethodHandles.Lookup(classObject, false);
            try {
                lookup.accessCheckArgRetTypes(type);
            }
            catch (IllegalAccessException e) {
                IllegalAccessError err = new IllegalAccessError();
                err.initCause(e);
                throw err;
            }
            short bsmIndex = UNSAFE.getShort(bsmData);
            int bsmArgCount = UNSAFE.getShort(bsmData + 2L);
            long bsmArgs = bsmData + 4L;
            MethodHandle bsm = MethodHandle.getCPMethodHandleAt(internalRamClass, bsmIndex);
            if (null == bsm) {
                throw new NullPointerException(Msg.getString("K05cd", (Object)classObject.toString(), bsmIndex));
            }
            Object[] staticArgs = new Object[3 + bsmArgCount];
            staticArgs[0] = lookup;
            staticArgs[1] = name;
            staticArgs[2] = type;
            ConstantPool cp = access.getConstantPool(internalRamClass);
            boolean treatLastArgAsVarargs = bsm.isVarargsCollector();
            Class<?> varargsComponentType = bsm.type.lastParameterType().getComponentType();
            int bsmTypeArgCount = bsm.type.parameterCount();
            for (int i = 0; i < bsmArgCount; ++i) {
                int staticArgIndex = 3 + i;
                short index = UNSAFE.getShort(bsmArgs + (long)(i * 2));
                int cpType = MethodHandle.getCPTypeAt(internalRamClass, index);
                Object cpEntry = null;
                switch (cpType) {
                    case 1: {
                        cpEntry = cp.getClassAt((int)index);
                        if (cpEntry != null) break;
                        throw MethodHandle.throwNoClassDefFoundError(classObject, index);
                    }
                    case 2: {
                        cpEntry = cp.getStringAt((int)index);
                        break;
                    }
                    case 3: {
                        int cpValue = cp.getIntAt((int)index);
                        Class<?> argClass = treatLastArgAsVarargs && staticArgIndex >= bsmTypeArgCount - 1 ? varargsComponentType : bsm.type.parameterType(staticArgIndex);
                        if (argClass == Short.TYPE) {
                            cpEntry = (short)cpValue;
                            break;
                        }
                        if (argClass == Boolean.TYPE) {
                            cpEntry = cpValue == 0 ? Boolean.FALSE : Boolean.TRUE;
                            break;
                        }
                        if (argClass == Byte.TYPE) {
                            cpEntry = (byte)cpValue;
                            break;
                        }
                        if (argClass == Character.TYPE) {
                            cpEntry = Character.valueOf((char)cpValue);
                            break;
                        }
                        cpEntry = cpValue;
                        break;
                    }
                    case 4: {
                        cpEntry = Float.valueOf(cp.getFloatAt((int)index));
                        break;
                    }
                    case 5: {
                        cpEntry = cp.getLongAt((int)index);
                        break;
                    }
                    case 6: {
                        cpEntry = cp.getDoubleAt((int)index);
                        break;
                    }
                    case 13: {
                        cpEntry = MethodHandle.getCPMethodTypeAt(internalRamClass, index);
                        break;
                    }
                    case 14: {
                        cpEntry = MethodHandle.getCPMethodHandleAt(internalRamClass, index);
                        break;
                    }
                }
                cpEntry.getClass();
                staticArgs[staticArgIndex] = cpEntry;
            }
            CallSite cs = null;
            switch (staticArgs.length) {
                case 3: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2]);
                    break;
                }
                case 4: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3]);
                    break;
                }
                case 5: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3], staticArgs[4]);
                    break;
                }
                case 6: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3], staticArgs[4], staticArgs[5]);
                    break;
                }
                case 7: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3], staticArgs[4], staticArgs[5], staticArgs[6]);
                    break;
                }
                default: {
                    cs = (CallSite)bsm.invokeWithArguments(staticArgs);
                }
            }
            if (cs != null) {
                MethodType callsiteType = cs.type();
                if (callsiteType != type) {
                    throw WrongMethodTypeException.newWrongMethodTypeException(type, callsiteType);
                }
                result = cs.dynamicInvoker();
            }
        }
        catch (Throwable e) {
            if (type == null) {
                throw new BootstrapMethodError(e);
            }
            try {
                MethodHandle thrower = MethodHandles.throwException(type.returnType(), BootstrapMethodError.class);
                MethodHandle constructor = MethodHandles.Lookup.IMPL_LOOKUP.findConstructor(BootstrapMethodError.class, MethodType.methodType(Void.TYPE, Throwable.class));
                result = MethodHandles.foldArguments(thrower, constructor.bindTo(e));
                result = MethodHandles.dropArguments(result, 0, type.parameterList());
            }
            catch (IllegalAccessException iae) {
                throw new Error(iae);
            }
            catch (NoSuchMethodException nsme) {
                throw new Error(nsme);
            }
        }
        return result;
    }

    private static final Throwable throwNoClassDefFoundError(Class<?> clazz, int index) {
        String className = MethodHandle.getCPClassNameAt(clazz, index);
        NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(className);
        noClassDefFoundError.initCause(new ClassNotFoundException(className));
        throw noClassDefFoundError;
    }

    public String toString() {
        return "MethodHandle" + this.type.toString();
    }

    private final MethodHandle forGenericInvoke(MethodType newType, boolean dropFirstArg) {
        if (this.type == newType) {
            return this;
        }
        if (dropFirstArg) {
            return this.asType(newType.dropFirstParameterType());
        }
        return this.asType(newType);
    }

    private static final MethodHandle sendResolveMethodHandle(int cpRefKind, Class<?> currentClass, Class<?> referenceClazz, String name, String typeDescriptor, ClassLoader loader) throws Throwable {
        try {
            MethodHandles.Lookup lookup = new MethodHandles.Lookup(currentClass, false);
            MethodType type = null;
            MethodHandle result = null;
            switch (cpRefKind) {
                case 1: {
                    result = lookup.findGetter(referenceClazz, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, lookup, loader));
                    break;
                }
                case 2: {
                    result = lookup.findStaticGetter(referenceClazz, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, lookup, loader));
                    break;
                }
                case 3: {
                    result = lookup.findSetter(referenceClazz, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, lookup, loader));
                    break;
                }
                case 4: {
                    result = lookup.findStaticSetter(referenceClazz, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, lookup, loader));
                    break;
                }
                case 5: {
                    type = MethodType.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findVirtual(referenceClazz, name, type);
                    break;
                }
                case 6: {
                    type = MethodType.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findStatic(referenceClazz, name, type);
                    break;
                }
                case 7: {
                    type = MethodType.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findSpecial(referenceClazz, name, type, currentClass);
                    break;
                }
                case 8: {
                    type = MethodType.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findConstructor(referenceClazz, type);
                    break;
                }
                case 9: {
                    type = MethodType.vmResolveFromMethodDescriptorString(typeDescriptor, loader, null);
                    lookup.accessCheckArgRetTypes(type);
                    result = lookup.findVirtual(referenceClazz, name, type);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return result;
        }
        catch (IllegalAccessException iae) {
            throw new IllegalAccessError(iae.getMessage()).initCause(iae);
        }
    }

    private static final Class<?> resolveFieldHandleHelper(String typeDescriptor, MethodHandles.Lookup lookup, ClassLoader loader) throws Throwable {
        MethodType mt = MethodType.vmResolveFromMethodDescriptorString("(" + typeDescriptor + ")V", loader, null);
        lookup.accessCheckArgRetTypes(mt);
        return mt.parameterType(0);
    }

    private MethodHandle returnFilterPlaceHolder() {
        return this;
    }

    private MethodHandle foldHandlePlaceHolder() {
        return this;
    }

    private MethodHandle guardWithTestPlaceHolder() {
        return this;
    }

    private MethodHandle filterArgumentsPlaceHolder(int index, int parentOffset, int nextOffset) {
        return this;
    }

    private static Object constructorPlaceHolder(Object newObjectRef) {
        return newObjectRef;
    }

    void compareWith(MethodHandle other, Comparator c) {
        throw new UnsupportedOperationException("Subclass must implement this");
    }

    static final void enforceArityLimit(byte kind, MethodType type) {
        int argumentSlots = type.argSlots;
        if (8 == kind) {
            ++argumentSlots;
        }
        if (argumentSlots > 254) {
            MethodHandle.throwIllegalArgumentExceptionForMTArgCount(argumentSlots);
        }
    }

    static void throwIllegalArgumentExceptionForMTArgCount(int argSlots) {
        throw new IllegalArgumentException(Msg.getString("K0578", argSlots + 1));
    }

    static void throwIllegalArgumentExceptionForMHArgCount() {
        throw new IllegalArgumentException(Msg.getString("K0579"));
    }

    String mapKindToBytecode() {
        switch (this.kind) {
            case 1: {
                return "getField";
            }
            case 2: {
                return "getStatic";
            }
            case 3: {
                return "putField";
            }
            case 4: {
                return "putStatic";
            }
            case 0: 
            case 5: {
                return "invokeVirtual";
            }
            case 6: {
                return "invokeStatic";
            }
            case 7: {
                return "invokeSpecial";
            }
            case 8: {
                return "newInvokeSpecial";
            }
            case 9: {
                return "invokeInterface";
            }
            case 17: {
                return ((VarargsCollectorHandle)this).next.mapKindToBytecode();
            }
        }
        return "KIND_#" + this.kind;
    }

    static {
        ComputedCalls.load();
        ThunkKey.load();
        ThunkTuple.load();
        ILGenMacros.load();
        EMPTY_CLASS_ARRAY = new Class[0];
    }

    static final class IWAContainer {
        static final MethodHandle spreader_0 = MethodHandles.spreadInvoker(MethodType.genericMethodType(0), 0);
        static final MethodHandle spreader_1 = MethodHandles.spreadInvoker(MethodType.genericMethodType(1), 0);
        static final MethodHandle spreader_2 = MethodHandles.spreadInvoker(MethodType.genericMethodType(2), 0);
        static final MethodHandle spreader_3 = MethodHandles.spreadInvoker(MethodType.genericMethodType(3), 0);
        static final MethodHandle spreader_4 = MethodHandles.spreadInvoker(MethodType.genericMethodType(4), 0);
        static final MethodHandle spreader_5 = MethodHandles.spreadInvoker(MethodType.genericMethodType(5), 0);
        static final MethodHandle spreader_6 = MethodHandles.spreadInvoker(MethodType.genericMethodType(6), 0);
        static final MethodHandle spreader_7 = MethodHandles.spreadInvoker(MethodType.genericMethodType(7), 0);

        IWAContainer() {
        }

        static MethodHandle getMH(int len) {
            switch (len) {
                case 0: {
                    return spreader_0;
                }
                case 1: {
                    return spreader_1;
                }
                case 2: {
                    return spreader_2;
                }
                case 3: {
                    return spreader_3;
                }
                case 4: {
                    return spreader_4;
                }
                case 5: {
                    return spreader_5;
                }
                case 6: {
                    return spreader_6;
                }
                case 7: {
                    return spreader_7;
                }
            }
            return MethodHandles.spreadInvoker(MethodType.genericMethodType(len), 0);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface FrameIteratorSkip {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

