/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.FoldNonvoidHandle;
import java.lang.invoke.FoldVoidHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObjectArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;

abstract class FoldHandle
extends MethodHandle {
    protected final MethodHandle next;
    protected final MethodHandle combiner;
    private final int foldPosition;
    private final int[] argumentIndices;
    private static final ThunkTable _thunkTable = new ThunkTable();

    protected FoldHandle(MethodHandle next, MethodHandle combiner, MethodType type, int foldPosition, int ... argumentIndices) {
        super(type, (byte)27, FoldHandle.infoAffectingThunks(combiner.type(), foldPosition, argumentIndices));
        this.next = next;
        this.combiner = combiner;
        this.foldPosition = foldPosition;
        this.argumentIndices = argumentIndices;
    }

    FoldHandle(FoldHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.combiner = originalHandle.combiner;
        this.foldPosition = originalHandle.foldPosition;
        this.argumentIndices = originalHandle.argumentIndices;
    }

    public static FoldHandle get(MethodHandle next, MethodHandle combiner, MethodType type, int foldPosition, int ... argumentIndices) {
        if (combiner.type().returnType() == Void.TYPE) {
            return new FoldVoidHandle(next, combiner, type, foldPosition, argumentIndices);
        }
        return new FoldNonvoidHandle(next, combiner, type, foldPosition, argumentIndices);
    }

    private static Object[] infoAffectingThunks(MethodType combinerType, int foldPosition, int ... argumentIndices) {
        Object[] result = new Object[]{combinerType, foldPosition, argumentIndices};
        return result;
    }

    @Override
    protected ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    protected final ThunkTuple computeThunks(Object info) {
        return this.thunkTable().get(new ThunkKeyWithObjectArray(ThunkKey.computeThunkableType(this.type()), (Object[])info));
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof FoldHandle) {
            ((FoldHandle)right).compareWithFold(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithFold(FoldHandle left, Comparator c) {
        c.compareChildHandle(left.next, this.next);
        c.compareChildHandle(left.combiner, this.combiner);
        c.compareStructuralParameter(left.foldPosition, this.foldPosition);
        c.compareStructuralParameter(left.argumentIndices, this.argumentIndices);
    }

    protected static native int foldPosition();

    protected static native int argIndices();

    protected static native int argumentsForCombiner(int var0, int var1);
}

