/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithIntArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.reflect.Array;

final class CollectHandle
extends MethodHandle {
    final MethodHandle next;
    final int collectArraySize;
    final int collectPosition;
    private static final ThunkTable _thunkTable = new ThunkTable();

    CollectHandle(MethodHandle next, int collectArraySize, int collectPosition) {
        super(CollectHandle.collectMethodType(next.type(), collectArraySize, collectPosition), (byte)10, new int[]{collectArraySize, collectPosition});
        this.collectPosition = collectPosition;
        this.collectArraySize = collectArraySize;
        this.next = next;
    }

    CollectHandle(CollectHandle original, MethodType newType) {
        super(original, newType);
        this.collectPosition = original.collectPosition;
        this.collectArraySize = original.collectArraySize;
        this.next = original.next;
    }

    private static final MethodType collectMethodType(MethodType type, int collectArraySize, int collectPosition) {
        int parameterCount = type.parameterCount();
        if (0 == parameterCount) {
            throw new IllegalArgumentException(Msg.getString("K05ca", collectPosition));
        }
        Class<?> arrayComponent = type.parameterType(collectPosition).getComponentType();
        if (null == arrayComponent) {
            throw new IllegalArgumentException(Msg.getString("K05ca", collectPosition));
        }
        MethodType newType = type.changeParameterType(collectPosition, arrayComponent);
        if (0 == collectArraySize) {
            newType = newType.dropParameterTypes(collectPosition, collectPosition + 1);
        } else if (collectArraySize > 1) {
            Class[] classes = new Class[collectArraySize - 1];
            int arrayLength = classes.length;
            for (int j = 0; j < arrayLength; ++j) {
                classes[j] = arrayComponent;
            }
            newType = newType.insertParameterTypes(collectPosition + 1, classes);
        }
        return newType;
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new CollectHandle(this, newType);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    protected final ThunkTuple computeThunks(Object arg) {
        int[] collectArguments = (int[])arg;
        return this.thunkTable().get(new ThunkKeyWithIntArray(ThunkKey.computeThunkableType(this.type()), collectArguments));
    }

    private final Object allocateArray() {
        return Array.newInstance(this.next.type().parameterType(this.collectPosition).getComponentType(), this.collectArraySize);
    }

    private static native int numArgsToCollect();

    private static native int collectionStart();

    private static native int numArgsAfterCollectArray();

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int argPlaceholder) throws Throwable {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.next);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        ILGenMacros.populateArray(ILGenMacros.push(this.allocateArray()), ILGenMacros.middleN(CollectHandle.collectionStart(), CollectHandle.numArgsToCollect(), argPlaceholder));
        return ILGenMacros.invokeExact_X(this.next, ILGenMacros.placeholder(ILGenMacros.firstN(CollectHandle.collectionStart(), argPlaceholder), ILGenMacros.pop_L(), ILGenMacros.lastN(CollectHandle.numArgsAfterCollectArray(), argPlaceholder)));
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof CollectHandle) {
            ((CollectHandle)right).compareWithCollect(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithCollect(CollectHandle left, Comparator c) {
        c.compareStructuralParameter(left.collectArraySize, this.collectArraySize);
        c.compareStructuralParameter(left.collectPosition, this.collectPosition);
        c.compareChildHandle(left.next, this.next);
    }
}

