/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.jvm.io.ConsoleInputStream;
import com.ibm.jvm.io.ConsolePrintStream;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.RuntimePermissions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.misc.Version;
import sun.reflect.CallerSensitive;

public final class System {
    public static final InputStream in = null;
    public static final PrintStream out = null;
    public static final PrintStream err = null;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static Properties systemProperties;
    private static SecurityManager security;
    private static volatile Console console;
    private static volatile boolean consoleInitialized;
    private static String lineSeparator;
    private static boolean propertiesInitialized;
    private static boolean useLegacyVerPresents;
    private static String platformEncoding;
    private static String fileEncoding;
    private static String osEncoding;
    private static final int InitLocale = 0;
    private static final int PlatformEncoding = 1;
    private static final int FileEncoding = 2;
    private static final int OSEncoding = 3;

    private static void initEncodings() {
        platformEncoding = System.getEncoding(1);
        String definedFileEncoding = System.getEncoding(2);
        String definedOSEncoding = System.getEncoding(3);
        if (definedFileEncoding != null) {
            fileEncoding = definedFileEncoding;
            if (definedOSEncoding == null) {
                osEncoding = platformEncoding;
            }
        } else {
            fileEncoding = platformEncoding;
        }
        if (osEncoding == null) {
            osEncoding = definedOSEncoding;
        }
    }

    static void afterClinitInitialization() {
        if (null == com.ibm.oti.vm.VM.getVMLangAccess()) {
            com.ibm.oti.vm.VM.setVMLangAccess(new VMAccess());
        }
        System.ensureProperties(true);
        SharedSecrets.setJavaLangAccess((JavaLangAccess)new Access());
        try {
            Field f1 = J9VMInternals.class.getDeclaredField("jitHelpers");
            Field f2 = String.class.getDeclaredField("helpers");
            Unsafe unsafe = Unsafe.getUnsafe();
            unsafe.putObject(unsafe.staticFieldBase(f1), unsafe.staticFieldOffset(f1), JITHelpers.getHelpers());
            unsafe.putObject(unsafe.staticFieldBase(f2), unsafe.staticFieldOffset(f2), JITHelpers.getHelpers());
        }
        catch (NoSuchFieldException f1) {
            // empty catch block
        }
        String enableSharingInSubstringWhenOffsetIsZeroProperty = System.internalGetProperties().getProperty("java.lang.string.substring.nocopy");
        String.enableSharingInSubstringWhenOffsetIsZero = enableSharingInSubstringWhenOffsetIsZeroProperty == null || enableSharingInSubstringWhenOffsetIsZeroProperty.equalsIgnoreCase("false");
        StringCoding.encode((char[])new char[1], (int)0, (int)1);
        System.setErr(ConsolePrintStream.localize((OutputStream)new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), (boolean)true));
        System.setOut(ConsolePrintStream.localize((OutputStream)new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)), (boolean)true));
    }

    static native void startSNMPAgent();

    static void completeInitialization() {
        Method hook;
        Class<?> systemInitialization = null;
        try {
            systemInitialization = Class.forName("com.ibm.misc.SystemIntialization");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
        try {
            if (null != systemInitialization) {
                hook = systemInitialization.getMethod("firstChanceHook", new Class[0]);
                hook.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
        System.setIn(ConsoleInputStream.localize((InputStream)new BufferedInputStream(new FileInputStream(FileDescriptor.in))));
        Terminator.setup();
        try {
            if (null != systemInitialization) {
                hook = systemInitialization.getMethod("lastChanceHook", new Class[0]);
                hook.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    public static void setIn(InputStream newIn) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermissions.permissionSetIO);
        }
        System.setFieldImpl("in", newIn);
    }

    public static void setOut(PrintStream newOut) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermissions.permissionSetIO);
        }
        System.setFieldImpl("out", newOut);
    }

    public static void setErr(PrintStream newErr) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermissions.permissionSetIO);
        }
        System.setFieldImpl("err", newErr);
    }

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void arraycopy(Object[] A1, int offset1, Object[] A2, int offset2, int length) {
        if (A1 == null || A2 == null) {
            throw new NullPointerException();
        }
        if (offset1 >= 0 && offset2 >= 0 && length >= 0 && length <= A1.length - offset1 && length <= A2.length - offset2) {
            if (A1 != A2 || offset1 > offset2 || offset1 + length <= offset2) {
                for (int i = 0; i < length; ++i) {
                    A2[offset2 + i] = A1[offset1 + i];
                }
            } else {
                for (int i = length - 1; i >= 0; --i) {
                    A2[offset2 + i] = A1[offset1 + i];
                }
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static native long currentTimeMillis();

    private static void ensureProperties(boolean isInitialization) {
        String key;
        Properties initializedProperties = new Properties();
        if (osEncoding != null) {
            initializedProperties.put("os.encoding", osEncoding);
        }
        initializedProperties.put("ibm.system.encoding", platformEncoding);
        initializedProperties.put("sun.jnu.encoding", platformEncoding);
        initializedProperties.put("file.encoding", fileEncoding);
        initializedProperties.put("file.encoding.pkg", "sun.io");
        initializedProperties.put("java.specification.vendor", "Oracle Corporation");
        initializedProperties.put("java.specification.name", "Java Platform API Specification");
        initializedProperties.put("com.ibm.oti.configuration", "scar");
        String[] list = System.getPropertyList();
        for (int i = 0; i < list.length && (key = list[i]) != null; i += 2) {
            initializedProperties.put(key, list[i + 1]);
        }
        propertiesInitialized = true;
        systemProperties = initializedProperties;
        Version.init();
        StringBuffer.initFromSystemProperties(systemProperties);
        StringBuilder.initFromSystemProperties(systemProperties);
        String javaRuntimeVersion = initializedProperties.getProperty("java.runtime.version");
        if (null != javaRuntimeVersion) {
            String fullVersion = initializedProperties.getProperty("java.fullversion");
            if (null != fullVersion) {
                initializedProperties.put("java.fullversion", javaRuntimeVersion + "\n" + fullVersion);
            }
            System.rasInitializeVersion(javaRuntimeVersion);
        }
        lineSeparator = initializedProperties.getProperty("line.separator", "\n");
        if (isInitialization) {
            VM.saveAndRemoveProperties((Properties)initializedProperties);
        }
        systemProperties = initializedProperties;
    }

    private static void initializeSystemProperties(Map<String, String> mapProperties) {
        systemProperties = new Properties();
        for (Map.Entry<String, String> property : mapProperties.entrySet()) {
            systemProperties.put(property.getKey(), property.getValue());
        }
    }

    private static native void rasInitializeVersion(String var0);

    public static void exit(int code) {
        RUNTIME.exit(code);
    }

    public static void gc() {
        RUNTIME.gc();
    }

    public static String getenv(String var) {
        if (var == null) {
            throw new NullPointerException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("getenv." + var));
        }
        return ProcessEnvironment.getenv(var);
    }

    public static Properties getProperties() {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        return systemProperties;
    }

    static Properties internalGetProperties() {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init");
        }
        return systemProperties;
    }

    public static String getProperty(String prop) {
        String propertyString = System.getProperty(prop, null);
        return propertyString;
    }

    public static String getProperty(String prop, String defaultValue) {
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertyAccess(prop);
        }
        if (!(propertiesInitialized || prop.equals("com.ibm.IgnoreMalformedInput") || prop.equals("file.encoding.pkg") || prop.equals("sun.nio.cs.map"))) {
            if (prop.equals("os.encoding")) {
                return osEncoding;
            }
            if (prop.equals("ibm.system.encoding")) {
                return platformEncoding;
            }
            if (prop.equals("file.encoding")) {
                return fileEncoding;
            }
            throw new Error("bootstrap error, system property access before init: " + prop);
        }
        return systemProperties.getProperty(prop, defaultValue);
    }

    public static String setProperty(String prop, String value) {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init: " + prop);
        }
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new PropertyPermission(prop, "write"));
        }
        return (String)systemProperties.setProperty(prop, value);
    }

    private static native String[] getPropertyList();

    private static native String getEncoding(int var0);

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static int identityHashCode(Object anObject) {
        if (anObject == null) {
            return 0;
        }
        return J9VMInternals.fastIdentityHashCode(anObject);
    }

    @CallerSensitive
    public static void load(String pathName) {
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkLink(pathName);
        }
        ClassLoader.loadLibraryWithPath(pathName, ClassLoader.callerClassLoader(), null);
    }

    @CallerSensitive
    public static void loadLibrary(String libName) {
        ClassLoader.loadLibraryWithClassLoader(libName, ClassLoader.callerClassLoader());
    }

    public static void runFinalization() {
        RUNTIME.runFinalization();
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean flag) {
        Runtime.runFinalizersOnExit((boolean)flag);
    }

    public static void setProperties(Properties p) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        if (p == null) {
            System.ensureProperties(false);
        } else {
            systemProperties = p;
        }
    }

    public static void setSecurityManager(final SecurityManager s) {
        final SecurityManager currentSecurity = security;
        if (s != null) {
            if (currentSecurity == null) {
                try {
                    s.checkPackageAccess("java.lang");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ProtectionDomain newDomain;
                        ProtectionDomain oldDomain;
                        if (currentSecurity == null) {
                            Msg.getString("K002c");
                        }
                        if ((oldDomain = currentSecurity == null ? System.class.getPDImpl() : currentSecurity.getClass().getPDImpl()) != (newDomain = s.getClass().getPDImpl())) {
                            newDomain.implies(new AllPermission());
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (currentSecurity != null) {
            currentSecurity.checkPermission(RuntimePermissions.permissionSetSecurityManager);
        }
        security = s;
    }

    public static native String mapLibraryName(String var0);

    private static native void setFieldImpl(String var0, Object var1);

    @CallerSensitive
    static Class getCallerClass() {
        return Class.getStackClass(2);
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    public static native long nanoTime();

    public static String clearProperty(String prop) {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init: " + prop);
        }
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new PropertyPermission(prop, "write"));
        }
        return (String)systemProperties.remove(prop);
    }

    public static Map<String, String> getenv() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Console console() {
        if (consoleInitialized) {
            return console;
        }
        Class<System> clazz = System.class;
        synchronized (System.class) {
            if (consoleInitialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return console;
            }
            console = SharedSecrets.getJavaIOAccess().console();
            consoleInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return console;
        }
    }

    private static void longMultiLeafArrayCopy(Object src, int srcPos, Object dest, int destPos, int length, int elementSize, int leafSize) {
        int L2;
        int L1;
        int newDestPos;
        int newSrcPos;
        boolean isFwd = src != dest || srcPos > destPos || srcPos + length <= destPos;
        int numOfElemsPerLeaf = leafSize / elementSize;
        if (isFwd) {
            newSrcPos = srcPos;
            newDestPos = destPos;
        } else {
            newSrcPos = srcPos + length - 1;
            newDestPos = destPos + length - 1;
        }
        int srcLeafPos = newSrcPos % numOfElemsPerLeaf;
        int destLeafPos = newDestPos % numOfElemsPerLeaf;
        if (srcLeafPos < destLeafPos) {
            if (isFwd) {
                L1 = numOfElemsPerLeaf - destLeafPos;
                L2 = numOfElemsPerLeaf - (srcLeafPos + L1);
            } else {
                L1 = srcLeafPos + 1;
                L2 = destLeafPos - srcLeafPos;
            }
        } else if (isFwd) {
            L1 = numOfElemsPerLeaf - srcLeafPos;
            L2 = numOfElemsPerLeaf - (destLeafPos + L1);
        } else {
            L1 = destLeafPos + 1;
            L2 = srcLeafPos - destLeafPos;
        }
        int L3 = numOfElemsPerLeaf - L2;
        int offset = isFwd ? 0 : L1 - 1;
        System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, L1);
        newSrcPos = isFwd ? newSrcPos + L1 : newSrcPos - L1;
        newDestPos = isFwd ? newDestPos + L1 : newDestPos - L1;
        length -= L1;
        while (length >= numOfElemsPerLeaf) {
            offset = isFwd ? 0 : L2 - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, L2);
            newSrcPos = isFwd ? newSrcPos + L2 : newSrcPos - L2;
            newDestPos = isFwd ? newDestPos + L2 : newDestPos - L2;
            offset = isFwd ? 0 : L3 - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, L3);
            newSrcPos = isFwd ? newSrcPos + L3 : newSrcPos - L3;
            newDestPos = isFwd ? newDestPos + L3 : newDestPos - L3;
            length -= numOfElemsPerLeaf;
        }
        if (length > L2) {
            offset = isFwd ? 0 : L2 - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, L2);
            newSrcPos = isFwd ? newSrcPos + L2 : newSrcPos - L2;
            newDestPos = isFwd ? newDestPos + L2 : newDestPos - L2;
            length -= L2;
        }
        if (length > 0) {
            offset = isFwd ? 0 : length - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, length);
        }
    }

    private static void simpleMultiLeafArrayCopy(Object src, int srcPos, Object dest, int destPos, int length, int elementSize, int leafSize) {
        int iterLength;
        int newDestPos;
        int newSrcPos;
        int count = 0;
        boolean isFwd = src != dest || srcPos > destPos || srcPos + length <= destPos;
        int numOfElemsPerLeaf = leafSize / elementSize;
        if (isFwd) {
            newSrcPos = srcPos;
            newDestPos = destPos;
        } else {
            newSrcPos = srcPos + length - 1;
            newDestPos = destPos + length - 1;
        }
        for (count = 0; count < length; count += iterLength) {
            int srcLeafPos = newSrcPos % numOfElemsPerLeaf;
            int destLeafPos = newDestPos % numOfElemsPerLeaf;
            iterLength = isFwd && srcLeafPos >= destLeafPos || !isFwd && srcLeafPos < destLeafPos ? (isFwd ? numOfElemsPerLeaf - srcLeafPos : srcLeafPos + 1) : (isFwd ? numOfElemsPerLeaf - destLeafPos : destLeafPos + 1);
            if (length - count < iterLength) {
                iterLength = length - count;
            }
            int offset = isFwd ? 0 : iterLength - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, iterLength);
            if (isFwd) {
                newSrcPos += iterLength;
                newDestPos += iterLength;
                continue;
            }
            newSrcPos -= iterLength;
            newDestPos -= iterLength;
        }
    }

    private static void multiLeafArrayCopy(Object src, int srcPos, Object dest, int destPos, int length, int elementSize, int leafSize) {
        int newDestPos;
        int newSrcPos;
        int count = 0;
        boolean isFwd = src != dest || srcPos > destPos || srcPos + length <= destPos;
        int numOfElemsPerLeaf = leafSize / elementSize;
        if (isFwd) {
            newSrcPos = srcPos;
            newDestPos = destPos;
        } else {
            newSrcPos = srcPos + length - 1;
            newDestPos = destPos + length - 1;
        }
        int iterLength1 = 0;
        int iterLength2 = 0;
        while (count < length) {
            int secondPos;
            int firstPos;
            int srcLeafPos = newSrcPos % numOfElemsPerLeaf;
            int destLeafPos = newDestPos % numOfElemsPerLeaf;
            if (isFwd && srcLeafPos >= destLeafPos || !isFwd && srcLeafPos < destLeafPos) {
                firstPos = srcLeafPos;
                secondPos = newDestPos;
            } else {
                firstPos = destLeafPos;
                secondPos = newSrcPos;
            }
            int offset = 0;
            iterLength1 = isFwd ? numOfElemsPerLeaf - firstPos : firstPos + 1;
            if (length - count < iterLength1) {
                iterLength1 = length - count;
            }
            if (isFwd) {
                iterLength2 = numOfElemsPerLeaf - (secondPos + iterLength1) % numOfElemsPerLeaf;
            } else {
                iterLength2 = (secondPos - iterLength1) % numOfElemsPerLeaf + 1;
                offset = iterLength1 - 1;
            }
            if (length - count - iterLength1 < iterLength2) {
                iterLength2 = length - count - iterLength1;
            }
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, iterLength1);
            offset = 0;
            if (isFwd) {
                newSrcPos += iterLength1;
                newDestPos += iterLength1;
            } else {
                newSrcPos -= iterLength1;
                newDestPos -= iterLength1;
                offset = iterLength2 - 1;
            }
            if (iterLength2 <= 0) break;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, iterLength2);
            if (isFwd) {
                newSrcPos += iterLength2;
                newDestPos += iterLength2;
            } else {
                newSrcPos -= iterLength2;
                newDestPos -= iterLength2;
            }
            count += iterLength1 + iterLength2;
        }
    }

    public static String lineSeparator() {
        return lineSeparator;
    }

    static {
        propertiesInitialized = false;
        useLegacyVerPresents = false;
        System.initEncodings();
    }
}

