/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Util;
import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private final String declaringClass;
    private final String methodName;
    private final String fileName;
    private final int lineNumber;
    transient Object source;

    public StackTraceElement(String cls, String method, String file, int line) {
        if (cls == null || method == null) {
            throw new NullPointerException();
        }
        this.declaringClass = cls;
        this.methodName = method;
        this.fileName = file;
        this.lineNumber = line;
    }

    private StackTraceElement() {
        this.declaringClass = null;
        this.methodName = null;
        this.fileName = null;
        this.lineNumber = 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement castObj = (StackTraceElement)obj;
        if (this.methodName == null || castObj.methodName == null) {
            return false;
        }
        if (!this.getMethodName().equals(castObj.getMethodName())) {
            return false;
        }
        if (!this.getClassName().equals(castObj.getClassName())) {
            return false;
        }
        String localFileName = this.getFileName();
        if (localFileName == null ? castObj.getFileName() != null : !localFileName.equals(castObj.getFileName())) {
            return false;
        }
        return this.getLineNumber() == castObj.getLineNumber();
    }

    public String getClassName() {
        return this.declaringClass == null ? "<unknown class>" : this.declaringClass;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName == null ? "<unknown method>" : this.methodName;
    }

    public int hashCode() {
        if (this.methodName == null) {
            return 0;
        }
        int hashCode = this.methodName.hashCode() ^ this.declaringClass.hashCode();
        return hashCode;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(80);
        Util.printStackTraceElement(this, this.source, buf, false);
        return buf.toString();
    }
}

