/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.sun.management.internal.GcInfoUtil;
import java.lang.management.MemoryUsage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;

public class GcInfo
implements CompositeData,
CompositeDataView {
    private final long index;
    private final long startTime;
    private final long endTime;
    private final Map<String, MemoryUsage> usageBeforeGc;
    private final Map<String, MemoryUsage> usageAfterGc;
    private CompositeData cdata;

    private CompositeData getCompositeData() {
        if (null == this.cdata) {
            this.cdata = GcInfoUtil.toCompositeData(this);
        }
        return this.cdata;
    }

    private void setCompositeData(CompositeData cd) {
        this.cdata = cd;
    }

    private GcInfo(long index, long startTime, long endTime, Map<String, MemoryUsage> usageBeforeGc, Map<String, MemoryUsage> usageAfterGc) {
        this.index = index;
        this.startTime = startTime;
        this.endTime = endTime;
        this.usageBeforeGc = usageBeforeGc;
        this.usageAfterGc = usageAfterGc;
    }

    public long getId() {
        return this.index;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public Map<String, MemoryUsage> getMemoryUsageBeforeGc() {
        return this.usageBeforeGc;
    }

    public Map<String, MemoryUsage> getMemoryUsageAfterGc() {
        return this.usageAfterGc;
    }

    public static GcInfo from(CompositeData cd) {
        GcInfo result = null;
        if (cd != null) {
            ManagementUtils.verifyFieldNumber(cd, 5);
            String[] attributeNames = new String[]{"index", "startTime", "endTime", "usageBeforeGc", "usageAfterGc"};
            ManagementUtils.verifyFieldNames(cd, attributeNames);
            String[] attributeTypes = new String[]{"java.lang.Long", "java.lang.Long", "java.lang.Long", TabularData.class.getName(), TabularData.class.getName()};
            ManagementUtils.verifyFieldTypes(cd, attributeNames, attributeTypes);
            Object[] attributeVals = cd.getAll(attributeNames);
            long indexVal = (Long)attributeVals[0];
            long startTimeVal = (Long)attributeVals[1];
            long endTimeVal = (Long)attributeVals[2];
            Map<String, MemoryUsage> usageBeforeGcVal = GcInfo.convertTabularDataToMemoryUsageMap((TabularData)attributeVals[3]);
            Map<String, MemoryUsage> usageAfterGcVal = GcInfo.convertTabularDataToMemoryUsageMap((TabularData)attributeVals[4]);
            result = new GcInfo(indexVal, startTimeVal, endTimeVal, usageBeforeGcVal, usageAfterGcVal);
            result.setCompositeData(cd);
        }
        return result;
    }

    private static Map<String, MemoryUsage> convertTabularDataToMemoryUsageMap(TabularData td) {
        HashMap<String, MemoryUsage> result = new HashMap<String, MemoryUsage>();
        for (CompositeData row : td.values()) {
            String keyVal = (String)row.get("key");
            MemoryUsage usageVal = MemoryUsage.from((CompositeData)row.get("value"));
            result.put(keyVal, usageVal);
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        return this.getCompositeData().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getCompositeData().containsValue(value);
    }

    @Override
    public boolean equals(Object obj) {
        return this.getCompositeData().equals(obj);
    }

    @Override
    public Object get(String key) {
        return this.getCompositeData().get(key);
    }

    @Override
    public Object[] getAll(String[] keys) {
        return this.getCompositeData().getAll(keys);
    }

    @Override
    public CompositeType getCompositeType() {
        return this.getCompositeData().getCompositeType();
    }

    @Override
    public int hashCode() {
        return this.getCompositeData().hashCode();
    }

    @Override
    public String toString() {
        return this.getCompositeData().toString();
    }

    @Override
    public Collection<?> values() {
        return this.getCompositeData().values();
    }

    @Override
    public CompositeData toCompositeData(CompositeType ct) {
        return this.getCompositeData();
    }

    static {
        GcInfoUtil.registerConverters();
    }
}

