/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.virtualization.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.virtualization.management.GuestOSProcessorUsage;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class GuestOSProcessorUsageUtil {
    private static CompositeType compositeType;

    public static CompositeType getCompositeType() {
        block3: {
            if (null == compositeType) {
                try {
                    String[] names = new String[]{"cpuTime", "timestamp", "cpuEntitlement", "hostCpuClockSpeed"};
                    String[] descs = new String[]{"cpuTime", "timestamp", "cpuEntitlement", "hostCpuClockSpeed"};
                    OpenType[] types = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.FLOAT, SimpleType.LONG};
                    compositeType = new CompositeType(GuestOSProcessorUsage.class.getName(), GuestOSProcessorUsage.class.getName(), names, descs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static void registerConverters() {
        ManagementUtils.addCompositeConverter(GuestOSProcessorUsage.class, GuestOSProcessorUsageUtil::toCompositeData);
    }

    public static CompositeData toCompositeData(GuestOSProcessorUsage usage) {
        CompositeDataSupport result;
        block3: {
            result = null;
            if (null != usage) {
                CompositeType type = GuestOSProcessorUsageUtil.getCompositeType();
                String[] names = new String[]{"cpuTime", "timestamp", "cpuEntitlement", "hostCpuClockSpeed"};
                Object[] values = new Object[]{usage.getCpuTime(), usage.getTimestamp(), Float.valueOf(usage.getCpuEntitlement()), usage.getHostCpuClockSpeed()};
                try {
                    result = new CompositeDataSupport(type, names, values);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return result;
    }

    private GuestOSProcessorUsageUtil() {
    }
}

