/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.virtualization.management;

import com.ibm.oti.util.Msg;
import com.ibm.virtualization.management.internal.GuestOSMemoryUsageUtil;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public final class GuestOSMemoryUsage {
    private static final int HASHMASK = 0xFFFFFFF;
    private long memUsed;
    private long timestamp;
    private long maxMemLimit;

    public GuestOSMemoryUsage() {
    }

    private GuestOSMemoryUsage(long memUsed, long timestamp, long maxMemLimit) throws IllegalArgumentException {
        if (memUsed < -1L || maxMemLimit < -1L || timestamp < 0L || memUsed > maxMemLimit && maxMemLimit >= 0L) {
            throw new IllegalArgumentException();
        }
        this.memUsed = memUsed;
        this.timestamp = timestamp;
        this.maxMemLimit = maxMemLimit;
    }

    public long getMemUsed() {
        return this.memUsed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getMaxMemLimit() {
        return this.maxMemLimit;
    }

    void updateValues(long used, long timestamp, long limit) {
        this.memUsed = used;
        this.timestamp = timestamp;
        this.maxMemLimit = limit;
    }

    public static GuestOSMemoryUsage from(CompositeData cd) {
        GuestOSMemoryUsage result = null;
        if (null != cd) {
            long maxMemLimit;
            long timestamp;
            long memUsed;
            if (!GuestOSMemoryUsageUtil.getCompositeType().isValue(cd)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                memUsed = (Long)cd.get("memUsed");
                timestamp = (Long)cd.get("timestamp");
                maxMemLimit = (Long)cd.get("maxMemLimit");
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            result = new GuestOSMemoryUsage(memUsed, timestamp, maxMemLimit);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n========== ");
        sb.append(this.getClass().getSimpleName());
        sb.append(" ==========\n\n");
        sb.append("timestamp = ");
        sb.append(this.timestamp);
        sb.append("\n");
        sb.append("memUsed = ");
        sb.append(this.memUsed);
        sb.append("\n");
        sb.append("maxMemLimit = ");
        sb.append(this.maxMemLimit);
        sb.append("\n");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof GuestOSMemoryUsage)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GuestOSMemoryUsage gmu = (GuestOSMemoryUsage)obj;
        if (gmu.getMemUsed() != this.getMemUsed()) {
            return false;
        }
        if (gmu.getTimestamp() != this.getTimestamp()) {
            return false;
        }
        return gmu.getMaxMemLimit() == this.getMaxMemLimit();
    }

    public int hashCode() {
        long gmHash = this.getMemUsed() + this.getTimestamp() + this.getMaxMemLimit();
        return (int)(((gmHash >> 32) + gmHash & 0xFFFFFFFL) * 23L);
    }

    static {
        GuestOSMemoryUsageUtil.registerConverters();
    }
}

