/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.AttachHandler;
import com.ibm.tools.attach.target.Attachment;
import com.ibm.tools.attach.target.CommonDirectory;
import com.ibm.tools.attach.target.IPC;
import com.ibm.tools.attach.target.TargetDirectory;
import java.io.IOException;

final class WaitLoop
extends Thread {
    WaitLoop() {
        this.setDaemon(true);
        this.setName("Attach API wait loop");
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attachment waitForNotification(boolean retry) throws IOException {
        Object myIN = AttachHandler.mainHandler.getIgnoreNotification();
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ignoreNotification entering");
        }
        Object object = myIN;
        synchronized (object) {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ignoreNotification entered");
            }
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification starting wait");
        }
        int status = 0;
        if (AttachHandler.startWaitingForSemaphore()) {
            status = CommonDirectory.waitSemaphore(AttachHandler.vmId);
            AttachHandler.endWaitingForSemaphore();
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ended wait");
        }
        if (AttachHandler.isAttachApiTerminated()) {
            if (AttachHandler.getDoCancelNotify()) {
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification cancelNotify");
                }
                CommonDirectory.cancelNotify(AttachHandler.getNumberOfTargets());
            }
            return null;
        }
        if (status != 0) {
            if (retry) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification reopen semaphore");
                AttachHandler.AttachStateSync attachStateSync = AttachHandler.stateSync;
                synchronized (attachStateSync) {
                    if (!AttachHandler.isAttachApiTerminated()) {
                        try {
                            CommonDirectory.obtainMasterLock();
                            status = CommonDirectory.reopenSemaphore();
                            CommonDirectory.releaseMasterLock();
                        }
                        catch (IOException e) {
                            IPC.logMessage("waitForNotification: IOError on master lock : ", e.toString());
                        }
                    }
                }
                if (0 == status && TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
                    if (CommonDirectory.tryObtainMasterLock()) {
                        IPC.logMessage("semaphore recovery: send test post");
                        int numTargets = CommonDirectory.countTargetDirectories();
                        AttachHandler.setNumberOfTargets(numTargets);
                        CommonDirectory.notifyVm(numTargets);
                        CommonDirectory.releaseMasterLock();
                    }
                    return this.waitForNotification(false);
                }
            }
            AttachHandler.mainHandler.terminate(false);
            return null;
        }
        Attachment at = WaitLoop.checkReplyAndCreateAttachment();
        return at;
    }

    private static Attachment checkReplyAndCreateAttachment() throws IOException {
        Attachment at = AttachHandler.mainHandler.connectToAttacher();
        if (!TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
            AttachHandler.mainHandler.terminate(false);
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("checkReplyAndCreateAttachment iteration " + AttachHandler.notificationCount + " waitForNotification obtainLock");
        }
        if (!AttachHandler.mainHandler.syncFileLock.lockFile(true)) {
            TargetDirectory.createMySyncFile();
        } else {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " checkReplyAndCreateAttachment releaseLock");
            }
            AttachHandler.mainHandler.syncFileLock.unlockFile();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            return at;
        }
        return at;
    }

    @Override
    public void run() {
        VM.markCurrentThreadAsSystem();
        while (!AttachHandler.isAttachApiTerminated()) {
            try {
                this.waitForNotification(true);
            }
            catch (IOException e) {
                IPC.logMessage("exception in waitForNotification ", e.toString());
            }
            catch (OutOfMemoryError e) {
                IPC.tracepoint(-2, e.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    continue;
                }
            }
            ++AttachHandler.notificationCount;
        }
        AttachHandler.mainHandler.syncFileLock = null;
    }
}

