/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.AttachHandler;
import com.ibm.tools.attach.target.AttachmentConnection;
import com.ibm.tools.attach.target.CommonDirectory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.SecureRandom;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class IPC {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final int JNI_OK = 0;
    static final int TRACEPOINT_STATUS_NORMAL = 0;
    static final int TRACEPOINT_STATUS_LOGGING = 1;
    static final int TRACEPOINT_STATUS_ERROR = -1;
    static final int TRACEPOINT_STATUS_OOM_DURING_WAIT = -2;
    static final int TRACEPOINT_STATUS_OOM_DURING_TERMINATE = -3;
    static final String LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final EnumSet<PosixFilePermission> NON_OWNER_READ_WRITE = EnumSet.of(PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE);
    static final int LOGGING_UNKNOWN = 0;
    static final int LOGGING_DISABLED = 1;
    static final int LOGGING_ENABLED = 2;
    public static boolean isWindows = false;
    private static Random randomGen;
    static PrintStream logStream;
    static int loggingStatus;
    static String defaultVmId;
    public static final syncObject accessorMutex;

    static native int chmod(String var0, int var1);

    static native int chownFileToTargetUid(String var0, long var1);

    static int mkdirWithPermissions(String absolutePath, int perms) throws IOException {
        int status = IPC.mkdirWithPermissionsImpl(absolutePath, perms);
        if (0 != status) {
            throw new IOException(absolutePath);
        }
        return status;
    }

    static native int mkdirWithPermissionsImpl(String var0, int var1);

    public static void checkOwnerAccessOnly(String filePath) throws IOException {
        block5: {
            long myUid = IPC.getUid();
            long fileOwner = CommonDirectory.getFileOwner(filePath);
            if (0L != myUid && fileOwner != myUid) {
                IPC.logMessage("Wrong permissions or ownership for ", filePath);
                throw new IOException(Msg.getString("K0803", (Object)filePath, fileOwner));
            }
            if (!isWindows) {
                try {
                    Set<PosixFilePermission> actualPermissions = Files.getPosixFilePermissions(Paths.get(filePath, new String[0]), LinkOption.NOFOLLOW_LINKS);
                    actualPermissions.retainAll(NON_OWNER_READ_WRITE);
                    if (!actualPermissions.isEmpty()) {
                        String permissionString = Files.getPosixFilePermissions(Paths.get(filePath, new String[0]), LinkOption.NOFOLLOW_LINKS).toString();
                        IPC.logMessage("Wrong permissions: " + permissionString + " for ", filePath);
                        throw new IOException(Msg.getString("K0805", (Object)filePath, permissionString));
                    }
                }
                catch (UnsupportedOperationException e) {
                    String osName = VM.getVMLangAccess().internalGetProperties().getProperty("os.name");
                    if (null == osName || osName.startsWith("Windows")) break block5;
                    throw new IOException(Msg.getString("K0806", filePath), e);
                }
            }
        }
    }

    static native int openSemaphore(String var0, String var1);

    static native int waitSemaphore();

    static native int notifyVm(String var0, String var1, int var2);

    static native int cancelNotify(String var0, String var1, int var2);

    static native void closeSemaphore();

    static native int destroySemaphore();

    public static native long getUid();

    static native boolean isUsingDefaultUid();

    static native long getProcessId();

    public static boolean processExists(long pid) {
        int rc = IPC.processExistsImpl(pid);
        return rc > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLoggingEnabled() {
        boolean result = false;
        if (1 == loggingStatus) {
            result = false;
        } else if (2 == loggingStatus) {
            result = true;
        } else {
            syncObject syncObject2 = accessorMutex;
            synchronized (syncObject2) {
                result = 2 == loggingStatus;
            }
        }
        return result;
    }

    private static native int processExistsImpl(long var0);

    static void createNewFileWithPermissions(File theFile, int perms) throws IOException {
        int rc;
        String filePathString = theFile.getAbsolutePath();
        if (theFile.exists()) {
            IPC.logMessage("Found existing file ", filePathString);
            if (!theFile.delete()) {
                IPC.logMessage("Cannot delete existing file ", filePathString);
                throw new IOException(Msg.getString("K0807", filePathString));
            }
        }
        if (0 != (rc = IPC.createFileWithPermissionsImpl(theFile.getAbsolutePath(), perms))) {
            IPC.logMessage("Cannot create new file ", filePathString);
            throw new IOException(Msg.getString("K0808", filePathString));
        }
    }

    private static native int createFileWithPermissionsImpl(String var0, int var1);

    static String getTmpDir() {
        String tmpDir = IPC.getTempDirImpl();
        if (null == tmpDir) {
            IPC.logMessage("Could not get system temporary directory. Trying java.io.tmpdir");
            tmpDir = VM.getVMLangAccess().internalGetProperties().getProperty(JAVA_IO_TMPDIR);
        }
        return tmpDir;
    }

    private static native String getTempDirImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRandomNumber() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (null == randomGen) {
                randomGen = new Random(System.nanoTime());
            }
            return randomGen.nextInt();
        }
    }

    public static String getRandomString() {
        SecureRandom randomGenerator = new SecureRandom();
        return Long.toHexString(randomGenerator.nextLong());
    }

    static native void tracepoint(int var0, String var1);

    public static void logMessage(String msg) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(msg);
        }
    }

    public static void logMessage(String string1, String string2) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(string1 + string2);
        }
    }

    public static void logMessage(String string1, int int1) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(string1 + Integer.toString(int1));
        }
    }

    public static void logMessage(String string1, int int1, String string2) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(string1 + Integer.toString(int1) + string2);
        }
    }

    public static void logMessage(String string1, int int1, String string2, String string3) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(string1 + Integer.toString(int1) + string2 + string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMessage(String msg, Throwable thrown) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (IPC.isLoggingEnabled()) {
                IPC.printMessageWithHeader(msg, logStream);
                thrown.printStackTrace(logStream);
                logStream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLogMessage(String msg) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (!Objects.isNull(logStream)) {
                IPC.printMessageWithHeader(msg, logStream);
                logStream.flush();
            }
        }
    }

    static void printMessageWithHeader(String msg, PrintStream log) {
        IPC.tracepoint(1, msg);
        IPC.printLogMessageHeader(log);
        log.println(msg);
    }

    private static void printLogMessageHeader(PrintStream log) {
        long currentTime = System.currentTimeMillis();
        log.print(currentTime);
        log.print(" ");
        String id = AttachHandler.getVmId();
        if (0 == id.length()) {
            id = defaultVmId;
        }
        log.print(id);
        log.print(": ");
        log.print(Thread.currentThread().getId());
        log.print(" [");
        log.print(Thread.currentThread().getName());
        log.print("]: ");
    }

    static void setDefaultVmId(String id) {
        defaultVmId = id;
    }

    public static void sendProperties(Properties props, OutputStream outStream) throws IOException {
        ByteArrayOutputStream propsBuffer = new ByteArrayOutputStream();
        props.store(propsBuffer, "");
        outStream.write(propsBuffer.toByteArray());
        outStream.write(0);
    }

    public static Properties receiveProperties(InputStream inStream, boolean requireNull) throws IOException {
        byte[] msgBuff = AttachmentConnection.streamReceiveBytes(inStream, 0, requireNull);
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(msgBuff));
        return props;
    }

    static {
        loggingStatus = 0;
        accessorMutex = new syncObject();
    }

    static final class syncObject {
        syncObject() {
        }
    }
}

