/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.target.FilelockTimer;
import com.ibm.tools.attach.target.IPC;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.TimerTask;

public final class FileLock {
    long fileDescriptor;
    String lockFilepath;
    int fileMode;
    private boolean locked = false;
    private static FilelockTimer fileLockWatchdogTimer;
    private static syncObject shutdownSync;
    static boolean terminated;
    private volatile java.nio.channels.FileLock lockObject;
    private volatile RandomAccessFile lockFileRAF;

    boolean isLocked() {
        return this.locked;
    }

    public FileLock(String filePath, int mode) {
        if (null == filePath) {
            throw new NullPointerException("filePath is null");
        }
        this.lockFilepath = filePath;
        this.fileMode = mode;
        this.lockObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockFile(boolean blocking) throws IOException {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage(blocking ? "locking file " : "non-blocking locking file ", this.lockFilepath);
        }
        int FILE_LOCK_TIMEOUT = 60000;
        if (this.locked) {
            throw new IOException(Msg.getString("K0574"));
        }
        this.fileDescriptor = FileLock.lockFileImpl(this.lockFilepath, this.fileMode, false);
        boolean bl = this.locked = 0L <= this.fileDescriptor;
        if (!this.locked && blocking) {
            FileLockWatchdogTask wdog = new FileLockWatchdogTask();
            IPC.logMessage("lock failed, trying blocking lock");
            syncObject syncObject2 = shutdownSync;
            synchronized (syncObject2) {
                if (!terminated && null == fileLockWatchdogTimer) {
                    fileLockWatchdogTimer = new FilelockTimer("file lock watchdog");
                }
                if (null == fileLockWatchdogTimer) {
                    return false;
                }
                fileLockWatchdogTimer.schedule((TimerTask)wdog, 60000L);
            }
            try {
                this.lockFileRAF = new RandomAccessFile(this.lockFilepath, "rw");
                FileChannel lockFileChannel = this.lockFileRAF.getChannel();
                this.lockObject = lockFileChannel.lock();
                IPC.logMessage("Blocking lock succeeded");
                this.locked = true;
            }
            catch (IOException e) {
                this.locked = false;
            }
            syncObject2 = shutdownSync;
            synchronized (syncObject2) {
                if (null != fileLockWatchdogTimer) {
                    wdog.cancel();
                }
            }
        }
        return this.locked;
    }

    public void unlockFile() {
        java.nio.channels.FileLock lockObjectCopy;
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("unlocking file ", this.lockFilepath);
        }
        if (null != (lockObjectCopy = this.lockObject)) {
            IPC.logMessage("closing ", this.lockFilepath);
            try {
                lockObjectCopy.release();
                this.lockFileRAF.close();
            }
            catch (IOException e) {
                IPC.logMessage("IOException unlocking file " + this.lockFilepath, e);
            }
        }
        if (this.locked && this.fileDescriptor >= 0L) {
            FileLock.unlockFileImpl(this.fileDescriptor);
        }
        this.locked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutDown() {
        syncObject syncObject2 = shutdownSync;
        synchronized (syncObject2) {
            terminated = true;
            if (null != fileLockWatchdogTimer) {
                fileLockWatchdogTimer.cancel();
                fileLockWatchdogTimer.purge();
            }
            fileLockWatchdogTimer = null;
        }
    }

    private static native long lockFileImpl(String var0, int var1, boolean var2);

    private static native int unlockFileImpl(long var0);

    static {
        shutdownSync = new syncObject();
    }

    final class FileLockWatchdogTask
    extends TimerTask {
        FileLockWatchdogTask() {
        }

        @Override
        public void run() {
            IPC.logMessage("waitAndCheckLock recreating ", FileLock.this.lockFilepath);
            File theFile = new File(FileLock.this.lockFilepath);
            if (!theFile.renameTo(new File(theFile.getParent(), ".trash_" + IPC.getRandomNumber()))) {
                IPC.logMessage("waitAndCheckLock could not rename ", theFile.getName());
                theFile.renameTo(new File(theFile.getParent(), ".trash_" + IPC.getRandomNumber()));
            }
            FileLock.this.unlockFile();
            if (!theFile.delete()) {
                IPC.logMessage("waitAndCheckLock could not delete ", theFile.getAbsolutePath());
            } else {
                IPC.logMessage("waitAndCheckLock deleted ", theFile.getAbsolutePath());
            }
            IPC.logMessage("waitAndCheckLock normal return ");
        }
    }

    static final class syncObject {
        syncObject() {
        }
    }
}

