/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.AttachHandler;
import com.ibm.tools.attach.target.AttachmentConnection;
import com.ibm.tools.attach.target.IPC;
import com.ibm.tools.attach.target.IbmAttachOperationFailedException;
import com.ibm.tools.attach.target.Reply;
import com.ibm.tools.attach.target.Response;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.util.Objects;
import java.util.Properties;
import sun.misc.VMSupport;

final class Attachment
extends Thread
implements Response {
    private Exception lastError;
    private OutputStream responseStream;
    private Socket attacherSocket;
    private final int portNumber;
    private InputStream commandStream;
    private String attachError;
    private final AttachHandler handler;
    private final String key;
    private static final String START_REMOTE_MANAGEMENT_AGENT = "startRemoteManagementAgent";
    private static final String START_LOCAL_MANAGEMENT_AGENT = "startLocalManagementAgent";

    Attachment(AttachHandler attachHandler, Reply rc) {
        this.setName("Attachment " + rc.getPortNumber());
        this.portNumber = rc.getPortNumber();
        this.key = rc.getKey();
        this.handler = attachHandler;
        this.setDaemon(true);
    }

    boolean connectToAttacher(int portNum) {
        try {
            InetAddress localHost = InetAddress.getLoopbackAddress();
            this.attacherSocket = new Socket(localHost, portNum);
            IPC.logMessage("connectToAttacher localPort=", this.attacherSocket.getLocalPort(), " remotePort=", Integer.toString(this.attacherSocket.getPort()));
            this.responseStream = this.attacherSocket.getOutputStream();
            this.commandStream = this.attacherSocket.getInputStream();
            AttachmentConnection.streamSend(this.responseStream, "ATTACH_CONNECTED " + this.key + ' ');
            return true;
        }
        catch (IOException e) {
            IPC.logMessage("connectToAttacher exception " + e.getMessage() + " " + e.toString());
            Attachment.closeQuietly(this.responseStream);
            Attachment.closeQuietly(this.commandStream);
            Attachment.closeQuietly(this.attacherSocket);
        }
        catch (Exception otherException) {
            IPC.logMessage("connectToAttacher exception ", otherException.toString());
        }
        return false;
    }

    private static void closeQuietly(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        boolean terminate = false;
        IPC.logMessage("Attachment run");
        this.connectToAttacher(this.getPortNumber());
        while (!terminate && !this.isInterrupted()) {
            terminate = this.doCommand(this.commandStream, this.responseStream);
        }
        try {
            AttachmentConnection.streamSend(this.responseStream, "ATTACH_DETACHED");
            if (null != this.responseStream) {
                this.responseStream.close();
                this.responseStream = null;
            }
            if (null != this.commandStream) {
                this.commandStream.close();
                this.commandStream = null;
            }
        }
        catch (IOException e) {
            this.lastError = e;
        }
        if (null != this.handler) {
            this.handler.removeAttachment(this);
        }
    }

    boolean doCommand(InputStream cmdStream, OutputStream respStream) {
        block20: {
            try {
                byte[] cmdBytes = AttachmentConnection.streamReceiveBytes(cmdStream, true);
                String cmd = AttachmentConnection.bytesToString(cmdBytes);
                IPC.logMessage("doCommand ", cmd);
                if (null == cmd) {
                    return true;
                }
                if (cmd.startsWith("ATTACH_DETACH")) {
                    return true;
                }
                if (cmd.startsWith("ATTACH_LOADAGENT")) {
                    if (this.parseLoadAgent(cmd)) {
                        AttachmentConnection.streamSend(respStream, "ATTACH_ACK");
                    } else {
                        AttachmentConnection.streamSend(respStream, "ATTACH_ERR " + this.attachError);
                    }
                    break block20;
                }
                if (cmd.startsWith("ATTACH_GETSYSTEMPROPERTIES")) {
                    Properties internalProperties = VM.getVMLangAccess().internalGetProperties();
                    String argumentString = String.join((CharSequence)" ", VM.getVMArgs());
                    Properties newProperties = (Properties)internalProperties.clone();
                    newProperties.put("sun.jvm.args", argumentString);
                    this.replyWithProperties(newProperties);
                    break block20;
                }
                if (cmd.startsWith("ATTACH_GETAGENTPROPERTIES")) {
                    this.replyWithProperties(AttachHandler.getAgentProperties());
                    break block20;
                }
                if (cmd.startsWith("ATTACH_START_LOCAL_MANAGEMENT_AGENT")) {
                    try {
                        String serviceAddress = Attachment.startLocalAgent();
                        AttachmentConnection.streamSend(respStream, "ATTACH_RESULT=" + serviceAddress);
                        break block20;
                    }
                    catch (IbmAttachOperationFailedException e) {
                        AttachmentConnection.streamSend(respStream, "ATTACH_ERR AttachOperationFailedException in startLocalManagementAgent:  " + e.getMessage());
                        return false;
                    }
                }
                if (cmd.startsWith("ATTACH_START_MANAGEMENT_AGENT")) {
                    int argsStart;
                    for (argsStart = 0; argsStart < cmdBytes.length && 0 != cmdBytes[argsStart]; ++argsStart) {
                    }
                    Properties agentProperties = null;
                    agentProperties = ++argsStart < cmdBytes.length ? IPC.receiveProperties(new ByteArrayInputStream(cmdBytes, argsStart, cmdBytes.length - argsStart), false) : IPC.receiveProperties(cmdStream, true);
                    IPC.logMessage("startAgent:" + cmd);
                    if (this.startAgent(agentProperties)) {
                        AttachmentConnection.streamSend(respStream, "ATTACH_ACK");
                    } else {
                        AttachmentConnection.streamSend(respStream, "ATTACH_ERR " + this.attachError);
                    }
                } else {
                    AttachmentConnection.streamSend(respStream, "ATTACH_ERR command invalid: " + cmd);
                }
            }
            catch (IOException e) {
                IPC.logMessage("doCommand IOException ", e.toString());
                return true;
            }
            catch (Throwable e) {
                IPC.logMessage("doCommand exception ", e.toString());
                try {
                    AttachmentConnection.streamSend(respStream, "ATTACH_ERR unexpected exception or error: " + e.toString());
                }
                catch (IOException e1) {
                    IPC.logMessage("IOException sending error response" + e1.toString());
                }
                return true;
            }
        }
        return false;
    }

    private void replyWithProperties(Properties props) throws IOException {
        IPC.sendProperties(props, this.responseStream);
    }

    synchronized void teardown() {
        try {
            if (null != this.responseStream) {
                this.responseStream.close();
            }
            if (null != this.attacherSocket) {
                this.attacherSocket.close();
            }
            if (null != this.commandStream) {
                this.commandStream.close();
            }
        }
        catch (IOException e) {
            this.lastError = e;
        }
    }

    private boolean parseLoadAgent(String cmd) {
        int openParenIndex = cmd.indexOf(40);
        int closeParenIndex = cmd.lastIndexOf(41);
        int commaIndex = cmd.indexOf(44);
        String optionString = "";
        boolean decorate = true;
        this.attachError = null;
        if (cmd.startsWith("ATTACH_LOADAGENTPATH")) {
            decorate = false;
        }
        if (openParenIndex < 0 || closeParenIndex < 0) {
            this.attachError = "syntax error";
            return false;
        }
        int agentNameEnd = commaIndex < 0 ? closeParenIndex : commaIndex;
        String agentName = cmd.substring(openParenIndex + 1, agentNameEnd);
        if (agentName.length() < 1) {
            this.attachError = "invalid agent name";
            return false;
        }
        if (commaIndex > 0) {
            optionString = cmd.substring(commaIndex + 1, closeParenIndex);
        }
        this.attachError = this.loadAgentLibrary(agentName, optionString, decorate);
        return this.attachError == null;
    }

    String loadAgentLibrary(String agentLibrary, String options, boolean decorate) {
        IPC.logMessage("loadAgentLibrary " + agentLibrary + ':' + options + " decorate=" + decorate);
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        int status = this.loadAgentLibraryImpl(loader, agentLibrary, options, decorate);
        if (0 != status) {
            if (-1 == status) {
                return "AgentLoadException " + agentLibrary + ':' + options;
            }
            return "AgentInitializationException" + status;
        }
        return null;
    }

    private native int loadAgentLibraryImpl(ClassLoader var1, String var2, String var3, boolean var4);

    private int getPortNumber() {
        return this.portNumber;
    }

    private boolean startAgent(Properties agentProperties) {
        try {
            IPC.logMessage("startAgent");
            if (null != MethodRefsHolder.startRemoteManagementAgentMethod) {
                Properties startArgument = agentProperties;
                MethodRefsHolder.startRemoteManagementAgentMethod.invoke(null, startArgument);
                return true;
            }
            this.attachError = "NoSuchMethodException: startRemoteManagementAgent";
        }
        catch (IllegalArgumentException e) {
            this.attachError = "IllegalArgumentException: " + e.getMessage();
        }
        catch (IllegalAccessException e) {
            this.attachError = "IllegalAccessException: " + e.getMessage();
        }
        catch (InvocationTargetException e) {
            this.attachError = "InvocationTargetException: " + e.getMessage();
        }
        return false;
    }

    private static String startLocalAgent() throws IbmAttachOperationFailedException {
        IPC.logMessage("startLocalAgent");
        try {
            if (null == MethodRefsHolder.startLocalManagementAgentMethod) {
                throw new IbmAttachOperationFailedException("startLocalManagementAgent cannot access startLocalManagementAgent");
            }
            MethodRefsHolder.startLocalManagementAgentMethod.invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            throw new IbmAttachOperationFailedException("startLocalManagementAgent error starting agent:" + e.getClass() + " " + e.getMessage());
        }
        String addr = Attachment.saveLocalConnectorAddress();
        if (Objects.isNull(addr)) {
            throw new IbmAttachOperationFailedException("startLocalManagementAgent: com.sun.management.jmxremote.localConnectorAddress not defined");
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String saveLocalConnectorAddress() {
        String addr;
        Properties systemProperties;
        Properties properties = systemProperties = VM.getVMLangAccess().internalGetProperties();
        synchronized (properties) {
            addr = systemProperties.getProperty("com.sun.management.jmxremote.localConnectorAddress");
            if (Objects.isNull(addr) && !Objects.isNull(addr = VMSupport.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress"))) {
                systemProperties.setProperty("com.sun.management.jmxremote.localConnectorAddress", addr);
            }
        }
        if (Objects.isNull(addr)) {
            IPC.logMessage("com.sun.management.jmxremote.localConnectorAddress not set");
            return null;
        }
        IPC.logMessage("com.sun.management.jmxremote.localConnectorAddress=", addr);
        return addr;
    }

    private static final class MethodRefsHolder {
        static Method startLocalManagementAgentMethod = null;
        static Method startRemoteManagementAgentMethod = null;

        private MethodRefsHolder() {
        }

        static {
            AccessController.doPrivileged(() -> {
                try {
                    Class<?> agentClass = Class.forName("sun.management.Agent");
                    Class<Properties> startRemoteArgumentType = Properties.class;
                    startLocalManagementAgentMethod = agentClass.getDeclaredMethod(Attachment.START_LOCAL_MANAGEMENT_AGENT, new Class[0]);
                    startRemoteManagementAgentMethod = agentClass.getDeclaredMethod(Attachment.START_REMOTE_MANAGEMENT_AGENT, startRemoteArgumentType);
                    startLocalManagementAgentMethod.setAccessible(true);
                    startRemoteManagementAgentMethod.setAccessible(true);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                    startLocalManagementAgentMethod = null;
                    startRemoteManagementAgentMethod = null;
                }
                return null;
            });
        }
    }
}

