/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.Advertisement;
import com.ibm.tools.attach.target.Attachment;
import com.ibm.tools.attach.target.CommonDirectory;
import com.ibm.tools.attach.target.FileLock;
import com.ibm.tools.attach.target.IPC;
import com.ibm.tools.attach.target.Reply;
import com.ibm.tools.attach.target.TargetDirectory;
import com.ibm.tools.attach.target.WaitLoop;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;

public class AttachHandler
extends Thread {
    private static final String VMID_PROPERTY = "com.ibm.tools.attach.id";
    private static final String DISPLAYNAME_PROPERTY = "com.ibm.tools.attach.displayName";
    static final String LOGGING_ENABLE_PROPERTY = "com.ibm.tools.attach.logging";
    static final String LOG_NAME_PROPERTY = "com.ibm.tools.attach.log.name";
    static final String VMID_VALID_PATTERN = "\\p{Alpha}\\w*";
    static final long shutdownTimeoutMs = Integer.getInteger("com.ibm.tools.attach.shutdown_timeout", 10000).longValue();
    static AttachHandler mainHandler = new AttachHandler();
    static volatile Thread currentAttachThread = mainHandler;
    private Vector<Attachment> attachments = new Vector();
    static String vmId = "";
    private String displayName;
    private static AttachStateValues attachState = AttachStateValues.ATTACH_UNINITIALIZED;
    private static boolean waitingForSemaphore = false;
    static AttachStateSync stateSync = new AttachStateSync();
    static int notificationCount;
    private static boolean doCancelNotify;
    private final syncObject ignoreNotification = new syncObject();
    private static final syncObject accessorMutex;
    private static String nameProperty;
    private static String pidProperty;
    private static int numberOfTargets;
    public static final String allowAttachSelf;
    FileLock syncFileLock;

    private AttachHandler() {
        this.setDaemon(true);
        this.setName("Attach API initializer");
    }

    static void initializeAttachAPI() {
        String enableAttachProp;
        if (IPC.isUsingDefaultUid()) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
        boolean enableAttach = true;
        String osName = VM.getVMLangAccess().internalGetProperties().getProperty("os.name");
        if (null != osName) {
            if (osName.equalsIgnoreCase("z/OS")) {
                enableAttach = false;
            } else if (osName.startsWith("Windows")) {
                IPC.isWindows = true;
            }
        }
        if (null != (enableAttachProp = VM.getVMLangAccess().internalGetProperties().getProperty("com.ibm.tools.attach.enable"))) {
            if (enableAttachProp.equalsIgnoreCase("no")) {
                enableAttach = false;
            } else if (enableAttachProp.equalsIgnoreCase("yes")) {
                enableAttach = true;
            }
        }
        if (enableAttach) {
            Runtime.getRuntime().addShutdownHook(new teardownHook());
            mainHandler.start();
        } else {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
        }
    }

    private static String validateVmId(String id) {
        if (null != id && !id.matches(VMID_VALID_PATTERN)) {
            id = null;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createFiles(String newDisplayName) throws IOException {
        try {
            if (CommonDirectory.tryObtainMasterLock()) {
                CommonDirectory.deleteStaleDirectories(pidProperty);
            } else {
                CommonDirectory.obtainMasterLock();
            }
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("AttachHandler obtained master lock");
            }
            CommonDirectory.createNotificationFile();
            if (AttachHandler.isAttachApiTerminated()) {
                boolean bl = false;
                return bl;
            }
            String myId = TargetDirectory.createMyDirectory(pidProperty, false);
            if (null == myId) {
                boolean bl = false;
                return bl;
            }
            AttachHandler.setVmId(myId);
            this.setDisplayName(newDisplayName);
            CommonDirectory.openSemaphore();
            CommonDirectory.obtainAttachLock();
            Advertisement.createAdvertisementFile(AttachHandler.getVmId(), newDisplayName);
        }
        finally {
            CommonDirectory.releaseAttachLock();
            CommonDirectory.releaseMasterLock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        VM.markCurrentThreadAsSystem();
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            if (AttachStateValues.ATTACH_UNINITIALIZED != AttachHandler.getAttachState()) {
                return;
            }
            AttachHandler.setAttachState(AttachStateValues.ATTACH_STARTING);
        }
        try {
            if (!this.initialize()) {
                IPC.logMessage("ERROR: failed to initialize");
                return;
            }
            WaitLoop waiter = new WaitLoop();
            AttachStateSync attachStateSync2 = stateSync;
            synchronized (attachStateSync2) {
                if (AttachHandler.isAttachApiTerminated()) {
                    return;
                }
                AttachHandler.setAttachState(AttachStateValues.ATTACH_INITIALIZED);
                currentAttachThread = waiter;
            }
            waiter.start();
        }
        catch (OutOfMemoryError e) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
        catch (IOException e) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize() throws IOException {
        String loggingProperty = VM.getVMLangAccess().internalGetProperties().getProperty(LOGGING_ENABLE_PROPERTY);
        String logName = VM.getVMLangAccess().internalGetProperties().getProperty(LOG_NAME_PROPERTY);
        logName = null != logName && !logName.equals("") ? logName + '_' : "";
        nameProperty = VM.getVMLangAccess().internalGetProperties().getProperty(DISPLAYNAME_PROPERTY);
        pidProperty = AttachHandler.validateVmId(VM.getVMLangAccess().internalGetProperties().getProperty(VMID_PROPERTY));
        if (null == pidProperty || 0 == pidProperty.length()) {
            long pid = IPC.getProcessId();
            pidProperty = Long.toString(pid);
        }
        if (null == nameProperty) {
            nameProperty = VM.getVMLangAccess().internalGetProperties().getProperty("sun.java.command");
        }
        Object pid = IPC.accessorMutex;
        synchronized (pid) {
            if (null == IPC.logStream && null != loggingProperty && loggingProperty.equalsIgnoreCase("yes")) {
                File logFile = new File(logName + pidProperty + ".log");
                IPC.logStream = new PrintStream(logFile);
                IPC.setDefaultVmId(pidProperty);
                IPC.printMessageWithHeader("AttachHandler initialized", IPC.logStream);
                IPC.loggingStatus = 2;
            } else {
                IPC.loggingStatus = 1;
            }
        }
        pid = stateSync;
        synchronized (pid) {
            if (AttachHandler.isAttachApiTerminated()) {
                IPC.logMessage("cancel initialize before prepareCommonDirectory");
                return false;
            }
            CommonDirectory.prepareCommonDirectory();
        }
        try {
            if (!this.createFiles(nameProperty)) {
                return false;
            }
        }
        catch (IOException e) {
            IPC.logMessage("AttachHandler IOException while creating files: ", e.getMessage());
            this.terminate(false);
            return false;
        }
        File syncFileObjectTemp = TargetDirectory.getSyncFileObject();
        if (AttachHandler.isAttachApiTerminated() || null == syncFileObjectTemp) {
            IPC.logMessage("cancel initialize before creating syncFileLock");
            return false;
        }
        this.syncFileLock = new FileLock(syncFileObjectTemp.getAbsolutePath(), 438);
        return true;
    }

    public Attachment connectToAttacher() throws IOException {
        String targetDirectoryPath = TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId());
        IPC.checkOwnerAccessOnly(targetDirectoryPath);
        Reply attacherReply = Reply.readReply(targetDirectoryPath);
        Attachment at = null;
        if (null != attacherReply) {
            int portNumber = attacherReply.getPortNumber();
            IPC.logMessage(notificationCount + " connectToAttacher reply on port ", portNumber);
            if (portNumber >= 0) {
                at = new Attachment(mainHandler, attacherReply);
                this.addAttachment(at);
                at.start();
            }
        } else if (1 != IPC.loggingStatus) {
            IPC.logMessage("connectToAttacher ", notificationCount, " waitForNotification no reply file");
        }
        return at;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean terminate(boolean wakeHandler) {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("AttachHandler terminate: Attach API is being shut down");
        }
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachStateValues myAttachState = AttachHandler.getAttachState();
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            switch (myAttachState) {
                case ATTACH_UNINITIALIZED: {
                    return false;
                }
                case ATTACH_STARTING: {
                    break;
                }
                case ATTACH_INITIALIZED: {
                    break;
                }
                case ATTACH_TERMINATED: {
                    return false;
                }
                default: {
                    IPC.logMessage("Unrecognized synchronization state " + stateSync.toString());
                }
            }
        }
        currentAttachThread.interrupt();
        if (wakeHandler) {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("AttachHandler terminate removing contents of directory : ", TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId()));
            }
            TargetDirectory.deleteMyFiles();
        } else {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("AttachHandler terminate removing directory : ", TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId()));
            }
            TargetDirectory.deleteMyDirectory(false);
        }
        for (Attachment a : this.attachments) {
            if (null == a) continue;
            a.teardown();
        }
        FileLock.shutDown();
        return AttachHandler.terminateWaitLoop(wakeHandler, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean terminateWaitLoop(boolean wakeHandler, int retryNumber) {
        boolean gotLock = false;
        boolean destroySemaphore = false;
        long lockDeadline = System.nanoTime() + shutdownTimeoutMs * 1000000L / 10L;
        try {
            gotLock = CommonDirectory.tryObtainMasterLock();
            while (!gotLock && AttachHandler.isWaitingForSemaphore()) {
                Thread.sleep(10L);
                gotLock = CommonDirectory.tryObtainMasterLock();
                if (System.nanoTime() <= lockDeadline) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            IPC.logMessage("InterruptedException while waiting to shut down", e);
        }
        if (!AttachHandler.isWaitingForSemaphore()) {
            wakeHandler = false;
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("VM already notified for termination, abandoning master lock");
            }
            if (gotLock) {
                CommonDirectory.releaseMasterLock();
                gotLock = false;
            }
        }
        if (gotLock) {
            try {
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("AttachHandler terminate obtained master lock");
                }
                int numTargets = CommonDirectory.countTargetDirectories() + retryNumber;
                AttachHandler.setNumberOfTargets(numTargets);
                if (numTargets <= 1) {
                    AttachHandler.setDoCancelNotify(false);
                    if (wakeHandler) {
                        CommonDirectory.notifyVm(1);
                    }
                    destroySemaphore = true;
                    return destroySemaphore;
                }
                if (!wakeHandler) return destroySemaphore;
                AttachHandler.setDoCancelNotify(true);
                CommonDirectory.notifyVm(numTargets);
                return destroySemaphore;
            }
            finally {
                CommonDirectory.releaseMasterLock();
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("AttachHandler terminate released master lock");
                }
            }
        } else {
            IPC.logMessage("AttachHandler tryObtainMasterLock failed");
        }
        return destroySemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForAttachApiInitialization() {
        boolean status;
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachStateValues currentState = AttachHandler.getAttachState();
            if (AttachStateValues.ATTACH_INITIALIZED == currentState) {
                status = true;
            } else if (AttachStateValues.ATTACH_TERMINATED == currentState) {
                status = false;
            } else {
                int waitCycles = 2;
                status = false;
                block10: while (waitCycles > 0) {
                    --waitCycles;
                    try {
                        stateSync.wait(100000L);
                        currentState = AttachHandler.getAttachState();
                        switch (currentState) {
                            case ATTACH_STARTING: {
                                continue block10;
                            }
                            case ATTACH_INITIALIZED: {
                                status = true;
                                waitCycles = 0;
                                continue block10;
                            }
                            case ATTACH_TERMINATED: {
                                waitCycles = 0;
                                continue block10;
                            }
                        }
                        waitCycles = 0;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setNumberOfTargets(int numberOfTargets) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            AttachHandler.numberOfTargets = numberOfTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getNumberOfTargets() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return numberOfTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAttachment(Attachment at) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            this.attachments.add(at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAttachment(Attachment attachment) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            int pos = this.attachments.indexOf(attachment);
            if (pos > 0) {
                this.attachments.remove(pos);
            }
        }
    }

    static Properties getAgentProperties() {
        String[] agentPropertyNames = new String[]{"com.sun.management.jmxremote.localConnectorAddress", "sun.jvm.args", "sun.jvm.flags", "sun.java.command"};
        Attachment.saveLocalConnectorAddress();
        Properties agentProperties = new Properties();
        for (String pName : agentPropertyNames) {
            String pValue = VM.getVMLangAccess().internalGetProperties().getProperty(pName);
            if (null == pValue) continue;
            agentProperties.put(pName, pValue);
        }
        return agentProperties;
    }

    public static boolean isAttachApiInitialized() {
        return AttachStateValues.ATTACH_INITIALIZED == AttachHandler.getAttachState();
    }

    public static boolean isAttachApiTerminated() {
        return AttachStateValues.ATTACH_TERMINATED == AttachHandler.getAttachState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttachStateValues getAttachState() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            return attachState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            return waitingForSemaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean startWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            waitingForSemaphore = attachState != AttachStateValues.ATTACH_TERMINATED;
            return waitingForSemaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            waitingForSemaphore = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAttachState(AttachStateValues attachState) {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachHandler.attachState = attachState;
            stateSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDisplayName() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return this.displayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDisplayName(String displayName) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            this.displayName = displayName;
        }
    }

    public Object getIgnoreNotification() {
        return this.ignoreNotification;
    }

    public static AttachHandler getMainHandler() {
        return mainHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVmId() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return vmId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setVmId(String id) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            vmId = id;
        }
    }

    public static long getProcessId() {
        return IPC.getProcessId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean getDoCancelNotify() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return doCancelNotify;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDoCancelNotify(boolean doCancel) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            doCancelNotify = doCancel;
        }
    }

    static {
        accessorMutex = new syncObject();
        allowAttachSelf = VM.getVMLangAccess().internalGetProperties().getProperty("jdk.attach.allowAttachSelf", "true");
    }

    static final class teardownHook
    extends Thread {
        teardownHook() {
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setName("Attach API teardown");
                VM.markCurrentThreadAsSystem();
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("shutting down attach API");
                }
                if (null == mainHandler) {
                    return;
                }
                long shutdownDeadlineNs = System.nanoTime() + shutdownTimeoutMs * 1000000L;
                boolean destroySemaphore = mainHandler.terminate(true);
                try {
                    mainHandler.join(shutdownTimeoutMs / 2L);
                    int timeout = 100;
                    int retryNumber = 0;
                    while (System.nanoTime() < shutdownDeadlineNs) {
                        currentAttachThread.join(timeout);
                        if (currentAttachThread.getState() != Thread.State.TERMINATED) {
                            IPC.logMessage("Timeout waiting for wait loop termination.  Retry #" + retryNumber);
                            timeout *= 2;
                            AttachHandler.terminateWaitLoop(true, retryNumber);
                            ++retryNumber;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    IPC.logMessage("teardown join with attach handler interrupted");
                }
                if (currentAttachThread.getState() != Thread.State.TERMINATED) {
                    IPC.logMessage("Attach API not terminated");
                }
                TargetDirectory.deleteMyDirectory(true);
                if (destroySemaphore) {
                    if (CommonDirectory.tryObtainMasterLock()) {
                        CommonDirectory.destroySemaphore();
                        if (1 != IPC.loggingStatus) {
                            IPC.logMessage("AttachHandler destroyed semaphore");
                        }
                        CommonDirectory.releaseMasterLock();
                    } else {
                        if (1 != IPC.loggingStatus) {
                            IPC.logMessage("could not obtain lock, semaphore not destroyed");
                        }
                        CommonDirectory.closeSemaphore();
                    }
                } else {
                    CommonDirectory.closeSemaphore();
                    if (1 != IPC.loggingStatus) {
                        IPC.logMessage("AttachHandler closed semaphore");
                    }
                }
                if (null != IPC.logStream) {
                    IPC.logStream.close();
                }
            }
            catch (OutOfMemoryError e) {
                IPC.tracepoint(-3, e.getMessage());
                return;
            }
        }
    }

    static final class syncObject {
        syncObject() {
        }
    }

    static final class AttachStateSync {
        AttachStateSync() {
        }
    }

    private static enum AttachStateValues {
        ATTACH_UNINITIALIZED,
        ATTACH_TERMINATED,
        ATTACH_STARTING,
        ATTACH_INITIALIZED;

    }
}

