/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.AttachHandler;
import com.ibm.tools.attach.target.IPC;
import com.ibm.tools.attach.target.TargetDirectory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Advertisement {
    private static final String KEY_ATTACH_NOTIFICATION_SYNC = "attachNotificationSync";
    private static final String KEY_REPLY_FILE = "replyFile";
    private static final String KEY_NOTIFIER = "notifier";
    private static final String KEY_DISPLAY_NAME = "displayName";
    private static final String KEY_VM_ID = "vmId";
    private static final String KEY_USER_UID = "userUid";
    private static final String KEY_USER_ID = "userId";
    private static final String KEY_VERSION = "version";
    private static final String KEY_PROCESS_ID = "processId";
    private static final String ADVERT_FILENAME = "attachInfo";
    private Properties props = new Properties();
    private final long pid;
    private final long uid;

    private Advertisement(InputStream advertStream) throws IOException {
        long id;
        try {
            this.props.load(advertStream);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(Msg.getString("K0556"), e);
        }
        try {
            id = Long.parseLong(this.props.getProperty(KEY_PROCESS_ID));
        }
        catch (NumberFormatException e) {
            id = 0L;
        }
        this.pid = id;
        try {
            id = Long.parseLong(this.props.getProperty(KEY_USER_UID));
        }
        catch (NumberFormatException e) {
            id = 0L;
        }
        if (null == this.props.getProperty(KEY_VM_ID) || null == this.props.getProperty(KEY_DISPLAY_NAME)) {
            throw new IOException(Msg.getString("K0554"));
        }
        this.uid = id;
    }

    public static Advertisement readAdvertisementFile(InputStream advertStream) throws IOException {
        Advertisement advert = null;
        try {
            advert = new Advertisement(advertStream);
        }
        catch (IOException e) {
            IPC.logMessage("IOException opening advertisement ", e.getMessage());
            throw e;
        }
        return advert;
    }

    private static StringBuilder createAdvertContent(String vmId, String displayName) {
        StringBuilder contentBuffer = new StringBuilder(512);
        Advertisement.addKeyAsciiValue(contentBuffer, KEY_VERSION, "0.1");
        Advertisement.addKeyValue(contentBuffer, KEY_USER_ID, VM.getVMLangAccess().internalGetProperties().getProperty("user.name"));
        Advertisement.addKeyAsciiValue(contentBuffer, KEY_USER_UID, Long.toString(IPC.getUid()));
        Advertisement.addKeyAsciiValue(contentBuffer, KEY_PROCESS_ID, Long.toString(IPC.getProcessId()));
        Advertisement.addKeyValue(contentBuffer, KEY_VM_ID, vmId);
        Advertisement.addKeyValue(contentBuffer, KEY_DISPLAY_NAME, null == displayName || displayName.length() == 0 ? vmId : displayName);
        Advertisement.addKeyValue(contentBuffer, KEY_NOTIFIER, "_notifier");
        File tmpTargetDirectoryFileObject = TargetDirectory.getTargetDirectoryFileObject();
        File tmpSyncFileObject = TargetDirectory.getSyncFileObject();
        if (null != tmpTargetDirectoryFileObject && null != tmpSyncFileObject) {
            Advertisement.addKeyValue(contentBuffer, KEY_REPLY_FILE, new File(tmpTargetDirectoryFileObject, "replyInfo").getPath());
            Advertisement.addKeyValue(contentBuffer, KEY_ATTACH_NOTIFICATION_SYNC, tmpSyncFileObject.getAbsolutePath());
            return contentBuffer;
        }
        return null;
    }

    private static void addKeyValue(StringBuilder contentBuffer, String newKey, String newValue) {
        contentBuffer.append(newKey);
        contentBuffer.append('=');
        Advertisement.encodeString(contentBuffer, newValue);
        contentBuffer.append('\n');
    }

    private static void addKeyAsciiValue(StringBuilder contentBuffer, String newKey, String newValue) {
        contentBuffer.append(newKey);
        contentBuffer.append('=');
        contentBuffer.append(newValue);
        contentBuffer.append('\n');
    }

    private static void encodeString(StringBuilder buffer, String originalString) {
        block6: for (int i = 0; i < originalString.length(); ++i) {
            char ch = originalString.charAt(i);
            switch (ch) {
                case '\t': {
                    buffer.append("\\t");
                    continue block6;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block6;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block6;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block6;
                }
                default: {
                    if ("\\#!=:".indexOf(ch) >= 0 || ch == ' ') {
                        buffer.append('\\');
                    }
                    if (ch >= ' ' && ch <= '~') {
                        buffer.append(ch);
                        continue block6;
                    }
                    String hex = Integer.toHexString(ch);
                    buffer.append("\\u");
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buffer.append("0");
                    }
                    buffer.append(hex);
                }
            }
        }
    }

    static void createAdvertisementFile(String vmId, String displayName) throws IOException {
        if (AttachHandler.isAttachApiTerminated()) {
            return;
        }
        File advertFile = TargetDirectory.getAdvertisementFileObject();
        IPC.createNewFileWithPermissions(advertFile, 384);
        try (FileOutputStream advertOutputStream = new FileOutputStream(advertFile);){
            StringBuilder advertContent = Advertisement.createAdvertContent(vmId, displayName);
            if (null == advertContent) {
                IPC.logMessage("createAdvertisementFile failed to create advertisement file : file object is null");
                return;
            }
            advertOutputStream.write(advertContent.toString().getBytes("ISO8859_1"));
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("createAdvertisementFile ", advertFile.getAbsolutePath());
            }
        }
    }

    public static String getFilename() {
        return ADVERT_FILENAME;
    }

    public String getDisplayName() {
        return this.props.getProperty(KEY_DISPLAY_NAME);
    }

    public long getProcessId() {
        return this.pid;
    }

    public String getVmId() {
        return this.props.getProperty(KEY_VM_ID);
    }

    String getNotifier() {
        return this.props.getProperty(KEY_NOTIFIER);
    }

    public String getReplyFile() {
        return this.props.getProperty(KEY_REPLY_FILE);
    }

    public long getUid() {
        return this.uid;
    }

    public String getNotificationSync() {
        return this.props.getProperty(KEY_ATTACH_NOTIFICATION_SYNC);
    }
}

