/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.security.ProtectionDomain;

public final class Util {
    private static final String defaultEncoding;
    private static final String[] digitChars;

    public static byte[] getBytes(String name) {
        if (defaultEncoding != null) {
            try {
                return name.getBytes(defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return name.getBytes();
    }

    public static String toString(byte[] bytes) {
        if (defaultEncoding != null) {
            try {
                return new String(bytes, 0, bytes.length, defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(bytes, 0, bytes.length);
    }

    public static String convertFromUTF8(byte[] buf, int offset, int utfSize) throws UTFDataFormatException {
        return Util.convertUTF8WithBuf(buf, new char[utfSize], offset, utfSize);
    }

    public static String convertUTF8WithBuf(byte[] buf, char[] out, int offset, int utfSize) throws UTFDataFormatException {
        int count = 0;
        int s = 0;
        while (count < utfSize) {
            byte b;
            if ((out[s] = (char)buf[offset + count++]) < '\u0080') {
                ++s;
                continue;
            }
            char a = out[s];
            if ((a & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new UTFDataFormatException(Msg.getString("K0062", count));
                }
                if (((b = buf[count++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0062", count - 1));
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new UTFDataFormatException(Msg.getString("K0063", count + 1));
                }
                b = buf[count++];
                byte c = buf[count++];
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0064", count - 2));
                }
                out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException(Msg.getString("K0065", count - 1));
        }
        return new String(out, 0, s);
    }

    public static String urlEncode(String s) {
        boolean modified = false;
        StringBuilder buf = new StringBuilder();
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || "_-!.~'()*,:$&+/@".indexOf(ch) > -1) {
                if (start >= 0) {
                    modified = true;
                    Util.convert(s.substring(start, i), buf);
                    start = -1;
                }
                buf.append(ch);
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            modified = true;
            Util.convert(s.substring(start, s.length()), buf);
        }
        return modified ? buf.toString() : s;
    }

    private static void convert(String s, StringBuilder buf) {
        byte[] bytes;
        String digits = "0123456789abcdef";
        try {
            bytes = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = s.getBytes();
        }
        for (int j = 0; j < bytes.length; ++j) {
            buf.append('%');
            buf.append("0123456789abcdef".charAt((bytes[j] & 0xF0) >> 4));
            buf.append("0123456789abcdef".charAt(bytes[j] & 0xF));
        }
    }

    public static boolean startsWithDriveLetter(String path) {
        if (path.charAt(1) != ':') {
            return false;
        }
        char c = path.charAt(0);
        return (c = Character.toLowerCase(c)) >= 'a' && c <= 'z';
    }

    public static String canonicalizePath(String file) {
        int dirIndex;
        while ((dirIndex = file.indexOf("/./")) >= 0) {
            file = file.substring(0, dirIndex + 1) + file.substring(dirIndex + 3);
        }
        if (file.endsWith("/.")) {
            file = file.substring(0, file.length() - 1);
        }
        while ((dirIndex = file.indexOf("/../")) >= 0) {
            if (dirIndex != 0) {
                file = file.substring(0, file.lastIndexOf(47, dirIndex - 1)) + file.substring(dirIndex + 3);
                continue;
            }
            file = file.substring(dirIndex + 3);
        }
        if (file.endsWith("/..") && file.length() > 3) {
            file = file.substring(0, file.lastIndexOf(47, file.length() - 4) + 1);
        }
        return file;
    }

    public static boolean doesClassLoaderDescendFrom(ClassLoader currentLoader, ClassLoader requestedLoader) {
        if (requestedLoader == null) {
            return true;
        }
        if (currentLoader != requestedLoader) {
            while (currentLoader != null) {
                if (currentLoader == requestedLoader) {
                    return true;
                }
                currentLoader = currentLoader.getParent();
            }
            return false;
        }
        return true;
    }

    public static void appendTo(Appendable buf, CharSequence s) {
        try {
            buf.append(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void appendTo(Appendable buf, int number) {
        int j = 1;
        int i = 0;
        for (i = number; i >= 10; i /= 10) {
            j *= 10;
        }
        Util.appendTo(buf, digitChars[i]);
        while (j >= 10) {
            i = (number -= j * i) / (j /= 10);
            Util.appendTo(buf, digitChars[i]);
        }
    }

    public static void appendTo(Appendable buf, CharSequence s, int indents) {
        for (int i = 0; i < indents; ++i) {
            Util.appendTo(buf, "\t");
        }
        Util.appendTo(buf, s);
    }

    public static void appendLnTo(Appendable buf) {
        if (buf instanceof PrintStream) {
            ((PrintStream)buf).println();
        } else if (buf instanceof PrintWriter) {
            ((PrintWriter)buf).println();
        } else {
            Util.appendTo(buf, "\n");
        }
    }

    public static void printStackTraceElement(StackTraceElement e, Object elementSource, Appendable buf, boolean extended) {
        Util.appendTo(buf, e.getClassName());
        Util.appendTo(buf, ".");
        Util.appendTo(buf, e.getMethodName());
        Util.appendTo(buf, "(");
        if (e.isNativeMethod()) {
            Util.appendTo(buf, "Native Method");
        } else {
            String fileName = e.getFileName();
            if (fileName == null) {
                Util.appendTo(buf, "Unknown Source");
            } else {
                int lineNumber = e.getLineNumber();
                Util.appendTo(buf, fileName);
                if (lineNumber >= 0) {
                    Util.appendTo(buf, ":");
                    Util.appendTo(buf, lineNumber);
                }
            }
        }
        Util.appendTo(buf, ")");
        if (elementSource != null) {
            Util.appendTo(buf, " from ");
            if (elementSource instanceof String) {
                Util.appendTo(buf, (String)elementSource);
            } else if (elementSource instanceof ProtectionDomain) {
                ProtectionDomain pd = (ProtectionDomain)elementSource;
                Util.appendTo(buf, pd.getClassLoader().toString());
                Util.appendTo(buf, "(");
                Util.appendTo(buf, pd.getCodeSource().getLocation().toString());
                Util.appendTo(buf, ")");
            }
        }
    }

    static {
        String encoding = VM.getVMLangAccess().internalGetProperties().getProperty("os.encoding");
        if (encoding != null) {
            try {
                "".getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                encoding = null;
            }
        }
        defaultEncoding = encoding;
        digitChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    }
}

