/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.CannotSetClasspathException;
import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import com.ibm.oti.util.Msg;
import java.net.URL;

final class SharedClassURLClasspathHelperImpl
extends SharedClassAbstractHelper
implements SharedClassURLClasspathHelper {
    private URL[] urls;
    private URL[] origurls;
    private boolean[] validated;
    private int urlCount;
    private int confirmedCount;
    private boolean invalidURLExists;

    private static native void init();

    SharedClassURLClasspathHelperImpl(ClassLoader loader, URL[] classpath, int id, boolean canFind, boolean canStore) {
        this.origurls = classpath;
        this.urls = new URL[classpath.length];
        this.urlCount = classpath.length;
        this.validated = new boolean[classpath.length];
        this.confirmedCount = 0;
        this.invalidURLExists = false;
        this.initialize(loader, id, canFind, canStore);
        this.initializeShareableClassloader(loader);
        this.initializeURLs();
    }

    private void initializeURLs() {
        for (int i = 0; i < this.urlCount; ++i) {
            this.urls[i] = this.convertJarURL(this.origurls[i]);
            if (this.validateURL(this.urls[i], false)) continue;
            this.invalidURLExists = true;
        }
    }

    private native int findSharedClassImpl2(int var1, String var2, String var3, ClassLoader var4, URL[] var5, boolean var6, boolean var7, int var8, int var9, byte[] var10);

    private native boolean storeSharedClassImpl2(int var1, String var2, ClassLoader var3, URL[] var4, int var5, int var6, Class<?> var7, byte[] var8);

    private native void notifyClasspathChange2(ClassLoader var1);

    @Override
    public byte[] findSharedClass(String className, SharedClassURLClasspathHelper.IndexHolder indexFoundAtHolder) {
        return this.findSharedClass(null, className, indexFoundAtHolder);
    }

    @Override
    public synchronized byte[] findSharedClass(String partition, String className, SharedClassURLClasspathHelper.IndexHolder indexFoundAtHolder) {
        boolean doStore;
        boolean doFind;
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            this.printVerboseInfo(Msg.getString("K059f"));
            return null;
        }
        if (!this.canFind) {
            return null;
        }
        if (className == null) {
            this.printVerboseError(Msg.getString("K05a1"));
            return null;
        }
        if (this.invalidURLExists) {
            this.printVerboseInfo(Msg.getString("K05a4"));
            return null;
        }
        if (this.confirmedCount == 0) {
            this.printVerboseInfo(Msg.getString("K05a5"));
            return null;
        }
        SharedClassFilter theFilter = this.getSharingFilter();
        if (theFilter != null) {
            doFind = theFilter.acceptFind(className);
            doStore = nativeFlags[0] == 0 ? theFilter.acceptStore(className) : true;
        } else {
            doFind = true;
            doStore = true;
        }
        byte[] romClassCookie = new byte[this.ROMCLASS_COOKIE_SIZE];
        int indexFoundAt = this.findSharedClassImpl2(this.id, partition, className, loader, this.urls, doFind, doStore, this.urlCount, this.confirmedCount, romClassCookie);
        if (indexFoundAt < 0) {
            return null;
        }
        if (indexFoundAtHolder != null) {
            indexFoundAtHolder.setIndex(indexFoundAt);
        }
        return romClassCookie;
    }

    @Override
    public boolean storeSharedClass(Class<?> clazz, int foundAtIndex) {
        return this.storeSharedClass(null, clazz, foundAtIndex);
    }

    @Override
    public synchronized boolean storeSharedClass(String partition, Class<?> clazz, int foundAtIndex) {
        ClassLoader actualLoader;
        if (!this.canStore) {
            return false;
        }
        if (clazz == null) {
            this.printVerboseError(Msg.getString("K05a3"));
            return false;
        }
        if (this.urlCount == 0) {
            this.printVerboseError(Msg.getString("K05a6"));
            return false;
        }
        if (foundAtIndex < 0) {
            this.printVerboseError(Msg.getString("K05a7"));
            return false;
        }
        if (foundAtIndex >= this.urlCount) {
            this.printVerboseError(Msg.getString("K05a8"));
            return false;
        }
        if (this.invalidURLExists) {
            this.printVerboseInfo(Msg.getString("K05a9"));
            return false;
        }
        if (!this.validated[foundAtIndex]) {
            if (!this.validateURL(this.urls[foundAtIndex], true)) {
                return false;
            }
            this.validated[foundAtIndex] = true;
        }
        if (!this.validateClassLoader(actualLoader = this.getClassLoader(), clazz)) {
            return false;
        }
        if (this.confirmedCount <= foundAtIndex) {
            this.confirmedCount = foundAtIndex + 1;
            this.printVerboseInfo(Msg.getString("K05aa", this.confirmedCount));
        }
        return this.storeSharedClassImpl2(this.id, partition, actualLoader, this.urls, this.urlCount, foundAtIndex, clazz, nativeFlags);
    }

    private synchronized void growURLs(int toMinSize) {
        this.printVerboseInfo(Msg.getString("K05ab", toMinSize));
        int newSize = (toMinSize + 1) * 2;
        URL[] newOrigUrls = new URL[newSize];
        URL[] newUrls = new URL[newSize];
        boolean[] newValidated = new boolean[newSize];
        System.arraycopy((Object)this.origurls, 0, (Object)newOrigUrls, 0, this.urlCount);
        System.arraycopy((Object)this.urls, 0, (Object)newUrls, 0, this.urlCount);
        System.arraycopy((Object)this.validated, 0, (Object)newValidated, 0, this.urlCount);
        this.origurls = newOrigUrls;
        this.urls = newUrls;
        this.validated = newValidated;
    }

    @Override
    public synchronized void addClasspathEntry(URL cpe) {
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            if (cpe == null) {
                this.printVerboseError(Msg.getString("K05ac"));
                return;
            }
            if (this.urls.length < this.urlCount + 1) {
                this.growURLs(this.urlCount + 1);
            }
            this.origurls[this.urlCount] = cpe;
            this.urls[this.urlCount] = this.convertJarURL(cpe);
            if (!this.validateURL(this.urls[this.urlCount], false)) {
                this.invalidURLExists = true;
            }
            ++this.urlCount;
            this.notifyClasspathChange2(loader);
        }
    }

    synchronized URL[] getClasspath() {
        URL[] correctLengthArray = new URL[this.urlCount];
        System.arraycopy((Object)this.origurls, 0, (Object)correctLengthArray, 0, this.urlCount);
        return correctLengthArray;
    }

    @Override
    public synchronized void confirmAllEntries() {
        this.confirmedCount = this.urlCount;
    }

    @Override
    public synchronized void setClasspath(URL[] newClasspath) throws CannotSetClasspathException {
        int i;
        boolean changeMade = false;
        boolean invalidURLFound = false;
        int commonURLsLength = this.origurls.length < newClasspath.length ? this.origurls.length : newClasspath.length;
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            throw new CannotSetClasspathException(Msg.getString("K059a"));
        }
        if (newClasspath.length < this.confirmedCount) {
            throw new CannotSetClasspathException(Msg.getString("K05ad"));
        }
        for (i = 0; i < this.confirmedCount; ++i) {
            if (newClasspath[i].equals(this.origurls[i])) continue;
            throw new CannotSetClasspathException(Msg.getString("K05ae", i));
        }
        if (newClasspath.length > this.origurls.length) {
            this.growURLs(newClasspath.length);
        }
        for (i = this.confirmedCount; i < commonURLsLength; ++i) {
            boolean urlUpdated;
            boolean bl = urlUpdated = !newClasspath[i].equals(this.origurls[i]);
            if (!this.invalidURLExists && !urlUpdated) continue;
            URL temp = null;
            temp = urlUpdated ? this.convertJarURL(newClasspath[i]) : this.urls[i];
            if (!invalidURLFound && !this.validateURL(temp, false)) {
                invalidURLFound = true;
                this.printVerboseInfo(Msg.getString("K05af", newClasspath[i], i));
            }
            if (!urlUpdated) continue;
            this.origurls[i] = newClasspath[i];
            this.urls[i] = temp;
            changeMade = true;
        }
        this.invalidURLExists = invalidURLFound;
        for (i = commonURLsLength; i < newClasspath.length; ++i) {
            this.origurls[i] = newClasspath[i];
            this.urls[i] = this.convertJarURL(newClasspath[i]);
            if (!this.invalidURLExists && !this.validateURL(this.urls[i], false)) {
                this.printVerboseInfo(Msg.getString("K05b0", newClasspath[i], i));
                this.invalidURLExists = true;
            }
            changeMade = true;
        }
        if (this.urlCount != newClasspath.length) {
            this.urlCount = newClasspath.length;
            changeMade = true;
        }
        if (!this.invalidURLExists) {
            this.printVerboseInfo(Msg.getString("K05b1"));
        }
        if (changeMade) {
            this.printVerboseInfo(Msg.getString("K05b2", this.urlCount));
            this.notifyClasspathChange2(loader);
        }
    }

    @Override
    String getHelperType() {
        return "SharedClassURLClasspathHelper";
    }

    static {
        SharedClassURLClasspathHelperImpl.init();
    }
}

