/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermission;
import java.security.AccessControlException;

public abstract class SharedAbstractHelperFactory {
    private static int idCount = 1;
    static Object monitor = new Monitor();

    static boolean checkPermission(ClassLoader loader, String type) {
        boolean result = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new SharedClassPermission(loader, type));
            }
            catch (AccessControlException e) {
                result = false;
            }
        }
        return result;
    }

    static boolean canFind(ClassLoader loader) {
        return SharedAbstractHelperFactory.checkPermission(loader, "read");
    }

    static boolean canStore(ClassLoader loader) {
        return SharedAbstractHelperFactory.checkPermission(loader, "write");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getNewID() {
        Object object = monitor;
        synchronized (object) {
            return idCount++;
        }
    }

    private static final class Monitor {
        Monitor() {
        }
    }
}

