/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.reflect;

import com.ibm.oti.reflect.AnnotationParser;
import com.ibm.oti.reflect.Annotations;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;

public class Constructor {
    private java.lang.reflect.Constructor constructor;
    private SoftReference<Annotations> annotations;

    public Constructor(java.lang.reflect.Constructor constructor) {
        this.constructor = constructor;
    }

    private synchronized Annotations getAnnotations() {
        Annotations ans;
        if (this.annotations == null || (ans = this.annotations.get()) == null) {
            ans = new Annotations(AnnotationParser.parseAnnotations(this.constructor));
            this.annotations = new SoftReference<Annotations>(ans);
        }
        return ans;
    }

    public <T extends Annotation> T getAnnotation(Class<T> cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        return this.getAnnotations().getAnnotation(cl);
    }

    public Annotation[] getDeclaredAnnotations() {
        return (Annotation[])this.getAnnotations().getAnnotations().clone();
    }

    public Annotation[][] getParameterAnnotations() {
        return AnnotationParser.parseParameterAnnotations(this.constructor);
    }
}

