/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.lang.management.ProcessorUsage;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class ProcessorUsageUtil {
    private static CompositeType compositeType;

    public static CompositeType getCompositeType() {
        block3: {
            if (null == compositeType) {
                try {
                    String[] names = new String[]{"user", "system", "idle", "wait", "busy", "id", "online", "timestamp"};
                    String[] dscs = new String[]{"user", "system", "idle", "wait", "busy", "id", "online", "timestamp"};
                    OpenType[] types = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG};
                    compositeType = new CompositeType(ProcessorUsage.class.getName(), ProcessorUsage.class.getName(), names, dscs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static void registerConverters() {
        ManagementUtils.addCompositeConverter(ProcessorUsage.class, ProcessorUsageUtil::toCompositeData);
    }

    public static CompositeData toCompositeData(ProcessorUsage usage) {
        CompositeDataSupport result;
        block3: {
            result = null;
            if (null != usage) {
                CompositeType type = ProcessorUsageUtil.getCompositeType();
                String[] names = new String[]{"user", "system", "idle", "wait", "busy", "id", "online", "timestamp"};
                Object[] values = new Object[]{usage.getUser(), usage.getSystem(), usage.getIdle(), usage.getWait(), usage.getBusy(), usage.getId(), usage.getOnline(), usage.getTimestamp()};
                try {
                    result = new CompositeDataSupport(type, names, values);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return result;
    }

    private ProcessorUsageUtil() {
    }
}

