/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.lang.management.AvailableProcessorsNotificationInfo;
import com.ibm.lang.management.ProcessingCapacityNotificationInfo;
import com.ibm.lang.management.TotalPhysicalMemoryNotificationInfo;
import com.ibm.lang.management.internal.AvailableProcessorsNotificationInfoUtil;
import com.ibm.lang.management.internal.ExtendedOperatingSystemMXBeanImpl;
import com.ibm.lang.management.internal.OperatingSystemNotificationThreadShutdown;
import com.ibm.lang.management.internal.ProcessingCapacityNotificationInfoUtil;
import com.ibm.lang.management.internal.TotalPhysicalMemoryNotificationInfoUtil;
import javax.management.Notification;

final class OperatingSystemNotificationThread
extends Thread {
    private final ExtendedOperatingSystemMXBeanImpl osBean;

    OperatingSystemNotificationThread(ExtendedOperatingSystemMXBeanImpl osBean) {
        this.osBean = osBean;
    }

    @Override
    public void run() {
        OperatingSystemNotificationThreadShutdown myShutdownNotifier = new OperatingSystemNotificationThreadShutdown(this);
        try {
            Runtime.getRuntime().addShutdownHook(myShutdownNotifier);
        }
        catch (IllegalStateException e) {
            return;
        }
        this.processNotificationLoop();
    }

    private native void processNotificationLoop();

    private void dispatchNotificationHelper(int type, long data, long sequenceNumber) {
        if (type == 1) {
            AvailableProcessorsNotificationInfo info = new AvailableProcessorsNotificationInfo((int)data);
            Notification n = new Notification("com.ibm.management.available.processors.change", "java.lang:type=OperatingSystem", sequenceNumber);
            n.setUserData(AvailableProcessorsNotificationInfoUtil.toCompositeData(info));
            this.osBean.sendNotification(n);
        } else if (type == 2) {
            ProcessingCapacityNotificationInfo info = new ProcessingCapacityNotificationInfo((int)data);
            Notification n = new Notification("com.ibm.management.processing.capacity.change", "java.lang:type=OperatingSystem", sequenceNumber);
            n.setUserData(ProcessingCapacityNotificationInfoUtil.toCompositeData(info));
            this.osBean.sendNotification(n);
        } else if (type == 3) {
            TotalPhysicalMemoryNotificationInfo info = new TotalPhysicalMemoryNotificationInfo(data);
            Notification n = new Notification("com.ibm.management.total.physical.memory.change", "java.lang:type=OperatingSystem", sequenceNumber);
            n.setUserData(TotalPhysicalMemoryNotificationInfoUtil.toCompositeData(info));
            this.osBean.sendNotification(n);
        }
    }
}

