/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.lang.management.MemoryUsage;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class MemoryUsageUtil {
    private static CompositeType compositeType;

    public static CompositeType getCompositeType() {
        block3: {
            if (null == compositeType) {
                try {
                    String[] names = new String[]{"total", "free", "swapTotal", "swapFree", "cached", "buffered", "timestamp"};
                    String[] descs = new String[]{"total", "free", "swapTotal", "swapFree", "cached", "buffered", "timestamp"};
                    OpenType[] types = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
                    compositeType = new CompositeType(MemoryUsage.class.getName(), MemoryUsage.class.getName(), names, descs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static void registerConverters() {
        ManagementUtils.addCompositeConverter(MemoryUsage.class, MemoryUsageUtil::toCompositeData);
    }

    public static CompositeData toCompositeData(MemoryUsage usage) {
        CompositeDataSupport result;
        block3: {
            result = null;
            if (null != usage) {
                CompositeType type = MemoryUsageUtil.getCompositeType();
                String[] names = new String[]{"total", "free", "swapTotal", "swapFree", "cached", "buffered", "timestamp"};
                Object[] values = new Object[]{usage.getTotal(), usage.getFree(), usage.getSwapTotal(), usage.getSwapFree(), usage.getCached(), usage.getBuffered(), usage.getTimestamp()};
                try {
                    result = new CompositeDataSupport(type, names, values);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return result;
    }

    private MemoryUsageUtil() {
    }
}

