/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jit.crypto;

import com.ibm.jit.crypto.JITAESCryptInHardware;
import com.ibm.jit.crypto.JITFullHardwareDigest;
import com.ibm.oti.vm.VM;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class JITFullHardwareCrypt {
    private final String _modeName;
    private final String _algorithmName;
    private final int _keyLengthBits;
    private final byte _mode;
    private byte[] _IV_And_key;
    byte[] _AESGCMParameterBlock;
    private boolean _modeIsEncrypt;
    private byte _cfbSize;
    private final int _ivLength;
    private final int _keyOffset;
    private final int _keyLengthBytes;
    private final int _blockSize;
    static boolean hardwareGCMSupport;
    private static final Map<String, JITFullHardwareCrypt[]> supportedCiphers;
    private static final JITFullHardwareCrypt[] supportedECBCipher;
    private static final JITFullHardwareCrypt[] supportedCBCCipher;
    private static final JITFullHardwareCrypt[] supportedCFBCipher;
    private static final JITFullHardwareCrypt[] supportedCTRCipher;
    private static final JITFullHardwareCrypt[] supportedOFBCipher;
    private static final JITFullHardwareCrypt[] supportedGCMCipher;
    private static hw hardware;
    private static byte[] supportedECB;
    private static byte[] supportedCBC;
    private static byte[] supportedOFB;
    private static byte[] supportedCFB;
    private static byte[] supportedCTR;
    private static byte[] supportedGCM;

    public void cipher(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset) {
        assert (hardware == hw.zseries);
        this.z_cipher(in, inputLength, inputOffset, out, outputOffset, null, 0);
    }

    public void cipher(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] ctr, int ctrOffset) {
        assert (hardware == hw.zseries);
        this.z_cipher(in, inputLength, inputOffset, out, outputOffset, ctr, ctrOffset);
    }

    public void cipherFinal(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] aad, int aadLength, int aadOffset, long TAADL, long TPCL) {
        assert (hardware == hw.zseries);
        AESGCMParams.flag = (byte)3;
        AESGCMParams.putLongtoByteArray(TAADL, this._AESGCMParameterBlock, 48);
        AESGCMParams.putLongtoByteArray(TPCL, this._AESGCMParameterBlock, 56);
        int modeCode = this._mode;
        if (!this._modeIsEncrypt) {
            modeCode = 128 + this._mode;
        }
        String forceKMA = System.getenv("FORCEKMA");
        int augmentedMode = AESGCMParams.flag;
        modeCode += (augmentedMode <<= 8);
        if (hardwareGCMSupport || forceKMA != null) {
            JITFullHardwareCrypt.z_kmgcm(in, inputLength, inputOffset, out, outputOffset, aad, aadLength, aadOffset, this._AESGCMParameterBlock, modeCode);
        } else {
            JITFullHardwareCrypt.z_gcmWithKMCTR(in, inputLength, inputOffset, out, outputOffset, aad, aadLength, aadOffset, this._AESGCMParameterBlock, modeCode);
        }
    }

    public void init(boolean isEncrypt, byte[] key) {
        this._modeIsEncrypt = isEncrypt;
        if (this._IV_And_key == null || this._keyLengthBytes + this._ivLength > this._IV_And_key.length) {
            this._IV_And_key = new byte[this._keyLengthBytes + this._ivLength];
        }
        System.arraycopy((Object)key, 0, (Object)this._IV_And_key, this._ivLength, this._keyLengthBytes);
    }

    public void init(boolean isEncrypt, byte[] key, byte[] IV) {
        assert (hardware == hw.zseries);
        assert (key.length == this._keyLengthBytes);
        this._modeIsEncrypt = isEncrypt;
        if (this._modeName == "GCM") {
            this._AESGCMParameterBlock = new byte[80 + key.length];
            this.updateJ0(key, IV);
            System.arraycopy((Object)this._AESGCMParameterBlock, 64 + this._blockSize - 4, (Object)this._AESGCMParameterBlock, 12, 4);
            System.arraycopy((Object)key, 0, (Object)this._AESGCMParameterBlock, 80, key.length);
        } else {
            assert (IV.length == this._ivLength);
            if (this._IV_And_key == null || this._keyLengthBytes + this._ivLength > this._IV_And_key.length) {
                this._IV_And_key = new byte[this._keyLengthBytes + this._ivLength];
            }
            System.arraycopy((Object)IV, 0, (Object)this._IV_And_key, 0, this._ivLength);
            System.arraycopy((Object)key, 0, (Object)this._IV_And_key, this._ivLength, this._keyLengthBytes);
        }
    }

    public void init(boolean isEncrypt, byte[] key, byte[] IV, int size) {
        assert (hardware == hw.zseries);
        assert (IV.length == this._ivLength);
        assert (key.length == this._keyLengthBytes);
        this._modeIsEncrypt = isEncrypt;
        if (this._IV_And_key == null || this._keyLengthBytes + this._ivLength > this._IV_And_key.length) {
            this._IV_And_key = new byte[this._keyLengthBytes + this._ivLength];
        }
        if (IV == null) {
            Arrays.fill(this._IV_And_key, 0, this._ivLength, (byte)0);
        } else {
            System.arraycopy((Object)IV, 0, (Object)this._IV_And_key, 0, this._ivLength);
        }
        System.arraycopy((Object)key, 0, (Object)this._IV_And_key, this._ivLength, this._keyLengthBytes);
        this._cfbSize = (byte)size;
    }

    public static boolean isSupportedByHardware(String algorithm, String mode) {
        if (hardware != hw.zseries || JITAESCryptInHardware.disableHardwareAcceleration) {
            return false;
        }
        int unitCount = -1;
        if (mode.length() > 3 && mode.startsWith("CFB")) {
            unitCount = Integer.parseInt(mode.substring(3));
            if (unitCount % 8 != 0) {
                return false;
            }
            mode = "CFB";
        }
        JITFullHardwareCrypt element = null;
        JITFullHardwareCrypt[] ciphers = supportedCiphers.get(mode);
        if (ciphers == null) {
            return false;
        }
        for (int i = ciphers.length - 1; i >= 0; --i) {
            if (!ciphers[i]._algorithmName.equals(algorithm)) continue;
            element = ciphers[i];
            break;
        }
        if (element == null) {
            return false;
        }
        byte[] result = null;
        switch (mode) {
            case "GCM": {
                if ((supportedGCM[element._mode / 8] & (byte)(1 << 7 - element._mode % 8)) != 0) {
                    return true;
                }
                if ((supportedCTR[element._mode / 8] & (byte)(1 << 7 - element._mode % 8)) != 0) {
                    hardwareGCMSupport = false;
                    return true;
                }
                return false;
            }
            case "ECB": {
                result = supportedECB;
                break;
            }
            case "CBC": {
                result = supportedCBC;
                break;
            }
            case "OFB": {
                result = supportedOFB;
                break;
            }
            case "CFB": {
                if (unitCount > 0 && unitCount / 8 > element._blockSize) {
                    return false;
                }
                result = supportedCFB;
                break;
            }
            case "CTR": {
                result = supportedCTR;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return (result[element._mode / 8] & (byte)(1 << 7 - element._mode % 8)) != 0;
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    public byte[] getIV() {
        if (this._ivLength == 0) {
            return null;
        }
        byte[] result = new byte[this._ivLength];
        System.arraycopy((Object)this._IV_And_key, 0, (Object)result, 0, this._ivLength);
        return result;
    }

    public byte[] getTag() {
        if (!this._modeName.equals("GCM") || this._AESGCMParameterBlock == null) {
            return null;
        }
        byte[] result = new byte[16];
        System.arraycopy((Object)this._AESGCMParameterBlock, 16, (Object)result, 0, 16);
        return result;
    }

    public int getIVSize() {
        return this._ivLength;
    }

    public int getKeySize() {
        return this._keyLengthBits;
    }

    @CallerSensitive
    public static JITFullHardwareCrypt getCrypto(String algorithm, String mode, int keyLength) {
        ClassLoader callerClassLoader = Reflection.getCallerClass().getClassLoader();
        if (callerClassLoader != null && callerClassLoader != VM.getVMLangAccess().getExtClassLoader()) {
            throw new SecurityException(JITFullHardwareCrypt.class.getName());
        }
        JITFullHardwareCrypt[] ciphers = supportedCiphers.get(mode);
        if (ciphers == null) {
            return null;
        }
        for (int i = 0; i < ciphers.length; ++i) {
            JITFullHardwareCrypt element = ciphers[i];
            if (element._keyLengthBits != keyLength || !element._algorithmName.equals(algorithm)) continue;
            return JITFullHardwareCrypt.copy(element);
        }
        return null;
    }

    private JITFullHardwareCrypt() {
        assert (false);
        this._modeName = "";
        this._algorithmName = "";
        this._mode = 0;
        this._keyLengthBytes = 0;
        this._ivLength = 0;
        this._keyOffset = 0;
        this._blockSize = 0;
        this._keyLengthBits = 0;
        this._IV_And_key = null;
    }

    private JITFullHardwareCrypt(String algorithm, String modeName, int keyLength, int blockSize, byte mode, int keyOffset) {
        this._algorithmName = algorithm;
        this._modeName = modeName;
        this._keyLengthBits = keyLength;
        this._blockSize = blockSize;
        this._mode = mode;
        this._keyOffset = keyOffset;
        this._ivLength = keyOffset;
        this._keyLengthBytes = keyLength / 8;
    }

    private static JITFullHardwareCrypt copy(JITFullHardwareCrypt in) {
        if (hardware == hw.zseries) {
            return new JITFullHardwareCrypt(in._algorithmName, in._modeName, in._keyLengthBits, in._blockSize, in._mode, in._keyOffset);
        }
        return null;
    }

    private void z_cipher(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] ctr, int ctrOffset) {
        int modeCode = this._mode;
        if (!this._modeIsEncrypt) {
            modeCode = 128 + this._mode;
        }
        if (this._IV_And_key == null) {
            throw new NullPointerException();
        }
        switch (this._modeName) {
            case "GCM": {
                assert (false);
            }
            case "ECB": {
                JITFullHardwareCrypt.z_km(in, inputLength, inputOffset, out, outputOffset, this._IV_And_key, modeCode);
                break;
            }
            case "CBC": {
                JITFullHardwareCrypt.z_kmc(in, inputLength, inputOffset, out, outputOffset, this._IV_And_key, modeCode);
                break;
            }
            case "OFB": {
                JITFullHardwareCrypt.z_kmo(in, inputLength, inputOffset, out, outputOffset, this._IV_And_key, modeCode);
                break;
            }
            case "CFB": {
                modeCode = (int)((long)modeCode | (long)this._cfbSize << 24);
                JITFullHardwareCrypt.z_kmf(in, inputLength, inputOffset, out, outputOffset, this._IV_And_key, modeCode);
                break;
            }
            case "CTR": {
                JITFullHardwareCrypt.z_kmctr(in, inputLength, inputOffset, out, outputOffset, ctr, ctrOffset, this._IV_And_key, modeCode);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static void z_km(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_km_native(in, inputLength, inputOffset, out, outputOffset, key_IV, mode);
    }

    private static void z_kmc(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_kmc_native(in, inputLength, inputOffset, out, outputOffset, key_IV, mode);
    }

    private static void z_kmo(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_kmo_native(in, inputLength, inputOffset, out, outputOffset, key_IV, mode);
    }

    private static void z_kmf(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_kmf_native(in, inputLength, inputOffset, out, outputOffset, key_IV, mode);
    }

    private static void z_kmctr(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] ctr, int ctrOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_kmctr_native(in, inputLength, inputOffset, out, outputOffset, ctr, ctrOffset, key_IV, mode);
    }

    private static void z_kmgcm(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] aad, int aadLength, int aadOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_kmgcm_native(in, inputLength, inputOffset, out, outputOffset, aad, aadLength, aadOffset, key_IV, mode);
    }

    private static void z_gcmWithKMCTR(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] aad, int aadLength, int aadOffset, byte[] params, int mode) {
        int i;
        int blockSize = 16;
        boolean finalUpdate = (mode & 0x100) != 0;
        boolean LastAAD = (mode & 0x200) != 0;
        boolean _modeIsEncrypt = (mode & 0x80) == 0;
        int fc = mode & 0x7F;
        int _keyLengthBytes = fc == 20 ? 32 : (fc == 19 ? 24 : 16);
        byte[] hashSubkey = new byte[16];
        byte[] zeros = new byte[16];
        byte[] hashSubkeyParamBlock = new byte[_keyLengthBytes];
        System.arraycopy((Object)params, 80, (Object)hashSubkeyParamBlock, 0, _keyLengthBytes);
        JITFullHardwareCrypt.z_km(zeros, 16, 0, hashSubkey, 0, hashSubkeyParamBlock, fc);
        byte[] ghashParamBlock = new byte[32];
        System.arraycopy((Object)hashSubkey, 0, (Object)ghashParamBlock, 16, 16);
        System.arraycopy((Object)params, 16, (Object)ghashParamBlock, 0, 16);
        if (aadLength >= 16) {
            int len = aadLength - aadLength % 16;
            JITFullHardwareDigest.z_kimd(aad, len, aadOffset, ghashParamBlock, 65);
            aadLength -= len;
            aadOffset += len;
        }
        if (aadLength > 0) {
            assert (LastAAD);
            byte[] lastAAD = new byte[16];
            System.arraycopy((Object)aad, aadOffset, (Object)lastAAD, 0, aadLength);
            JITFullHardwareDigest.z_kimd(lastAAD, 16, 0, ghashParamBlock, 65);
        }
        int startIndex = 12;
        int counter = params[startIndex++] & 0xFF;
        counter = (counter << 8) + (params[startIndex++] & 0xFF);
        counter = (counter << 8) + (params[startIndex++] & 0xFF);
        counter = (counter << 8) + (params[startIndex++] & 0xFF);
        ++counter;
        int numCompleteBlk = inputLength / 16;
        byte[] gctrParamblock = hashSubkeyParamBlock;
        if (numCompleteBlk > 0) {
            byte[] counters = new byte[numCompleteBlk * 16];
            for (i = 0; i < numCompleteBlk; ++i) {
                System.arraycopy((Object)params, 64, (Object)counters, i * 16, 12);
                AESGCMParams.putInttoByteArray(counter, counters, (i + 1) * 16 - 4);
                ++counter;
            }
            System.arraycopy((Object)counters, counters.length - 4, (Object)params, 12, 4);
            if (!_modeIsEncrypt) {
                JITFullHardwareDigest.z_kimd(in, numCompleteBlk * 16, inputOffset, ghashParamBlock, 65);
            }
            JITFullHardwareCrypt.z_kmctr(in, numCompleteBlk * 16, inputOffset, out, outputOffset, counters, 0, gctrParamblock, fc);
            if (_modeIsEncrypt) {
                JITFullHardwareDigest.z_kimd(out, numCompleteBlk * 16, outputOffset, ghashParamBlock, 65);
            }
            inputOffset += numCompleteBlk * 16;
            inputLength -= numCompleteBlk * 16;
            outputOffset += numCompleteBlk * 16;
        }
        byte[] lastCounterCiphered = new byte[16];
        if (inputLength > 0) {
            assert (finalUpdate);
            byte[] lastCounter = new byte[16];
            System.arraycopy((Object)params, 64, (Object)lastCounter, 0, 12);
            lastCounter[12] = (byte)(counter >> 24);
            lastCounter[13] = (byte)(counter >> 16);
            lastCounter[14] = (byte)(counter >> 8);
            lastCounter[15] = (byte)counter;
            JITFullHardwareCrypt.z_km(lastCounter, 16, 0, lastCounterCiphered, 0, gctrParamblock, fc);
            if (_modeIsEncrypt) {
                for (int i2 = 0; i2 < inputLength; ++i2) {
                    out[outputOffset + i2] = (byte)(in[inputOffset + i2] ^ lastCounterCiphered[i2]);
                }
            }
        }
        if (finalUpdate) {
            int len = inputLength > 0 ? 32 : 16;
            int offset = _modeIsEncrypt ? outputOffset : inputOffset;
            byte[] input = _modeIsEncrypt ? out : in;
            byte[] lastCiphered = new byte[len];
            if (inputLength > 0) {
                System.arraycopy((Object)input, offset, (Object)lastCiphered, 0, inputLength);
            }
            System.arraycopy((Object)params, 48, (Object)lastCiphered, len - 16, 16);
            JITFullHardwareDigest.z_kimd(lastCiphered, len, 0, ghashParamBlock, 65);
            JITFullHardwareCrypt.z_kmctr(ghashParamBlock, 16, 0, params, 16, params, 64, gctrParamblock, fc);
        } else {
            System.arraycopy((Object)ghashParamBlock, 0, (Object)params, 16, 16);
        }
        if (inputLength > 0 && !_modeIsEncrypt) {
            for (i = 0; i < inputLength; ++i) {
                out[outputOffset + i] = (byte)(in[inputOffset + i] ^ lastCounterCiphered[i]);
            }
        }
    }

    private static native void z_km_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void z_kmc_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void z_kmo_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void z_kmf_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void z_kmctr_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    private static native void z_kmgcm_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6, int var7, byte[] var8, int var9);

    private static native void z_km_supported(byte[] var0);

    private static native void z_kmc_supported(byte[] var0);

    private static native void z_kmo_supported(byte[] var0);

    private static native void z_kmf_supported(byte[] var0);

    private static native void z_kmctr_supported(byte[] var0);

    private static native void z_kmgcm_supported(byte[] var0);

    private void updateJ0(byte[] key, byte[] IV) {
        int fc;
        byte[] J = new byte[this._blockSize];
        int blockSize = this._blockSize;
        int n = key.length == 16 ? 18 : (fc = key.length == 24 ? 19 : 20);
        if (IV.length == 12) {
            J[this._blockSize - 1] = 1;
            System.arraycopy((Object)IV, 0, (Object)J, 0, IV.length);
        } else {
            int ivLength = IV.length;
            int offset = 0;
            byte[] hashSubkey = new byte[blockSize];
            byte[] zeros = new byte[blockSize];
            byte[] hashSubkeyParamBlock = new byte[this._keyLengthBytes];
            System.arraycopy((Object)key, 0, (Object)hashSubkeyParamBlock, 0, this._keyLengthBytes);
            JITFullHardwareCrypt.z_km(zeros, blockSize, 0, hashSubkey, 0, hashSubkeyParamBlock, fc);
            byte[] ghashParamBlock = new byte[2 * blockSize];
            System.arraycopy((Object)hashSubkey, 0, (Object)ghashParamBlock, blockSize, blockSize);
            if (ivLength >= blockSize) {
                int len = ivLength - ivLength % blockSize;
                JITFullHardwareDigest.z_kimd(IV, len, offset, ghashParamBlock, 65);
                ivLength -= len;
                offset += len;
            }
            byte[] lastIV = null;
            if (ivLength > 0) {
                lastIV = new byte[2 * blockSize];
                System.arraycopy((Object)IV, offset, (Object)lastIV, 0, ivLength);
            } else {
                lastIV = new byte[blockSize];
            }
            AESGCMParams.putLongtoByteArray(IV.length * 8, lastIV, lastIV.length - 8);
            JITFullHardwareDigest.z_kimd(lastIV, lastIV.length, 0, ghashParamBlock, 65);
            System.arraycopy((Object)ghashParamBlock, 0, (Object)J, 0, blockSize);
        }
        System.arraycopy((Object)J, 0, (Object)this._AESGCMParameterBlock, 64, J.length);
    }

    static {
        supportedECBCipher = new JITFullHardwareCrypt[]{new JITFullHardwareCrypt("DES", "ECB", 64, 8, 1, 0), new JITFullHardwareCrypt("DESede", "ECB", 128, 8, 2, 0), new JITFullHardwareCrypt("DESede", "ECB", 192, 8, 3, 0), new JITFullHardwareCrypt("AES", "ECB", 128, 16, 18, 0), new JITFullHardwareCrypt("AES", "ECB", 192, 16, 19, 0), new JITFullHardwareCrypt("AES", "ECB", 256, 16, 20, 0)};
        supportedCBCCipher = new JITFullHardwareCrypt[]{new JITFullHardwareCrypt("DES", "CBC", 64, 8, 1, 8), new JITFullHardwareCrypt("DESede", "CBC", 128, 8, 2, 8), new JITFullHardwareCrypt("DESede", "CBC", 192, 8, 3, 8), new JITFullHardwareCrypt("AES", "CBC", 128, 16, 18, 16), new JITFullHardwareCrypt("AES", "CBC", 192, 16, 19, 16), new JITFullHardwareCrypt("AES", "CBC", 256, 16, 20, 16)};
        supportedCFBCipher = new JITFullHardwareCrypt[]{new JITFullHardwareCrypt("DES", "CFB", 64, 8, 1, 8), new JITFullHardwareCrypt("DESede", "CFB", 128, 8, 2, 8), new JITFullHardwareCrypt("DESede", "CFB", 192, 8, 3, 8), new JITFullHardwareCrypt("AES", "CFB", 128, 16, 18, 16), new JITFullHardwareCrypt("AES", "CFB", 192, 16, 19, 16), new JITFullHardwareCrypt("AES", "CFB", 256, 16, 20, 16)};
        supportedCTRCipher = new JITFullHardwareCrypt[]{new JITFullHardwareCrypt("DES", "CTR", 64, 8, 1, 0), new JITFullHardwareCrypt("DESede", "CTR", 128, 8, 2, 0), new JITFullHardwareCrypt("DESede", "CTR", 192, 8, 3, 0), new JITFullHardwareCrypt("AES", "CTR", 128, 16, 18, 0), new JITFullHardwareCrypt("AES", "CTR", 192, 16, 19, 0), new JITFullHardwareCrypt("AES", "CTR", 256, 16, 20, 0)};
        supportedOFBCipher = new JITFullHardwareCrypt[]{new JITFullHardwareCrypt("DES", "OFB", 64, 8, 1, 8), new JITFullHardwareCrypt("DESede", "OFB", 128, 8, 2, 8), new JITFullHardwareCrypt("DESede", "OFB", 192, 8, 3, 8), new JITFullHardwareCrypt("AES", "OFB", 128, 16, 18, 16), new JITFullHardwareCrypt("AES", "OFB", 192, 16, 19, 16), new JITFullHardwareCrypt("AES", "OFB", 256, 16, 20, 16)};
        supportedGCMCipher = new JITFullHardwareCrypt[]{new JITFullHardwareCrypt("AES", "GCM", 128, 16, 18, 0), new JITFullHardwareCrypt("AES", "GCM", 192, 16, 19, 0), new JITFullHardwareCrypt("AES", "GCM", 256, 16, 20, 0)};
        supportedCiphers = new HashMap<String, JITFullHardwareCrypt[]>();
        supportedCiphers.put("GCM", supportedGCMCipher);
        supportedCiphers.put("ECB", supportedECBCipher);
        supportedCiphers.put("CBC", supportedCBCCipher);
        supportedCiphers.put("CFB", supportedCFBCipher);
        supportedCiphers.put("CTR", supportedCTRCipher);
        supportedCiphers.put("OFB", supportedOFBCipher);
        if (JITAESCryptInHardware.osArch.equals("s390x") || JITAESCryptInHardware.osArch.equals("s390")) {
            hardware = hw.zseries;
            supportedECB = new byte[16];
            supportedCBC = new byte[16];
            supportedOFB = new byte[16];
            supportedCFB = new byte[16];
            supportedCTR = new byte[16];
            supportedGCM = new byte[16];
            String disableKMA = System.getenv("DISABLEKMA");
            hardwareGCMSupport = disableKMA == null;
            JITFullHardwareCrypt.z_km_supported(supportedECB);
            JITFullHardwareCrypt.z_kmc_supported(supportedCBC);
            JITFullHardwareCrypt.z_kmo_supported(supportedOFB);
            JITFullHardwareCrypt.z_kmf_supported(supportedCFB);
            JITFullHardwareCrypt.z_kmctr_supported(supportedCTR);
            JITFullHardwareCrypt.z_kmgcm_supported(supportedGCM);
        } else {
            hardware = JITAESCryptInHardware.osArch.equals("x86") || JITAESCryptInHardware.osArch.equals("amd64") ? hw.xseries : hw.pseries;
        }
    }

    private static class AESGCMParams {
        static byte flag;
        static final int counterValueOffset = 12;
        static final int tagOffset = 16;
        static final int tagSize = 16;
        static final int hashSubkeyOffset = 32;
        static final int TAADLOffset = 48;
        static final int TPCLOffset = 56;
        static final int J0Offset = 64;
        static final int keyOffset = 80;
        static final int parameterBlockSize = 80;

        private AESGCMParams() {
        }

        public static void putInttoByteArray(int number, byte[] bArray, int startIndex) {
            bArray[startIndex] = (byte)(number >>> 24);
            bArray[startIndex + 1] = (byte)(number >>> 16);
            bArray[startIndex + 2] = (byte)(number >>> 8);
            bArray[startIndex + 3] = (byte)number;
        }

        public static void putLongtoByteArray(long number, byte[] bArray, int startIndex) {
            bArray[startIndex] = (byte)(number >>> 56);
            bArray[startIndex + 1] = (byte)(number >>> 48);
            bArray[startIndex + 2] = (byte)(number >>> 40);
            bArray[startIndex + 3] = (byte)(number >>> 32);
            bArray[startIndex + 4] = (byte)(number >>> 24);
            bArray[startIndex + 5] = (byte)(number >>> 16);
            bArray[startIndex + 6] = (byte)(number >>> 8);
            bArray[startIndex + 7] = (byte)number;
        }

        public static void dump(byte[] params) {
            for (int i = 0; i < params.length; ++i) {
                System.out.printf("%x\t", params[i]);
                if (i % 8 != 7) continue;
                System.out.println();
            }
        }
    }

    private static enum hw {
        zseries,
        pseries,
        xseries;

    }
}

