/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import java.lang.ref.SoftReference;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class StackTraceElementUtil {
    private static CompositeType compositeType;
    private static SoftReference<String[]> methodNameCache;
    private static SoftReference<String[]> returnTypeCache;

    public static StackTraceElement from(CompositeData stackTraceCD) {
        return StackTraceElementUtil.fromArray(new CompositeData[]{stackTraceCD})[0];
    }

    private static String[] getMethodNames() {
        String[] methodNames = null;
        if (null != methodNameCache) {
            methodNames = methodNameCache.get();
        }
        if (null == methodNames) {
            methodNames = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
            methodNameCache = new SoftReference<String[]>(methodNames);
        }
        return methodNames;
    }

    private static String[] getMethodReturnTypeNames() {
        String[] returnTypes = null;
        if (null != returnTypeCache) {
            returnTypes = returnTypeCache.get();
        }
        if (null == returnTypes) {
            returnTypes = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Boolean"};
        }
        returnTypeCache = new SoftReference<String[]>(returnTypes);
        return returnTypes;
    }

    private static Object[] getValues(StackTraceElement element) {
        Object[] values = new Object[]{element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber(), element.isNativeMethod()};
        return values;
    }

    public static StackTraceElement[] fromArray(CompositeData[] stackTraceDataVal) {
        if (stackTraceDataVal == null) {
            return null;
        }
        String[] attributeNames = StackTraceElementUtil.getMethodNames();
        String[] attributeTypes = StackTraceElementUtil.getMethodReturnTypeNames();
        int length = stackTraceDataVal.length;
        StackTraceElement[] result = new StackTraceElement[length];
        for (int i = 0; i < length; ++i) {
            StackTraceElement element;
            CompositeData data = stackTraceDataVal[i];
            if (data == null) {
                result[i] = null;
                continue;
            }
            ManagementUtils.verifyFieldNumber(data, attributeNames.length);
            ManagementUtils.verifyFieldNames(data, attributeNames);
            ManagementUtils.verifyFieldTypes(data, attributeNames, attributeTypes);
            Object[] attributeVals = data.getAll(attributeNames);
            String classNameVal = (String)attributeVals[0];
            String methodNameVal = (String)attributeVals[1];
            String fileNameVal = (String)attributeVals[2];
            int lineNumberVal = (Integer)attributeVals[3];
            boolean nativeMethodVal = (Boolean)attributeVals[4];
            result[i] = element = new StackTraceElement(classNameVal, methodNameVal, fileNameVal, lineNumberVal);
        }
        return result;
    }

    public static CompositeType getCompositeType() {
        block3: {
            if (compositeType == null) {
                String[] names = StackTraceElementUtil.getMethodNames();
                String[] descs = StackTraceElementUtil.getMethodNames();
                OpenType[] types = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN};
                try {
                    compositeType = new CompositeType(StackTraceElement.class.getName(), StackTraceElement.class.getName(), names, descs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static CompositeData toCompositeData(StackTraceElement element) {
        CompositeDataSupport result;
        block3: {
            result = null;
            if (element != null) {
                CompositeType type = StackTraceElementUtil.getCompositeType();
                String[] names = StackTraceElementUtil.getMethodNames();
                Object[] values = StackTraceElementUtil.getValues(element);
                try {
                    result = new CompositeDataSupport(type, names, values);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return result;
    }

    private StackTraceElementUtil() {
    }

    static {
        methodNameCache = null;
        returnTypeCache = null;
    }
}

