/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.lang.management.RuntimeMXBean;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;

public class RuntimeMXBeanImpl
implements RuntimeMXBean {
    private static final RuntimeMXBean instance = new RuntimeMXBeanImpl();
    private final ObjectName objectName = ManagementUtils.createObjectName("java.lang:type=Runtime");

    protected RuntimeMXBeanImpl() {
    }

    public static RuntimeMXBean getInstance() {
        return instance;
    }

    @Override
    public final String getBootClassPath() {
        if (!this.isBootClassPathSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05F5"));
        }
        RuntimeMXBeanImpl.checkMonitorPermission();
        return VM.getVMLangAccess().internalGetProperties().getProperty("sun.boot.class.path");
    }

    @Override
    public final String getClassPath() {
        return System.getProperty("java.class.path");
    }

    @Override
    public final String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    @Override
    public final String getManagementSpecVersion() {
        return "1.0";
    }

    private native String getNameImpl();

    @Override
    public final String getName() {
        return this.getNameImpl();
    }

    @Override
    public final String getSpecName() {
        return System.getProperty("java.vm.specification.name");
    }

    @Override
    public final String getSpecVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    @Override
    public final String getSpecVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    private native long getStartTimeImpl();

    @Override
    public final long getStartTime() {
        return this.getStartTimeImpl();
    }

    private native long getUptimeImpl();

    @Override
    public final long getUptime() {
        return this.getUptimeImpl();
    }

    @Override
    public final String getVmName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public final String getVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public final String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    private native boolean isBootClassPathSupportedImpl();

    @Override
    public final boolean isBootClassPathSupported() {
        return this.isBootClassPathSupportedImpl();
    }

    @Override
    public final List<String> getInputArguments() {
        RuntimeMXBeanImpl.checkMonitorPermission();
        return ManagementUtils.convertStringArrayToList(VM.getVMArgs());
    }

    @Override
    public final Map<String, String> getSystemProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties props = System.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = props.getProperty(propName);
            result.put(propName, propValue);
        }
        return result;
    }

    @Override
    public final ObjectName getObjectName() {
        return this.objectName;
    }

    public static void checkMonitorPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
    }
}

