/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import java.lang.management.MonitorInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class MonitorInfoUtil {
    private static CompositeType compositeType;

    public static MonitorInfo[] fromArray(CompositeData[] monitorInfos) {
        MonitorInfo[] result = null;
        if (monitorInfos != null) {
            String[] attributeNames = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            String[] attributeTypes = new String[]{"java.lang.String", "java.lang.Integer", CompositeData.class.getName(), "java.lang.Integer"};
            int length = monitorInfos.length;
            result = new MonitorInfo[length];
            for (int i = 0; i < length; ++i) {
                CompositeData data = monitorInfos[i];
                ManagementUtils.verifyFieldNumber(data, 4);
                ManagementUtils.verifyFieldNames(data, attributeNames);
                ManagementUtils.verifyFieldTypes(data, attributeNames, attributeTypes);
                result[i] = MonitorInfo.from(data);
            }
        }
        return result;
    }

    public static CompositeType getCompositeType() {
        block3: {
            if (compositeType == null) {
                try {
                    String[] names = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    String[] descs = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    OpenType[] types = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, StackTraceElementUtil.getCompositeType(), SimpleType.INTEGER};
                    compositeType = new CompositeType(MonitorInfo.class.getName(), MonitorInfo.class.getName(), names, descs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static CompositeData toCompositeData(MonitorInfo info) {
        CompositeDataSupport result;
        block3: {
            result = null;
            if (info != null) {
                CompositeType type = MonitorInfoUtil.getCompositeType();
                String[] names = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                Object[] values = new Object[]{info.getClassName(), info.getIdentityHashCode(), StackTraceElementUtil.toCompositeData(info.getLockedStackFrame()), info.getLockedStackDepth()};
                try {
                    result = new CompositeDataSupport(type, names, values);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return result;
    }

    private MonitorInfoUtil() {
    }
}

