/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.MemoryMXBeanImpl;
import com.ibm.oti.util.Msg;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import javax.management.ObjectName;

public class MemoryPoolMXBeanImpl
implements MemoryPoolMXBean {
    private static final Constructor<MemoryUsage> memUsageConstructor;
    private final String name;
    private final int id;
    private final MemoryType type;
    private final MemoryMXBeanImpl memBean;
    private final ObjectName objectName;

    protected MemoryPoolMXBeanImpl(String name, MemoryType type, int id, MemoryMXBeanImpl memBean) {
        this.objectName = ManagementUtils.createObjectName("java.lang:type=MemoryPool", name);
        this.name = name;
        this.type = type;
        this.id = id;
        this.memBean = memBean;
    }

    private native MemoryUsage getCollectionUsageImpl(int var1, Class<MemoryUsage> var2, Constructor<MemoryUsage> var3);

    @Override
    public MemoryUsage getCollectionUsage() {
        if (null != memUsageConstructor) {
            return this.getCollectionUsageImpl(this.id, MemoryUsage.class, memUsageConstructor);
        }
        return null;
    }

    private native MemoryUsage getPreCollectionUsageImpl(int var1, Class<MemoryUsage> var2, Constructor<MemoryUsage> var3);

    public MemoryUsage getPreCollectionUsage() {
        return this.getPreCollectionUsageImpl(this.getID(), MemoryUsage.class, memUsageConstructor);
    }

    private native long getCollectionUsageThresholdImpl(int var1);

    @Override
    public long getCollectionUsageThreshold() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        return this.getCollectionUsageThresholdImpl(this.id);
    }

    private native long getCollectionUsageThresholdCountImpl(int var1);

    @Override
    public long getCollectionUsageThresholdCount() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        return this.getCollectionUsageThresholdCountImpl(this.id);
    }

    @Override
    public String[] getMemoryManagerNames() {
        LinkedList<String> result = new LinkedList<String>();
        block0: for (MemoryManagerMXBean bean : this.memBean.getMemoryManagerMXBeans(false)) {
            for (String managedPool : bean.getMemoryPoolNames()) {
                if (!managedPool.equals(this.name)) continue;
                result.add(bean.getName());
                continue block0;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    int getID() {
        return this.id;
    }

    private native MemoryUsage getPeakUsageImpl(int var1, Class<MemoryUsage> var2, Constructor<MemoryUsage> var3);

    @Override
    public MemoryUsage getPeakUsage() {
        return this.getPeakUsageImpl(this.id, MemoryUsage.class, memUsageConstructor);
    }

    @Override
    public MemoryType getType() {
        return this.type;
    }

    private native MemoryUsage getUsageImpl(int var1, Class<MemoryUsage> var2, Constructor<MemoryUsage> var3);

    @Override
    public MemoryUsage getUsage() {
        return this.getUsageImpl(this.id, MemoryUsage.class, memUsageConstructor);
    }

    private native long getUsageThresholdImpl(int var1);

    @Override
    public long getUsageThreshold() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        return this.getUsageThresholdImpl(this.id);
    }

    private native long getUsageThresholdCountImpl(int var1);

    @Override
    public long getUsageThresholdCount() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        return this.getUsageThresholdCountImpl(this.id);
    }

    private native boolean isCollectionUsageThresholdExceededImpl(int var1);

    @Override
    public boolean isCollectionUsageThresholdExceeded() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        return this.isCollectionUsageThresholdExceededImpl(this.id);
    }

    private native boolean isCollectionUsageThresholdSupportedImpl(int var1);

    @Override
    public boolean isCollectionUsageThresholdSupported() {
        return this.isCollectionUsageThresholdSupportedImpl(this.id);
    }

    private native boolean isUsageThresholdExceededImpl(int var1);

    @Override
    public boolean isUsageThresholdExceeded() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        return this.isUsageThresholdExceededImpl(this.id);
    }

    private native boolean isUsageThresholdSupportedImpl(int var1);

    @Override
    public boolean isUsageThresholdSupported() {
        return this.isUsageThresholdSupportedImpl(this.id);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private native void resetPeakUsageImpl(int var1);

    @Override
    public void resetPeakUsage() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.resetPeakUsageImpl(this.id);
    }

    private native void setCollectionUsageThresholdImpl(int var1, long var2);

    @Override
    public void setCollectionUsageThreshold(long threshold) {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        if (threshold < 0L) {
            throw new IllegalArgumentException(Msg.getString("K05FE"));
        }
        if (this.exceedsMaxPoolSize(threshold)) {
            throw new IllegalArgumentException(Msg.getString("K05FF"));
        }
        this.setCollectionUsageThresholdImpl(this.id, threshold);
    }

    private native void setUsageThresholdImpl(int var1, long var2);

    @Override
    public void setUsageThreshold(long threshold) {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        if (threshold < 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F0"));
        }
        if (this.exceedsMaxPoolSize(threshold)) {
            throw new IllegalArgumentException(Msg.getString("K05F1"));
        }
        this.setUsageThresholdImpl(this.id, threshold);
    }

    private boolean exceedsMaxPoolSize(long value) {
        MemoryUsage m = this.getUsage();
        return -1L != m.getMax() && 0L != m.getMax() && m.getMax() < value;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    static {
        Constructor constructor;
        try {
            constructor = MemoryUsage.class.getConstructor(Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            constructor = null;
        }
        memUsageConstructor = constructor;
    }
}

