/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.LockInfoUtil;
import com.ibm.java.lang.management.internal.MemoryNotificationInfoUtil;
import com.ibm.java.lang.management.internal.MemoryUsageUtil;
import com.ibm.java.lang.management.internal.MonitorInfoUtil;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import com.ibm.java.lang.management.internal.ThreadInfoUtil;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.PlatformManagedObject;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public final class ManagementUtils {
    private static final String NOTIFICATION_EMITTER_TYPE = "javax.management.NotificationEmitter";
    private static final boolean isUnix;
    public static final boolean VERBOSE_MODE;
    private static final Map<Class<?>, Function<Object, CompositeData>> compositeConverterMap;
    public static final String BUFFERPOOL_MXBEAN_DOMAIN_TYPE = "java.nio:type=BufferPool";

    public static void verifyFieldTypes(CompositeData cd, String[] expectedNames, String[] expectedTypes) {
        Object[] allVals = cd.getAll(expectedNames);
        if (allVals.length != expectedTypes.length) {
            throw new IllegalArgumentException(Msg.getString("K05E8"));
        }
        for (int i = 0; i < allVals.length; ++i) {
            String expectedType;
            String actualType;
            Object actualVal = allVals[i];
            if (actualVal == null || (actualType = actualVal.getClass().getName()).equals(expectedType = expectedTypes[i]) || (expectedType.equals(CompositeData.class.getName()) ? actualVal instanceof CompositeData : expectedType.equals(TabularData.class.getName()) && actualVal instanceof TabularData)) continue;
            throw new IllegalArgumentException(Msg.getString("K05E9", (Object)expectedType, actualType));
        }
    }

    public static void verifyFieldNames(CompositeData cd, String[] expected) {
        for (String expect : expected) {
            if (cd.containsKey(expect)) continue;
            throw new IllegalArgumentException(Msg.getString("K05EA", expect));
        }
    }

    public static void verifyFieldNumber(CompositeData cd, int i) {
        if (cd == null) {
            throw new NullPointerException(Msg.getString("K05EB"));
        }
        if (cd.values().size() != i) {
            throw new IllegalArgumentException(Msg.getString("K05EC"));
        }
    }

    public static List<String> convertStringArrayToList(String[] data) {
        ArrayList<String> result = new ArrayList<String>(data.length);
        for (String string : data) {
            result.add(string);
        }
        return result;
    }

    public static Object convertTabularDataToMap(TabularData data) {
        if (data == null) {
            return null;
        }
        Set<String> cdKeySet = data.getTabularType().getRowType().keySet();
        if (cdKeySet.size() != 2) {
            throw new IllegalArgumentException(Msg.getString("K05ED"));
        }
        String[] keys = cdKeySet.toArray(new String[2]);
        Collection<?> rows = data.values();
        HashMap<Object, Object> result = new HashMap<Object, Object>(rows.size());
        for (CompositeData rowCD : rows) {
            result.put(rowCD.get(keys[0]), rowCD.get(keys[1]));
        }
        return result;
    }

    private static <T> T convertFromCompositeData(CompositeData data, Class<T> realClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (data == null) {
            return null;
        }
        Method forMethod = realClass.getMethod("from", CompositeData.class);
        return realClass.cast(forMethod.invoke(null, data));
    }

    public static <T> T convertFromOpenType(Object data, Class<?> openClass, Class<T> realClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (data == null) {
            return null;
        }
        Object result = null;
        if (openClass.isArray() && realClass.isArray()) {
            Class<?> openElementClass = openClass.getComponentType();
            Class<?> realElementClass = realClass.getComponentType();
            Object[] dataArray = (Object[])data;
            int length = dataArray.length;
            result = Array.newInstance(realElementClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(result, i, ManagementUtils.convertFromOpenType(dataArray[i], openElementClass, realElementClass));
            }
        } else if (openClass.equals(CompositeData.class)) {
            result = ManagementUtils.convertFromCompositeData((CompositeData)data, realClass);
        } else if (openClass.equals(TabularData.class)) {
            if (realClass.equals(Map.class)) {
                result = ManagementUtils.convertTabularDataToMap((TabularData)data);
            }
        } else if (openClass.equals(String[].class)) {
            if (realClass.equals(List.class)) {
                result = ManagementUtils.convertStringArrayToList((String[])data);
            }
        } else if (openClass.equals(String.class) && realClass.equals(MemoryType.class)) {
            result = ManagementUtils.convertStringToMemoryType((String)data);
        }
        return (T)result;
    }

    private static MemoryType convertStringToMemoryType(String data) {
        MemoryType result;
        block2: {
            result = null;
            try {
                result = MemoryType.valueOf(data);
            }
            catch (IllegalArgumentException e) {
                if (!VERBOSE_MODE) break block2;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static <T> void addCompositeConverter(Class<T> clazz, Function<T, CompositeData> object) {
        Function<T, CompositeData> converter = object;
        compositeConverterMap.put(clazz, converter);
    }

    public static <T> T convertToOpenType(Object data, Class<T> openClass, Class<?> realClass) {
        if (data == null) {
            return null;
        }
        String[] result = null;
        if (openClass.isArray() && realClass.isArray()) {
            Class<?> openElementClass = openClass.getComponentType();
            Class<?> realElementClass = realClass.getComponentType();
            Object[] dataArray = (Object[])data;
            int length = dataArray.length;
            result = Array.newInstance(openElementClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(result, i, ManagementUtils.convertToOpenType(dataArray[i], openElementClass, realElementClass));
            }
        } else if (openClass.equals(CompositeData.class)) {
            Function<Object, CompositeData> converter = compositeConverterMap.get(realClass);
            if (converter != null) {
                result = converter.apply(data);
            }
        } else if (openClass.equals(TabularData.class)) {
            if (realClass.equals(Map.class)) {
                result = ManagementUtils.toSystemPropertiesTabularData((Map)data);
            }
        } else if (openClass.equals(String[].class)) {
            if (realClass.equals(List.class)) {
                List list = (List)data;
                result = list.toArray(new String[list.size()]);
            }
        } else if (openClass.equals(String.class) && realClass.isEnum()) {
            result = ((Enum)data).name();
        }
        return (T)result;
    }

    public static TabularData toSystemPropertiesTabularData(Map<String, String> propsMap) {
        if (propsMap == null) {
            return null;
        }
        TabularDataSupport result = null;
        try {
            String[] rtItemNames = new String[]{"key", "value"};
            String[] rtItemDescs = new String[]{"key", "value"};
            OpenType[] rtItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            CompositeType rowType = new CompositeType(propsMap.getClass().getName(), propsMap.getClass().getName(), rtItemNames, rtItemDescs, rtItemTypes);
            TabularType sysPropsType = new TabularType(propsMap.getClass().getName(), propsMap.getClass().getName(), rowType, new String[]{"key"});
            result = new TabularDataSupport(sysPropsType);
            for (Map.Entry<String, String> entry : propsMap.entrySet()) {
                String propKey = entry.getKey();
                String propVal = entry.getValue();
                result.put(new CompositeDataSupport(rowType, rtItemNames, new String[]{propKey, propVal}));
            }
        }
        catch (OpenDataException e) {
            if (VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            result = null;
        }
        return result;
    }

    public static Class<?> getClassMaybePrimitive(String name) throws ClassNotFoundException {
        SecurityManager sm;
        int i = name.lastIndexOf(46);
        if (i != -1 && (sm = System.getSecurityManager()) != null) {
            sm.checkPackageAccess(name.substring(0, i));
        }
        Class<Object> result = null;
        try {
            result = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            if (name.equals(Boolean.TYPE.getName())) {
                result = Boolean.TYPE;
            }
            if (name.equals(Character.TYPE.getName())) {
                result = Character.TYPE;
            }
            if (name.equals(Byte.TYPE.getName())) {
                result = Byte.TYPE;
            }
            if (name.equals(Short.TYPE.getName())) {
                result = Short.TYPE;
            }
            if (name.equals(Integer.TYPE.getName())) {
                result = Integer.TYPE;
            }
            if (name.equals(Long.TYPE.getName())) {
                result = Long.TYPE;
            }
            if (name.equals(Float.TYPE.getName())) {
                result = Float.TYPE;
            }
            if (name.equals(Double.TYPE.getName())) {
                result = Double.TYPE;
            }
            if (name.equals(Void.TYPE.getName())) {
                result = Void.TYPE;
            }
            if (VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw e;
        }
        return result;
    }

    public static boolean isWrapperClass(Class<?> wrapper, Class<?> primitive) {
        boolean result = true;
        if (primitive.equals(Boolean.TYPE) && !wrapper.equals(Boolean.class)) {
            result = false;
        } else if (primitive.equals(Character.TYPE) && !wrapper.equals(Character.class)) {
            result = false;
        } else if (primitive.equals(Byte.TYPE) && !wrapper.equals(Byte.class)) {
            result = false;
        } else if (primitive.equals(Short.TYPE) && !wrapper.equals(Short.class)) {
            result = false;
        } else if (primitive.equals(Integer.TYPE) && !wrapper.equals(Integer.class)) {
            result = false;
        } else if (primitive.equals(Long.TYPE) && !wrapper.equals(Long.class)) {
            result = false;
        } else if (primitive.equals(Float.TYPE) && !wrapper.equals(Float.class)) {
            result = false;
        } else if (primitive.equals(Double.TYPE) && !wrapper.equals(Double.class)) {
            result = false;
        }
        return result;
    }

    public static boolean isANotificationEmitter(MBeanServerConnection connection, ObjectName mxbeanObjectName) throws IOException, IllegalArgumentException {
        boolean result = false;
        try {
            result = connection.isInstanceOf(mxbeanObjectName, NOTIFICATION_EMITTER_TYPE);
        }
        catch (InstanceNotFoundException e) {
            result = false;
        }
        return result;
    }

    public static boolean isRunningOnUnix() {
        return isUnix;
    }

    public static ObjectName createObjectName(String name) {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            if (VERBOSE_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static ObjectName createObjectName(String domain, String name) {
        try {
            return ObjectName.getInstance(domain + ",name=" + name);
        }
        catch (MalformedObjectNameException e) {
            if (VERBOSE_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static ObjectName checkNamedMXBean(String mxbeanName, Class<?> mxbeanInterface) {
        if (mxbeanName == null) {
            throw new NullPointerException(Msg.getString("K0603"));
        }
        if (mxbeanInterface == null) {
            throw new NullPointerException(Msg.getString("K0614"));
        }
        ObjectName mxbeanObjectName = Metadata.makeObjectName(mxbeanName);
        ObjectName[] validObjectNames = Metadata.objectNamesByInterface.get(mxbeanInterface);
        if (validObjectNames != null) {
            for (ObjectName objectName : validObjectNames) {
                if (!objectName.apply(mxbeanObjectName)) continue;
                return mxbeanObjectName;
            }
            String domain = mxbeanObjectName.getDomain();
            String type = mxbeanObjectName.getKeyProperty("type");
            for (ObjectName objectName : validObjectNames) {
                if (!domain.equals(objectName.getDomain()) || !Objects.equals(type, objectName.getKeyProperty("type"))) continue;
                return mxbeanObjectName;
            }
        }
        throw new IllegalArgumentException(Msg.getString("K0605", (Object)mxbeanName, mxbeanInterface.getName()));
    }

    public static void checkSupported(Class<?> mxbeanInterface) {
        if (!Metadata.managementInterfaces.contains(mxbeanInterface)) {
            throw new IllegalArgumentException(Msg.getString("K0601", mxbeanInterface.getName()));
        }
    }

    public static void checkSupportedSingleton(Class<?> mxbeanInterface) {
        ManagementUtils.checkSupported(mxbeanInterface);
        if (Metadata.isMultiInstanceBeanInterface(mxbeanInterface)) {
            throw new IllegalArgumentException(Msg.getString("K0602", mxbeanInterface.getName()));
        }
    }

    public static Set<PlatformManagedObject> getAllAvailableMXBeans() {
        HashSet<PlatformManagedObject> allBeans = new HashSet<PlatformManagedObject>();
        for (List<PlatformManagedObject> beans : Metadata.beansByInterface.values()) {
            allBeans.addAll(beans);
        }
        return allBeans;
    }

    public static Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        return Collections.unmodifiableSet(Metadata.managementInterfaces);
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> mxbeanInterface) {
        PlatformManagedObject bean;
        ManagementUtils.checkSupportedSingleton(mxbeanInterface);
        List<PlatformManagedObject> beans = Metadata.beansByInterface.get(mxbeanInterface);
        if (beans != null && beans.size() == 1 && mxbeanInterface.isAssignableFrom((bean = beans.get(0)).getClass())) {
            return (T)((PlatformManagedObject)mxbeanInterface.cast(bean));
        }
        return null;
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> mxbeanInterface) throws IllegalArgumentException {
        ManagementUtils.checkSupported(mxbeanInterface);
        LinkedList<T> matchedBeans = new LinkedList<T>();
        List<PlatformManagedObject> beans = Metadata.beansByInterface.get(mxbeanInterface);
        if (beans != null) {
            for (PlatformManagedObject bean : beans) {
                matchedBeans.add(mxbeanInterface.cast(bean));
            }
        }
        return matchedBeans;
    }

    static {
        Properties properties = VM.getVMLangAccess().internalGetProperties();
        String thisOs = properties.getProperty("os.name");
        isUnix = "aix".equalsIgnoreCase(thisOs) || "linux".equalsIgnoreCase(thisOs) || "mac os x".equalsIgnoreCase(thisOs) || "z/OS".equalsIgnoreCase(thisOs);
        VERBOSE_MODE = properties.getProperty("com.ibm.lang.management.verbose") != null;
        compositeConverterMap = new ConcurrentHashMap();
        ManagementUtils.addCompositeConverter(LockInfo.class, LockInfoUtil::toCompositeData);
        ManagementUtils.addCompositeConverter(MemoryNotificationInfo.class, MemoryNotificationInfoUtil::toCompositeData);
        ManagementUtils.addCompositeConverter(MemoryUsage.class, MemoryUsageUtil::toCompositeData);
        ManagementUtils.addCompositeConverter(MonitorInfo.class, MonitorInfoUtil::toCompositeData);
        ManagementUtils.addCompositeConverter(StackTraceElement.class, StackTraceElementUtil::toCompositeData);
        ManagementUtils.addCompositeConverter(ThreadInfo.class, ThreadInfoUtil::toCompositeData);
    }

    private static final class Metadata {
        static final Map<Class<?>, List<PlatformManagedObject>> beansByInterface = new HashMap();
        static final Set<Class<? extends PlatformManagedObject>> managementInterfaces = new HashSet<Class<? extends PlatformManagedObject>>();
        static final Set<Class<?>> multiInstanceBeanInterfaces = new HashSet();
        static final Map<Class<?>, ObjectName[]> objectNamesByInterface = new HashMap();

        private Metadata() {
        }

        static ObjectName makeObjectName(String mxbeanName) {
            try {
                return ObjectName.getInstance(mxbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException(Msg.getString("K0604", mxbeanName), e);
            }
        }

        static boolean isMultiInstanceBeanInterface(Class<?> mxbeanInterface) {
            return multiInstanceBeanInterfaces.contains(mxbeanInterface);
        }

        static {
            Component.registerAll();
        }
    }

    private static final class Component<T extends PlatformManagedObject> {
        private static final String GUEST_OPERATING_SYSTEM_MXBEAN_NAME = "com.ibm.virtualization.management:type=GuestOS";
        private static final String HYPERVISOR_MXBEAN_NAME = "com.ibm.virtualization.management:type=Hypervisor";
        private static final String JVM_CPU_MONITOR_MXBEAN_NAME = "com.ibm.lang.management:type=JvmCpuMonitor";
        private static final String OPENJ9_DIAGNOSTICS_MXBEAN_NAME = "openj9.lang.management:type=OpenJ9Diagnostics";
        private final Map<ObjectName, PlatformManagedObject> beansByName;
        private final Set<Class<?>> interfaceTypes;
        private final boolean isSingleton;

        static void registerAll() {
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
        }

        private static <T> void addNew(Set<T> values, T value) {
            if (!values.add(value)) {
                throw new IllegalArgumentException();
            }
        }

        private static void checkNames(Collection<? extends PlatformManagedObject> beans, ObjectName pattern) {
            for (PlatformManagedObject platformManagedObject : beans) {
                ObjectName objectName = platformManagedObject.getObjectName();
                if (!pattern.apply(objectName)) {
                    throw new IllegalArgumentException(Msg.getString("K0615", (Object)objectName.getCanonicalName(), pattern));
                }
                if (!objectName.isPattern()) continue;
                throw new IllegalArgumentException(Msg.getString("K0616", objectName.getCanonicalName()));
            }
        }

        private static <T extends PlatformManagedObject> Component<T> create(String objectNamePattern, T bean) {
            return new Component<T>(objectNamePattern, bean);
        }

        private static <T extends PlatformManagedObject> Component<T> create(String objectNameBase, Collection<? extends T> beans) {
            return new Component<T>(objectNameBase + ",name=*", beans);
        }

        private static <T> List<T> excluding(List<T> objects, Class<?> excludedType) {
            ArrayList<T> filtered = new ArrayList<T>();
            for (T object : objects) {
                if (excludedType.isInstance(object)) continue;
                filtered.add(object);
            }
            return filtered;
        }

        private static <K, V> void putNew(Map<K, V> map, K key, V value) {
            if (map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            map.put(key, value);
        }

        private Component(String objectName, T bean) {
            ObjectName name = Metadata.makeObjectName(objectName);
            if (name.isPattern()) {
                throw new IllegalArgumentException(objectName);
            }
            if (bean == null) {
                this.beansByName = Collections.emptyMap();
            } else {
                Component.checkNames(Collections.singleton(bean), name);
                this.beansByName = Collections.singletonMap(name, bean);
            }
            this.interfaceTypes = new HashSet();
            this.isSingleton = true;
        }

        private Component(String objectNamePattern, Collection<? extends T> beans) {
            ObjectName pattern = Metadata.makeObjectName(objectNamePattern);
            if (!pattern.isPattern()) {
                throw new IllegalArgumentException(objectNamePattern);
            }
            Component.checkNames(beans, pattern);
            this.beansByName = new HashMap<ObjectName, PlatformManagedObject>(beans.size());
            this.interfaceTypes = new HashSet();
            this.isSingleton = true;
            for (PlatformManagedObject bean : beans) {
                Component.putNew(this.beansByName, bean.getObjectName(), bean);
            }
        }

        private Component<T> addInterface(Class<? super T> interfaceType) {
            Component.addNew(this.interfaceTypes, interfaceType);
            return this;
        }

        private Component<T> addInterfaceIf(Class<?> interfaceType, boolean required) {
            if (required) {
                for (PlatformManagedObject implementation : this.beansByName.values()) {
                    if (interfaceType.isInstance(implementation)) continue;
                    throw new IllegalArgumentException();
                }
                Component.addNew(this.interfaceTypes, interfaceType);
            }
            return this;
        }

        private void validateAndRegister() {
            Collection<PlatformManagedObject> allBeans = this.beansByName.values();
            for (PlatformManagedObject platformManagedObject : allBeans) {
                for (Class<?> clazz : this.interfaceTypes) {
                    if (clazz.isInstance(platformManagedObject)) continue;
                    throw new IllegalArgumentException();
                }
            }
            Map<Class<?>, List<PlatformManagedObject>> beansByInterface = Metadata.beansByInterface;
            for (PlatformManagedObject platformManagedObject : allBeans) {
                for (Class<?> clazz : this.interfaceTypes) {
                    List<PlatformManagedObject> beans = beansByInterface.get(clazz);
                    if (beans == null) {
                        beans = new ArrayList<PlatformManagedObject>(2);
                        beansByInterface.put(clazz, beans);
                    }
                    beans.add(platformManagedObject);
                }
            }
            Set<Class<? extends PlatformManagedObject>> set = Metadata.managementInterfaces;
            for (Class<?> clazz : this.interfaceTypes) {
                if (!PlatformManagedObject.class.isAssignableFrom(clazz)) continue;
                Class<?> clazz2 = clazz;
                set.add(clazz2);
            }
            if (!this.isSingleton) {
                Metadata.multiInstanceBeanInterfaces.addAll(this.interfaceTypes);
            }
            Map<Class<?>, ObjectName[]> map = Metadata.objectNamesByInterface;
            Set<ObjectName> set2 = this.beansByName.keySet();
            int n = set2.size();
            for (Class<?> interfaceType : this.interfaceTypes) {
                int oldLength;
                ObjectName[] nameArray = map.get(interfaceType);
                if (nameArray == null) {
                    oldLength = 0;
                    nameArray = new ObjectName[n];
                } else {
                    oldLength = nameArray.length;
                    ObjectName[] objectNameArray = nameArray;
                    nameArray = new ObjectName[oldLength + n];
                    System.arraycopy((Object)objectNameArray, 0, (Object)nameArray, 0, oldLength);
                }
                for (ObjectName beanName : set2) {
                    nameArray[oldLength++] = beanName;
                }
                map.put(interfaceType, nameArray);
            }
        }
    }
}

