/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.CertId;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;

public final class OOBCertHash
extends CMPDerObject {
    private AlgorithmId hashAlg;
    private CertId certId;
    byte[] hashVal;
    private static final byte TAG_HASH_ALG = 0;
    private static final byte TAG_CERT_ID = 1;

    public OOBCertHash(AlgorithmId algorithmId, CertId certId, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("OOBCertHash error, hashVal not specified");
        }
        this.hashAlg = algorithmId;
        this.certId = certId;
        this.hashVal = (byte[])byArray.clone();
    }

    public OOBCertHash(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new OOBCertHash(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("OOBCertHash parsing error, not a SEQUENCE");
        }
        this.hashAlg = null;
        this.certId = null;
        this.hashVal = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("OOBCertHash parsing error, missing data");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        boolean bl = false;
        if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
            this.hashAlg = AlgorithmId.parse((DerValue)derValue2.getData().getDerValue());
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                throw new IOException("OOBCertHash parsing error, missing data");
            }
        }
        if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
            this.certId = new CertId(derValue2.getData().getDerValue().toByteArray());
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                throw new IOException("OOBCertHash parsing error, missing data");
            }
        }
        this.hashVal = derValue2.getBitString();
        if (this.hashVal == null) {
            throw new IOException("OOBCertHash parsing error, hash value not specified");
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("OOBCertHash parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.hashAlg != null) {
            derOutputStream = new DerOutputStream();
            this.hashAlg.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream);
        }
        if (this.certId != null) {
            derOutputStream = new DerOutputStream();
            this.certId.encode((OutputStream)derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream);
        }
        if (this.hashVal == null) {
            throw new IOException("OOBCertHash encoding error, hash value not specified");
        }
        derOutputStream2.putBitString(this.hashVal);
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public boolean equals(OOBCertHash oOBCertHash) {
        DerValue derValue;
        DerValue derValue2;
        if (oOBCertHash == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            oOBCertHash.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof OOBCertHash) {
            return this.equals((OOBCertHash)object);
        }
        return false;
    }

    public CertId getCertId() {
        if (this.certId == null) {
            return null;
        }
        return (CertId)this.certId.clone();
    }

    public AlgorithmId getHashAlg() throws IOException {
        if (this.hashAlg == null) {
            return null;
        }
        return new AlgorithmId(this.hashAlg.getOID(), this.hashAlg.getParameters());
    }

    public byte[] getHashValue() {
        return (byte[])this.hashVal.clone();
    }

    public String toString() {
        String string = "OOBCertHash:";
        string = this.hashAlg == null ? String.valueOf(string) + "\r\n\tno hash algorithm specifided" : String.valueOf(string) + "\r\n\thash algorithm: " + this.hashAlg.toString();
        string = this.certId == null ? String.valueOf(string) + "\r\n\tno cert id specified" : String.valueOf(string) + "\r\n\tcert id: " + this.certId.toString();
        string = String.valueOf(string) + "\r\n\thash value: " + new String(this.hashVal);
        return string;
    }
}

