/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.crypto.provider.X509Factory;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.CRLExtensions;
import com.ibm.security.x509.CertificateIssuerExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IssuingDistributionPointExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLEntryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;

public final class X509CRLImpl
extends X509CRL
implements DerEncoder {
    private static final int V1 = 0;
    private static final int V2 = 1;
    private byte[] signedCRL = null;
    private byte[] signature = null;
    private byte[] tbsCertList = null;
    private AlgorithmId sigAlgId = null;
    private int version;
    private AlgorithmId infoSigAlgId;
    private X500Name issuer = null;
    private Date thisUpdate = null;
    private Date nextUpdate = null;
    private Map<X509IssuerSerial, X509CRLEntry> revokedMap = new TreeMap<X509IssuerSerial, X509CRLEntry>();
    private List<X509CRLEntry> revokedList = new LinkedList<X509CRLEntry>();
    private CRLExtensions extensions = null;
    private static final boolean isExplicit = true;
    private static final long YR_2050 = 2524636800000L;
    private boolean readOnly = false;
    private X500Principal issuerX500Principal = null;
    private PublicKey verifiedPublicKey;
    private String verifiedProvider;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509CRLImpl";

    private X509CRLImpl() {
        if (debug != null) {
            debug.entry(8192L, className, "X509CRLImpl");
            debug.exit(8192L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(byte[] crlData) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLImpl", (Object)crlData);
        }
        try {
            this.parse(new DerValue(crlData));
        }
        catch (IOException e) {
            this.signedCRL = null;
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLImpl", e);
            }
            throw new CRLException("Parsing error: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(DerValue val) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLImpl", val);
        }
        try {
            this.parse(val);
        }
        catch (IOException e) {
            this.signedCRL = null;
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLImpl", e);
            }
            throw new CRLException("Parsing error: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(InputStream inStrm) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLImpl", inStrm);
        }
        try {
            this.parse(new DerValue(inStrm));
        }
        catch (IOException e) {
            this.signedCRL = null;
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLImpl", e);
            }
            throw new CRLException("Parsing error: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(X500Name issuer, Date thisDate, Date nextDate) {
        if (debug != null) {
            Object[] parms = new Object[]{issuer, thisDate, nextDate};
            debug.entry(16384L, (Object)className, "X509CRLImpl", parms);
        }
        this.issuer = issuer;
        this.thisUpdate = thisDate != null ? new Date(thisDate.getTime()) : thisDate;
        this.nextUpdate = nextDate != null ? new Date(nextDate.getTime()) : nextDate;
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(X500Name issuer, Date thisDate, Date nextDate, X509CRLEntry[] badCerts) throws CRLException {
        if (debug != null) {
            Object[] parms = new Object[]{issuer, thisDate, nextDate, badCerts};
            debug.entry(16384L, (Object)className, "X509CRLImpl", parms);
        }
        this.issuer = issuer;
        this.thisUpdate = thisDate != null ? new Date(thisDate.getTime()) : thisDate;
        this.nextUpdate = nextDate != null ? new Date(nextDate.getTime()) : nextDate;
        if (badCerts != null) {
            X500Principal crlIssuer;
            X500Principal badCertIssuer = crlIssuer = this.getIssuerX500Principal();
            for (int i = 0; i < badCerts.length; ++i) {
                if (badCerts[i] == null) continue;
                X509CRLEntryImpl badCert = (X509CRLEntryImpl)badCerts[i];
                try {
                    badCertIssuer = this.getCertIssuer(badCert, badCertIssuer);
                }
                catch (IOException ioe) {
                    throw new CRLException(ioe);
                }
                badCert.setCertificateIssuer(crlIssuer, badCertIssuer);
                X509IssuerSerial issuerSerial = new X509IssuerSerial(badCertIssuer, badCert.getSerialNumber());
                this.revokedMap.put(issuerSerial, badCert);
                this.revokedList.add(badCert);
                if (!badCert.hasExtensions()) continue;
                this.version = 1;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(int version, X500Name issuer, Date thisDate, Date nextDate, X509CRLEntry[] badCerts, CRLExtensions crlExts) throws CRLException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(version), issuer, thisDate, nextDate, badCerts, crlExts};
            debug.entry(16384L, (Object)className, "X509CRLImpl", parms);
        }
        if (version != 0 && version != 1) {
            throw new CRLException("CRL version " + version + " not supported");
        }
        this.version = version;
        this.issuer = issuer;
        this.thisUpdate = thisDate != null ? new Date(thisDate.getTime()) : thisDate;
        this.nextUpdate = nextDate != null ? new Date(nextDate.getTime()) : nextDate;
        if (badCerts != null) {
            X500Principal crlIssuer;
            X500Principal badCertIssuer = crlIssuer = this.getIssuerX500Principal();
            for (int i = 0; i < badCerts.length; ++i) {
                if (badCerts[i] == null) continue;
                X509CRLEntryImpl badCert = (X509CRLEntryImpl)badCerts[i];
                try {
                    badCertIssuer = this.getCertIssuer(badCert, badCertIssuer);
                }
                catch (IOException ioe) {
                    throw new CRLException(ioe);
                }
                badCert.setCertificateIssuer(crlIssuer, badCertIssuer);
                X509IssuerSerial issuerSerial = new X509IssuerSerial(badCertIssuer, badCert.getSerialNumber());
                this.revokedMap.put(issuerSerial, badCert);
                this.revokedList.add(badCert);
                if (!badCerts[i].hasExtensions() || this.version >= 1) continue;
                throw new CRLException("Revoked certs extensions present. Invalid version number: " + this.version);
            }
        }
        if (crlExts != null) {
            if (this.version < 1) {
                throw new CRLException("CRL extensions present. Invalid version number: " + this.version);
            }
            if (crlExts != null) {
                DerOutputStream derout = new DerOutputStream();
                crlExts.encode(derout, false);
                DerInputStream derin = null;
                try {
                    derin = new DerInputStream(derout.toByteArray());
                }
                catch (IOException ex) {
                    throw new CRLException(ex.getMessage());
                }
                this.extensions = new CRLExtensions(derin);
                this.version = 1;
            } else {
                this.extensions = crlExts;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(X500Name issuer, Date thisDate, Date nextDate, X509CRLEntry[] badCerts, CRLExtensions crlExts) throws CRLException {
        this(issuer, thisDate, nextDate, badCerts);
        if (debug != null) {
            Object[] parms = new Object[]{issuer, thisDate, nextDate, badCerts, crlExts};
            debug.entry(16384L, (Object)className, "X509CRLImpl", parms);
        }
        if (crlExts != null) {
            if (crlExts != null) {
                DerOutputStream derout = new DerOutputStream();
                crlExts.encode(derout, false);
                DerInputStream derin = null;
                try {
                    derin = new DerInputStream(derout.toByteArray());
                }
                catch (IOException ex) {
                    throw new CRLException(ex.getMessage());
                }
                this.extensions = new CRLExtensions(derin);
                this.version = 1;
            } else {
                this.extensions = crlExts;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public byte[] getEncodedInternal() throws CRLException {
        if (this.signedCRL == null) {
            throw new CRLException("Null CRL to encode");
        }
        return this.signedCRL;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncoded");
        }
        byte[] dup = (byte[])this.getEncodedInternal().clone();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getEncoded", (Object)dup);
        }
        return dup;
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        try {
            out.write(this.getEncoded());
        }
        catch (CRLException e) {
            if (debug != null) {
                debug.exception(16384L, className, "derEncode", e);
            }
            throw new IOException(e.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public void encodeInfo(OutputStream out) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encodeInfo", out);
        }
        try {
            DerOutputStream tmp = new DerOutputStream();
            DerOutputStream rCerts = new DerOutputStream();
            DerOutputStream seq = new DerOutputStream();
            if (this.version != 0) {
                tmp.putInteger(BigInteger.valueOf(this.version));
            }
            this.infoSigAlgId.encode(tmp);
            if (this.version == 0 && this.issuer.toString() == null) {
                if (debug != null) {
                    debug.text(16384L, className, "encodeInfo", "Null Issuer DN not allowed in v1 CRL");
                }
                throw new CRLException("Null Issuer DN not allowed in v1 CRL");
            }
            this.issuer.encode(tmp);
            if (this.thisUpdate.getTime() < 2524636800000L) {
                tmp.putUTCTime(this.thisUpdate);
            } else {
                tmp.putGeneralizedTime(this.thisUpdate);
            }
            if (this.nextUpdate != null) {
                if (this.nextUpdate.getTime() < 2524636800000L) {
                    tmp.putUTCTime(this.nextUpdate);
                } else {
                    tmp.putGeneralizedTime(this.nextUpdate);
                }
            }
            if (!this.revokedList.isEmpty()) {
                for (X509CRLEntry entry : this.revokedList) {
                    ((X509CRLEntryImpl)entry).encode(rCerts);
                }
                tmp.write((byte)48, rCerts);
            }
            if (this.extensions != null) {
                this.extensions.encode(tmp, true);
            }
            seq.write((byte)48, tmp);
            this.tbsCertList = seq.toByteArray();
            out.write(this.tbsCertList);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encodeInfo", e);
            }
            throw new CRLException("Encoding error: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "encodeInfo");
        }
    }

    @Override
    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", key);
        }
        this.verify(key, "");
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "verify", key, sigProvider);
        }
        if (this.signedCRL == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Uninitialized CRL");
            }
            throw new CRLException("Uninitialized CRL");
        }
        Signature sigVerf = null;
        if (sigProvider == null) {
            sigProvider = "";
        }
        if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(key) && sigProvider.equals(this.verifiedProvider)) {
            return;
        }
        sigVerf = sigProvider.length() == 0 ? Signature.getInstance(this.sigAlgId.getName()) : Signature.getInstance(this.sigAlgId.getName(), sigProvider);
        sigVerf.initVerify(key);
        if (this.tbsCertList == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Uninitialized CRL");
            }
            throw new CRLException("Uninitialized CRL");
        }
        sigVerf.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!sigVerf.verify(this.signature)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature does not match.");
            }
            throw new SignatureException("Signature does not match.");
        }
        this.verifiedPublicKey = key;
        this.verifiedProvider = sigProvider;
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    @Override
    public synchronized void verify(PublicKey key, Provider sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.signedCRL == null) {
            throw new CRLException("Uninitialized CRL");
        }
        Signature sigVerf = null;
        sigVerf = sigProvider == null ? Signature.getInstance(this.sigAlgId.getName()) : Signature.getInstance(this.sigAlgId.getName(), sigProvider);
        sigVerf.initVerify(key);
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        sigVerf.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!sigVerf.verify(this.signature)) {
            throw new SignatureException("Signature does not match.");
        }
        this.verifiedPublicKey = key;
    }

    public static void verify(X509CRL crl, PublicKey key, Provider sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        X509CRLImpl crlImpl = (X509CRLImpl)crl;
        crlImpl.verify(key, sigProvider);
    }

    public void sign(PrivateKey key, String algorithm) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", key, algorithm);
        }
        this.sign(key, algorithm, null);
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public void sign(PrivateKey key, String algorithm, String provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            Object[] parms = new Object[]{key, algorithm, provider};
            debug.entry(16384L, (Object)className, "sign", parms);
        }
        try {
            if (this.readOnly) {
                if (debug != null) {
                    debug.text(16384L, className, "sign", "cannot over-write existing CRL");
                }
                throw new CRLException("cannot over-write existing CRL");
            }
            Signature sigEngine = null;
            sigEngine = provider == null || provider.length() == 0 ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
            sigEngine.initSign(key);
            this.infoSigAlgId = this.sigAlgId = AlgorithmId.get(sigEngine.getAlgorithm());
            DerOutputStream out = new DerOutputStream();
            DerOutputStream tmp = new DerOutputStream();
            this.encodeInfo(tmp);
            this.sigAlgId.encode(tmp);
            sigEngine.update(this.tbsCertList, 0, this.tbsCertList.length);
            this.signature = sigEngine.sign();
            tmp.putBitString(this.signature);
            out.write((byte)48, tmp);
            this.signedCRL = out.toByteArray();
            this.readOnly = true;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", e);
            }
            throw new CRLException("Error while encoding data: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("X.509 CRL v" + (this.version + 1) + "\r\n");
        if (this.sigAlgId != null) {
            sb.append("Signature Algorithm: " + this.sigAlgId.toString() + ", OID=" + this.sigAlgId.getOID().toString() + "\r\n");
        }
        if (this.issuer != null) {
            sb.append("Issuer: " + this.issuer.toString() + "\r\n");
        }
        if (this.thisUpdate != null) {
            sb.append("\r\nThis Update: " + this.thisUpdate.toString() + "\r\n");
        }
        if (this.nextUpdate != null) {
            sb.append("Next Update: " + this.nextUpdate.toString() + "\r\n");
        }
        if (this.revokedList.isEmpty()) {
            sb.append("\r\nNO certificates have been revoked\r\n");
        } else {
            sb.append("\r\nRevoked Certificates: " + this.revokedList.size());
            int i = 1;
            for (X509CRLEntry entry : this.revokedList) {
                sb.append("\n[" + i++ + "] " + entry.toString());
            }
        }
        if (this.extensions != null) {
            Collection<Extension> allExts = this.extensions.getAllExtensions();
            Object[] objs = allExts.toArray();
            sb.append("\r\nCRL Extensions: " + objs.length);
            for (int i = 0; i < objs.length; ++i) {
                sb.append("\r\n[" + (i + 1) + "]: ");
                Extension ext = (Extension)objs[i];
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb.append(ext.toString());
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        DerOutputStream out = new DerOutputStream();
                        out.putOctetString(extValue);
                        extValue = out.toByteArray();
                        HexDumpEncoder enc = new HexDumpEncoder();
                        sb.append("Extension unknown: DER encoded OCTET string =\r\n" + enc.encodeBuffer(extValue) + "\r\n");
                        continue;
                    }
                    sb.append(ext.toString());
                    continue;
                }
                catch (Exception e) {
                    sb.append(", Error parsing this extension");
                }
            }
        }
        if (this.signature != null) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            sb.append("\r\nSignature:\r\n" + encoder.encodeBuffer(this.signature) + "\r\n");
        } else {
            sb.append("NOT signed yet\r\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isRevoked(Certificate cert) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isRevoked", cert);
        }
        if (this.revokedMap == null || this.revokedMap.isEmpty()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isRevoked", new Boolean(false));
            }
            return false;
        }
        if (!(cert instanceof X509Certificate)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isRevoked", new Boolean(false));
            }
            return false;
        }
        X509Certificate xcert = (X509Certificate)cert;
        X509IssuerSerial issuerSerial = new X509IssuerSerial(xcert);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isRevoked", new Boolean(this.revokedMap.containsKey(issuerSerial)));
        }
        return this.revokedMap.containsKey(issuerSerial);
    }

    @Override
    public int getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", new Integer(this.version + 1));
        }
        return this.version + 1;
    }

    @Override
    public Principal getIssuerDN() {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuerDN");
            debug.exit(16384L, (Object)className, "getIssuerDN", this.issuer);
        }
        return this.issuer;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        if (this.issuerX500Principal == null || !this.readOnly) {
            try {
                DerOutputStream out = new DerOutputStream();
                ((X500Name)this.getIssuerDN()).encode(out);
                this.issuerX500Principal = new X500Principal(out.toByteArray());
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.issuerX500Principal;
    }

    public static X500Principal getIssuerX500Principal(X509CRL crl) {
        try {
            byte[] encoded = crl.getEncoded();
            DerInputStream derIn = new DerInputStream(encoded);
            DerValue tbsCert = derIn.getSequence(3)[0];
            DerInputStream tbsIn = tbsCert.getData();
            byte nextByte = (byte)tbsIn.peekByte();
            if (nextByte == 2) {
                DerValue derValue = tbsIn.getDerValue();
            }
            DerValue tmp = tbsIn.getDerValue();
            tmp = tbsIn.getDerValue();
            byte[] principalBytes = tmp.toByteArray();
            return new X500Principal(principalBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse issuer", e);
        }
    }

    @Override
    public Date getThisUpdate() {
        if (debug != null) {
            debug.entry(16384L, className, "getThisUpdate");
            debug.exit(16384L, (Object)className, "getThisUpdate", new Date(this.thisUpdate.getTime()));
        }
        return new Date(this.thisUpdate.getTime());
    }

    @Override
    public Date getNextUpdate() {
        Date result;
        if (debug != null) {
            debug.entry(16384L, className, "getNextUpdate");
        }
        if (this.nextUpdate == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNextUpdate", null);
            }
            return null;
        }
        try {
            result = new Date(this.nextUpdate.getTime());
        }
        catch (Exception e) {
            result = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getNextUpdate_1", result);
        }
        return result;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getRevokedCertificate", serialNumber);
        }
        if (this.revokedMap == null || this.revokedMap.isEmpty()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRevokedCertificate", null);
            }
            return null;
        }
        X509IssuerSerial issuerSerial = new X509IssuerSerial(this.getIssuerX500Principal(), serialNumber);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRevokedCertificate", this.revokedMap.get(issuerSerial));
        }
        return this.revokedMap.get(issuerSerial);
    }

    @Override
    public X509CRLEntry getRevokedCertificate(X509Certificate cert) {
        if (this.revokedMap.isEmpty()) {
            return null;
        }
        X509IssuerSerial issuerSerial = new X509IssuerSerial(cert);
        return this.revokedMap.get(issuerSerial);
    }

    public Set getRevokedCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "getRevokedCertificates");
        }
        if (this.revokedList == null || this.revokedList.isEmpty()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRevokedCertificates", null);
            }
            return null;
        }
        return new TreeSet<X509CRLEntry>(this.revokedList);
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        if (debug != null) {
            debug.entry(16384L, className, "getTBSCertList");
        }
        if (this.tbsCertList == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTBSCertList", "Uninitialized CRL");
            }
            throw new CRLException("Uninitialized CRL");
        }
        byte[] dup = new byte[this.tbsCertList.length];
        System.arraycopy(this.tbsCertList, 0, dup, 0, dup.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getTBSCertList", dup);
        }
        return dup;
    }

    @Override
    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature", null);
            }
            return null;
        }
        byte[] dup = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, dup, 0, dup.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature", dup);
        }
        return dup;
    }

    @Override
    public String getSigAlgName() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.sigAlgId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature", this.sigAlgId.getName());
        }
        return this.sigAlgId.getName();
    }

    @Override
    public String getSigAlgOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgOID");
        }
        if (this.sigAlgId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgOID", null);
            }
            return null;
        }
        ObjectIdentifier oid = this.sigAlgId.getOID();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigAlgOID", oid.toString());
        }
        return oid.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgParams");
        }
        if (this.sigAlgId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgParams", null);
            }
            return null;
        }
        try {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgParams", this.sigAlgId.getEncodedParams());
            }
            return this.sigAlgId.getEncodedParams();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSigAlgParams", e);
                debug.exit(16384L, (Object)className, "getSigAlgParams", null);
            }
            return null;
        }
    }

    public AlgorithmId getSigAlgId() {
        return this.sigAlgId;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", new Boolean(this.extensions.hasUnsupportedCriticalExtension()));
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs", null);
            }
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (!ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs", extSet);
        }
        return extSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getNonCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs", null);
            }
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs", extSet);
        }
        return extSet;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getExtensionValue", oid);
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
            }
            return null;
        }
        try {
            String extAlias = OIDMap.getName(new ObjectIdentifier(oid));
            Extension crlExt = null;
            if (extAlias == null) {
                ObjectIdentifier findOID = new ObjectIdentifier(oid);
                Extension ex = null;
                Enumeration<Extension> e = this.extensions.getElements();
                while (e.hasMoreElements()) {
                    ex = e.nextElement();
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    crlExt = ex;
                    break;
                }
            } else {
                crlExt = this.extensions.get(extAlias);
            }
            if (crlExt == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_2", null);
                }
                return null;
            }
            byte[] extData = crlExt.getExtensionValue();
            if (extData == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_3", null);
                }
                return null;
            }
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(extData);
            byte[] result = out.toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getExtensionValue", e);
                debug.exit(16384L, (Object)className, "getExtensionValue_4", null);
            }
            return null;
        }
    }

    private void parse(DerValue val) throws CRLException, IOException {
        DerValue tmp;
        AlgorithmId tmpId;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parse", val);
        }
        if (this.readOnly) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "cannot over-write existing CRL");
            }
            throw new CRLException("cannot over-write existing CRL");
        }
        this.signedCRL = val.toByteArray();
        DerValue[] seq = new DerValue[]{val.getData().getDerValue(), val.getData().getDerValue(), val.getData().getDerValue()};
        if (val.getData().available() != 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "signed overrun, bytes = " + val.getData().available());
            }
            throw new CRLException("signed overrun, bytes = " + val.getData().available());
        }
        if (seq[0].getTag() != 48) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "signed CRL fields invalid");
            }
            throw new CRLException("signed CRL fields invalid");
        }
        this.sigAlgId = AlgorithmId.parse(seq[1]);
        this.signature = seq[2].getBitString();
        if (seq[1].getData().available() != 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "AlgorithmId field overrun");
            }
            throw new CRLException("AlgorithmId field overrun");
        }
        if (seq[2].getData().available() != 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "Signature field overrun");
            }
            throw new CRLException("Signature field overrun");
        }
        this.tbsCertList = seq[0].toByteArray();
        DerInputStream derStrm = seq[0].getData();
        this.version = 0;
        byte nextByte = (byte)derStrm.peekByte();
        if (nextByte == 2) {
            this.version = derStrm.getInteger().intValue();
            if (this.version != 1) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "parse", "Invalid version");
                }
                throw new CRLException("Invalid version");
            }
        }
        if (!(tmpId = AlgorithmId.parse(tmp = derStrm.getDerValue())).equals(this.sigAlgId)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "Signature algorithm mismatch");
            }
            throw new CRLException("Signature algorithm mismatch");
        }
        this.infoSigAlgId = tmpId;
        this.issuer = new X500Name(derStrm);
        if (this.issuer.toString() == null && this.version == 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "Null Issuer DN allowed only in v2 CRL");
            }
            throw new CRLException("Null Issuer DN allowed only in v2 CRL");
        }
        nextByte = (byte)derStrm.peekByte();
        if (nextByte == 23) {
            this.thisUpdate = derStrm.getUTCTime();
        } else if (nextByte == 24) {
            this.thisUpdate = derStrm.getGeneralizedTime();
        } else {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "Invalid encoding for thisUpdate (tag=" + nextByte + ")");
            }
            throw new CRLException("Invalid encoding for thisUpdate (tag=" + nextByte + ")");
        }
        nextByte = (byte)derStrm.peekByte();
        if (nextByte == 23) {
            this.nextUpdate = derStrm.getUTCTime();
        } else if (nextByte == 24) {
            this.nextUpdate = derStrm.getGeneralizedTime();
        }
        if (derStrm.available() == 0) {
            return;
        }
        nextByte = (byte)derStrm.peekByte();
        if (nextByte == 48 && (nextByte & 0xC0) != 128) {
            X500Principal crlIssuer;
            DerValue[] badCerts = derStrm.getSequence(4);
            X500Principal badCertIssuer = crlIssuer = this.getIssuerX500Principal();
            for (int i = 0; i < badCerts.length; ++i) {
                X509CRLEntryImpl entry = new X509CRLEntryImpl(badCerts[i]);
                if (entry.hasExtensions() && this.version == 0) {
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "parse", "Invalid encoding, extensions not supported in CRL v1 entries.");
                    }
                    throw new CRLException("Invalid encoding, extensions not supported in CRL v1 entries.");
                }
                badCertIssuer = this.getCertIssuer(entry, badCertIssuer);
                entry.setCertificateIssuer(crlIssuer, badCertIssuer);
                X509IssuerSerial issuerSerial = new X509IssuerSerial(badCertIssuer, entry.getSerialNumber());
                this.revokedMap.put(issuerSerial, entry);
                this.revokedList.add(entry);
            }
        }
        if (derStrm.available() == 0) {
            return;
        }
        tmp = derStrm.getDerValue();
        if (tmp.isConstructed() && tmp.isContextSpecific((byte)0)) {
            if (this.version == 0) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "parse", "Invalid encoding, extensions not supported in CRL v1.");
                }
                throw new CRLException("Invalid encoding, extensions not supported in CRL v1.");
            }
            this.extensions = new CRLExtensions(tmp.getData());
        }
        this.readOnly = true;
        if (debug != null) {
            debug.exit(8192L, className, "parse");
        }
    }

    public static byte[] getEncodedInternal(X509CRL crl) throws CRLException {
        if (crl instanceof X509CRLImpl) {
            return ((X509CRLImpl)crl).getEncodedInternal();
        }
        return crl.getEncoded();
    }

    private X500Principal getCertIssuer(X509CRLEntryImpl entry, X500Principal prevCertIssuer) throws IOException {
        CertificateIssuerExtension ciExt = entry.getCertificateIssuerExtension();
        if (ciExt != null) {
            GeneralNames names = (GeneralNames)ciExt.get("value");
            X500Name issuerDN = (X500Name)((GeneralName)names.get(0)).getName();
            return new X500Principal(issuerDN.getName());
        }
        return prevCertIssuer;
    }

    public static X509CRLImpl toImpl(X509CRL crl) throws CRLException {
        if (crl instanceof X509CRLImpl) {
            return (X509CRLImpl)crl;
        }
        return X509Factory.intern((X509CRL)crl);
    }

    public Object getExtension(ObjectIdentifier oid) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.get(OIDMap.getName(oid));
    }

    public AuthorityKeyIdentifierExtension getAuthKeyIdExtension() throws IOException {
        Object obj = this.getExtension(PKIXExtensions.AuthorityKey_Id);
        return (AuthorityKeyIdentifierExtension)obj;
    }

    public IssuingDistributionPointExtension getIssuingDistributionPointExtension() throws IOException {
        Object obj = this.getExtension(PKIXExtensions.IssuingDistributionPoint_Id);
        return (IssuingDistributionPointExtension)obj;
    }

    private static final class X509IssuerSerial
    implements Comparable<X509IssuerSerial> {
        final X500Principal issuer;
        final BigInteger serial;
        volatile int hashcode = 0;

        X509IssuerSerial(X500Principal issuer, BigInteger serial) {
            this.issuer = issuer;
            this.serial = serial;
        }

        X509IssuerSerial(X509Certificate cert) {
            this(cert.getIssuerX500Principal(), cert.getSerialNumber());
        }

        X500Principal getIssuer() {
            return this.issuer;
        }

        BigInteger getSerial() {
            return this.serial;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof X509IssuerSerial)) {
                return false;
            }
            X509IssuerSerial other = (X509IssuerSerial)o;
            return this.serial.equals(other.getSerial()) && this.issuer.equals(other.getIssuer());
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                int result = 17;
                result = 37 * result + this.issuer.hashCode();
                this.hashcode = result = 37 * result + this.serial.hashCode();
            }
            return this.hashcode;
        }

        @Override
        public int compareTo(X509IssuerSerial another) {
            int cissuer = this.issuer.toString().compareTo(another.issuer.toString());
            if (cissuer != 0) {
                return cissuer;
            }
            return this.serial.compareTo(another.serial);
        }
    }
}

