/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CRLExtensions;
import com.ibm.security.x509.CRLReasonCodeExtension;
import com.ibm.security.x509.CertificateIssuerExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.X509CRLEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;

public final class X509CRLEntryImpl
extends X509CRLEntry
implements Comparable<X509CRLEntryImpl> {
    private SerialNumber serialNumber = null;
    private Date revocationDate = null;
    private CRLExtensions extensions = null;
    private byte[] revokedCert = null;
    private X500Principal certIssuer;
    private static final boolean isExplicit = false;
    private static final long YR_2050 = 2524636800000L;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509CRLEntryImpl";

    private X509CRLEntryImpl() {
        if (debug != null) {
            debug.entry(16384L, className, "X509CRLEntryImpl");
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(BigInteger num, Date date) {
        if (debug != null) {
            debug.entry(16384L, className, "X509CRLEntryImpl", num, date);
        }
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date != null ? new Date(date.getTime()) : date;
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(BigInteger num, Date date, CRLExtensions crlEntryExts) {
        if (debug != null) {
            Object[] parms = new Object[]{num, date, crlEntryExts};
            debug.entry(16384L, (Object)className, "X509CRLEntryImpl", parms);
        }
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date != null ? new Date(date.getTime()) : date;
        this.extensions = crlEntryExts;
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(byte[] revokedCert) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLEntryImpl", (Object)revokedCert);
        }
        try {
            this.parse(new DerValue(revokedCert));
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLEntryImpl", e);
            }
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + e.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    public X509CRLEntryImpl(DerValue derValue) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLEntryImpl", derValue);
        }
        try {
            this.parse(derValue);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLEntryImpl", e);
            }
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + e.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLEntryImpl");
        }
    }

    @Override
    public boolean hasExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "hasExtensions");
        }
        boolean result = false;
        if (this.extensions != null) {
            result = true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasExtensions", new Boolean(result));
        }
        return result;
    }

    public void encode(DerOutputStream outStrm) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outStrm);
        }
        try {
            if (this.revokedCert == null) {
                DerOutputStream tmp = new DerOutputStream();
                this.serialNumber.encode(tmp);
                if (this.revocationDate.getTime() < 2524636800000L) {
                    tmp.putUTCTime(this.revocationDate);
                } else {
                    tmp.putGeneralizedTime(this.revocationDate);
                }
                if (this.extensions != null) {
                    this.extensions.encode(tmp, false);
                }
                DerOutputStream seq = new DerOutputStream();
                seq.write((byte)48, tmp);
                this.revokedCert = seq.toByteArray();
            }
            outStrm.write(this.revokedCert);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e);
            }
            throw new CRLException("Encoding error: " + e.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncoded");
        }
        byte[] result = (byte[])this.getEncoded0().clone();
        if (debug != null) {
            debug.exit(16384L, className, "getEncoded");
        }
        return result;
    }

    private byte[] getEncoded0() throws CRLException {
        if (this.revokedCert == null) {
            this.encode(new DerOutputStream());
        }
        return this.revokedCert;
    }

    @Override
    public X500Principal getCertificateIssuer() {
        return this.certIssuer;
    }

    void setCertificateIssuer(X500Principal crlIssuer, X500Principal certIssuer) {
        this.certIssuer = crlIssuer.equals(certIssuer) ? null : certIssuer;
    }

    @Override
    public BigInteger getSerialNumber() {
        if (debug != null) {
            debug.entry(16384L, className, "getSerialNumber");
            debug.exit(16384L, (Object)className, "getSerialNumber", this.serialNumber.getNumber());
        }
        return this.serialNumber.getNumber();
    }

    @Override
    public Date getRevocationDate() {
        if (debug != null) {
            debug.entry(16384L, className, "getRevocationDate");
            debug.exit(16384L, (Object)className, "getRevocationDate", new Date(this.revocationDate.getTime()));
        }
        return new Date(this.revocationDate.getTime());
    }

    @Override
    public CRLReason getRevocationReason() {
        Extension ext = this.getExtension(PKIXExtensions.ReasonCode_Id);
        if (ext == null) {
            return null;
        }
        CRLReasonCodeExtension rcExt = (CRLReasonCodeExtension)ext;
        return rcExt.getReasonCode();
    }

    public static CRLReason getRevocationReason(X509CRLEntry crlEntry) {
        try {
            byte[] ext = crlEntry.getExtensionValue("2.5.29.21");
            if (ext == null) {
                return null;
            }
            DerValue val = new DerValue(ext);
            byte[] data = val.getOctetString();
            CRLReasonCodeExtension rcExt = new CRLReasonCodeExtension(Boolean.FALSE, data);
            return rcExt.getReasonCode();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serialNumber.toString());
        sb.append("  On: " + this.revocationDate.toString());
        if (this.extensions != null) {
            Collection<Extension> allEntryExts = this.extensions.getAllExtensions();
            Extension[] exts = allEntryExts.toArray(new Extension[0]);
            sb.append("\n    CRL Entry Extensions: " + exts.length);
            for (int i = 0; i < exts.length; ++i) {
                sb.append("\n    [" + (i + 1) + "]: ");
                Extension ext = exts[i];
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb.append(ext.toString());
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        DerOutputStream out = new DerOutputStream();
                        out.putOctetString(extValue);
                        extValue = out.toByteArray();
                        HexDumpEncoder enc = new HexDumpEncoder();
                        sb.append("Extension unknown: DER encoded OCTET string =\n" + enc.encodeBuffer(extValue) + "\n");
                        continue;
                    }
                    sb.append(ext.toString());
                    continue;
                }
                catch (Exception e) {
                    sb.append(", Error parsing this extension");
                }
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
        }
        boolean result = false;
        if (this.extensions != null) {
            result = this.extensions.hasUnsupportedCriticalExtension();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", new Boolean(result));
        }
        return result;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (!ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs", extSet);
        }
        return extSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getNonCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs", extSet);
        }
        return extSet;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getExtensionValue", oid);
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
            }
            return null;
        }
        try {
            String extAlias = OIDMap.getName(new ObjectIdentifier(oid));
            Extension crlExt = null;
            if (extAlias == null) {
                ObjectIdentifier findOID = new ObjectIdentifier(oid);
                Extension ex = null;
                Enumeration<Extension> e = this.extensions.getElements();
                while (e.hasMoreElements()) {
                    ex = e.nextElement();
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    crlExt = ex;
                    break;
                }
            } else {
                crlExt = this.extensions.get(extAlias);
            }
            if (crlExt == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_2", null);
                }
                return null;
            }
            byte[] extData = crlExt.getExtensionValue();
            if (extData == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_3", null);
                }
                return null;
            }
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(extData);
            byte[] result = out.toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getExtensionValue", e);
                debug.exit(16384L, (Object)className, "getExtensionValue_4", null);
            }
            return null;
        }
    }

    public Extension getExtension(ObjectIdentifier oid) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.get(OIDMap.getName(oid));
    }

    private void parse(DerValue derVal) throws CRLException, IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parse", derVal);
        }
        if (derVal.getTag() != 48) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Invalid encoded RevokedCertificate, starting sequence tag missing.");
            }
            throw new CRLException("Invalid encoded RevokedCertificate, starting sequence tag missing.");
        }
        if (derVal.getData().available() == 0) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "No data encoded for RevokedCertificates");
            }
            throw new CRLException("No data encoded for RevokedCertificates");
        }
        this.revokedCert = derVal.toByteArray();
        DerInputStream in = derVal.toDerInputStream();
        DerValue val = in.getDerValue();
        this.serialNumber = new SerialNumber(val);
        int nextByte = derVal.getData().peekByte();
        if ((byte)nextByte == 23) {
            this.revocationDate = derVal.getData().getUTCTime();
        } else if ((byte)nextByte == 24) {
            this.revocationDate = derVal.getData().getGeneralizedTime();
        } else {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Invalid encoding for revocation date");
            }
            throw new CRLException("Invalid encoding for revocation date");
        }
        if (derVal.getData().available() == 0) {
            if (debug != null) {
                debug.exit(8192L, className, "parse_1");
            }
            return;
        }
        this.extensions = new CRLExtensions(derVal.toDerInputStream());
        if (debug != null) {
            debug.exit(8192L, className, "parse");
        }
    }

    CertificateIssuerExtension getCertificateIssuerExtension() {
        return (CertificateIssuerExtension)this.getExtension(PKIXExtensions.CertificateIssuer_Id);
    }

    public Map<String, java.security.cert.Extension> getExtensions() {
        if (this.extensions == null) {
            return Collections.emptyMap();
        }
        Collection<Extension> exts = this.extensions.getAllExtensions();
        TreeMap<String, java.security.cert.Extension> map = new TreeMap<String, java.security.cert.Extension>();
        for (Extension ext : exts) {
            map.put(ext.getId(), ext);
        }
        return map;
    }

    @Override
    public int compareTo(X509CRLEntryImpl that) {
        int compSerial = this.getSerialNumber().compareTo(that.getSerialNumber());
        if (compSerial != 0) {
            return compSerial;
        }
        try {
            byte[] thisEncoded = this.getEncoded0();
            byte[] thatEncoded = that.getEncoded0();
            for (int i = 0; i < thisEncoded.length && i < thatEncoded.length; ++i) {
                int a = thisEncoded[i] & 0xFF;
                int b = thatEncoded[i] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return thisEncoded.length - thatEncoded.length;
        }
        catch (CRLException ce) {
            return -1;
        }
    }
}

