/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public final class KeyIdentifier {
    private byte[] octetString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.KeyIdentifier";

    public KeyIdentifier(byte[] octetString) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyIdentifier", (Object)octetString);
        }
        this.octetString = octetString != null ? (byte[])octetString.clone() : octetString;
        if (debug != null) {
            debug.exit(16384L, className, "KeyIdentifier");
        }
    }

    public KeyIdentifier(DerValue val) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyIdentifier", val);
        }
        this.octetString = val.getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "KeyIdentifier");
        }
    }

    public KeyIdentifier(PublicKey pubKey) throws IOException {
        DerValue algAndKey = new DerValue(pubKey.getEncoded());
        if (algAndKey.getTag() != 48) {
            throw new IOException("PublicKey value is not a valid X.509 public key");
        }
        AlgorithmId algid = AlgorithmId.parse(algAndKey.getData().getDerValue());
        byte[] key = algAndKey.getData().getUnalignedBitString().toByteArray();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e3) {
            throw new IOException("SHA1 not supported");
        }
        md.update(key);
        this.octetString = md.digest();
    }

    public byte[] getIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getIdentifier");
            debug.exit(16384L, (Object)className, "getIdentifier", (byte[])this.octetString.clone());
        }
        return (byte[])this.octetString.clone();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = "KeyIdentifier [\n";
        HexDumpEncoder encoder = new HexDumpEncoder();
        s = s + encoder.encodeBuffer(this.octetString);
        s = s + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        out.putOctetString(this.octetString);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }
}

