/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.ec.ECKeyFactory;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AlgorithmId
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = 7205873507486557157L;
    private static boolean initOidTable = false;
    private static Map<String, ObjectIdentifier> oidTable;
    private String provider;
    private ObjectIdentifier algid;
    private AlgorithmParameters algParams;
    protected DerValue params;
    private static Debug debug;
    private static String className;
    private static final int[] MD2_data;
    private static final int[] MD5_data;
    private static final int[] SHA1_OIW_data;
    private static final int[] SHA256_data;
    private static final int[] SHA384_data;
    private static final int[] SHA512_data;
    private static final int[] SHA224_data;
    private static final int[] HmacSHA1_data;
    private static final int[] PasswordBasedMac_data;
    public static ObjectIdentifier MD2_oid;
    public static ObjectIdentifier MD5_oid;
    public static ObjectIdentifier SHA_oid;
    public static ObjectIdentifier SHA256_oid;
    public static ObjectIdentifier SHA384_oid;
    public static ObjectIdentifier SHA512_oid;
    public static ObjectIdentifier SHA224_oid;
    public static ObjectIdentifier HmacSHA1_oid;
    public static ObjectIdentifier PasswordBasedMac_oid;
    private static final int[] DH_data;
    private static final int[] DH_PKIX_data;
    private static final int[] DSA_OIW_data;
    private static final int[] DSA_PKIX_data;
    private static final int[] RSA_data;
    private static final int[] RSAEncryption_data;
    public static ObjectIdentifier DH_oid;
    public static ObjectIdentifier DH_PKIX_oid;
    public static ObjectIdentifier DSA_OIW_oid;
    public static ObjectIdentifier DSA_oid;
    public static ObjectIdentifier RSA_oid;
    public static ObjectIdentifier RSAEncryption_oid;
    public static ObjectIdentifier EC_oid;
    private static final int[] md2WithRSAEncryption_data;
    private static final int[] md5WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_OIW_data;
    private static final int[] sha256WithRSAEncryption_data;
    private static final int[] sha384WithRSAEncryption_data;
    private static final int[] sha512WithRSAEncryption_data;
    private static final int[] sha224WithRSAEncryption_data;
    private static final int[] shaWithDSA_OIW_data;
    private static final int[] sha1WithDSA_OIW_data;
    private static final int[] sha224WithDSA_data;
    private static final int[] sha256WithDSA_data;
    private static final int[] dsaWithSHA1_PKIX_data;
    private static final int[] DESCBC_data;
    private static final int[] tripleDESCBC_data;
    private static final int[] RC2CBC_data;
    private static final int[] AES_data;
    private static final int[] AES128CBC_data;
    private static final int[] AES192CBC_data;
    private static final int[] AES256CBC_data;
    private static final int[] sha1WithECDSA_data;
    private static final int[] sha224WithECDSA_data;
    private static final int[] sha256WithECDSA_data;
    private static final int[] sha384WithECDSA_data;
    private static final int[] sha512WithECDSA_data;
    private static final int[] specifiedWithECDSA_data;
    private static final int[] RSAPSS_data;
    private static final int[] mgf1_data;
    private static final int[] ecoid_data;
    public static ObjectIdentifier md2WithRSAEncryption_oid;
    public static ObjectIdentifier md5WithRSAEncryption_oid;
    public static ObjectIdentifier sha1WithRSAEncryption_oid;
    public static ObjectIdentifier RSAPSS_oid;
    public static ObjectIdentifier mgf1_oid;
    public static ObjectIdentifier sha1WithRSAEncryption_OIW_oid;
    public static ObjectIdentifier sha256WithRSAEncryption_oid;
    public static ObjectIdentifier sha384WithRSAEncryption_oid;
    public static ObjectIdentifier sha512WithRSAEncryption_oid;
    public static ObjectIdentifier sha224WithRSAEncryption_oid;
    public static ObjectIdentifier shaWithDSA_OIW_oid;
    public static ObjectIdentifier sha1WithDSA_OIW_oid;
    public static ObjectIdentifier sha1WithDSA_oid;
    public static ObjectIdentifier sha256WithDSA_oid;
    public static ObjectIdentifier sha224WithDSA_oid;
    public static ObjectIdentifier DESCBC_oid;
    public static ObjectIdentifier tripleDESCBC_oid;
    public static ObjectIdentifier RC2CBC_oid;
    public static ObjectIdentifier AES_oid;
    public static ObjectIdentifier AES128CBC_oid;
    public static ObjectIdentifier AES192CBC_oid;
    public static ObjectIdentifier AES256CBC_oid;
    public static ObjectIdentifier sha1WithECDSA_oid;
    public static ObjectIdentifier sha224WithECDSA_oid;
    public static ObjectIdentifier sha256WithECDSA_oid;
    public static ObjectIdentifier sha384WithECDSA_oid;
    public static ObjectIdentifier sha512WithECDSA_oid;
    public static ObjectIdentifier specifiedWithECDSA_oid;

    public AlgorithmId(DerValue val) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgorithmId", val);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AlgorithmId", "algid parse error: not a sequence");
            }
            throw new IOException("algid parse error: not a sequence");
        }
        DerInputStream in = val.toDerInputStream();
        this.algid = in.getOID();
        if (in.available() == 0) {
            this.params = null;
        } else {
            this.params = in.getDerValue();
            if (this.params.getTag() == 5) {
                if (this.params.length() != 0) {
                    throw new IOException("invalid NULL");
                }
                this.params = null;
            }
            if (in.available() != 0) {
                throw new IOException("Invalid AlgorithmIdentifier: extra data");
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(DerValue val, String provider) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", val, provider);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AlgorithmId", "algid parse error: not a sequence");
            }
            throw new IOException("algid parse error: not a sequence");
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        DerInputStream in = val.toDerInputStream();
        this.algid = in.getOID();
        if (in.available() == 0) {
            this.params = null;
        } else {
            this.params = in.getDerValue();
            if (this.params.getTag() == 5) {
                if (this.params.length() != 0) {
                    throw new IOException("invalid NULL");
                }
                this.params = null;
            }
            if (in.available() != 0) {
                throw new IOException("Invalid AlgorithmIdentifier: extra data");
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier oid, byte[] params) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", oid, params);
        }
        this.algid = oid;
        if (params != null && params.length != 0) {
            this.params = new DerValue(params);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier oid, byte[] params, String provider) throws IOException {
        this.provider = null;
        if (debug != null) {
            Object[] parms = new Object[]{oid, params, provider};
            debug.entry(16384L, (Object)className, "AlgorithmId", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.algid = oid;
        if (params != null && params.length != 0) {
            this.params = new DerValue(params);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(String oid, byte[] params) throws IOException {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", oid, params);
        }
        try {
            this.algid = new ObjectIdentifier(oid);
        }
        catch (Exception e) {
            this.algid = null;
        }
        if (params != null && params.length != 0) {
            this.params = new DerValue(params);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(String oid, byte[] params, String provider) throws IOException {
        this.provider = null;
        if (debug != null) {
            Object[] parms = new Object[]{oid, params, provider};
            debug.entry(16384L, (Object)className, "AlgorithmId", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        try {
            this.algid = new ObjectIdentifier(oid);
        }
        catch (Exception e) {
            this.algid = null;
        }
        if (params != null && params.length != 0) {
            this.params = new DerValue(params);
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier oid, AlgorithmParameters algparams) {
        block4: {
            this.provider = null;
            if (debug != null) {
                debug.entry(16384L, className, "AlgorithmId", oid, algparams);
            }
            this.algid = oid;
            this.algParams = algparams;
            try {
                this.params = this.algParams != null ? new DerValue(this.algParams.getEncoded()) : null;
            }
            catch (Exception e) {
                this.params = null;
                if (debug == null) break block4;
                debug.exception(16384L, className, "AlgorithmId", e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public static AlgorithmId getAlgorithmId(String algname) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAlgorithmId", algname);
            debug.exit(16384L, (Object)className, "getAlgorithmId", AlgorithmId.get(algname));
        }
        return AlgorithmId.get(algname);
    }

    public AlgorithmParameters getAlgParameters() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgParameters");
            debug.exit(16384L, (Object)className, "getAlgParameters", this.algParams);
        }
        return this.algParams;
    }

    public byte[] getParameters() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getParameters");
        }
        if (this.params != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getParameters_1", this.params.toByteArray());
            }
            return this.params.toByteArray();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getParameters_2", null);
        }
        return null;
    }

    public static AlgorithmId get(AlgorithmParameters algparams) throws NoSuchAlgorithmException {
        ObjectIdentifier oid = null;
        String algname = algparams.getAlgorithm();
        oid = AlgorithmId.algOID(algname);
        if (oid == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + algname);
        }
        return new AlgorithmId(oid, algparams);
    }

    public static AlgorithmId get(String algname) throws NoSuchAlgorithmException {
        ObjectIdentifier oid;
        if (debug != null) {
            debug.entry(49152L, (Object)className, "get", algname);
        }
        if ((oid = AlgorithmId.algOID(algname)) == null) {
            if (debug != null) {
                debug.text(49152L, className, "get", "unrecognized algorithm name: " + algname);
            }
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + algname);
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "get", new AlgorithmId(oid));
        }
        return new AlgorithmId(oid);
    }

    public static AlgorithmId get(String algname, String provider) throws NoSuchAlgorithmException {
        ObjectIdentifier oid;
        if (debug != null) {
            debug.entry(49152L, className, "get", algname, provider);
        }
        if ((oid = AlgorithmId.algOID(algname)) == null) {
            if (debug != null) {
                debug.text(49152L, className, "get", "unrecognized algorithm name: " + algname);
            }
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + algname);
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "get", new AlgorithmId(oid, provider));
        }
        return new AlgorithmId(oid, provider);
    }

    public static AlgorithmId parse(DerValue val) throws IOException {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "parse", val);
            debug.exit(49152L, className, "parse");
        }
        return AlgorithmId.parse(val, null);
    }

    public static AlgorithmId parse(DerValue val, String provider) throws IOException {
        DerValue params;
        if (debug != null) {
            debug.entry(49152L, className, "parse", val, provider);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(49152L, className, "parse", "algid parse error, not a sequence");
            }
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream in = val.toDerInputStream();
        ObjectIdentifier algid = in.getOID();
        if (in.available() == 0) {
            params = null;
        } else {
            params = in.getDerValue();
            if (params.getTag() == 5) {
                params = null;
            }
        }
        AlgorithmId alg = new AlgorithmId(algid, params, provider);
        if (params != null) {
            alg.decodeParams();
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "parse", alg);
        }
        return alg;
    }

    public AlgorithmId(ObjectIdentifier oid) {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgorithmId", oid);
        }
        this.algid = oid;
        this.algParams = null;
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    public AlgorithmId(ObjectIdentifier oid, String provider) {
        this.provider = null;
        if (debug != null) {
            debug.entry(16384L, className, "AlgorithmId", oid, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.algid = oid;
        this.algParams = null;
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    private AlgorithmId(ObjectIdentifier oid, DerValue params, String provider) throws IOException {
        this.provider = null;
        if (debug != null) {
            Object[] parms = new Object[]{oid, params, provider};
            debug.entry(16384L, (Object)className, "AlgorithmId", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.algid = oid;
        this.params = params;
        if (this.params != null) {
            this.decodeParams();
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgorithmId");
        }
    }

    protected void decodeParams() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "decodeParams");
        }
        if (this.params == null) {
            this.algParams = null;
            if (debug != null) {
                debug.exit(16384L, className, "decodeParams_1");
            }
            return;
        }
        try {
            this.algParams = this.provider != null ? AlgorithmParameters.getInstance(this.algid.toString(), this.provider) : AlgorithmParameters.getInstance(this.algid.toString());
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams_1", e.toString());
            }
            try {
                this.algParams = this.provider != null ? AlgorithmParameters.getInstance(this.algName(), this.provider) : AlgorithmParameters.getInstance(this.algName());
            }
            catch (NoSuchAlgorithmException e2) {
                if (debug != null) {
                    debug.text(16384L, className, "decodeParams_2", e2.toString());
                    debug.exit(16384L, className, "decodeParams_2");
                }
                try {
                    if (debug != null) {
                        debug.text(16384L, className, "decodeParams_2", " try EC internal provider get algid" + this.algid.toString());
                    }
                    this.algParams = AlgorithmParameters.getInstance(this.algid.toString(), ECKeyFactory.ecInternalProvider);
                    if (debug != null) {
                        debug.text(16384L, className, "decodeParams_2", "get algParams = " + this.algParams);
                    }
                }
                catch (Exception ei) {
                    this.algParams = null;
                    return;
                }
            }
            catch (NoSuchProviderException nspe) {
                if (debug != null) {
                    debug.text(16384L, className, "decodeParams_3", nspe.toString());
                    debug.exit(16384L, className, "decodeParams_3");
                }
                this.algParams = null;
                return;
            }
        }
        catch (NoSuchProviderException nspe2) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams_4", nspe2.toString());
                debug.exit(16384L, className, "decodeParams_4");
            }
            this.algParams = null;
            return;
        }
        this.algParams.init(this.params.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "decodeParams_5");
        }
    }

    public final void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.derEncode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        bytes.putOID(this.algid);
        if (this.params == null && this.algParams != null) {
            this.params = new DerValue(this.algParams.getEncoded());
        }
        if (this.params == null) {
            bytes.putNull();
        } else {
            bytes.putDerValue(this.params);
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public final byte[] encode() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "encode");
        }
        bytes.putOID(this.algid);
        if (this.params == null) {
            bytes.putNull();
        } else {
            bytes.putDerValue(this.params);
        }
        out.write((byte)48, bytes);
        byte[] retval = out.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", retval);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ObjectIdentifier algOID(String name) {
        if (AlgorithmId.debug != null) {
            AlgorithmId.debug.entry(8192L, (Object)AlgorithmId.className, "algOID", name);
        }
        if (name.indexOf(46) != -1) {
            if (name.startsWith("OID.")) {
                an_oid = null;
                try {
                    an_oid = new ObjectIdentifier(name.substring("OID.".length()));
                }
                catch (Exception e) {
                    an_oid = null;
                }
                if (AlgorithmId.debug != null) {
                    AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_1", an_oid);
                }
                return an_oid;
            }
            an_oid = null;
            try {
                an_oid = new ObjectIdentifier(name);
            }
            catch (Exception e) {
                an_oid = null;
            }
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_2", an_oid);
            }
            return an_oid;
        }
        if (name.equalsIgnoreCase("DES")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_3", AlgorithmId.DESCBC_oid);
            }
            return AlgorithmId.DESCBC_oid;
        }
        if (name.equalsIgnoreCase("tripleDES")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_4", AlgorithmId.tripleDESCBC_oid);
            }
            return AlgorithmId.tripleDESCBC_oid;
        }
        if (name.equalsIgnoreCase("3DES")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_5", AlgorithmId.tripleDESCBC_oid);
            }
            return AlgorithmId.tripleDESCBC_oid;
        }
        if (name.equalsIgnoreCase("DESede")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_6", AlgorithmId.tripleDESCBC_oid);
            }
            return AlgorithmId.tripleDESCBC_oid;
        }
        if (name.equalsIgnoreCase("RC2")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_7", AlgorithmId.RC2CBC_oid);
            }
            return AlgorithmId.RC2CBC_oid;
        }
        if (name.equalsIgnoreCase("PBEWithMD2AndDES")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_8", PKCSOID.PBEWITHMD2ANDDES_CBC_OID);
            }
            return PKCSOID.PBEWITHMD2ANDDES_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithMD2AndRC2")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_9", PKCSOID.PBEWITHMD2ANDRC2_CBC_OID);
            }
            return PKCSOID.PBEWITHMD2ANDRC2_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithMD5AndDES")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_10", PKCSOID.PBEWITHMD5ANDDES_CBC_OID);
            }
            return PKCSOID.PBEWITHMD5ANDDES_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithMD5AndRC2")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_11", PKCSOID.PBEWITHMD5ANDRC2_CBC_OID);
            }
            return PKCSOID.PBEWITHMD5ANDRC2_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHA1AndDES") || name.equalsIgnoreCase("PBEWithSHAAndDES")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_12", PKCSOID.PBEWITHSHA1ANDDES_CBC_OID);
            }
            return PKCSOID.PBEWITHSHA1ANDDES_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHA1AndRC2") || name.equalsIgnoreCase("PBEWithSHAAndRC2")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_13", PKCSOID.PBEWITHSHA1ANDRC2_CBC_OID);
            }
            return PKCSOID.PBEWITHSHA1ANDRC2_CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd40BitRC4") || name.equalsIgnoreCase("PBEWithSHA1And40BitRC4") || name.equalsIgnoreCase("PBEWithSHA-1And40BitRC4")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_14", PKCSOID.PBEWITHSHAAND40BITRC4_OID);
            }
            return PKCSOID.PBEWITHSHAAND40BITRC4_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd128BitRC4") || name.equalsIgnoreCase("PBEWithSHA1And128BitRC4") || name.equalsIgnoreCase("PBEWithSHA-1And128BitRC4")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_15", PKCSOID.PBEWITHSHAAND128BITRC4_OID);
            }
            return PKCSOID.PBEWITHSHAAND128BITRC4_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd3KeyTripleDes") || name.equalsIgnoreCase("PBEWithSHA1And3KeyTripleDes") || name.equalsIgnoreCase("PBEWithSHA-1And3KeyTripleDes")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_16", PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd2KeyTripleDes") || name.equalsIgnoreCase("PBEWithSHA1And2KeyTripleDes") || name.equalsIgnoreCase("PBEWithSHA-1And2KeyTripleDes")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_17", PKCSOID.PBEWITHSHAAND2KEYTRIPLEDESCBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND2KEYTRIPLEDESCBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd40BitRC2") || name.equalsIgnoreCase("PBEWithSHA1And40BitRC2") || name.equalsIgnoreCase("PBEWithSHA-1And40BitRC2")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_18", PKCSOID.PBEWITHSHAAND40BITRC2CBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND40BITRC2CBC_OID;
        }
        if (name.equalsIgnoreCase("PBEWithSHAAnd128BitRC2") || name.equalsIgnoreCase("PBEWithSHA1And128BitRC2") || name.equalsIgnoreCase("PBEWithSHA-1And128BitRC2")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_19", PKCSOID.PBEWITHSHAAND128BITRC2CBC_OID);
            }
            return PKCSOID.PBEWITHSHAAND128BITRC2CBC_OID;
        }
        if (name.equalsIgnoreCase("MD5")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_20", AlgorithmId.MD5_oid);
            }
            return AlgorithmId.MD5_oid;
        }
        if (name.equalsIgnoreCase("MD2")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_21", AlgorithmId.MD2_oid);
            }
            return AlgorithmId.MD2_oid;
        }
        if (name.equalsIgnoreCase("SHA") || name.equalsIgnoreCase("SHA1") || name.equalsIgnoreCase("SHA-1")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_22", AlgorithmId.SHA_oid);
            }
            return AlgorithmId.SHA_oid;
        }
        if (name.equalsIgnoreCase("SHA-256") || name.equalsIgnoreCase("SHA256")) {
            return AlgorithmId.SHA256_oid;
        }
        if (name.equalsIgnoreCase("SHA-384") || name.equalsIgnoreCase("SHA384")) {
            return AlgorithmId.SHA384_oid;
        }
        if (name.equalsIgnoreCase("SHA-512") || name.equalsIgnoreCase("SHA512")) {
            return AlgorithmId.SHA512_oid;
        }
        if (name.equalsIgnoreCase("SHA-224") || name.equalsIgnoreCase("SHA224")) {
            return AlgorithmId.SHA224_oid;
        }
        if (name.equalsIgnoreCase("RSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_23", AlgorithmId.RSAEncryption_oid);
            }
            return AlgorithmId.RSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("DiffieHellman") || name.equalsIgnoreCase("Diffie-Hellman") || name.equalsIgnoreCase("DH")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_24", AlgorithmId.DH_oid);
            }
            return AlgorithmId.DH_oid;
        }
        if (name.equalsIgnoreCase("DSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_25", AlgorithmId.DSA_oid);
            }
            return AlgorithmId.DSA_oid;
        }
        if (name.equalsIgnoreCase("EC")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_36", AlgorithmId.EC_oid);
            }
            return AlgorithmId.EC_oid;
        }
        if (name.equalsIgnoreCase("MD5withRSA") || name.equalsIgnoreCase("MD5/RSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_26", AlgorithmId.md5WithRSAEncryption_oid);
            }
            return AlgorithmId.md5WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("MD2withRSA") || name.equalsIgnoreCase("MD2/RSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_27", AlgorithmId.md2WithRSAEncryption_oid);
            }
            return AlgorithmId.md2WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHAwithDSA") || name.equalsIgnoreCase("SHA1withDSA") || name.equalsIgnoreCase("SHA/DSA") || name.equalsIgnoreCase("SHA-1/DSA") || name.equalsIgnoreCase("SHA1/DSA") || name.equalsIgnoreCase("DSAWithSHA1")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_28", AlgorithmId.sha1WithDSA_oid);
            }
            return AlgorithmId.sha1WithDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA224withDSA") || name.equalsIgnoreCase("SHA224/DSA") || name.equalsIgnoreCase("SHA-224/DSA") || name.equalsIgnoreCase("DSAWithSHA224")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_28", AlgorithmId.sha224WithDSA_oid);
            }
            return AlgorithmId.sha224WithDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA256withDSA") || name.equalsIgnoreCase("SHA256/DSA") || name.equalsIgnoreCase("SHA-256/DSA") || name.equalsIgnoreCase("DSAWithSHA256")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_28", AlgorithmId.sha256WithDSA_oid);
            }
            return AlgorithmId.sha256WithDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA1WithRSA") || name.equalsIgnoreCase("SHA-1/RSA") || name.equalsIgnoreCase("SHA1/RSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_29", AlgorithmId.sha1WithRSAEncryption_oid);
            }
            return AlgorithmId.sha1WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA224WithRSA") || name.equalsIgnoreCase("SHA-224/RSA") || name.equalsIgnoreCase("SHA224/RSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_42", AlgorithmId.sha224WithRSAEncryption_oid);
            }
            return AlgorithmId.sha224WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA256WithRSA") || name.equalsIgnoreCase("SHA2WithRSA") || name.equalsIgnoreCase("SHA-256/RSA") || name.equalsIgnoreCase("SHA256/RSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_43", AlgorithmId.sha256WithRSAEncryption_oid);
            }
            return AlgorithmId.sha256WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA384WithRSA") || name.equalsIgnoreCase("SHA-384/RSA") || name.equalsIgnoreCase("SHA384/RSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_44", AlgorithmId.sha384WithRSAEncryption_oid);
            }
            return AlgorithmId.sha384WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA512WithRSA") || name.equalsIgnoreCase("SHA-512/RSA") || name.equalsIgnoreCase("SHA512/RSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_45", AlgorithmId.sha512WithRSAEncryption_oid);
            }
            return AlgorithmId.sha512WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHAWithRSA") || name.equalsIgnoreCase("SHA/RSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_30", AlgorithmId.sha1WithRSAEncryption_oid);
            }
            return AlgorithmId.sha1WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA1withECDSA") || name.equalsIgnoreCase("SHA-1/ECDSA") || name.equalsIgnoreCase("ECDSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_37", AlgorithmId.sha1WithECDSA_oid);
            }
            return AlgorithmId.sha1WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA224withECDSA") || name.equalsIgnoreCase("SHA-224/ECDSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_38", AlgorithmId.sha224WithECDSA_oid);
            }
            return AlgorithmId.sha224WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA256withECDSA") || name.equalsIgnoreCase("SHA-256/ECDSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_39", AlgorithmId.sha256WithECDSA_oid);
            }
            return AlgorithmId.sha256WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA384withECDSA") || name.equalsIgnoreCase("SHA-384/ECDSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_40", AlgorithmId.sha384WithECDSA_oid);
            }
            return AlgorithmId.sha384WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA512withECDSA") || name.equalsIgnoreCase("SHA-512/ECDSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_41", AlgorithmId.sha512WithECDSA_oid);
            }
            return AlgorithmId.sha512WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("DatawithECDSA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_42", AlgorithmId.specifiedWithECDSA_oid);
            }
            return AlgorithmId.specifiedWithECDSA_oid;
        }
        if (name.equalsIgnoreCase("RSAPSS")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_46", AlgorithmId.RSAPSS_oid);
            }
            return AlgorithmId.RSAPSS_oid;
        }
        if (name.equalsIgnoreCase("MGF1")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_47", AlgorithmId.mgf1_oid);
            }
            return AlgorithmId.mgf1_oid;
        }
        if (name.equalsIgnoreCase("HmacSHA1") || name.equalsIgnoreCase("HmacSHA")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_31", AlgorithmId.HmacSHA1_oid);
            }
            return AlgorithmId.HmacSHA1_oid;
        }
        if (name.equalsIgnoreCase("PBM") || name.equalsIgnoreCase("PasswordBasedMac")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_32", AlgorithmId.PasswordBasedMac_oid);
            }
            return AlgorithmId.PasswordBasedMac_oid;
        }
        if (name.equalsIgnoreCase("AES")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_36", AlgorithmId.AES_oid);
            }
            return AlgorithmId.AES_oid;
        }
        if (name.equalsIgnoreCase("AES128")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_33", AlgorithmId.AES128CBC_oid);
            }
            return AlgorithmId.AES128CBC_oid;
        }
        if (name.equalsIgnoreCase("AES192")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_34", AlgorithmId.AES192CBC_oid);
            }
            return AlgorithmId.AES192CBC_oid;
        }
        if (name.equalsIgnoreCase("AES256")) {
            if (AlgorithmId.debug != null) {
                AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_35", AlgorithmId.AES256CBC_oid);
            }
            return AlgorithmId.AES256CBC_oid;
        }
        if (AlgorithmId.initOidTable) ** GOTO lbl241
        var2_6 = AlgorithmId.class;
        synchronized (AlgorithmId.class) {
            if (AlgorithmId.initOidTable) ** GOTO lbl240
            provs = Security.getProviders();
            i = 0;
            while (true) {
                if (i < provs.length) {
                    enumCount = provs[i].keys();
                } else {
                    if (AlgorithmId.oidTable == null) {
                        AlgorithmId.oidTable = new HashMap<String, ObjectIdentifier>(1);
                    }
                    AlgorithmId.initOidTable = true;
lbl240:
                    // 2 sources

                    // ** MonitorExit[var2_6] (shouldn't be in output)
lbl241:
                    // 2 sources

                    if (AlgorithmId.debug != null) {
                        AlgorithmId.debug.exit(8192L, (Object)AlgorithmId.className, "algOID_33", AlgorithmId.oidTable.get(name.toUpperCase(Locale.US)));
                    }
                    return AlgorithmId.oidTable.get(name.toUpperCase(Locale.US));
                }
                while (enumCount.hasMoreElements()) {
                    alias = (String)enumCount.nextElement();
                    upperCaseAlias = alias.toUpperCase(Locale.US);
                    if (!upperCaseAlias.startsWith("ALG.ALIAS") || (index = upperCaseAlias.indexOf("OID.", 0)) == -1) continue;
                    if ((index += "OID.".length()) == alias.length()) break;
                    if (AlgorithmId.oidTable == null) {
                        AlgorithmId.oidTable = new HashMap<String, ObjectIdentifier>(11);
                    }
                    oidString = alias.substring(index);
                    stdAlgName = provs[i].getProperty(alias);
                    if (stdAlgName != null) {
                        stdAlgName = stdAlgName.toUpperCase(Locale.US);
                    }
                    if (stdAlgName == null || AlgorithmId.oidTable.get(stdAlgName) != null) continue;
                    try {
                        AlgorithmId.oidTable.put(stdAlgName, new ObjectIdentifier(oidString));
                    }
                    catch (Exception e) {
                        AlgorithmId.oidTable.put(stdAlgName, null);
                    }
                }
                ++i;
            }
        }
    }

    private String algName() {
        if (debug != null) {
            debug.entry(8192L, className, "algName");
        }
        if (this.algid.equals(DESCBC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_1", "DES");
            }
            return "DES";
        }
        if (this.algid.equals(tripleDESCBC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_2", "DESede");
            }
            return "DESede";
        }
        if (this.algid.equals(RC2CBC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_3", "RC2");
            }
            return "RC2";
        }
        if (this.algid.equals(MD5_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_4", "MD5");
            }
            return "MD5";
        }
        if (this.algid.equals(MD2_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_5", "MD2");
            }
            return "MD2";
        }
        if (this.algid.equals(SHA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_6", "SHA-1");
            }
            return "SHA-1";
        }
        if (this.algid.equals(SHA224_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_50", "SHA-224");
            }
            return "SHA-224";
        }
        if (this.algid.equals(SHA256_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_46", "SHA-256");
            }
            return "SHA-256";
        }
        if (this.algid.equals(SHA384_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_47", "SHA-384");
            }
            return "SHA-384";
        }
        if (this.algid.equals(SHA512_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_48", "SHA-512");
            }
            return "SHA-512";
        }
        if (this.algid.equals(RSAEncryption_oid) || this.algid.equals(RSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_7", "RSA");
            }
            return "RSA";
        }
        if (this.algid.equals(DH_oid) || this.algid.equals(DH_PKIX_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_8", "DiffieHellman");
            }
            return "DiffieHellman";
        }
        if (this.algid.equals(DSA_oid) || this.algid.equals(DSA_OIW_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_9", "DSA");
            }
            return "DSA";
        }
        if (this.algid.equals(EC_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_36", "EC");
            }
            return "EC";
        }
        if (this.algid.equals(md5WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_10", "MD5withRSA");
            }
            return "MD5withRSA";
        }
        if (this.algid.equals(md2WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_11", "MD2withRSA");
            }
            return "MD2withRSA";
        }
        if (this.algid.equals(sha1WithDSA_oid) || this.algid.equals(sha1WithDSA_OIW_oid) || this.algid.equals(shaWithDSA_OIW_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_12", "SHA1withDSA");
            }
            return "SHA1withDSA";
        }
        if (this.algid.equals(sha224WithDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_12a", "SHA224withDSA");
            }
            return "SHA224withDSA";
        }
        if (this.algid.equals(sha256WithDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_12a", "SHA256withDSA");
            }
            return "SHA256withDSA";
        }
        if (this.algid.equals(sha1WithRSAEncryption_oid) || this.algid.equals(sha1WithRSAEncryption_OIW_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_13", "SHA1withRSA");
            }
            return "SHA1withRSA";
        }
        if (this.algid.equals(sha224WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_49", "SHA224withRSA");
            }
            return "SHA224withRSA";
        }
        if (this.algid.equals(sha256WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_43", "SHA256withRSA");
            }
            return "SHA256withRSA";
        }
        if (this.algid.equals(sha384WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_44", "SHA384withRSA");
            }
            return "SHA384withRSA";
        }
        if (this.algid.equals(sha512WithRSAEncryption_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_45", "SHA512withRSA");
            }
            return "SHA512withRSA";
        }
        if (this.algid.equals(sha1WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_37", "SHA1withECDSA");
            }
            return "SHA1withECDSA";
        }
        if (this.algid.equals(sha224WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_38", "SHA224withECDSA");
            }
            return "SHA224withECDSA";
        }
        if (this.algid.equals(sha256WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_39", "SHA256withECDSA");
            }
            return "SHA256withECDSA";
        }
        if (this.algid.equals(sha384WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_40", "SHA384withECDSA");
            }
            return "SHA384withECDSA";
        }
        if (this.algid.equals(sha512WithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_41", "SHA512withECDSA");
            }
            return "SHA512withECDSA";
        }
        if (this.algid.equals(specifiedWithECDSA_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_42", "SpecifiedwithECDSA");
            }
            return "DatawithECDSA";
        }
        if (this.algid.equals(RSAPSS_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_50", "RSAPSS");
            }
            return "RSAPSS";
        }
        if (this.algid.equals(mgf1_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_51", "MGF1");
            }
            return "MGF1";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD2ANDDES_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_14", "PBEWithMD2AndDES");
            }
            return "PBEWithMD2AndDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD2ANDRC2_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_15", "PBEWithMD2AndRC2");
            }
            return "PBEWithMD2AndRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD5ANDDES_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_16", "PBEWithMD5AndDES");
            }
            return "PBEWithMD5AndDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHMD5ANDRC2_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_17", "PBEWithMD5AndRC2");
            }
            return "PBEWithMD5AndRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAANDDES_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_18", "PBEWithSHAAndDES");
            }
            return "PBEWithSHAAndDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAANDRC2_CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_19", "PBEWithSHAAndRC2");
            }
            return "PBEWithSHAAndRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND40BITRC4_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_20", "PBEWithSHAAnd40BitRC4");
            }
            return "PBEWithSHAAnd40BitRC4";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND128BITRC4_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_21", "PBEWithSHAAnd128BitRC4");
            }
            return "PBEWithSHAAnd128BitRC4";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND3KEYTRIPLEDESCBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_22", "PBEWithSHAAnd3KeyTripleDES");
            }
            return "PBEWithSHAAnd3KeyTripleDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND2KEYTRIPLEDESCBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_23", "PBEWithSHAAnd2KeyTripleDES");
            }
            return "PBEWithSHAAnd2KeyTripleDES";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND40BITRC2CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_24", "PBEWithSHAAnd40BitRC2");
            }
            return "PBEWithSHAAnd40BitRC2";
        }
        if (this.algid.equals(PKCSOID.PBEWITHSHAAND128BITRC2CBC_OID)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_25", "PBEWithSHAAnd128BitRC2");
            }
            return "PBEWithSHAAnd128BitRC2";
        }
        if (this.algid.equals(HmacSHA1_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_26", "HmacSHA1");
            }
            return "HmacSHA1";
        }
        if (this.algid.equals(PasswordBasedMac_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_27", "PasswordBasedMac");
            }
            return "PasswordBasedMac";
        }
        if (this.algid.equals(AES_oid)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "algName_31", "AES");
            }
            return "AES";
        }
        if (this.algid.equals(AES128CBC_oid) && debug != null) {
            debug.exit(8192L, (Object)className, "algName_28", "AES128");
        }
        if (this.algid.equals(AES192CBC_oid) && debug != null) {
            debug.exit(8192L, (Object)className, "algName_29", "AES192");
        }
        if (this.algid.equals(AES256CBC_oid) && debug != null) {
            debug.exit(8192L, (Object)className, "algName_30", "AES256");
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "algName_28", this.algid.toString());
        }
        return this.algid.toString();
    }

    public final ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.algid);
        }
        return this.algid;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", this.algName());
        }
        return this.algName();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.algName() + this.paramsToString());
        }
        return this.algName() + this.paramsToString();
    }

    public byte[] getEncodedParams() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedParams");
        }
        if (this.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedParams_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncodedParams_2", this.params.toByteArray());
        }
        return this.params.toByteArray();
    }

    protected String paramsToString() {
        if (debug != null) {
            debug.entry(16384L, className, "paramsToString");
        }
        if (this.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "paramsToString_1", "");
            }
            return "";
        }
        if (this.algParams != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "paramsToString_2", this.algParams.toString());
            }
            return this.algParams.toString();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "paramsToString_3", ", params unparsed");
        }
        return ", params unparsed";
    }

    public boolean equals(AlgorithmId other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (!this.algid.equals(other.algid)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (this.params == null && other.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        if (this.params == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", this.params.equals(other.params));
        }
        return this.params.equals(other.params);
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other instanceof AlgorithmId) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((AlgorithmId)other));
            }
            return this.equals((AlgorithmId)other);
        }
        if (other instanceof ObjectIdentifier) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", this.equals((ObjectIdentifier)other));
            }
            return this.equals((ObjectIdentifier)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_3", false);
        }
        return false;
    }

    public final boolean equals(ObjectIdentifier id) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", id);
            debug.exit(16384L, (Object)className, "equals", this.algid.equals(id));
        }
        return this.algid.equals(id);
    }

    public int hashCode() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(this.algid.toString());
        sbuf.append(this.paramsToString());
        return sbuf.toString().hashCode();
    }

    public static String makeSigAlg(String digAlg, String encAlg) {
        if ((digAlg = digAlg.replace("-", "").toUpperCase(Locale.US)).equalsIgnoreCase("SHA")) {
            digAlg = "SHA1";
        }
        if ((encAlg = encAlg.toUpperCase(Locale.US)).equals("EC")) {
            encAlg = "ECDSA";
        }
        return digAlg + "with" + encAlg;
    }

    public static String getEncAlgFromSigAlg(String signatureAlgorithm) {
        int and;
        signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.US);
        int with = signatureAlgorithm.indexOf("WITH");
        String keyAlgorithm = null;
        if (with > 0 && (keyAlgorithm = (and = signatureAlgorithm.indexOf("AND", with + 4)) > 0 ? signatureAlgorithm.substring(with + 4, and) : signatureAlgorithm.substring(with + 4)).equalsIgnoreCase("ECDSA")) {
            keyAlgorithm = "EC";
        }
        return keyAlgorithm;
    }

    public static String getDigAlgFromSigAlg(String signatureAlgorithm) {
        int with = (signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.US)).indexOf("WITH");
        if (with > 0) {
            return signatureAlgorithm.substring(0, with);
        }
        return null;
    }

    static {
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.x509.AlgorithmId";
        MD2_data = new int[]{1, 2, 840, 113549, 2, 2};
        MD5_data = new int[]{1, 2, 840, 113549, 2, 5};
        SHA1_OIW_data = new int[]{1, 3, 14, 3, 2, 26};
        SHA256_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 1};
        SHA384_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 2};
        SHA512_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 3};
        SHA224_data = new int[]{2, 16, 840, 1, 101, 3, 4, 2, 4};
        HmacSHA1_data = new int[]{1, 3, 6, 1, 5, 5, 8, 1, 2};
        PasswordBasedMac_data = new int[]{1, 2, 840, 113533, 7, 66, 13};
        DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
        DH_PKIX_data = new int[]{1, 2, 840, 10046, 2, 1};
        DSA_OIW_data = new int[]{1, 3, 14, 3, 2, 12};
        DSA_PKIX_data = new int[]{1, 2, 840, 10040, 4, 1};
        RSA_data = new int[]{2, 5, 8, 1, 1};
        RSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 1};
        md2WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 2};
        md5WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 4};
        sha1WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 5};
        sha1WithRSAEncryption_OIW_data = new int[]{1, 3, 14, 3, 2, 29};
        sha256WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 11};
        sha384WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 12};
        sha512WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 13};
        sha224WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 14};
        shaWithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 13};
        sha1WithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 27};
        sha224WithDSA_data = new int[]{2, 16, 840, 1, 101, 3, 4, 3, 1};
        sha256WithDSA_data = new int[]{2, 16, 840, 1, 101, 3, 4, 3, 2};
        dsaWithSHA1_PKIX_data = new int[]{1, 2, 840, 10040, 4, 3};
        DESCBC_data = new int[]{1, 3, 14, 3, 2, 7};
        tripleDESCBC_data = new int[]{1, 2, 840, 113549, 3, 7};
        RC2CBC_data = new int[]{1, 2, 840, 113549, 3, 2};
        AES_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1};
        AES128CBC_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 2};
        AES192CBC_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 22};
        AES256CBC_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 42};
        sha1WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 1};
        sha224WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3, 1};
        sha256WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3, 2};
        sha384WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3, 3};
        sha512WithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3, 4};
        specifiedWithECDSA_data = new int[]{1, 2, 840, 10045, 4, 3};
        RSAPSS_data = new int[]{1, 2, 840, 113549, 1, 1, 10};
        mgf1_data = new int[]{1, 2, 840, 113549, 1, 1, 8};
        ecoid_data = new int[]{1, 2, 840, 10045, 2, 1};
        try {
            MD2_oid = new ObjectIdentifier(MD2_data);
            MD5_oid = new ObjectIdentifier(MD5_data);
            SHA_oid = new ObjectIdentifier(SHA1_OIW_data);
            SHA256_oid = new ObjectIdentifier(SHA256_data);
            SHA384_oid = new ObjectIdentifier(SHA384_data);
            SHA512_oid = new ObjectIdentifier(SHA512_data);
            SHA224_oid = new ObjectIdentifier(SHA224_data);
            HmacSHA1_oid = new ObjectIdentifier(HmacSHA1_data);
            PasswordBasedMac_oid = new ObjectIdentifier(PasswordBasedMac_data);
            DH_oid = new ObjectIdentifier(DH_data);
            DH_PKIX_oid = new ObjectIdentifier(DH_PKIX_data);
            DSA_OIW_oid = new ObjectIdentifier(DSA_OIW_data);
            DSA_oid = new ObjectIdentifier(DSA_PKIX_data);
            RSA_oid = new ObjectIdentifier(RSA_data);
            RSAEncryption_oid = new ObjectIdentifier(RSAEncryption_data);
            md2WithRSAEncryption_oid = new ObjectIdentifier(md2WithRSAEncryption_data);
            md5WithRSAEncryption_oid = new ObjectIdentifier(md5WithRSAEncryption_data);
            sha1WithRSAEncryption_oid = new ObjectIdentifier(sha1WithRSAEncryption_data);
            sha1WithRSAEncryption_OIW_oid = new ObjectIdentifier(sha1WithRSAEncryption_OIW_data);
            sha256WithRSAEncryption_oid = new ObjectIdentifier(sha256WithRSAEncryption_data);
            sha384WithRSAEncryption_oid = new ObjectIdentifier(sha384WithRSAEncryption_data);
            sha512WithRSAEncryption_oid = new ObjectIdentifier(sha512WithRSAEncryption_data);
            sha224WithRSAEncryption_oid = new ObjectIdentifier(sha224WithRSAEncryption_data);
            shaWithDSA_OIW_oid = new ObjectIdentifier(shaWithDSA_OIW_data);
            sha1WithDSA_OIW_oid = new ObjectIdentifier(sha1WithDSA_OIW_data);
            sha1WithDSA_oid = new ObjectIdentifier(dsaWithSHA1_PKIX_data);
            sha224WithDSA_oid = new ObjectIdentifier(sha224WithDSA_data);
            sha256WithDSA_oid = new ObjectIdentifier(sha256WithDSA_data);
            DESCBC_oid = new ObjectIdentifier(DESCBC_data);
            tripleDESCBC_oid = new ObjectIdentifier(tripleDESCBC_data);
            RC2CBC_oid = new ObjectIdentifier(RC2CBC_data);
            AES_oid = new ObjectIdentifier(AES_data);
            AES128CBC_oid = new ObjectIdentifier(AES128CBC_data);
            AES192CBC_oid = new ObjectIdentifier(AES192CBC_data);
            AES256CBC_oid = new ObjectIdentifier(AES256CBC_data);
            sha1WithECDSA_oid = new ObjectIdentifier(sha1WithECDSA_data);
            sha224WithECDSA_oid = new ObjectIdentifier(sha224WithECDSA_data);
            sha256WithECDSA_oid = new ObjectIdentifier(sha256WithECDSA_data);
            sha384WithECDSA_oid = new ObjectIdentifier(sha384WithECDSA_data);
            sha512WithECDSA_oid = new ObjectIdentifier(sha512WithECDSA_data);
            specifiedWithECDSA_oid = new ObjectIdentifier(specifiedWithECDSA_data);
            EC_oid = new ObjectIdentifier(ecoid_data);
            RSAPSS_oid = new ObjectIdentifier(RSAPSS_data);
            mgf1_oid = new ObjectIdentifier(mgf1_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

