/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.AbstractAlgorithmConstraints;
import com.ibm.security.util.AlgorithmDecomposer;
import com.ibm.security.util.ConstraintsParameters;
import com.ibm.security.util.Debug;
import com.ibm.security.util.KeyUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    private final String[] disabledAlgorithms;
    private final Constraints algorithmConstraints;

    public DisabledAlgorithmConstraints(String propertyName) {
        this(propertyName, new AlgorithmDecomposer());
    }

    public DisabledAlgorithmConstraints(String propertyName, AlgorithmDecomposer decomposer) {
        super(decomposer);
        this.disabledAlgorithms = DisabledAlgorithmConstraints.getAlgorithms(propertyName);
        this.algorithmConstraints = new Constraints(this.disabledAlgorithms);
    }

    public DisabledAlgorithmConstraints(String[] disabledAlgorithms, AlgorithmDecomposer decomposer) {
        super(decomposer);
        this.disabledAlgorithms = disabledAlgorithms;
        this.algorithmConstraints = new Constraints(disabledAlgorithms);
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        if (!DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, algorithm, this.decomposer)) {
            return false;
        }
        if (parameters != null) {
            return this.algorithmConstraints.permits(algorithm, parameters);
        }
        return true;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        return this.checkConstraints(primitives, "", key, null);
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(primitives, algorithm, key, parameters);
    }

    public final void permits(ConstraintsParameters cp) throws CertPathValidatorException {
        this.permits(cp.getAlgorithm(), cp);
    }

    public final void permits(String algorithm, Key key, AlgorithmParameters params, String variant) throws CertPathValidatorException {
        this.permits(algorithm, new ConstraintsParameters(algorithm, params, key, variant == null ? "generic" : variant));
    }

    public final void permits(String algorithm, ConstraintsParameters cp) throws CertPathValidatorException {
        this.algorithmConstraints.permits(algorithm, cp);
    }

    public boolean checkProperty(String param) {
        param = param.toLowerCase(Locale.ENGLISH);
        for (String block : this.disabledAlgorithms) {
            if (block.toLowerCase(Locale.ENGLISH).indexOf(param) < 0) continue;
            return true;
        }
        return false;
    }

    protected boolean checkConstraints(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (algorithm != null && algorithm.length() != 0 && !this.permits(primitives, algorithm, parameters)) {
            return false;
        }
        if (!this.permits(primitives, key.getAlgorithm(), null)) {
            return false;
        }
        return this.algorithmConstraints.permits(key);
    }

    private static class DisabledConstraint
    extends Constraint {
        DisabledConstraint(String algo) {
            this.algorithm = algo;
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + this.algorithm + this.extendedMsg(cp), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }

        @Override
        public boolean permits(Key key) {
            return false;
        }
    }

    private static class KeySizeConstraint
    extends Constraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(String algo, Constraint.Operator operator, int length) {
            this.algorithm = algo;
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = length;
                    break;
                }
                case NE: {
                    this.minSize = length;
                    this.maxSize = length;
                    break;
                }
                case LT: {
                    this.minSize = length;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = length + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = length;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = length > 1 ? length - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            Key key = null;
            if (cp.getPublicKey() != null) {
                key = cp.getPublicKey();
            } else if (cp.getCertificate() != null) {
                key = cp.getCertificate().getPublicKey();
            }
            if (key != null && !this.permitsImpl(key)) {
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(cp);
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize limits. " + this.algorithm + " " + KeyUtil.getKeySize(key) + "bit key" + this.extendedMsg(cp), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.nextConstraint != null && this.nextConstraint.permits(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("KeySizeConstraints.permits(): " + this.algorithm);
            }
            return this.permitsImpl(key);
        }

        @Override
        public boolean permits(AlgorithmParameters parameters) {
            Collection<String> aliases;
            String paramAlg = parameters.getAlgorithm();
            if (!this.algorithm.equalsIgnoreCase(parameters.getAlgorithm()) && !(aliases = AlgorithmDecomposer.getAliases(this.algorithm)).contains(paramAlg)) {
                return true;
            }
            int keySize = KeyUtil.getKeySize(parameters);
            if (keySize == 0) {
                return false;
            }
            if (keySize > 0) {
                return keySize >= this.minSize && keySize <= this.maxSize && this.prohibitedSize != keySize;
            }
            return true;
        }

        private boolean permitsImpl(Key key) {
            if (this.algorithm.compareToIgnoreCase(key.getAlgorithm()) != 0) {
                return true;
            }
            int size = KeyUtil.getKeySize(key);
            if (size == 0) {
                return false;
            }
            if (size > 0) {
                return size >= this.minSize && size <= this.maxSize && this.prohibitedSize != size;
            }
            return true;
        }
    }

    private static class UsageConstraint
    extends Constraint {
        String[] usages;

        UsageConstraint(String algorithm, String[] usages) {
            this.algorithm = algorithm;
            this.usages = usages;
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            for (String usage : this.usages) {
                String v = null;
                if (usage.compareToIgnoreCase("TLSServer") == 0) {
                    v = "tls server";
                } else if (usage.compareToIgnoreCase("TLSClient") == 0) {
                    v = "tls client";
                } else if (usage.compareToIgnoreCase("SignedJAR") == 0) {
                    v = "plugin code signing";
                }
                if (debug != null) {
                    debug.println("Checking if usage constraint \"" + v + "\" matches \"" + cp.getVariant() + "\"");
                    ByteArrayOutputStream ba = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(ba);
                    new Exception().printStackTrace(ps);
                    debug.println(ba.toString());
                }
                if (cp.getVariant().compareTo(v) != 0) continue;
                if (this.next(cp)) {
                    return;
                }
                throw new CertPathValidatorException("Usage constraint " + usage + " check failed: " + this.algorithm + this.extendedMsg(cp), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static class DenyAfterConstraint
    extends Constraint {
        private Date denyAfterDate;
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, MMM d HH:mm:ss z yyyy");

        DenyAfterConstraint(String algo, int year, int month, int day) {
            Calendar c;
            this.algorithm = algo;
            if (debug != null) {
                debug.println("DenyAfterConstraint read in as:  year " + year + ", month = " + month + ", day = " + day);
            }
            if (year > (c = new Calendar.Builder().setTimeZone(TimeZone.getTimeZone("GMT")).setDate(year, month - 1, day).build()).getActualMaximum(1) || year < c.getActualMinimum(1)) {
                throw new IllegalArgumentException("Invalid year given in constraint: " + year);
            }
            if (month - 1 > c.getActualMaximum(2) || month - 1 < c.getActualMinimum(2)) {
                throw new IllegalArgumentException("Invalid month given in constraint: " + month);
            }
            if (day > c.getActualMaximum(5) || day < c.getActualMinimum(5)) {
                throw new IllegalArgumentException("Invalid Day of Month given in constraint: " + day);
            }
            this.denyAfterDate = c.getTime();
            if (debug != null) {
                debug.println("DenyAfterConstraint date set to: " + dateFormat.format(this.denyAfterDate));
            }
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            String errmsg;
            Date currentDate;
            if (cp.getJARTimestamp() != null) {
                currentDate = cp.getJARTimestamp().getTimestamp();
                errmsg = "JAR Timestamp date: ";
            } else if (cp.getPKIXParamDate() != null) {
                currentDate = cp.getPKIXParamDate();
                errmsg = "PKIXParameter date: ";
            } else {
                currentDate = new Date();
                errmsg = "Current date: ";
            }
            if (!this.denyAfterDate.after(currentDate)) {
                if (this.next(cp)) {
                    return;
                }
                throw new CertPathValidatorException("denyAfter constraint check failed: " + this.algorithm + " used with Constraint date: " + dateFormat.format(this.denyAfterDate) + "; " + errmsg + dateFormat.format(currentDate) + this.extendedMsg(cp), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.next(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("DenyAfterConstraints.permits(): " + this.algorithm);
            }
            return this.denyAfterDate.after(new Date());
        }
    }

    private static class jdkCAConstraint
    extends Constraint {
        jdkCAConstraint(String algo) {
            this.algorithm = algo;
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("jdkCAConstraints.permits(): " + this.algorithm);
            }
            if (cp.isTrustedMatch()) {
                if (this.next(cp)) {
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on certificate anchor limits. " + this.algorithm + this.extendedMsg(cp), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static abstract class Constraint {
        String algorithm;
        Constraint nextConstraint = null;

        private Constraint() {
        }

        public boolean permits(Key key) {
            return true;
        }

        public boolean permits(AlgorithmParameters parameters) {
            return true;
        }

        public abstract void permits(ConstraintsParameters var1) throws CertPathValidatorException;

        boolean next(ConstraintsParameters cp) throws CertPathValidatorException {
            if (this.nextConstraint != null) {
                this.nextConstraint.permits(cp);
                return true;
            }
            return false;
        }

        boolean next(Key key) {
            return this.nextConstraint != null && this.nextConstraint.permits(key);
        }

        String extendedMsg(ConstraintsParameters cp) {
            return cp.getCertificate() == null ? "." : " used with certificate: " + cp.getCertificate().getSubjectX500Principal() + (cp.getVariant() != "generic" ? ".  Usage was " + cp.getVariant() : ".");
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String s) {
                switch (s) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException("Error in security property. " + s + " is not a legal Operator");
            }
        }
    }

    private static class Constraints {
        private Map<String, List<Constraint>> constraintsMap = new HashMap<String, List<Constraint>>();

        public Constraints(String[] constraintArray) {
            for (String constraintEntry : constraintArray) {
                int space;
                if (constraintEntry == null || constraintEntry.isEmpty()) continue;
                constraintEntry = constraintEntry.trim();
                if (debug != null) {
                    debug.println("Constraints: " + constraintEntry);
                }
                String algorithm = AlgorithmDecomposer.hashName(((space = constraintEntry.indexOf(32)) > 0 ? constraintEntry.substring(0, space) : constraintEntry).toUpperCase(Locale.ENGLISH));
                List constraintList = this.constraintsMap.getOrDefault(algorithm, new ArrayList(1));
                for (String alias : AlgorithmDecomposer.getAliases(algorithm)) {
                    this.constraintsMap.putIfAbsent(alias, constraintList);
                }
                if (space <= 0) {
                    constraintList.add(new DisabledConstraint(algorithm));
                    continue;
                }
                String policy = constraintEntry.substring(space + 1);
                jdkCAConstraint lastConstraint = null;
                boolean jdkCALimit = false;
                boolean denyAfterLimit = false;
                for (String entry : policy.split("&")) {
                    Matcher matcher;
                    Constraint c;
                    if ((entry = entry.trim()).startsWith("keySize")) {
                        StringTokenizer tokens;
                        if (debug != null) {
                            debug.println("Constraints set to keySize: " + entry);
                        }
                        if (!"keySize".equals((tokens = new StringTokenizer(entry)).nextToken())) {
                            throw new IllegalArgumentException("Error in security property. Constraint unknown: " + entry);
                        }
                        c = new KeySizeConstraint(algorithm, Constraint.Operator.of(tokens.nextToken()), Integer.parseInt(tokens.nextToken()));
                    } else if (entry.equalsIgnoreCase("jdkCA")) {
                        if (debug != null) {
                            debug.println("Constraints set to jdkCA.");
                        }
                        if (jdkCALimit) {
                            throw new IllegalArgumentException("Only one jdkCA entry allowed in property. Constraint: " + constraintEntry);
                        }
                        c = new jdkCAConstraint(algorithm);
                        jdkCALimit = true;
                    } else if (entry.startsWith("denyAfter") && (matcher = Holder.DENY_AFTER_PATTERN.matcher(entry)).matches()) {
                        if (debug != null) {
                            debug.println("Constraints set to denyAfter");
                        }
                        if (denyAfterLimit) {
                            throw new IllegalArgumentException("Only one denyAfter entry allowed in property. Constraint: " + constraintEntry);
                        }
                        int year = Integer.parseInt(matcher.group(1));
                        int month = Integer.parseInt(matcher.group(2));
                        int day = Integer.parseInt(matcher.group(3));
                        c = new DenyAfterConstraint(algorithm, year, month, day);
                        denyAfterLimit = true;
                    } else if (entry.startsWith("usage")) {
                        String[] s = entry.substring(5).trim().split(" ");
                        c = new UsageConstraint(algorithm, s);
                        if (debug != null) {
                            debug.println("Constraints usage length is " + s.length);
                        }
                    } else {
                        throw new IllegalArgumentException("Error in security property. Constraint unknown: " + entry);
                    }
                    if (lastConstraint == null) {
                        constraintList.add(c);
                    } else {
                        lastConstraint.nextConstraint = c;
                    }
                    lastConstraint = c;
                }
            }
        }

        private List<Constraint> getConstraints(String algorithm) {
            return this.constraintsMap.get(algorithm);
        }

        public boolean permits(Key key) {
            List<Constraint> list = this.getConstraints(key.getAlgorithm());
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(key)) continue;
                if (debug != null) {
                    debug.println("keySizeConstraint: failed key constraint check " + KeyUtil.getKeySize(key));
                }
                return false;
            }
            return true;
        }

        public boolean permits(String algorithm, AlgorithmParameters aps) {
            List<Constraint> list = this.getConstraints(algorithm);
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(aps)) continue;
                if (debug != null) {
                    debug.println("keySizeConstraint: failed algorithm parameters constraint check " + aps);
                }
                return false;
            }
            return true;
        }

        public void permits(String algorithm, ConstraintsParameters cp) throws CertPathValidatorException {
            X509Certificate cert = cp.getCertificate();
            if (debug != null) {
                debug.println("Constraints.permits(): " + algorithm + " Variant: " + cp.getVariant());
            }
            HashSet<String> algorithms = new HashSet<String>();
            if (algorithm != null) {
                algorithms.addAll(AlgorithmDecomposer.decomposeOneHash(algorithm));
            }
            if (cert != null) {
                algorithms.add(cert.getPublicKey().getAlgorithm());
            }
            if (cp.getPublicKey() != null) {
                algorithms.add(cp.getPublicKey().getAlgorithm());
            }
            for (String alg : algorithms) {
                List<Constraint> list = this.getConstraints(alg);
                if (list == null) continue;
                for (Constraint constraint : list) {
                    constraint.permits(cp);
                }
            }
        }

        private static class Holder {
            private static final Pattern DENY_AFTER_PATTERN = Pattern.compile("denyAfter\\s+(\\d{4})-(\\d{2})-(\\d{2})");

            private Holder() {
            }
        }
    }
}

