/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.AuthenticatedSafe;
import com.ibm.security.pkcs12.CertBag;
import com.ibm.security.pkcs12.CrlBag;
import com.ibm.security.pkcs12.KeyBag;
import com.ibm.security.pkcs12.MacData;
import com.ibm.security.pkcs12.PKCS12;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs12.SafeContents;
import com.ibm.security.pkcs12.ShroudedKeyBag;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.DigestInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class BasicPFX
extends PKCSDerObject {
    private BigInteger version = BigInteger.valueOf(3L);
    ContentInfo authSafe;
    MacData macData;
    AuthenticatedSafe authSafeContents;
    AuthenticatedSafe verifiedContents;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.BasicPFX";

    BasicPFX() {
        if (debug != null) {
            debug.entry(16384L, className, "BasicPFX");
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "BasicPFX", provider);
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "BasicPFX", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "BasicPFX", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(ContentInfo cinfo, MacData macdata, String provider) {
        super(provider);
        ObjectIdentifier contentType;
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, macdata, provider};
            debug.entry(16384L, (Object)className, "BasicPFX", parms);
        }
        if (!(contentType = cinfo.getContentType()).equals(PKCSOID.SIGNED_DATA_OID) && !contentType.equals(PKCSOID.DATA_OID)) {
            if (debug != null) {
                debug.text(16384L, className, "BasicPFX", "Content type must be Data or SignedData.");
            }
            throw new IllegalArgumentException("Content type must be Data or SignedData.");
        }
        if (contentType.equals(PKCSOID.DATA_OID) && macdata == null) {
            if (debug != null) {
                debug.text(16384L, className, "BasicPFX", "MacData value must be specified for password-integrity mode (content type Data).");
            }
            throw new IllegalArgumentException("MacData value must be specified for password-integrity mode (content type Data).");
        }
        this.authSafe = cinfo;
        this.macData = macdata;
        if (debug != null) {
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(ContentInfo cinfo, MacData macdata) {
        this(cinfo, macdata, null);
        if (debug != null) {
            debug.entry(16384L, className, "BasicPFX", cinfo, macdata);
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "BasicPFX", parms);
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "BasicPFX", parms);
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.authSafe == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "No data to encode.");
            }
            throw new IOException("No data to encode.");
        }
        if (this.authSafe.getContentType().equals(PKCSOID.DATA_OID) && this.macData == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Integrity protection must be applied before encoding.");
            }
            throw new IOException("Integrity protection must be applied before encoding.");
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        this.authSafe.encode(bytes);
        if (this.macData != null) {
            this.macData.encode(bytes);
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof BasicPFX) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((BasicPFX)other));
            }
            return this.equals((BasicPFX)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    @Override
    public int hashCode() {
        try {
            DerOutputStream thisOut = new DerOutputStream();
            this.encode(thisOut);
            int HashVal = Arrays.hashCode(thisOut.toByteArray());
            return HashVal;
        }
        catch (Exception e) {
            return 0;
        }
    }

    boolean equals(BasicPFX other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }

    @Override
    public String toString() {
        String out = "";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = out + "PFX:";
        out = out + "\r\n\tversion: " + this.version;
        out = out + "\r\n\tauthsafe: ";
        out = this.authSafe == null ? out + "null" : out + "\r\n" + this.authSafe.toString();
        out = out + "\r\n\tmacdata: ";
        out = this.macData == null ? out + "null" : out + "\r\n" + this.macData.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        DerInputStream dis;
        DerValue der;
        BigInteger ver;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (this.version == null) {
            this.version = BigInteger.valueOf(3L);
        }
        if (!this.version.equals(ver = (der = (dis = encoding.getData()).getDerValue()).getInteger())) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid version: " + ver + ". Must be 3.");
            }
            throw new IOException("Invalid version: " + ver + ". Must be 3.");
        }
        der = dis.getDerValue();
        this.authSafe = new ContentInfo(der.toByteArray(), this.provider);
        ObjectIdentifier contentType = this.authSafe.getContentType();
        if (!contentType.equals(PKCSOID.SIGNED_DATA_OID) && !contentType.equals(PKCSOID.DATA_OID)) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Content type must be Data or SignedData");
            }
            throw new IOException("Content type must be Data or SignedData");
        }
        if (contentType.equals(PKCSOID.SIGNED_DATA_OID)) {
            if (dis.available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "PFX parsing error - data overrun, bytes = " + encoding.getData().available());
                }
                throw new IOException("PFX parsing error - data overrun, bytes = " + encoding.getData().available());
            }
        } else if (dis.available() != 0) {
            der = dis.getDerValue();
            this.macData = new MacData(der.toByteArray(), this.provider);
            if (dis.available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "PFX parsing error - data overrun, bytes = " + encoding.getData().available());
                }
                throw new IOException("PFX parsing error - data overrun, bytes = " + encoding.getData().available());
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PFX parsing error - MacData is missing");
            }
            throw new IOException("PFX parsing error - MacData is missing");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    int getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version.intValue());
        }
        return this.version.intValue();
    }

    ContentInfo getAuthenticatedSafe() {
        if (debug != null) {
            debug.entry(16384L, className, "getAuthenticatedSafe");
            debug.exit(16384L, (Object)className, "getAuthenticatedSafe", this.authSafe);
        }
        return this.authSafe;
    }

    MacData getMacData() {
        if (debug != null) {
            debug.entry(16384L, className, "getMacData");
            debug.exit(16384L, (Object)className, "getMacData", (MacData)this.macData.clone());
        }
        return (MacData)this.macData.clone();
    }

    String[] getFriendlyNames(char[] pwd) throws PKCSException {
        int i;
        SafeBag[] bags;
        Vector<Object> namesV = new Vector<Object>();
        String[] names = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getFriendlyNames", (Object)pwd);
        }
        try {
            bags = this.getSafeBags(pwd, null, null, false);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getFriendlyNames", e);
            }
            throw new PKCSException(e, "Error extracting SafeBags from PFX (" + e.toString() + ")");
        }
        for (i = 0; i < bags.length; ++i) {
            Object value;
            PKCSAttribute attr;
            PKCSAttributes attrs = bags[i].getAttributes();
            if (attrs == null || (attr = (PKCSAttribute)attrs.getAttribute(PKCSOID.FRIENDLY_NAME_OID)) == null) continue;
            try {
                value = attr.getAttributeValue();
            }
            catch (IOException e) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getFriendlyNames", e);
                continue;
            }
            if (namesV.contains(value)) continue;
            namesV.add(value);
        }
        if (namesV.size() > 0) {
            names = new String[namesV.size()];
            for (i = 0; i < namesV.size(); ++i) {
                names[i] = (String)namesV.elementAt(i);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getFriendlyNames", names);
        }
        return names;
    }

    Vector getAllPrivateKeyEntryAliases(char[] pwd) throws PKCSException {
        Vector<Object> namesV = new Vector<Object>();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAllPrivateKeyEntryAliases", (Object)pwd);
        }
        SafeBag[] nonShroudedKeyBags = null;
        SafeBag[] shroudedKeyBags = null;
        SafeBag[] privateKeyBags = null;
        try {
            shroudedKeyBags = this.getTypedBags(PKCSOID.SHROUDEDKEYBAG_OID, pwd, null, null, false);
            nonShroudedKeyBags = this.getTypedBags(PKCSOID.KEYBAG_OID, pwd, null, null, false);
            if (nonShroudedKeyBags != null && shroudedKeyBags != null) {
                ArrayList<SafeBag> allKeyBags = new ArrayList<SafeBag>(Arrays.asList(nonShroudedKeyBags));
                allKeyBags.addAll(Arrays.asList(shroudedKeyBags));
                privateKeyBags = (SafeBag[])allKeyBags.toArray();
            } else if (nonShroudedKeyBags != null) {
                privateKeyBags = nonShroudedKeyBags;
            } else if (shroudedKeyBags != null) {
                privateKeyBags = shroudedKeyBags;
            }
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getAllPrivateKeyEntryAliases", e);
            }
            throw new PKCSException(e, "Error extracting SafeBags from PFX (" + e.toString() + ")");
        }
        if (privateKeyBags != null) {
            for (int i = 0; i < privateKeyBags.length; ++i) {
                Object value;
                PKCSAttribute attr;
                PKCSAttributes attrs = privateKeyBags[i].getAttributes();
                if (attrs == null || (attr = (PKCSAttribute)attrs.getAttribute(PKCSOID.FRIENDLY_NAME_OID)) == null) continue;
                try {
                    value = attr.getAttributeValue();
                }
                catch (IOException e) {
                    if (debug == null) continue;
                    debug.exception(16384L, className, "getAllPrivateKeyEntryAliases", e);
                    continue;
                }
                if (namesV.contains(value)) continue;
                namesV.add(value);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAllPrivateKeyEntryAliases", namesV);
        }
        return namesV;
    }

    byte[][] getAllLocalKeyIds(char[] pwd) throws PKCSException {
        SafeBag[] bags;
        ArrayList<Object> localKeyIdsList = new ArrayList<Object>();
        Object localKeyIds = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAllLocalKeyIds", (Object)pwd);
        }
        try {
            bags = this.getSafeBags(pwd, null, null, false);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getAllLocalKeyIds", e);
            }
            throw new PKCSException(e, "Error extracting SafeBags from PFX (" + e.toString() + ")");
        }
        for (int i = 0; i < bags.length; ++i) {
            Object value;
            PKCSAttribute attr;
            PKCSAttributes attrs = bags[i].getAttributes();
            if (attrs == null || (attr = (PKCSAttribute)attrs.getAttribute(PKCSOID.LOCAL_KEY_ID_OID)) == null) continue;
            try {
                value = attr.getAttributeValue();
            }
            catch (IOException e) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getAllLocalKeyIds", e);
                continue;
            }
            if (localKeyIdsList.contains(value)) continue;
            localKeyIdsList.add(value);
        }
        if (localKeyIdsList.size() > 0) {
            localKeyIds = new byte[localKeyIdsList.size()][];
            Iterator it = localKeyIdsList.iterator();
            int i = 0;
            while (it.hasNext()) {
                localKeyIds[i] = (byte[])it.next();
                ++i;
            }
        }
        return localKeyIds;
    }

    Certificate[] getCertificatesByLocalKeyId(char[] pwd, byte[] localKeyId) throws PKCSException {
        LinkedList safeBagsList;
        if (debug != null) {
            debug.entry(16384L, className, "getCertificatesByLocalKeyId", pwd, localKeyId.toString());
        }
        if ((safeBagsList = (LinkedList)this.getSafeBagsByLocalKeyId(pwd, localKeyId)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificatesByLocalKeyId_1", null);
            }
            return null;
        }
        LinkedList certBagsList = new LinkedList();
        for (int i = 0; i < safeBagsList.size(); ++i) {
            SafeBag bag = (SafeBag)safeBagsList.get(i);
            ObjectIdentifier oid = bag.getObjectIdentifier();
            if (!oid.equals(PKCSOID.CERTBAG_OID) && !oid.equals(PKCSOID.CERT_TYPES_OID)) continue;
            certBagsList.add(safeBagsList.get(i));
        }
        if (certBagsList.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificatesByLocalKeyId_2", null);
            }
            return null;
        }
        Certificate[] certs = new Certificate[certBagsList.size()];
        for (int i = 0; i < certBagsList.size(); ++i) {
            CertBag bag;
            SafeBag sbag = (SafeBag)certBagsList.get(i);
            try {
                bag = new CertBag(sbag.getValue(), this.provider);
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "getCertificatesByLocalKeyId", e);
                }
                throw new PKCSException(e, "Error extracting CertBags from PFX (" + e.toString() + ")");
            }
            certs[i] = (Certificate)bag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificatesByLocalKeyId_3", certs);
        }
        return certs;
    }

    EncryptedPrivateKeyInfo[] getShroudedKeysByLocalKeyId(char[] pwd, byte[] localKeyId) throws PKCSException {
        LinkedList safeBagsV;
        if (debug != null) {
            debug.entry(16384L, className, "getShroudedKeysByFriendlyName", pwd, localKeyId);
        }
        if ((safeBagsV = (LinkedList)this.getSafeBagsByLocalKeyId(pwd, localKeyId)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_1", null);
            }
            return null;
        }
        LinkedList keyBagsList = new LinkedList();
        for (int i = 0; i < safeBagsV.size(); ++i) {
            SafeBag bag = (SafeBag)safeBagsV.get(i);
            ObjectIdentifier oid = bag.getObjectIdentifier();
            if (!oid.equals(PKCSOID.SHROUDEDKEYBAG_OID)) continue;
            keyBagsList.add(safeBagsV.get(i));
        }
        if (keyBagsList.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_2", null);
            }
            return null;
        }
        EncryptedPrivateKeyInfo[] keys = new EncryptedPrivateKeyInfo[keyBagsList.size()];
        for (int i = 0; i < keyBagsList.size(); ++i) {
            ShroudedKeyBag bag;
            SafeBag sbag = (SafeBag)keyBagsList.get(i);
            try {
                bag = new ShroudedKeyBag(sbag.getValue(), this.provider);
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "getShroudedKeysByFriendlyName", e);
                }
                throw new PKCSException(e, "Error extracting ShroudedKeyBags from PFX (" + e.toString() + ")");
            }
            keys[i] = (EncryptedPrivateKeyInfo)bag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_3", keys);
        }
        return keys;
    }

    byte[] getLocalKeyIdOfShroudedKey(EncryptedPrivateKeyInfo shroudedKey, char[] pwd) throws PKCSException, IOException {
        EncryptedPrivateKeyInfo testShroudedKey = null;
        SafeBag[] shroudedSafeBags = this.getTypedBags(PKCSOID.SHROUDEDKEYBAG_OID, pwd, null, null, false);
        if (shroudedSafeBags == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getLocalKeyIdOfShroudedKey", null);
            }
            return null;
        }
        for (int i = 0; i < shroudedSafeBags.length; ++i) {
            PKCSAttribute attr;
            byte[] encoding = shroudedSafeBags[i].getValue();
            testShroudedKey = new EncryptedPrivateKeyInfo(encoding, this.provider);
            if (!testShroudedKey.equals((Object)shroudedKey)) continue;
            PKCSAttributes attrs = shroudedSafeBags[i].getAttributes();
            if (attrs != null && (attr = (PKCSAttribute)attrs.getAttribute(PKCSOID.LOCAL_KEY_ID_OID)) != null) {
                return (byte[])attr.getAttributeValue();
            }
            return null;
        }
        return null;
    }

    byte[] getLocalKeyIdOfPrivateKey(PrivateKeyInfo privateKey, char[] pwd) throws PKCSException, IOException {
        PrivateKeyInfo testPrivateKey = null;
        SafeBag[] safeBags = this.getTypedBags(PKCSOID.KEYBAG_OID, pwd, null, null, false);
        if (safeBags == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getLocalKeyIdOfPrivateKey", null);
            }
            return null;
        }
        for (int i = 0; i < safeBags.length; ++i) {
            PKCSAttribute attr;
            byte[] encoding = safeBags[i].getValue();
            testPrivateKey = new PrivateKeyInfo(encoding, this.provider);
            if (!testPrivateKey.equals((Object)privateKey)) continue;
            PKCSAttributes attrs = safeBags[i].getAttributes();
            if (attrs != null && (attr = (PKCSAttribute)attrs.getAttribute(PKCSOID.LOCAL_KEY_ID_OID)) != null) {
                return (byte[])attr.getAttributeValue();
            }
            return null;
        }
        return null;
    }

    String getFriendlyNameOfShroudedKey(EncryptedPrivateKeyInfo shroudedKey, char[] pwd) throws PKCSException, IOException {
        EncryptedPrivateKeyInfo testShroudedKey = null;
        SafeBag[] shroudedSafeBags = this.getTypedBags(PKCSOID.SHROUDEDKEYBAG_OID, pwd, null, null, false);
        if (shroudedSafeBags == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFriendlyNameOfShroudedKey", null);
            }
            return null;
        }
        for (int i = 0; i < shroudedSafeBags.length; ++i) {
            PKCSAttribute attr;
            byte[] encoding = shroudedSafeBags[i].getValue();
            testShroudedKey = new EncryptedPrivateKeyInfo(encoding, this.provider);
            if (!testShroudedKey.equals((Object)shroudedKey)) continue;
            PKCSAttributes attrs = shroudedSafeBags[i].getAttributes();
            if (attrs != null && (attr = (PKCSAttribute)attrs.getAttribute(PKCSOID.FRIENDLY_NAME_OID)) != null) {
                return (String)attr.getAttributeValue();
            }
            return null;
        }
        return null;
    }

    Certificate[] getCertificatesByFriendlyName(char[] pwd, String friendlyName) throws PKCSException {
        Vector safeBagsV;
        if (debug != null) {
            debug.entry(16384L, className, "getCertificatesByFriendlyName", pwd, friendlyName);
        }
        if ((safeBagsV = this.getSafeBagsByFriendlyName(pwd, friendlyName)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificatesByFriendlyName_1", null);
            }
            return null;
        }
        Vector certBagsV = new Vector();
        for (int i = 0; i < safeBagsV.size(); ++i) {
            SafeBag bag = (SafeBag)safeBagsV.elementAt(i);
            ObjectIdentifier oid = bag.getObjectIdentifier();
            if (!oid.equals(PKCSOID.CERTBAG_OID) && !oid.equals(PKCSOID.CERT_TYPES_OID)) continue;
            certBagsV.add(safeBagsV.elementAt(i));
        }
        if (certBagsV.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificatesByFriendlyName_2", null);
            }
            return null;
        }
        Certificate[] certs = new Certificate[certBagsV.size()];
        for (int i = 0; i < certBagsV.size(); ++i) {
            CertBag bag;
            SafeBag sbag = (SafeBag)certBagsV.elementAt(i);
            try {
                bag = new CertBag(sbag.getValue(), this.provider);
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "getCertificatesByFriendlyName", e);
                }
                throw new PKCSException(e, "Error extracting CertBags from PFX (" + e.toString() + ")");
            }
            certs[i] = (Certificate)bag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificatesByFriendlyName_3", certs);
        }
        return certs;
    }

    PrivateKeyInfo[] getPrivateKeysByFriendlyName(char[] pwd, String friendlyName) throws PKCSException {
        Vector safeBagsV;
        if (debug != null) {
            debug.entry(16384L, className, "getPrivateKeysByFriendlyName", pwd, friendlyName);
        }
        if ((safeBagsV = this.getSafeBagsByFriendlyName(pwd, friendlyName)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPrivateKeysByFriendlyName_1", null);
            }
            return null;
        }
        Vector keyBagsV = new Vector();
        for (int i = 0; i < safeBagsV.size(); ++i) {
            SafeBag bag = (SafeBag)safeBagsV.elementAt(i);
            ObjectIdentifier oid = bag.getObjectIdentifier();
            if (!oid.equals(PKCSOID.KEYBAG_OID)) continue;
            keyBagsV.add(safeBagsV.elementAt(i));
        }
        if (keyBagsV.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPrivateKeysByFriendlyName_2", null);
            }
            return null;
        }
        PrivateKeyInfo[] keys = new PrivateKeyInfo[keyBagsV.size()];
        for (int i = 0; i < keyBagsV.size(); ++i) {
            KeyBag bag;
            SafeBag sbag = (SafeBag)keyBagsV.elementAt(i);
            try {
                bag = new KeyBag(sbag.getValue(), this.provider);
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "getPrivateKeysByFriendlyName", e);
                }
                throw new PKCSException(e, "Error extracting KeyBags from PFX (" + e.toString() + ")");
            }
            keys[i] = (PrivateKeyInfo)bag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPrivateKeysByFriendlyName_3", keys);
        }
        return keys;
    }

    EncryptedPrivateKeyInfo[] getShroudedKeysByFriendlyName(char[] pwd, String friendlyName) throws PKCSException {
        Vector safeBagsV;
        if (debug != null) {
            debug.entry(16384L, className, "getShroudedKeysByFriendlyName", pwd, friendlyName);
        }
        if ((safeBagsV = this.getSafeBagsByFriendlyName(pwd, friendlyName)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_1", null);
            }
            return null;
        }
        Vector keyBagsV = new Vector();
        for (int i = 0; i < safeBagsV.size(); ++i) {
            SafeBag bag = (SafeBag)safeBagsV.elementAt(i);
            ObjectIdentifier oid = bag.getObjectIdentifier();
            if (!oid.equals(PKCSOID.SHROUDEDKEYBAG_OID)) continue;
            keyBagsV.add(safeBagsV.elementAt(i));
        }
        if (keyBagsV.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_2", null);
            }
            return null;
        }
        EncryptedPrivateKeyInfo[] keys = new EncryptedPrivateKeyInfo[keyBagsV.size()];
        for (int i = 0; i < keyBagsV.size(); ++i) {
            ShroudedKeyBag bag;
            SafeBag sbag = (SafeBag)keyBagsV.elementAt(i);
            try {
                bag = new ShroudedKeyBag(sbag.getValue(), this.provider);
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "getShroudedKeysByFriendlyName", e);
                }
                throw new PKCSException(e, "Error extracting ShroudedKeyBags from PFX (" + e.toString() + ")");
            }
            keys[i] = (EncryptedPrivateKeyInfo)bag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_3", keys);
        }
        return keys;
    }

    boolean verifyMac(char[] pwd) throws IOException {
        byte[] newDigest;
        byte[] dataBytes;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verifyMac", (Object)pwd);
        }
        if (this.macData == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verifyMac_1", false);
            }
            return false;
        }
        DigestInfo dinfo = this.macData.getMac();
        byte[] digest = dinfo.getDigest();
        AlgorithmId alg = dinfo.getDigestAlgorithm();
        byte[] salt = this.macData.getSalt();
        int iCount = this.macData.getIterations();
        try {
            Data data = (Data)this.authSafe.getContent();
            dataBytes = data.getData();
            newDigest = this.calculateMac(dataBytes, alg.getName(), pwd, salt, iCount);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "verifyMac", e);
                debug.exit(16384L, (Object)className, "verifyMac_2", false);
            }
            return false;
        }
        if (digest.length != newDigest.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verifyMac_3", false);
            }
            return false;
        }
        boolean isEqual = true;
        for (int i = 0; i < digest.length; ++i) {
            if (digest[i] == newDigest[i]) continue;
            isEqual = false;
        }
        if (!isEqual) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verifyMac_3", false);
            }
            return false;
        }
        this.verifiedContents = new AuthenticatedSafe(dataBytes, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verifyMac_4", true);
        }
        return true;
    }

    PrivateKeyInfo[] getPrivateKeys(char[] pwd, PrivateKey key, Certificate cert, boolean skipUnprotected) throws IOException, PKCSException {
        SafeBag[] safeBags;
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert, new Boolean(skipUnprotected)};
            debug.entry(16384L, (Object)className, "getPrivateKeys", parms);
        }
        if ((safeBags = this.getTypedBags(PKCSOID.KEYBAG_OID, pwd, key, cert, skipUnprotected)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPrivateKeys_1", null);
            }
            return null;
        }
        PrivateKeyInfo[] keys = new PrivateKeyInfo[safeBags.length];
        for (int i = 0; i < safeBags.length; ++i) {
            byte[] encoding = safeBags[i].getValue();
            try {
                keys[i] = new PrivateKeyInfo(encoding, this.provider);
                continue;
            }
            catch (IOException e) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getPrivateKeys", e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPrivateKeys_2", keys);
        }
        return keys;
    }

    EncryptedPrivateKeyInfo[] getShroudedKeys(char[] pwd, PrivateKey key, Certificate cert, boolean skipUnprotected) throws IOException, PKCSException {
        SafeBag[] safeBags;
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert, new Boolean(skipUnprotected)};
            debug.entry(16384L, (Object)className, "getShroudedKeys", parms);
        }
        if ((safeBags = this.getTypedBags(PKCSOID.SHROUDEDKEYBAG_OID, pwd, key, cert, skipUnprotected)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeys_1", null);
            }
            return null;
        }
        EncryptedPrivateKeyInfo[] keys = new EncryptedPrivateKeyInfo[safeBags.length];
        for (int i = 0; i < safeBags.length; ++i) {
            byte[] encoding = safeBags[i].getValue();
            try {
                keys[i] = new EncryptedPrivateKeyInfo(encoding, this.provider);
                continue;
            }
            catch (IOException e) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getShroudedKeys", e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getShroudedKeys_2", keys);
        }
        return keys;
    }

    Certificate[] getCertificates(char[] pwd, PrivateKey key, Certificate cert, boolean skipUnprotected) throws IOException, PKCSException {
        HexDumpEncoder hd = new HexDumpEncoder();
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert, new Boolean(skipUnprotected)};
            debug.entry(16384L, (Object)className, "getCertificates", parms);
        }
        SafeBag[] bags1 = this.getTypedBags(PKCSOID.X509CERTBAG_OID, pwd, key, cert, skipUnprotected);
        SafeBag[] bags2 = this.getTypedBags(PKCSOID.SDSICERTBAG_OID, pwd, key, cert, skipUnprotected);
        SafeBag[] bags3 = this.getTypedBags(PKCSOID.CERTBAG_OID, pwd, key, cert, skipUnprotected);
        if (bags1 == null && bags2 == null && bags3 == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificates_1", null);
            }
            return null;
        }
        int len1 = 0;
        int len2 = 0;
        int len3 = 0;
        if (bags1 != null) {
            len1 = bags1.length;
        }
        if (bags2 != null) {
            len2 = bags2.length;
        }
        if (bags3 != null) {
            len3 = bags3.length;
        }
        SafeBag[] safeBags = new SafeBag[len1 + len2 + len3];
        int index = 0;
        if (bags1 != null) {
            System.arraycopy(bags1, 0, safeBags, index, bags1.length);
            index = bags1.length;
        }
        if (bags2 != null) {
            System.arraycopy(bags2, 0, safeBags, index, bags2.length);
            index += bags2.length;
        }
        if (bags3 != null) {
            System.arraycopy(bags3, 0, safeBags, index, bags3.length);
        }
        Certificate[] certs = new Certificate[safeBags.length];
        for (int i = 0; i < safeBags.length; ++i) {
            byte[] encoding = safeBags[i].getValue();
            CertBag bag = new CertBag(encoding, this.provider);
            certs[i] = (Certificate)bag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates_2", certs);
        }
        return certs;
    }

    CRL[] getCRLs(char[] pwd, PrivateKey key, Certificate cert, boolean skipUnprotected) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert, new Boolean(skipUnprotected)};
            debug.entry(16384L, (Object)className, "getCRLs", parms);
        }
        SafeBag[] bags1 = this.getTypedBags(PKCSOID.X509CRLBAG_OID, pwd, key, cert, skipUnprotected);
        SafeBag[] bags2 = this.getTypedBags(PKCSOID.CRLBAG_OID, pwd, key, cert, skipUnprotected);
        if (bags1 == null && bags2 == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCRLs_1", null);
            }
            return null;
        }
        int len1 = 0;
        int len2 = 0;
        if (bags1 != null) {
            len1 = bags1.length;
        }
        if (bags2 != null) {
            len2 = bags2.length;
        }
        SafeBag[] safeBags = new SafeBag[len1 + len2];
        int index = 0;
        if (bags1 != null) {
            System.arraycopy(bags1, 0, safeBags, index, bags1.length);
            index = bags1.length;
        }
        if (bags2 != null) {
            System.arraycopy(bags2, 0, safeBags, index, bags2.length);
            index += bags2.length;
        }
        CRL[] crls = new CRL[safeBags.length];
        for (int i = 0; i < safeBags.length; ++i) {
            byte[] encoding = safeBags[i].getValue();
            CrlBag bag = new CrlBag(safeBags[i].getObjectIdentifier(), encoding, this.provider);
            crls[i] = (CRL)bag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs_2", crls);
        }
        return crls;
    }

    SafeContents[] getSafeContents(char[] pwd, PrivateKey key, Certificate cert, boolean skipUnprotected) throws IOException, PKCSException {
        SafeBag[] safeBags;
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert, new Boolean(skipUnprotected)};
            debug.entry(16384L, (Object)className, "getSafeContents", parms);
        }
        if ((safeBags = this.getTypedBags(PKCSOID.SAFECONTENTSBAG_OID, pwd, key, cert, skipUnprotected)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSafeContents_1", null);
            }
            return null;
        }
        SafeContents[] scs = new SafeContents[safeBags.length];
        for (int i = 0; i < safeBags.length; ++i) {
            byte[] encoding = safeBags[i].getValue();
            try {
                scs[i] = new SafeContents(encoding, this.provider);
                continue;
            }
            catch (IOException e) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getSafeContents", e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeContents_2", scs);
        }
        return scs;
    }

    SafeBag[] getSafeBags(char[] pwd, PrivateKey key, Certificate cert, boolean skipUnprotected) throws IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert, new Boolean(skipUnprotected)};
            debug.entry(16384L, (Object)className, "getSafeBags", parms);
            debug.exit(16384L, (Object)className, "getSafeBags", this.getBags(pwd, key, cert, skipUnprotected));
        }
        return this.getBags(pwd, key, cert, skipUnprotected);
    }

    synchronized void applyMac(char[] pwd, int iterations) throws PKCSException, NoSuchAlgorithmException, IOException {
        int iCount = 1;
        if (debug != null) {
            debug.entry(16384L, className, "applyMac", pwd, new Integer(iterations));
        }
        if (iterations > 0) {
            iCount = iterations;
        }
        this.authSafe = this.authSafeContents.toContentInfo();
        Data data = (Data)this.authSafe.getContent();
        byte[] dataBytes = data.getData();
        byte[] salt = new byte[20];
        SecureRandom random = null;
        try {
            random = this.provider != null ? SecureRandom.getInstance("IBMSecureRandom", this.provider) : SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException nsae) {
            if (debug != null) {
                debug.exception(16384L, className, "applyMac", nsae);
            }
            random = new SecureRandom();
        }
        catch (NoSuchProviderException nspe) {
            if (debug != null) {
                debug.exception(16384L, className, "applyMac", nspe);
            }
            throw new PKCSException("provider " + this.provider + " not found: " + nspe);
        }
        random.nextBytes(salt);
        byte[] digest = this.calculateMac(dataBytes, "SHA1", pwd, salt, iCount);
        DigestInfo dinfo = new DigestInfo("SHA1", null, digest, this.provider);
        this.macData = new MacData(dinfo, salt, iCount, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "applyMac");
        }
    }

    Vector getSafeBagsByFriendlyName(char[] pwd, String friendlyName) throws PKCSException {
        SafeBag[] bags;
        if (debug != null) {
            debug.entry(16384L, className, "getSafeBagsByFriendlyName", pwd, friendlyName);
        }
        try {
            bags = this.getSafeBags(pwd, null, null, false);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSafeBagsByFriendlyName", e);
            }
            throw new PKCSException(e, "Error extracting SafeBags from PFX (" + e.toString() + ")");
        }
        Vector<SafeBag> safeBagsV = new Vector<SafeBag>();
        for (int i = 0; i < bags.length; ++i) {
            PKCSAttribute attr;
            PKCSAttributes attrs = bags[i].getAttributes();
            if (attrs == null || (attr = (PKCSAttribute)attrs.getAttribute(PKCSOID.FRIENDLY_NAME_OID)) == null) continue;
            try {
                String val = (String)attr.getAttributeValue();
                if (!val.equals(friendlyName)) continue;
                safeBagsV.add(bags[i]);
                continue;
            }
            catch (Exception e) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getSafeBagsByFriendlyName", e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeBagsByFriendlyName", safeBagsV);
        }
        return safeBagsV;
    }

    Collection getSafeBagsByLocalKeyId(char[] pwd, byte[] localKeyId) throws PKCSException {
        SafeBag[] bags;
        if (debug != null) {
            debug.entry(16384L, className, "getSafeBagsByLocalKeyId", pwd, localKeyId);
        }
        try {
            bags = this.getSafeBags(pwd, null, null, false);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSafeBagsByLocalKeyId", e);
            }
            throw new PKCSException(e, "Error extracting SafeBags from PFX (" + e.toString() + ")");
        }
        LinkedList<SafeBag> safeBagsList = new LinkedList<SafeBag>();
        for (int i = 0; i < bags.length; ++i) {
            PKCSAttribute attr;
            PKCSAttributes attrs = bags[i].getAttributes();
            if (attrs == null || (attr = (PKCSAttribute)attrs.getAttribute(PKCSOID.LOCAL_KEY_ID_OID)) == null) continue;
            try {
                byte[] val = (byte[])attr.getAttributeValue();
                boolean theyEqual = false;
                if (val.length == localKeyId.length) {
                    theyEqual = true;
                    for (int j = 0; j < val.length; ++j) {
                        if (val[j] == localKeyId[j]) continue;
                        theyEqual = false;
                    }
                }
                if (!theyEqual) continue;
                safeBagsList.add(bags[i]);
                continue;
            }
            catch (Exception e) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getSafeBagsByLocalKeyId", e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeBagsByLocalKeyId", safeBagsList);
        }
        return safeBagsList;
    }

    private SafeBag[] getTypedBags(ObjectIdentifier oid, char[] pwd, PrivateKey key, Certificate cert, boolean skipUnprotected) throws IOException {
        SafeBag[] safeBags;
        Vector<SafeBag> bagV = new Vector<SafeBag>();
        if (debug != null) {
            Object[] parms = new Object[]{oid, pwd, key, cert, new Boolean(skipUnprotected)};
            debug.entry(8192L, (Object)className, "getTypedBags", parms);
        }
        if ((safeBags = this.getBags(pwd, key, cert, skipUnprotected)) == null) {
            safeBags = new SafeBag[]{};
        }
        for (int i = 0; i < safeBags.length; ++i) {
            if (!safeBags[i].getObjectIdentifier().equals(oid)) continue;
            bagV.add(safeBags[i]);
        }
        if (bagV.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getTypedBags_1", null);
            }
            return null;
        }
        SafeBag[] bags = new SafeBag[bagV.size()];
        for (int i = 0; i < bagV.size(); ++i) {
            bags[i] = (SafeBag)bagV.elementAt(i);
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getTypedBags_2", bags);
        }
        return bags;
    }

    private byte[] calculateMac(byte[] data, String alg, char[] pwd, byte[] salt, int iCount) throws PKCSException, NoSuchAlgorithmException {
        Mac hmac;
        if (debug != null) {
            Object[] parms = new Object[]{data, alg, pwd, salt, new Integer(iCount)};
            debug.entry(16384L, (Object)className, "calculateMac", parms);
        }
        String digestAlg = "SHA";
        int keysize = 20;
        String upperAlg = alg.toUpperCase(Locale.US);
        if (upperAlg.indexOf("MD2") != -1) {
            digestAlg = "MD2";
            keysize = 16;
        } else if (upperAlg.indexOf("MD5") != -1) {
            digestAlg = "MD5";
            keysize = 16;
        } else if (upperAlg.indexOf("SHA") == -1) {
            if (debug != null) {
                debug.text(16384L, className, "calculateMac", "Unsupported MAC algorithm: " + alg + ".  Digest algorithm must be one of SHA, MD2 or MD5.");
            }
            throw new IllegalArgumentException("Unsupported MAC algorithm: " + alg + ".  Digest algorithm must be one of SHA, MD2 or MD5.");
        }
        byte[] keyBytes = PKCS12.genKey((byte)3, digestAlg, pwd, salt, iCount, keysize);
        SecretKeySpec key = new SecretKeySpec(keyBytes, alg);
        String upperDigest = digestAlg.toUpperCase(Locale.US);
        String macAlg = upperDigest.indexOf("SHA") != -1 ? "HmacSHA1" : "Hmac" + digestAlg;
        try {
            hmac = this.provider != null ? Mac.getInstance(macAlg, this.provider) : Mac.getInstance(macAlg);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, className, "calculateMac", "Unable to instantiate HMAC (" + e.toString() + ")");
            }
            throw new PKCSException(e, "Unable to instantiate HMAC (" + e.toString() + ")");
        }
        try {
            hmac.init(key, null);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "calculateMac", e);
            }
            throw new PKCSException(e, "Unable to initialize HMAC (" + e.toString() + ")");
        }
        hmac.update(data, 0, data.length);
        byte[] result = hmac.doFinal();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "calculateMac", result);
        }
        return result;
    }

    private SafeBag[] getBags(char[] pwd, PrivateKey key, Certificate cert, boolean skipUnprotected) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{pwd, key, cert, new Boolean(skipUnprotected)};
            debug.entry(8192L, (Object)className, "getBags", parms);
        }
        HexDumpEncoder hd = new HexDumpEncoder();
        Vector<SafeBag> allBags = new Vector<SafeBag>();
        ContentInfo[] cinfos = this.getPFXContents();
        for (int i = 0; i < cinfos.length; ++i) {
            Content ed;
            if (cinfos[i].getContentType().equals(PKCSOID.DATA_OID)) {
                if (skipUnprotected) continue;
                Data data = (Data)cinfos[i].getContent();
                byte[] dataBytes = data.getData();
                SafeContents sc = new SafeContents(dataBytes, this.provider);
                SafeBag[] safeBags = sc.getSafeBags();
                for (int j = 0; j < safeBags.length; ++j) {
                    allBags.add(safeBags[j]);
                }
                continue;
            }
            if (cinfos[i].getContentType().equals(PKCSOID.ENCRYPTED_DATA_OID)) {
                try {
                    ed = (EncryptedData)cinfos[i].getContent();
                    EncryptedContentInfo eci = ((EncryptedData)ed).getEncryptedContent();
                    AlgorithmId algid = eci.getContentEncryptionAlgorithm();
                    byte[] encryptedContents = eci.getEncryptedContent();
                    String algname = algid.getName();
                    byte[] encodedParams = algid.getParameters();
                    DerValue derParams = new DerValue(encodedParams);
                    DerValue[] seq = new DerValue[]{derParams.getData().getDerValue(), derParams.getData().getDerValue()};
                    byte[] salt = seq[0].getOctetString();
                    int iCount = seq[1].getInteger().intValue();
                    PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iCount);
                    AlgorithmParameters params = null;
                    params = this.provider != null ? AlgorithmParameters.getInstance("PBE", this.provider) : AlgorithmParameters.getInstance("PBE");
                    params.init(paramSpec);
                    PBEKeySpec keySpec = new PBEKeySpec(pwd);
                    SecretKeyFactory keyFact = null;
                    keyFact = this.provider != null ? SecretKeyFactory.getInstance(algname, this.provider) : SecretKeyFactory.getInstance(algname);
                    SecretKey sKey = keyFact.generateSecret(keySpec);
                    Cipher cipher = null;
                    cipher = this.provider != null ? Cipher.getInstance(algname, this.provider) : Cipher.getInstance(algname);
                    cipher.init(2, (Key)sKey, params);
                    byte[] dataBytes = cipher.doFinal(encryptedContents);
                    SafeContents sc = new SafeContents(dataBytes, this.provider);
                    SafeBag[] safeBags = sc.getSafeBags();
                    for (int j = 0; j < safeBags.length; ++j) {
                        allBags.add(safeBags[j]);
                    }
                    continue;
                }
                catch (Exception e) {
                    if (debug == null) continue;
                    debug.exception(8192L, className, "getBags", e);
                    continue;
                }
            }
            if (!cinfos[i].getContentType().equals(PKCSOID.ENVELOPED_DATA_OID) || key == null || cert == null) continue;
            try {
                ed = (EnvelopedData)cinfos[i].getContent();
                ContentInfo cinfo = ((EnvelopedData)ed).decrypt(key, cert);
                Data data = (Data)cinfo.getContent();
                byte[] dataBytes = data.getData();
                SafeContents sc = new SafeContents(dataBytes, this.provider);
                SafeBag[] safeBags = sc.getSafeBags();
                for (int j = 0; j < safeBags.length; ++j) {
                    allBags.add(safeBags[j]);
                }
                continue;
            }
            catch (Exception e) {
                if (debug == null) continue;
                debug.exception(8192L, className, "getBags", e);
            }
        }
        if (allBags.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getBags_1", null);
            }
            return null;
        }
        SafeBag[] safeBags = new SafeBag[allBags.size()];
        for (int i = 0; i < allBags.size(); ++i) {
            safeBags[i] = (SafeBag)allBags.elementAt(i);
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getBags_2", safeBags);
        }
        return safeBags;
    }

    private ContentInfo[] getPFXContents() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getPFXContents");
        }
        if (this.verifiedContents != null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPFXContents_1", this.verifiedContents.getContentInfos());
            }
            return this.verifiedContents.getContentInfos();
        }
        if (this.authSafe != null) {
            Data data;
            if (this.authSafe.getContentType().equals(PKCSOID.DATA_OID)) {
                data = (Data)this.authSafe.getContent();
            } else {
                SignedData sd = (SignedData)this.authSafe.getContent();
                ContentInfo cinfo = sd.getEncapsulatedContentInfo().getContentInfo();
                data = (Data)cinfo.getContent();
            }
            AuthenticatedSafe as = new AuthenticatedSafe(data.getData(), this.provider);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPFXContents_2", as.getContentInfos());
            }
            return as.getContentInfos();
        }
        if (this.authSafeContents != null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPFXContents_3", this.authSafeContents.getContentInfos());
            }
            return this.authSafeContents.getContentInfos();
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getPFXContents_4", new ContentInfo[0]);
        }
        return new ContentInfo[0];
    }

    synchronized void addSafeBagsWithPasswordPrivacy(SafeBag[] bags, String cipherAlg, char[] pwd) throws NoSuchAlgorithmException, IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{bags, cipherAlg, pwd};
            debug.entry(16384L, (Object)className, "addSafeBagsWithPasswordPrivacy", parms);
        }
        SafeContents safeContents = new SafeContents(bags, this.provider);
        byte[] contents = safeContents.encode();
        ContentInfo cinfo = this.protectWithPasswordPrivacy(contents, "SHA", cipherAlg, pwd);
        this.addContentToAuthSafe(cinfo);
        if (debug != null) {
            debug.exit(16384L, className, "addSafeBagsWithPasswordPrivacy");
        }
    }

    synchronized void addContentToAuthSafe(ContentInfo cinfo) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addContentToAuthSafe", cinfo);
        }
        ContentInfo[] contents = new ContentInfo[]{cinfo};
        this.authSafeContents = this.authSafeContents == null ? new AuthenticatedSafe(contents, this.provider) : this.authSafeContents.addContentInfo(contents);
        if (debug != null) {
            debug.exit(16384L, className, "addContentToAuthSafe");
        }
    }

    abstract ContentInfo protectWithPasswordPrivacy(byte[] var1, String var2, String var3, char[] var4) throws IOException, PKCSException, NoSuchAlgorithmException;

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                buf.append('\n');
            }
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            buf.append(' ');
        }
        return buf.toString();
    }
}

