/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import java.io.File;

public class FileName {
    private String directory;
    private String name;
    private String fileExtension;

    public FileName(String string) {
        this.splitFileName(string);
    }

    public FileName(FileName fileName) {
        this.directory = fileName.directory;
        this.name = fileName.name;
        this.fileExtension = fileName.fileExtension;
    }

    public FileName(String string, String string2) {
        this(string);
        if (this.fileExtension.equals("")) {
            this.fileExtension = string2;
        }
    }

    public FileName(File file) {
        if (file.isDirectory()) {
            this.directory = file.getAbsolutePath();
            this.name = "";
            this.fileExtension = "";
        } else {
            this.splitFileName(file.getAbsolutePath());
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getName() {
        return this.name;
    }

    public String getFile() {
        return this.getName() + this.getFileExtension();
    }

    public void setExtension(String string) {
        this.fileExtension = string;
    }

    public FileName substituteExtension(String string) {
        FileName fileName = new FileName(this.toString());
        fileName.fileExtension = string;
        return fileName;
    }

    private void splitFileName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        String string3 = file.getAbsolutePath();
        this.directory = string3.substring(0, string3.lastIndexOf(File.separator));
        if (string2.lastIndexOf(".") == -1) {
            this.name = string2;
            this.fileExtension = "";
        } else {
            this.name = string2.substring(0, string2.lastIndexOf("."));
            this.fileExtension = string2.substring(string2.lastIndexOf("."), string2.length());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FileName) {
            return ((FileName)object).toString().equals(this.toString());
        }
        if (object instanceof String) {
            return ((String)object).equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.directory + File.separator + this.name + this.fileExtension;
    }

    public FileName changeExtension(String string) {
        FileName fileName = new FileName(this);
        fileName.fileExtension = string;
        return fileName;
    }
}

