/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.ext;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$CMSDatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptorImpl;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DescriptorType;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.util.Calendar;
import javax.security.auth.callback.CallbackHandler;

class DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl
extends DatabaseDescriptorFactory$DatabaseDescriptorImpl
implements DatabaseDescriptorFactory$CMSDatabaseDescriptor {
    private boolean useStash = false;
    private int passwordExpiryTime = 0;
    private boolean useV1Stash = false;

    public DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(String string, String string2, CallbackHandler callbackHandler, boolean bl, boolean bl2, int n, DatabaseDescriptorFactory$DescriptorType databaseDescriptorFactory$DescriptorType) throws KeyManagerException {
        super(string, string2, callbackHandler, Constants$DatabaseType.CMS, databaseDescriptorFactory$DescriptorType);
        this.useStash = bl;
        this.useV1Stash = bl2;
        if (n != 0) {
            this.setPasswordExpiryTime(n);
        } else {
            this.passwordExpiryTime = n;
        }
    }

    public DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException {
        this(databaseDescriptorFactory$DatabaseDescriptor.getFileNameString(), databaseDescriptorFactory$DatabaseDescriptor.getPassword(), null, false, false, 0, DatabaseDescriptorFactory$DescriptorType.Source);
    }

    private void setPasswordExpiryTime(int n) {
        if (n == 0) {
            this.passwordExpiryTime = 0;
        } else {
            Calendar calendar = Calendar.getInstance();
            int n2 = 6;
            calendar.add(6, n);
            this.passwordExpiryTime = (int)(calendar.getTimeInMillis() / 1000L);
            if (this.passwordExpiryTime < 0) {
                this.passwordExpiryTime = 0;
            }
        }
    }

    public boolean isUseStash() {
        return this.useStash;
    }

    public boolean isUseV1Stash() {
        return this.useV1Stash;
    }

    public int getPasswordExpiryTime() {
        return this.passwordExpiryTime;
    }

    public static DatabaseDescriptorFactory$CMSDatabaseDescriptor getDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler) throws KeyManagerException {
        int n = commandParameters.isParameterPresent(Constants$Parameter.Expire) ? commandParameters.getExpire() : 0;
        boolean bl = commandParameters.isParameterPresent(Constants$Parameter.StashPassword) ? commandParameters.isStash() : KeymanSettings$Setting.DefaultPasswordStashingState.getBoolean().booleanValue();
        boolean bl2 = commandParameters.isParameterPresent(Constants$Parameter.StashV1Password) ? commandParameters.isV1Stash() : KeymanSettings$Setting.DefaultPasswordV1StashingState.getBoolean().booleanValue();
        if (bl) {
            if (commandParameters.isParameterPresent(Constants$Parameter.Password)) {
                return new DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(commandParameters.getDatabaseName(), commandParameters.getPassword(), callbackHandler, true, bl2, n, DatabaseDescriptorFactory$DescriptorType.Source);
            }
            return new DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(commandParameters.getDatabaseName(), null, callbackHandler, true, bl2, n, DatabaseDescriptorFactory$DescriptorType.Source);
        }
        if (commandParameters.isParameterPresent(Constants$Parameter.Password)) {
            return new DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(commandParameters.getDatabaseName(), commandParameters.getPassword(), callbackHandler, false, false, n, DatabaseDescriptorFactory$DescriptorType.Source);
        }
        return new DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(commandParameters.getDatabaseName(), null, callbackHandler, false, false, n, DatabaseDescriptorFactory$DescriptorType.Source);
    }

    public static DatabaseDescriptorFactory$CMSDatabaseDescriptor getDescriptor(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException {
        return new DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(databaseDescriptorFactory$DatabaseDescriptor);
    }

    public static DatabaseDescriptorFactory$DatabaseDescriptor getSecondaryDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler) throws KeyManagerException {
        if (commandParameters.isParameterPresent(Constants$Parameter.SecondaryDbPassword)) {
            return new DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(commandParameters.getSecondaryDb(), commandParameters.getSecondaryDbPassword(), callbackHandler, false, false, 0, DatabaseDescriptorFactory$DescriptorType.Secondary);
        }
        return new DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(commandParameters.getSecondaryDb(), null, callbackHandler, false, false, 0, DatabaseDescriptorFactory$DescriptorType.Secondary);
    }

    public static DatabaseDescriptorFactory$DatabaseDescriptor getTargetDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler) throws KeyManagerException {
        if (commandParameters.isParameterPresent(Constants$Parameter.TargetPassword)) {
            return new DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(commandParameters.getTarget(), commandParameters.getTargetPassword(), callbackHandler, false, false, 0, DatabaseDescriptorFactory$DescriptorType.Target);
        }
        return new DatabaseDescriptorFactory$CMSDatabaseDescriptorImpl(commandParameters.getTarget(), null, callbackHandler, false, false, 0, DatabaseDescriptorFactory$DescriptorType.Target);
    }

    public boolean allowsAction(Constants$CommandType constants$CommandType) {
        switch (constants$CommandType) {
            case StashDBPassword: {
                return this.isPasswordProtected();
            }
            case DisplayDBPasswordExpiry: {
                return true;
            }
        }
        return super.allowsAction(constants$CommandType);
    }

    protected void updateDescriptor(ParameterMap parameterMap) {
        super.updateDescriptor(parameterMap);
        if (parameterMap.containsKey(Constants$Parameter.StashPassword)) {
            this.useStash = (Boolean)parameterMap.get(Constants$Parameter.StashPassword);
        }
        if (parameterMap.containsKey(Constants$Parameter.Expire)) {
            this.setPasswordExpiryTime((Integer)parameterMap.get(Constants$Parameter.Expire));
        }
        if (parameterMap.containsKey(Constants$Parameter.StashV1Password)) {
            this.useV1Stash = (Boolean)parameterMap.get(Constants$Parameter.StashV1Password);
        }
    }

    public void setPassword(CommandParameters commandParameters) throws KeyManagerException {
        super.setPassword(commandParameters);
        this.useStash = commandParameters.isParameterPresent(Constants$Parameter.StashPassword) ? commandParameters.isStash() : KeymanSettings$Setting.DefaultPasswordStashingState.getBoolean().booleanValue();
        if (commandParameters.isParameterPresent(Constants$Parameter.Expire)) {
            this.setPasswordExpiryTime(commandParameters.getExpire());
        }
        this.useV1Stash = commandParameters.isParameterPresent(Constants$Parameter.StashV1Password) ? commandParameters.isV1Stash() : KeymanSettings$Setting.DefaultPasswordV1StashingState.getBoolean().booleanValue();
    }

    public void setStash(boolean bl) {
        this.useStash = bl;
    }

    public void setV1Stash(boolean bl) {
        this.useV1Stash = bl;
    }

    public void setPasswordExpiryTimeSinceEpoch(int n) {
        this.passwordExpiryTime = n > 0 ? n : 0;
    }
}

