/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory$FileKeyStoreProxy;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$CMSDatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceXorFactory;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import com.ibm.security.cmskeystore.CMSLoadParameter;
import com.ibm.security.cmskeystore.CMSLoadStoreParameterFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

class KeyStoreProxyCreatorFactory$CMSKeyStoreProxy
extends KeyStoreProxyCreatorFactory$FileKeyStoreProxy {
    public KeyStoreProxyCreatorFactory$CMSKeyStoreProxy(KeyStore keyStore, DatabaseDescriptorFactory$CMSDatabaseDescriptor databaseDescriptorFactory$CMSDatabaseDescriptor, boolean bl) throws KeyManagerException, CancelledException {
        super(keyStore, databaseDescriptorFactory$CMSDatabaseDescriptor, bl);
    }

    protected void performLoad(InputStream inputStream, boolean bl) throws NoSuchAlgorithmException, CertificateException, IOException, KeyManagerException, CancelledException {
        byte[] byArray;
        if (inputStream == null) {
            byArray = null;
        } else {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        String string = ((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.descriptor).getPassword(false, bl);
        if (string == null) {
            if (!(bl && KeymanSettings$Setting.CMSPasswordRequired.getBoolean().booleanValue() || !this.loadWithPassword(byArray, KeymanSettings.PASSWORDLESS_CMS_PASSWORD))) {
                return;
            }
            if (KeymanSettings$Setting.DefaultCMSPassword.getString() != null && this.loadWithPassword(byArray, KeymanSettings$Setting.DefaultCMSPassword.getString())) {
                return;
            }
        }
        super.performLoad(byArray == null ? null : new ByteArrayInputStream(byArray), bl);
        CMSLoadParameter cMSLoadParameter = (CMSLoadParameter)CMSLoadStoreParameterFactory.newCMSLoadParameter((File)(bl ? null : new File(((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.descriptor).getFileNameString())), (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.descriptor).getPassword().toCharArray()));
        this.keyStore.load((KeyStore.LoadStoreParameter)cMSLoadParameter);
        if (!bl) {
            ((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.descriptor).setPasswordExpiryTimeSinceEpoch(cMSLoadParameter.getPasswordExpiry());
        }
    }

    private boolean loadWithPassword(byte[] byArray, String string) throws NoSuchAlgorithmException, CertificateException {
        try {
            this.keyStore.load(byArray == null ? null : new ByteArrayInputStream(byArray), string.toCharArray());
            ((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.descriptor).setPassword(string);
            ((DatabaseDescriptorFactory$CMSDatabaseDescriptor)this.descriptor).setPasswordProtected(!string.equals(KeymanSettings.PASSWORDLESS_CMS_PASSWORD));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected void performSave(DatabaseDescriptorFactory$CMSDatabaseDescriptor databaseDescriptorFactory$CMSDatabaseDescriptor) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagerException {
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(databaseDescriptorFactory$CMSDatabaseDescriptor.getPassword().toCharArray());
        boolean bl = false;
        if (databaseDescriptorFactory$CMSDatabaseDescriptor.isUseV1Stash() && ByteSequenceXorFactory.isStashtoV1Allowed(CommandFactory.getStashFileName(databaseDescriptorFactory$CMSDatabaseDescriptor.getFileNameString()), Command.isPasswordStashed())) {
            bl = true;
        }
        KeyStore.LoadStoreParameter loadStoreParameter = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)new File(databaseDescriptorFactory$CMSDatabaseDescriptor.getFileNameString()), (KeyStore.ProtectionParameter)passwordProtection, (boolean)databaseDescriptorFactory$CMSDatabaseDescriptor.isUseStash(), (boolean)bl, (int)databaseDescriptorFactory$CMSDatabaseDescriptor.getPasswordExpiryTime());
        this.keyStore.store(loadStoreParameter);
    }

    protected void performSave(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagerException {
        this.performSave((DatabaseDescriptorFactory$CMSDatabaseDescriptor)databaseDescriptorFactory$DatabaseDescriptor);
    }
}

